************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2010 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
      SUBROUTINE LJLGWS(JH,S,R,Y,QA,QB,W)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION W(JH,2),Y(JH),S(2)
      DIMENSION QA(JH),QB(JH)

      S(1)=0
      S(2)=0
      DO J=1,JH
        S(1)=S(1)+W(J,1)*QA(J)
        S(2)=S(2)+W(J,2)*QA(J)        
        QB(J)=QB(J)+R*Y(J)*QA(J)
      END DO

      END
