module NumRu
  module DCLExt
    module Anim

      class Stream

        include Anim

        DEPTH = 24
        BPP = 24

        DEFAULT_FRAMERATE = 4
        DEFAULT_FILENAME = "dcl.mp4"



        attr_accessor :filename, :framerate
        attr_reader :pipe
        attr_reader :buffersize

        def initialize(pipe)
          @pipe = pipe
          @buffersize = width * height * DEPTH
          @num_frames = 0
          @source_id = nil
          ARGV.each do |arg|
            case arg
            when /\A--dclext-anim-framerate=/
              @framerate = $'.to_i
            when /\A--dclext-anim-filename=/
              @filename = $'
            end
          end
          @framerate ||= ((c=ENV["DCLEXT_ANIM_FRAMERATE"]) && c.to_i) || DEFAULT_FRAMERATE
          @filename ||= ENV["DCLEXT_ANIM_FILENAME"] || DEFAULT_FILENAME
        end

        def start
          require "gst"

          Gst.init

          loop = GLib::MainLoop.new(nil, false)

          x264opts = "path=qual quantizer=18 qp-min=10 qp-max=25 me=umh subme=6 ref=3 threads=0 cabac=true dct8x8=false"
#          x264opts = "bitrate=10000"
          cmd = "appsrc min-latency=100000000 block=true name=dclsource caps=\"#{caps_str}\" ! queue ! ffmpegcolorspace ! video/x-raw-yuv,format=(fourcc)I420,width=#{width},height=#{height} ! videorate ! video/x-raw-yuv,framerate=#{@framerate}/1 ! queue ! x264enc #{x264opts} ! queue ! mp4mux ! filesink location=#{@filename}"

          bin = Gst::Parse.launch(cmd)

          appsrc = bin.get_child("dclsource")
          appsrc.format = Gst::Format::TIME
          appsrc.max_bytes = height*width*DEPTH*5

          bus = bin.bus
          bus.add_watch do |bus, message|
            case message.type
            when Gst::Message::EOS
              loop.quit
            when Gst::Message::ERROR
              p message.parse
              loop.quit
            end
            true
          end

          appsrc.signal_connect('need-data') do |elm, length|
            start_feed(elm)
          end
          appsrc.signal_connect('enough-data') do |elm|
            stop_feed
          end

          bin.play
          begin
            loop.run
          rescue Interrupt
          ensure
            @pipe.close
            bin.stop
          end
        end

        def caps_str
          "video/x-raw-rgb,width=(int)#{width},height=(int)#{height},depth=(int)#{DEPTH},bpp=(int)#{BPP},framerate=#{@framerate}/1,endianness=4321,red_mask=16711680,green_mask=65280,blue_mask=255"
        end

        def get_data
          sleep(0.1)
          @pipe.read(@buffersize/8)
        end

        def start_feed(appsrc)
          unless @source_id
            @source_id = GLib::Idle.add do
              if data = get_data
                buffer = Gst::Buffer.new(data.size*8)
                buffer.caps = Gst::Caps.parse(caps_str)
                buffer.duration = 10**9/@framerate
                buffer.timestamp = buffer.duration * @num_frames
                buffer.set_data(data)
#                ret = appsrc.signal_emit("push-buffer", buffer)
                ret = appsrc.push_buffer(buffer)
                if ret.name == "GST_FLOW_OK"
                  @num_frames += 1
                  true
                else
                  p ret.name
                  appsrc.end_of_stream
                  false
                end
              else
                appsrc.end_of_stream
                false
              end
            end
          end
        end
        def stop_feed
          if @source_id
            GLib::Source.remove(@source_id)
            @source_id = nil
          end
        end

      end # class Stream

    end # module Anim
  end # module DCLExt

end # module NumRu
