!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_mpi_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2009/12/11  ݹ   wq_test_polvelbc.f90  SJPACK Ѥ˲¤
!
!
!      2008/07/05  ʿ 1D-1 ݾڤǤʤ?
!      2011/09/09  ݹ   wq_module_polvelbc_test.f90  MPI 
!      2011/09/12  ݹ   wtq_mpi_module Ѥ˲¤
!
program wtq_mpi_module_polvelbc_wq_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_mpi_module
  use mpi

  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,kmi)     :: xyr_Poloidal
  real(8), dimension(0:im-1,1:jm,kmi)     :: xyr_LaplaPol
  real(8), dimension(0:im-1,1:jm,kmi)     :: xyr_True
  real(8), dimension(0:im-1,1:jm,kmi)     :: xyr_Zero=0.0D0
  real(8), dimension((nm+1)**2,0:lmi)     :: wq_Poloidal
  real(8), dimension((nm+1)**2,0:lmi)     :: wq_LaplaPol
  real(8), dimension((nm+1)**2,0:lmi)     :: wq_LaplaPol0
  character(len=1), dimension(2), parameter :: BCond=(/'F','R'/)

  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -10

  integer :: l
  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  call MessageNotify('M','wtq_mpi_module_polvelbc_wq_test', &
       'wtq_mpi_module wq_LaplaPol2Pol_wq subroutine test')

  call wtq_mpi_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  do l=1,2

     ! P_10
     xyr_Poloidal = sin(xyr_Lat) * xyr_Rad * ((xyr_Rad-ri)*(xyr_Rad+ri))**3
!!$     xyr_Poloidal = sin(xyr_Lat) * xyr_Rad * ((xyr_Rad-ri)*(xyr_Rad+ri))**2
     wq_LaplaPol0 = wq_Lapla_wq(wq_xyr(xyr_Poloidal))
     !xyr_LaplaPol = sin(xyr_Lat) * sin( pi*(xyr_Rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_LaplaPol = cos(xyr_Lat)*cos(xyr_Lon)* xyr_Rad * (xyr_Rad-ri) 
     !xyr_LaplaPol = 2*sin(xyr_Lat)**2 * xyr_Rad * (xyr_Rad-ri) 

     !xyr_Poloidal = xyr_wz(wr_LaplaPol2pol_wr(wr_xyr(xyr_LaplaPol),BCond(l)))
     !xyr_Poloidal = xyr_wq(wq_LaplaPol2PolTau_wq(wq_xyr(xyr_LaplaPol),BCond(l)))

     wq_Poloidal  = wq_LaplaPol2Pol_wq(wq_LaplaPol0,BCond(l),new=.true.)
     wq_LaplaPol  = wq_Lapla_wq(wq_Poloidal)
     xyr_Poloidal = xyr_wq(wq_Poloidal)

     !---------------- å -----------------------
     call AssertEqual(&
          message='wq_Laplapol2Pol_wq (internal value)',                &
          answer = wq_LaplaPol(:,0:lmi-4),                              &
          check = wq_LaplaPol0(:,0:lmi-4),                              &
          significant_digits = check_digits, ignore_digits = ignore     &
       )

     !--------- üå ----------

     !----- =0 at the top ---------
     call AssertEqual(&
          message='wq_LaplaPol2Pol_wq (=0 Top Booundary)',            &
          answer = xyr_Poloidal(:,:,kmi),                                &
          check = xyr_Zero(:,:,kmi),                                     &
          significant_digits = check_digits, ignore_digits = ignore     &
          )

     !----- d/dr=0, d^2/dr^2 at the top ---------
     if( BCond(l)(1:1) == 'F' ) then
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_RadDRad_wq(wq_Poloidal))&
                                       -wq_RadDRad_wq(wq_Poloidal))/xyr_Rad**2
     else
        xyr_True = xyr_wq(wq_RadDRad_wq(wq_Poloidal))/xyr_Rad
     endif

     call AssertEqual(&
          message='wq_LaplaPol2Pol_wq (Top Booundary)',                 &
          answer = xyr_True(:,:,kmi),                                    &
          check = xyr_Zero(:,:,kmi),                                     &
          significant_digits = check_digits, ignore_digits = ignore     &
          )

     call MessageNotify('M','wq_module_polvelbc_test', &
          'wq_LaplaPol2Pol_wq: '//BCond(l)//'-Top B.C. test succeeded!')
          
  end do

  call MessageNotify('M','wtq_mpi_module_polvelbc_wq_test', &
       'wtq_mpi_module wq_LaplaPol2Pol_wq subroutine test succeeded!')

 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wtq_mpi_module_polvelbc_wq_test
