!------------------------------------------------------------------------
! Copyright(c) 2007-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ :: ѴؿΥƥ
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_base

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=2.0d0             ! Ⱦ

  real(8), dimension((nm+1)**2,0:lm)   ::  wu_data
  real(8), dimension(0:im-1,1:jm,0:km) ::  xyr_data
  real(8), dimension(0:im-1,1:jm,0:km) ::  xyr_xi
  ! Ƚ
  integer, parameter :: check_digits = 12
  integer, parameter :: ignore = -13
  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','wu_test_base', &
                         'wu_module basic transformation functions tests')

  call wu_Initial(im,jm,km,nm,lm,ra)

  xyr_xi = 2.0D0*(xyr_Rad/ra)**2 - 1.0D0

  ! Y_1^0 T_1
  xyr_data = dsqrt(3.0D0)*sin(xyr_Lat)*xyr_xi*xyr_Rad
  wu_data= 0.0D0 ; wu_data(l_nm(1,0),1)=1.0D0
  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_1^0 T_1')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_1^0 T_1')

  ! Y_1^1 T_0
  xyr_data = dsqrt(3.0D0/2)*cos(xyr_Lat)*cos(xyr_Lon)*xyr_Rad
  wu_data= 0.0D0 ;  wu_data(l_nm(1,1),0)=1.0D0/dsqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_1^1 T_0')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_1^1 T_0')

  !Y_1^{-1}T_2
  xyr_data = -dsqrt(3.0D0/2)*cos(xyr_Lat)*sin(xyr_Lon) &
              *(2*xyr_xi**2-1)*xyr_Rad
  wu_data= 0.0D0 ;  wu_data(l_nm(1,-1),2)=1.0D0/dsqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_1^(-1) T_2')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_1^(-1) T_2')

 ! Y_2^0 T_3
  xyr_data = dsqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1.0d0/2.0d0) &
              *(4.0d0*xyr_xi**3-3.0d0*xyr_xi) * xyr_Rad**2
  xyr_data = dsqrt(5.0D0)*(3.0/2*sin(xyr_Lat)**2-1.0d0/2.0d0) &
              *(4.0d0*xyr_xi**3-3.0d0*xyr_xi)
  wu_data= 0.0D0 ; wu_data(l_nm(2,0),3)=1.0D0

  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_2^0 T_3')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_2^0 T_3')

 !Y_2^1 T_4
  xyr_data = dsqrt(5.0D0/6.0d0)*3.0d0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
           *(8.0d0*xyr_xi**4 - 8.0d0*xyr_xi**2 + 1.0d0 )* xyr_Rad**2
  xyr_data = dsqrt(5.0D0/6.0d0)*3.0d0*sin(xyr_Lat)*cos(xyr_Lat)*cos(xyr_Lon) &
           *(8.0d0*xyr_xi**4 - 8.0d0*xyr_xi**2 + 1.0d0 )
  wu_data= 0.0D0 ; wu_data(l_nm(2,1),4)=1.0D0/sqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_2^1 T_4')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_2^1 T_4')

 ! Y_2^-2
  xyr_data = -dsqrt(5.0D0/2.4d1)*3.0d0*cos(xyr_Lat)**2*sin(2*xyr_Lon) &
            *(1.6d1*xyr_xi**5-2.0d1*xyr_xi**3+5.0d0*xyr_xi)* xyr_Rad**2
  xyr_data = -dsqrt(5.0D0/2.4d1)*3.0d0*cos(xyr_Lat)**2*sin(2*xyr_Lon) &
            *(1.6d1*xyr_xi**5-2.0d1*xyr_xi**3+5.0d0*xyr_xi)
  wu_data= 0.0D0 ; wu_data(l_nm(2,-2),5)=1.0D0/dsqrt(2.0D0)

  call check2d(wu_data, wu_xyr(xyr_data), &
        'transform test of Y_2^(-2) T_5')
  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of Y_2^(-2) T_5')

  xyr_data =                      &
    cos(2.0d0*xyr_Lon - pi/3.0d0) &
    * (sin(xyr_Lat)-1.0d0)**2     &
    * (sin(xyr_Lat)-0.5d0)        &
    * (sin(xyr_Lat)+1.0d0)        &
    * exp(xyr_Rad)

  call check3d(xyr_data, xyr_wu(wu_xyr(xyr_data)), &
        'inverse transform test of general function')

 call MessageNotify('M','wu_test_base', &
                        'wu_base_module functions tests succeeded!')


contains
  subroutine check2d(sol, ans, mess)
    real(8) :: sol(:,:)
    real(8) :: ans(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )

  end subroutine check2d

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d


end program wu_test_base
