!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!  wu_RadRot_xyz_xyz, wu_RadRotRot_xyz_xyz_xyz  Υƥ
!    r(xv), r(xxv)
!
!  2008/01/02  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative5

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLon
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLat
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VRad
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_RadRot
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_RadRotRot
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Torvel
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Polvel

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  integer :: i,j,k

  call MessageNotify('M','wu_test_derivative5', &
       'wu_module derivative function test #5')

  call wu_initial(im,jm,km,nm,lm,ra)

  xyr_VLon = 0.0D0 ; xyr_VLat = 0.0D0 ; xyr_VRad = xyr_Rad
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0

  call MessageNotify('M','wu_test_derivative5', 'Simple example (v_r=r)')
  call checkresult

  ! βž(ή)

  xyr_VLon = 0.0D0
  xyr_VLat =   xyr_Rad*sin(xyr_Lat)*cos(xyr_Lat)
  xyr_VRad = - xyr_Rad*cos(xyr_Lat)**2
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0
  call MessageNotify('M','wu_test_derivative5', 'Rigid Rotation: 1')
  call checkresult

  ! βž(ή)
  xyr_VLon =   xyr_Rad*cos(xyr_Lat)*sin(xyr_Lon)*cos(xyr_Lon)
  xyr_VLat = - xyr_Rad*sin(xyr_Lat)*cos(xyr_Lat)*sin(xyr_Lon)**2
  xyr_VRad = - xyr_Rad*(sin(xyr_Lat)**2*sin(xyr_Lon)**2 + cos(xyr_Lon)**2)
  xyr_RadRot = 0.0D0 ; xyr_RadRotRot = 0.0D0

  call MessageNotify('M','wu_test_derivative5', 'Rigid Rotation: 2')
  call checkresult

  ! ľ٤ȼ٥ȥ
  ! r**3 P_1^1
  xyr_Polvel = xyr_Rad**3 * cos(xyr_Lat)*sin(xyr_Lon)
  ! r**2 P_2^1
  ! xyr_Psi = xyr_Rad**3 * cos(xyr_Lat)*sin(xyr_Lat)*sin(xyr_Lon)

  xyr_VLon =   xyr_GradLat_wu(wu_xyr(xyr_Polvel*xyr_Rad))
  xyr_VLat = - xyr_GradLon_wu(wu_xyr(xyr_Polvel*xyr_Rad))
  xyr_VRad = 0.0D0
  ! rߢ(r) = L_2
  xyr_RadRot = 2.0d0 * xyr_Polvel
  ! rߢ(r) = L_2
  ! xyr_RadRot = 6 * xyr_Polvel
  xyr_RadRotRot = 0.0D0

  call MessageNotify('M','wu_test_derivative5', 'Vortical field')
  call checkresult

  ! ľ®٤ȼ٥ȥ
  xyr_Torvel = 0.0D0
  xyr_Polvel = xyr_Rad**3 * cos(xyr_Lat)*sin(xyr_Lon)   ! r**2 P_1^1
  call wu_Potential2Vector(&
         xyr_VLon,xyr_VLat,xyr_VRad, wu_xyr(xyr_Torvel),wu_xyr(xyr_Polvel) )

  !!$  xyr_VRad = xyr_wu(wu_L2_wu(wu_xyr(xyr_Psi/xyr_Rad)))
  !!$  xyr_VLat = xyr_GradLat_wu(wu_wr(wr_DRad_wu(wu_xyr(xyr_Psi*xyr_Rad))))
  !!$  xyr_VLon = xyr_GradLon_wu(wu_wr(wr_DRad_wu(wu_xyr(xyr_Psi*xyr_Rad))))

  xyr_RadRot = 0.0D0
  ! rߢߢߢ(r) = -L_2^2
  xyr_RadRotRot = -xyr_wu(wu_L2_wu(wu_wr(wr_Lapla_wu(wu_xyr(xyr_Polvel)))))
  !!$  xyr_RadRotRot = -8 * cos(xyr_Lat)*sin(xyr_Lon)

  call MessageNotify('M','wu_test_derivative5', 'Non-Vortical field')
  call checkresult

  call MessageNotify('M','wu_test_derivative5', &
       'wu_module derivative function test #5 succeeded!')

contains

  subroutine checkresult
    write(6,*)'Checking r Rot v...'

    xyr_Data = xyr_wu(wu_RadRot_xyr_xyr(xyr_VLon,xyr_VLat))
    call check3d(xyr_RadRot, xyr_Data, 'Checking r Rot v...')

    xyr_Data = xyr_wr(wr_RadRotRot_xyr_xyr_xyr(xyr_VLon,xyr_VLat,xyr_VRad))
    call check3d(xyr_RadRotRot, xyr_Data, 'Checking r Rot Rot v...')

  end subroutine checkresult

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

end program wu_test_derivative5
