!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!     ֥롼Υƥ
!       wu_Potential2Vector
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative6

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=32  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=32         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=7.0D0/13.0D0      ! ⳰Ⱦ \eta=0.35

  real(8), dimension((nm+1)*(nm+1),0:lm) :: wu_VTor    ! ȥݥƥ󥷥
  real(8), dimension((nm+1)*(nm+1),0:lm) :: wu_VPol    ! ݥݥƥ󥷥

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLon  ! ®()
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLat  ! ®()
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Vrad  ! ®(ư)
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_V0Lon  ! ®(, )
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_V0Lat  ! ®(, )
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_V0rad  ! ®(,ư)

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  call MessageNotify('M','wu_test_derivative7', &
       'wu_module derivative subroutine test #7')

  call wu_Initial(im,jm,km,nm,lm,ra)

! -----------------  1 --------------------
  ! βž
  wu_VTor = wu_xyr(xyr_Rad * sin(xyr_Lat))
  wu_VPol = 0.0D0
  xyr_V0lon = xyr_Rad * cos(xyr_Lat)
  xyr_V0lat = 0.0D0
  xyr_V0Rad = 0.0D0

  write(6,*)'Example 1 : rigid rotation 1'
  write(6,*)'    xyr_Vlon = xyr_Rad * cos(xyr_Lat)'
  write(6,*)'    xyr_Vlat = 0.0'
  write(6,*)'    xyr_VRad = 0.0'
  call checkresult

! -----------------  2 --------------------
  ! βž(ή)
  wu_VTor = wu_xyr(xyr_Rad * cos(xyr_Lat) * sin(xyr_Lon))
  wu_VPol = 0.0D0
  xyr_V0Lon = -xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)
  xyr_V0Lat = -xyr_Rad*cos(xyr_Lon)
  xyr_V0Rad = 0.0D0

  write(6,*)'Example 2 : rigid rotation'
  write(6,*)'    xyr_Vlon =   xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)'
  write(6,*)'    xyr_Vlat = - xyr_Rad*cos(xyr_Lon)'
  write(6,*)'    xyr_VRad =   0.0'

  call checkresult

! -----------------  3 --------------------
 ! ̵

  wu_VTor = 0.0D0
  wu_VPol = wu_xyr(xyr_Rad**3 * sin(xyr_Lat))
  xyr_V0lon = 0D0
  xyr_V0lat = 4.0D0 * xyr_Rad**2 * cos(xyr_Lat)
  xyr_V0rad = 2.0D0 * xyr_Rad**2 * sin(xyr_Lat)

  write(6,*)'Example 3 : no rotation'
  write(6,*)'    xyr_Vlon = 0.0'
  write(6,*)'    xyr_Vlat = 4 * xyr_Rad**2 * cos(xyr_Lat)'
  write(6,*)'    xyr_VRad = 2 * xyr_Rad**2 * sin(xyr_Lat)'

  call checkresult


! -----------------  4 --------------------
 ! ݥ®پ

  wu_VTor = 0.0D0
  wu_VPol = wu_xyr(xyr_Rad**5 * cos(xyr_Lat)*sin(xyr_Lon))
  xyr_V0lon =   6.0D0 * xyr_Rad**4 * cos(xyr_Lon)
  xyr_V0lat = - 6.0D0 * xyr_Rad**4 * sin(xyr_Lat) * sin(xyr_Lon)
  xyr_V0rad =   2.0D0 * xyr_Rad**4 * cos(xyr_Lat) * sin(xyr_Lon)

  write(6,*)'Example 4 : poloidal field'
  write(6,*)'    xyr_Vlon =   6 * xyr_Rad**4 * cos(xyr_Lon)'
  write(6,*)'    xyr_Vlat = - 6 * xyr_Rad**4 * sin(xyr_Lat) * sin(xyr_Lon)'
  write(6,*)'    xyr_VRad =   2 * xyr_Rad**4 * cos(xyr_Lat) * sin(xyr_Lon)'

  call checkresult

  call MessageNotify('M','wu_test_derivative6', &
       'wu_module derivative function test #6 succeeded!')

contains

 !-------  -------
  subroutine checkresult

    call wu_Potential2Vector(&
         xyr_VLon,xyr_VLat,xyr_VRad, wu_VTor, wu_VPol )

    call check3d(xyr_V0Lon, xyr_VLon, 'Checking V_Lon')
    call check3d(xyr_V0Lat, xyr_VLat, 'Checking V_Lat')
    call check3d(xyr_V0Rad, xyr_VRad, 'Checking V_Rad ')

  end subroutine checkresult

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d


end program wu_test_derivative6
