/*
 * $Id: p_header,v 1.4 2000/11/27 01:57:01 keiko Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return doublereal */
/* fnclib */
extern doublereal rd2r_(real *);
extern doublereal rr2d_(real *);
extern doublereal rexp_(real *, integer *, integer *);
extern doublereal rfpi_(void);
extern doublereal rmod_(real *, real *);
/* gnmlib */
extern doublereal rgnlt_(real *);
extern doublereal rgnle_(real *);
extern doublereal rgngt_(real *);
extern doublereal rgnge_(real *);
/* rfalib */
extern doublereal rmax_(real *, integer *, integer *);
extern doublereal rmin_(real *, integer *, integer *);
extern doublereal rsum_(real *, integer *, integer *);
extern doublereal rave_(real *, integer *, integer *);
extern doublereal rvar_(real *, integer *, integer *);
extern doublereal rstd_(real *, integer *, integer *);
extern doublereal rrms_(real *, integer *, integer *);
extern doublereal ramp_(real *, integer *, integer *);
/* rfblib */
extern doublereal rprd_(real *, real *, integer *, integer *, integer *);
extern doublereal rcov_(real *, real *, integer *, integer *, integer *);
extern doublereal rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_ifromc(obj, cx)
    VALUE obj, cx;
{
    char *i_cx;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }

    i_cx = STR2CSTR(cx);


    o_rtn_val = ifromc_(i_cx, (ftnlen)strlen(i_cx));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_lfromc(obj, cx)
    VALUE obj, cx;
{
    char *i_cx;
    logical o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }

    i_cx = STR2CSTR(cx);


    o_rtn_val = lfromc_(i_cx, (ftnlen)strlen(i_cx));

    rtn_val = (o_rtn_val == FALSE_) ? Qfalse : Qtrue;


    return rtn_val;

}

static VALUE
dcl_rfromc(obj, cx)
    VALUE obj, cx;
{
    char *i_cx;
    real o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }

    i_cx = STR2CSTR(cx);


    o_rtn_val = rfromc_(i_cx, (ftnlen)strlen(i_cx));

    rtn_val = rb_float_new((double)o_rtn_val);


    return rtn_val;

}
void
init_math1_xfclib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "ifromc", dcl_ifromc, 1);
    rb_define_module_function(mDCL, "lfromc", dcl_lfromc, 1);
    rb_define_module_function(mDCL, "rfromc", dcl_rfromc, 1);
}
