#
# kihon7.rb
#   $Id: kihon7.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

def aplot
  nmax = 40
  x = NArray.sfloat(nmax+1)
  y = NArray.sfloat(nmax+1)

  DCL::slpvpr(1)

  #-- circle ----
  dt = 2.0*PI/nmax
  for n in 0..nmax
    x[n] = 40.0*sin(n*dt)
    y[n] = 40.0*cos(n*dt)
  end

  DCL::sgplu(x, y)

  #-- triangle ----
  dt = 2.0*PI/3
  for n in 0..3
    x[n] = 40.0*sin(n*dt)
    y[n] = 40.0*cos(n*dt)
  end

  DCL::sgplu(x, y)

  #-- string ----
  DCL::sgtxu(0.0, 0.0, 'SGTXU')

end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

#sglset('LCLIP', true)

#-- frame 1 ----
DCL::sgfrm
#        xmin,  xmax,   ymin,  ymax
DCL::sgswnd(-100.0, 100.0, -100.0, 100.0)
DCL::sgsvpt(   0.0,   1.0,    0.0,   1.0)
DCL::sgstrn(1)
DCL::sgstrf

aplot

#-- frame 2 ----
DCL::sgfrm

#-- upper left ----
#        xmin,  xmax,   ymin,  ymax
DCL::sgswnd(-100.0, 100.0, -100.0, 100.0)
DCL::sgsvpt(   0.1,   0.4,    0.6,   0.9)
DCL::sgstrn(1)
DCL::sgstrf

aplot

#-- upper right ----
#        xmin,  xmax,   ymin,  ymax
DCL::sgswnd(-100.0, 100.0,  -40.0,  40.0)
DCL::sgsvpt(   0.6,   0.9,    0.6,   0.9)
DCL::sgstrn(1)
DCL::sgstrf

aplot

#-- lower left ----
#        xmin,  xmax,   ymin,  ymax
DCL::sgswnd(-100.0, 100.0, -200.0,   0.0)
DCL::sgsvpt(   0.1,   0.4,    0.1,   0.4)
DCL::sgstrn(1)
DCL::sgstrf

aplot
      
#-- lower right ----
#        xmin,  xmax,   ymin,   ymax
DCL::sgswnd(-100.0, 100.0,    0.0, -200.0)
DCL::sgsvpt(   0.6,   0.9,    0.1,   0.4)
DCL::sgstrn(1)
DCL::sgstrf

aplot

DCL::sgcls

