/*
 * $Id: p_header,v 1.2 2011-02-23 17:47:10 koshiro Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_indxcf(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) == T_STRING) {
      cx = rb_Array(cx);
    }
    if (TYPE(cx) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);
    i_cx = dcl_obj2ccharary(cx, (i_jd*(i_n-1)+1), 1);


    o_rtn_val = indxcf_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)1, (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freeccharary(i_cx);

    return rtn_val;

}

static VALUE
dcl_indxcl(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) == T_STRING) {
      cx = rb_Array(cx);
    }
    if (TYPE(cx) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);
    i_cx = dcl_obj2ccharary(cx, (i_jd*(i_n-1)+1), 1);


    o_rtn_val = indxcl_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)1, (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freeccharary(i_cx);

    return rtn_val;

}

static VALUE
dcl_indxmf(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = indxmf_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_indxml(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = indxml_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_indxnf(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = indxnf_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_indxnl(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = indxnl_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_indxif(obj, ix, n, jd, ii)
    VALUE obj, ix, n, jd, ii;
{
    integer *i_ix;
    integer i_n;
    integer i_jd;
    integer i_ii;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ii) != T_BIGNUM) || (TYPE(ii) != T_FIXNUM)) {
      ii = rb_funcall(ii, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ii = NUM2INT(ii);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = indxif_(i_ix, &i_n, &i_jd, &i_ii);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_indxil(obj, ix, n, jd, ii)
    VALUE obj, ix, n, jd, ii;
{
    integer *i_ix;
    integer i_n;
    integer i_jd;
    integer i_ii;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ii) != T_BIGNUM) || (TYPE(ii) != T_FIXNUM)) {
      ii = rb_funcall(ii, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ii = NUM2INT(ii);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = indxil_(i_ix, &i_n, &i_jd, &i_ii);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_indxrf(obj, rx, n, jd, rr)
    VALUE obj, rx, n, jd, rr;
{
    real *i_rx;
    integer i_n;
    integer i_jd;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = indxrf_(i_rx, &i_n, &i_jd, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_indxrl(obj, rx, n, jd, rr)
    VALUE obj, rx, n, jd, rr;
{
    real *i_rx;
    integer i_n;
    integer i_jd;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = indxrl_(i_rx, &i_n, &i_jd, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}

static VALUE
dcl_nindxc(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) == T_STRING) {
      cx = rb_Array(cx);
    }
    if (TYPE(cx) != T_ARRAY) {
      rb_raise(rb_eTypeError, "invalid type");
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);
    i_cx = dcl_obj2ccharary(cx, (i_jd*(i_n-1)+1), 1);


    o_rtn_val = nindxc_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)1, (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freeccharary(i_cx);

    return rtn_val;

}

static VALUE
dcl_nindxm(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = nindxm_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_nindxn(obj, cx, n, jd, ch)
    VALUE obj, cx, n, jd, ch;
{
    char *i_cx;
    integer i_n;
    integer i_jd;
    char *i_ch;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(cx) != T_STRING) {
      cx = rb_funcall(cx, rb_intern("to_str"), 0);
    }
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(ch) != T_STRING) {
      ch = rb_funcall(ch, rb_intern("to_str"), 0);
    }

    i_cx = StringValuePtr(cx);
    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ch = StringValuePtr(ch);


    o_rtn_val = nindxn_(i_cx, &i_n, &i_jd, i_ch, (ftnlen)strlen(i_cx), (ftnlen)strlen(i_ch));

    rtn_val = INT2NUM(o_rtn_val);


    return rtn_val;

}

static VALUE
dcl_nindxi(obj, ix, n, jd, ii)
    VALUE obj, ix, n, jd, ii;
{
    integer *i_ix;
    integer i_n;
    integer i_jd;
    integer i_ii;
    integer o_rtn_val;
    VALUE rtn_val;

    if ((TYPE(ix) == T_BIGNUM) || (TYPE(ix) == T_FIXNUM)) {
      ix = rb_Array(ix);
    }
    /* if ((TYPE(ix) != T_ARRAY) && 
           (rb_obj_is_kind_of(ix, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if ((TYPE(ii) != T_BIGNUM) || (TYPE(ii) != T_FIXNUM)) {
      ii = rb_funcall(ii, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_ii = NUM2INT(ii);
    i_ix = dcl_obj2cintegerary(ix);


    o_rtn_val = nindxi_(i_ix, &i_n, &i_jd, &i_ii);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecintegerary(i_ix);

    return rtn_val;

}

static VALUE
dcl_nindxr(obj, rx, n, jd, rr)
    VALUE obj, rx, n, jd, rr;
{
    real *i_rx;
    integer i_n;
    integer i_jd;
    real i_rr;
    integer o_rtn_val;
    VALUE rtn_val;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jd) != T_BIGNUM) || (TYPE(jd) != T_FIXNUM)) {
      jd = rb_funcall(jd, rb_intern("to_i"), 0);
    }
    if (TYPE(rr) != T_FLOAT) {
      rr = rb_funcall(rr, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_jd = NUM2INT(jd);
    i_rr = (real)NUM2DBL(rr);
    i_rx = dcl_obj2crealary(rx);


    o_rtn_val = nindxr_(i_rx, &i_n, &i_jd, &i_rr);

    rtn_val = INT2NUM(o_rtn_val);

    dcl_freecrealary(i_rx);

    return rtn_val;

}
void
init_math1_indxlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "indxcf", dcl_indxcf, 4);
    rb_define_module_function(mDCL, "indxcl", dcl_indxcl, 4);
    rb_define_module_function(mDCL, "indxmf", dcl_indxmf, 4);
    rb_define_module_function(mDCL, "indxml", dcl_indxml, 4);
    rb_define_module_function(mDCL, "indxnf", dcl_indxnf, 4);
    rb_define_module_function(mDCL, "indxnl", dcl_indxnl, 4);
    rb_define_module_function(mDCL, "indxif", dcl_indxif, 4);
    rb_define_module_function(mDCL, "indxil", dcl_indxil, 4);
    rb_define_module_function(mDCL, "indxrf", dcl_indxrf, 4);
    rb_define_module_function(mDCL, "indxrl", dcl_indxrl, 4);
    rb_define_module_function(mDCL, "nindxc", dcl_nindxc, 4);
    rb_define_module_function(mDCL, "nindxm", dcl_nindxm, 4);
    rb_define_module_function(mDCL, "nindxn", dcl_nindxn, 4);
    rb_define_module_function(mDCL, "nindxi", dcl_nindxi, 4);
    rb_define_module_function(mDCL, "nindxr", dcl_nindxr, 4);
}
