!----------------------------------------------------------------------
!     Copyright (c) 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtq_mpi_module ƥȥץ :: wq_mpi_module ѴؿΥƥ
!
!  2011/09/08  ݹ
!
program wtq_mpi_module_base_wq_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtq_mpi_module
  use mpi
  implicit none

  integer,parameter  :: im=32, jm=16         ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=10       ! ʻ(ư, ư)
  integer,parameter  :: nm=10                ! ȿ(ʿ)
  integer,parameter  :: lmo=10, lmi=16       ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5       ! ⳰Ⱦ

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11

  real(8), allocatable ::  xvr_data(:,:,:)
  real(8) :: pi
  integer :: iproc, np, ierr

 !---------------- MPI  ---------------------
  call MPI_INIT(IERR)
  call MPI_COMM_RANK(MPI_COMM_WORLD,IPROC,IERR)
  call MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

  pi = atan(1.0D0)*4.0D0

  call MessageNotify('M','wtq_mpi_module_base_test', &
                         'wtq_mpi_module wq-basic transformation functions tests') 

  call wtq_mpi_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

  allocate(xvr_data(0:im-1,jc,kmi))

  !---- Y_1^* Υƥ ----
  xvr_data = sqrt(3.0D0)*sin(xvr_Lat)*xvr_Rad        ! r Y_1^0 
  call AssertEqual(&
    message='xvr_wq with r Y_1^0',                                &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xvr_data = sqrt(3.0D0/2)*cos(xvr_Lat)*cos(xvr_Lon)*xvr_Rad**3   ! r^3Y_1^1 
  call AssertEqual(&
    message='xvr_wq with r^3 Y_1^1',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  xvr_data = -sqrt(3.0D0/2)*cos(xvr_Lat)*sin(xvr_Lon) * xvr_Rad**5  !r^5Y_1^{-1}
  call AssertEqual(&
    message='xvr_wq with r^5 Y_1^-1',                             &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- Y_2^* Υƥ ----
  !r^2 Y_2^0
  xvr_data = sqrt(5.0D0)*(3.0/2*sin(xvr_Lat)**2-1/2.0) * xvr_Rad**2
  call AssertEqual(&
    message='xvr_wq with r^2 Y_2^0',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^4 Y_2^1 
  xvr_data = sqrt(5.0D0/6)*3.0*sin(xvr_Lat)*cos(xvr_Lat)*cos(xvr_Lon) &
            * xvr_Rad**4
  call AssertEqual(&
    message='xvr_wq with r^4 Y_2^1',                              &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !r^6 Y_2^-2
  xvr_data = -sqrt(5.0D0/24)*3.0*cos(xvr_Lat)**2*sin(2*xvr_Lon)* xvr_Rad**6
  call AssertEqual(&
    message='xvr_wq with r^6 Y_2^-2',                             &
    answer = xvr_data,                                            &
    check = xvr_wq(wq_xvr(xvr_data)),                             &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  call MessageNotify('M','wtq_base_module_mpi_test', &
                         'wtq_mpi_module wq-basic functions tests succeeded!') 


 !------ MPIνλ ------

  call MPI_FINALIZE(IERR)

end program wtq_mpi_module_base_wq_test
