##$LOAD_PATH.clear
##$LOAD_PATH.push("/usr/lib/ruby/1.8")
##$LOAD_PATH.push("/usr/lib/ruby/1.8/i686-linux")
$LOAD_PATH.unshift("../lib/")
require "numru/gphys/axis.rb"
require "test/unit"
include NumRu

class AxisTest < Test::Unit::TestCase
  def setup
    @len = 10
    xc = VArray.new( NArray.float(@len).indgen! + 0.5 ).rename("x")
    xb = VArray.new( NArray.float(@len+1).indgen! ).rename("xb")
    @axpt = Axis.new().set_pos(xc)
    axcel = Axis.new(true).set_cell(xc,xb)
    @axcel_c = axcel.dup.set_pos_to_center
    @axcel_b = axcel.dup.set_pos_to_bounds
    #axcel2 = Axis.new(true).set_cell_guess_bounds(xc)

    xcc = xc.copy
    xcc.set_att("modulo", [@len.to_f])
    @axcyc = Axis.new().set_pos(xcc)
  end

  def test_cell
    assert_equal(@axcel_c.cell_center?, true)
    assert_equal(@axcel_b.cell_bounds?, true)
  end

  def test_length
    assert_equal(@axpt.length, @len)
    assert_equal(@axcel_c.length, @len)
    assert_equal(@axcel_b.length, @len+1)
  end

  def test_cyclic
    assert_equal(@axcyc.cyclic?, true)
    assert_equal(@axcyc.cyclic_extendible?, true)
    assert( @axcyc.cut(14.9)[0].is_a?(String) )  # cut by scalar
    ax, sl = @axcyc.cut([5.6, 13.1, 14.9])    # cut by Array
    assert_equal( ax.pos.val.to_a, [5.5, 13.5, 14.5] )
    assert_equal( sl, [5, 3, 4] )
    ax, sl = @axcyc.cut(-3..3)
    assert_equal( ax.pos.val.to_a, [-2.5, -1.5, -0.5, 0.5, 1.5, 2.5] )
    assert_equal( sl, [7,8,9,0,1,2] )
    ax, sl = @axcyc.cut(-3..13)
    assert_equal( ax.length, 16 )
    assert_equal( sl.length, 16 )
    p "###", ax.pos.val.to_a,sl.to_a
    ##p "###", @axcyc.cut(0.1..0.2)
  end

  def test_add
    assert_equal( @axpt.add(3.0).pos.val[0], @axpt.pos.val[0]+3.0 )
    axcel_b2 = @axcel_b.add( NArray.float(@axcel_b.length).indgen! )
    len = axcel_b2.length
    assert_equal( @axcel_b.pos[-1].val + (len-1), axcel_b2.pos[-1].val )
    assert_not_equal( @axcel_b.cell_center.val, axcel_b2.cell_center.val )
    assert_nothing_raised{@axcel_c.add(NArray.float(@axcel_c.length).indgen!)}
  end
end
