************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2011 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
************************************************************************
*     CALCULATE ENERGY
************************************************************************
      SUBROUTINE NDGEEA(MM,PSI,ENE)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI((MM+1)*(MM+1))

      CALL NDGEEZ(MM,PSI,ENE)
      
      DO M=1,MM
        CALL STNM2L(MM,M,M,L)
        CALL NDGEEW(MM,M,PSI(L),ENEW)
        ENE=ENE+ENEW
      END DO

      END
************************************************************************
      SUBROUTINE NDGEEZ(MM,PSI,ENE)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI(0:MM)

      ENE=0
      DO N=0,MM
        ENE=ENE+PSI(N)*PSI(N)*N*(N+1)
      END DO
      ENE=0.5D0*ENE

      END
************************************************************************
      SUBROUTINE NDGEEW(MM,M,PSI,ENE)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI(M:MM,2)

      ENE=0
      DO N=M,MM
        ENE=ENE+(PSI(N,1)*PSI(N,1)+PSI(N,2)*PSI(N,2))*N*(N+1)
      END DO

      END
************************************************************************
*     CALCULATE ENSTROPHY
************************************************************************
      SUBROUTINE NDGENA(MM,PSI,ENS)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI((MM+1)*(MM+1))

      CALL NDGENZ(MM,PSI,ENS)
      
      DO M=1,MM
        CALL STNM2L(MM,M,M,L)
        CALL NDGENW(MM,M,PSI(L),ENSW)
        ENS=ENS+ENSW
      END DO

      END
************************************************************************
      SUBROUTINE NDGENZ(MM,PSI,ENS)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI(0:MM)

      ENS=0
      DO N=0,MM
        ENS=ENS+PSI(N)*PSI(N)*(N*(N+1))*(N*(N+1))
      END DO
      ENS=0.5D0*ENS

      END
************************************************************************
      SUBROUTINE NDGENW(MM,M,PSI,ENS)

      IMPLICIT REAL*8(A-H,O-Z)
      DIMENSION PSI(M:MM,2)

      ENS=0
      DO N=M,MM
        ENS=ENS
     &      +(PSI(N,1)*PSI(N,1)+PSI(N,2)*PSI(N,2))*(N*(N+1))*(N*(N+1))
      END DO

      END
