#
# lay1.rb
#   $Id: lay1.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 401
jmax = 51

y = NArray.sfloat(nmax)

#-- data ----
y0 = 0.5
for n in 0..nmax-1
  y[n] = 5.0*y0 + 10.0
  y0 = 3.7*y0*(1.0-y0)
end

rundef = DCL::glrget('RUNDEF')

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::sldiv('Y', 3, 2)

for i in 1..8

  DCL::grfrm

  j = (i-1)*(jmax-1)
  xmin = j + 1600.0
  xmax = xmin + jmax - 1

  DCL::grswnd(xmin, xmax, rundef, rundef)
  DCL::ussttl('TIME', 'YEAR', 'TEMPERATURE', 'DEG')
  DCL::usgrph(rundef, y[j..j+jmax-1])

end

DCL::grcls

