#
# test01.rb
#
# $Id: test01.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


nx = 19
ny = 19
xmin = 0
xmax = 360
ymin = -90
ymax = +90
dx1 = 20
dx2 = 60
dy1 = 10
dy2 = 30
drad = PI / 180
dz = 0.05
dp = 0.2
p = NArray.new(Float, nx, ny)

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    p[i,j] = cos(alon) * (1-slat**2) * sin(2*PI*slat) + dz
  end
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

rmiss = DCL::glrget('RMISS')
DCL::sglset('LSOFTF', false)

DCL::grfrm
DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::uestlv(rmiss, -dp, 201)
DCL::uestlv(dp, dp*2, 401)
DCL::uestlv(dp*2, rmiss, 402)
DCL::uetone(p)

DCL::uxaxdv('B', dx1, dx2)
DCL::uxaxdv('T', dx1, dx2)
DCL::uxsttl('B', 'LONGITUDE', 0.0)

DCL::uyaxdv('L', dy1, dy2)
DCL::uyaxdv('R', dy1, dy2)
DCL::uysttl('L', 'LATITUDE', 0.0)

DCL::udgclb(p, dp)
DCL::udcntr(p)

DCL::grcls

