#
# uupk03.rb
#
# $Id: uupk03.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 30
y = NArray.sfloat(n)

#---------------------------- DATA DEFINITION --------------------------
r = 0.2
a = 3.7
for i in 0..n-1
  r = a*r*(1.0-r)
  y[i] = r
end

y[n/2-1] = 999.0
DCL::gllset('LMISS', true)
rundef = DCL::glrget('RUNDEF')

#----------------------------- GRAPH -----------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(0.0, 1.0, rundef, rundef)
DCL::usspnt(rundef, y)
DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uvbxl(rundef, y)

DCL::grfrm

DCL::grswnd(rundef, rundef, 0.0, 1.0)
DCL::usspnt(y, rundef)
DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uhbxl(y, rundef)

DCL::grcls

