#
# cslb01.rb
#
# $Id: cslb01.rb,v 1.2 2012-03-30 13:57:40 koshiro Exp $
#

require "narray"
require "numru/dcl"
include NumRu
include Math

nx=100
ny=100
level=256

r = NArray.float(nx,ny)
g = NArray.float(nx,ny)
b = NArray.float(nx,ny)

nx.times do |i|
  ny.times do |j|
    r[i,j] = exp(-((i-nx/2.0)**2.0 + (j-ny/2.0)**2.0) / 5000.0)
    g[i,j] = exp(-((i-nx/1.1)**2.0 + (j-ny/1.2)**2.0) / 1000.0)
    b[i,j] = exp(-((i-ny/3.0)**2.0 + (j-ny/5.0)**2.0) / 3000.0)
  end
end

rc = DCL::rnorml(r,0.0,1.0)
gc = DCL::rnorml(g,0.2,1.0)
bc = DCL::rnorml(b,0.0,1.0)

DCL::swiset('WINDOW_HEIGHT', 300)
DCL::swiset('WINDOW_WIDTH',  300)

iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i

DCL::gropn(iws)
DCL::grfrm
DCL::grswnd(-1.0, 1.0, -1.0, 1.0)
DCL::grsvpt(0.1, 0.9, 0.1, 0.9)
DCL::grstrn(1)
DCL::grstrf

DCL::prcopn('DclPaintGrid3')

DCL::uipda3(rc, gc, bc)

DCL::prccls('DclPaintGrid3')

DCL::uxaxdv('t', 0.1, 0.5)
DCL::uxaxdv('b', 0.1, 0.5)
DCL::uyaxdv('l', 0.1, 0.5)
DCL::uyaxdv('r', 0.1, 0.5)

DCL::grcls
