#
# kihon2.rb
#   $Id: kihon2.rb,v 1.1.1.1 2011-02-23 07:21:26 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math

nmax = 40
imax = 4
dt = 4.0*PI/nmax

x = NArray.sfloat(nmax+1)
y = NArray.sfloat(nmax+1, imax)

#-- data ----
x = x.indgen * 1.0/nmax
for n in 0..nmax
  for i in 0..imax-1
    y[n,i] = 0.2*sin(n*dt) + 0.8 - 0.2*i
  end
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::sgopn iws

#-- line index : frame 1 --
DCL::sgfrm
DCL::slpvpr(1) 

DCL::sgplv(x, y[true,0])

for i in 1..imax-1
  DCL::sgspli(2*(i+1))
  DCL::sgplv(x, y[true,i])
end

DCL::sgspli(1)

#-- line type : frame 2 --
DCL::sgfrm
DCL::slpvpr(1)

DCL::sgplv(x, y[true,0])

for i in 1..imax-1
  DCL::sgsplt(i+1)
  DCL::sgplv(x, y[true,i])
end

DCL::sgcls

