require "narray"
require "numru/dcl"
include NumRu
include NMath

xmin = -1.2
xmax = 1.2
ymin = -1.2
ymax = 1.2

n = 300
x = sin( NArray.sfloat(n).indgen! * (4*PI/(n-1)) )
y = cos( NArray.sfloat(n).indgen! * (6*PI/(n-1)) )
p = sin( NArray.sfloat(n).indgen! * (2*PI/(n-1)) )

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL.swpset('ldump',true) if iws==4
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, ymin, ymax)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::usdaxs
DCL::glpset('lmiss',true)
DCL::glpset('rmiss',p[5])

DCL.uegtla(-1.0,1.0,0.1)
DCL::uemrkz(x,y,p,10,3,0.01)
#DCL::uumrkz(x,y,10,1,0.002)

DCL::grcls

