require "numru/dcl"


module NumRu
  module DCL

    alias :__gropn :gropn
    def gropn(wsn)

      pr, pw = IO.pipe

      width = NumRu::DCLExt::Anim.width
      height = NumRu::DCLExt::Anim.height

      fork do

        require "numru/dclext/anim/stream"

        pw.close

        stream = NumRu::DCLExt::Anim::Stream.new(pr)
        stream.start

      end  # fork

      require "gtk2"
      require "numru/dclext/gtk"
      require "numru/dclext/anim/source"

      pr.close

      Gtk.init

      drw = Gtk::DrawingArea.new
      drw.set_width_request NumRu::DCLExt::Anim.width
      drw.set_height_request NumRu::DCLExt::Anim.height
      drw.show

      wnd = Gtk::Window.new
      wnd.add drw
      drw.realize

      pixmap = Gdk::Pixmap.new(drw.window, width, height, -1)

      NumRu::DCLExt.zgsdrw(drw)
      NumRu::DCLExt.zgspmp(pixmap)
      
      @source = NumRu::DCLExt::Anim::Source.new(pixmap, pw)

      __gropn(4)
    end # gropn
    module_function :__gropn, :gropn

    alias :__grfrm :grfrm
    def grfrm
      @source.new_frame
      __grfrm
    end
    module_function :__grfrm, :grfrm

    alias :__grcls :grcls
    def grcls
      @source.close
      __grcls
    end
    module_function :__grcls, :grcls

  end # module DCL

end # module NumRu
