!--
!----------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wq_mpi_module
!
!    spml/wq_mpi_module ⥸塼ϵǤήαư򥹥ڥȥˡ 
!    MPI 󲽤ˤäƿͷ׻뤿 Fortran90 ؿ󶡤
!    ΤǤ. 
!
!    ʿ˵ĴȡѴư
!    Matsushima and Marcus (1994) 󾧤줿¿༰Ѥ
!    ڥȥ׻ΤΤޤޤʴؿ󶡤. 
!
!     wa_mpi_module, aq_module ѤƤ. 
!    ǲǤϵĴѴѴΥ󥸥Ȥ 
!    ISPACK  Fortran77 ֥롼ѤƤ.
!
!    Matsushima and Marcus (1994) ¿༰˴ؤ 
!    doc/spectral_radial.tex 򻲾ȤΤ. 
!
!
!  2008/04/03  ݹ  wu_module 
!      2008/05/02  ݹ  ɲ
!      2008/07/01  ʿ ʿγʻ 0:im-1,1:jm ˽
!      2008/07/04  ʿ Ȥ RDoc Ѥ
!      2008/07/20  ݹ  wq_Rad2_wq, wq_Rad2Inv_wq, wq_Lapla_wq ɲ
!      2008/07/21  ݹ  ׻ѹ
!      2009/01/09  ݹ  wu_Initial åդɲ
!      2009/01/29  ʿ Ȥ RDoc Ѥ
!      2009/07/31  ݹ  ׻ threadprivate (OpenMP)
!      2009/12/06  ݹ  ƬȤ
!      2010/03/10  ʿ  threadprivate (ѥ¸)
!      2010/04/17  ݹ  wr_DivRad_xyr ɲ, wr_Div_xyr_xyr_xyr ѹ
!                            wq_LaplaPol2Pol_wq η׻ˡѹ
!      2010/05/08  ݹ  wq_LaplaPol2Pol_wq η׻ˡˤɤ.
!      2011/09/08  ݹ  MPI 
!
!
!      ǡ index
!        x :          y :     v : (ʬʻ)     r : ư
!        w : Ĵ´ؿڥȥ
!        n : Ĵ´ؿڥȥ(ʿȿ)
!        m : Ĵ´ؿڥȥ(Ӿȿ)
!        q : ڥȥؿڥȥ
!        a : Ǥդμ
!
!        xyr : 3 ʻǡ
!        xvr : 3 ʬʻǡ
!        xy  : ʿ 2 ʻǡ
!        xv  : ʿ 2 ʬʻǡ
!        yr  : Ҹ 2 ʻǡ
!        vr  : Ҹ 2 ʬʻǡ
!        xr  :  2 ʻǡ
!
!        wr  : ʿڥȥư³ʻǡ
!        wq  : ڥȥǡ
!
!++
module wq_mpi_module
  !
  != wq_mpi_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wq_module.f90,v 1.14 2010-05-08 11:53:56 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/wq_mpi_module ⥸塼ϵǤήαư򥹥ڥȥˡ 
  ! MPI 󲽤ˤäƿͷ׻뤿 Fortran90 ؿ󶡤
  ! ΤǤ. 
  !
  ! ʿ˵ĴȡѴư
  ! Matsushima and Marcus (1994) 󾧤줿¿༰Ѥ
  ! ڥȥ׻ΤΤޤޤʴؿ󶡤. 
  !
  !  wa_mpi_module, aq_module ѤƤ. 
  ! ǲǤϵĴѴΥ󥸥Ȥ 
  ! ISPACK  Fortran77 ֥롼ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (wq_, nmr_, nr_, xyr_, wr_, w_, xy_, xv_, yr_, vr_, xr_, 
  !   x_, y_, v_, r_, a_) , ֤ͤη򼨤Ƥ.
  !   wq_  :: ڥȥǡ(ĴȡӥѴ)
  !   nmr_ :: ʿڥȥǡ(ȿ n, Ӿȿʬ, ư)
  !   nr_  :: ʿڥȥǡ(ȿ n, ư)
  !   xyr_ :: 3 ʻǡ(١١ư)
  !   xvr_ :: 3 ʬʻǡ(١١ư)
  !   wr_  :: ʿڥȥ, ư³ʻǡ
  !   xy_  :: 2 ʻǡ(١)
  !   xv_  :: 2 ʬʻǡ(١)
  !   yr_  :: 2 ʻǡ(١ư)
  !   vr_  :: 2 ʬʻǡ(١ư)
  !   xr_  :: 2 ʻǡ(١ư)
  !   x_   :: 1 ʻǡ()
  !   y_   :: 1 ʻǡ()
  !   v_   :: 1 ʬʻǡ()
  !   r_   :: 1 ʻǡ(ư)
  !   a_   :: Ǥդμ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla,..)
  !   , δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_wq, _nmr, _nr, _xyr, _wr, _w, _xy, _xv, _yr, _vr, _xr, 
  !   _x, _y, _v, _r, _a) , ѿηڥȥǡ
  !   ʻǡǤ뤳Ȥ򼨤Ƥ. 
  !   _wq      :: ڥȥǡ
  !   _xyr     :: 3 ʻǡ
  !   _xyr_xyr :: 2 Ĥ3 ʻǡ, ...
  !   _xvr     :: 3 ʬʻǡ
  !   _xvr_xvr :: 2 Ĥ3 ʬʻǡ, ...
  !
  !=== ƥǡμ
  !
  ! * xyr : 3 ʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,1:jm,km). 
  !   * im, jm, km Ϥ줾, , ưºɸγʻǤ, 
  !     ֥롼 wq_mpi_Initial ˤƤ餫ꤷƤ.
  !
  ! * xvr : 3 ʬʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,jc,km). 
  !   * im, km Ϥ줾, ưºɸγʻǤ, 
  !   * jc ϤΥץͭٳʻǤ. 
  !     ֥롼 wq_mpi_Initial Ƥ֤ jc ꤵ. 
  !
  ! * wq : ڥȥǡ
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:lm). 
  !   * nm ϵĴȡκȿ, lm ϥӥ¿༰κ缡
  !     Ǥ, ֥롼 wq_mpi_Initial ˤƤ餫ꤷƤ. 
  !   * ʿڥȥǡγǼΤϴؿ l_nm, nm_l ˤäĴ٤
  !     ȤǤ. 
  !   * ư¥ڥȥǡγǼˡˤĤƤ aq_module.f90 
  !     ȤΤ. km < 2*im ǤʤФʤʤ. 
  !
  ! * nmr : ʿڥȥǡ¤ 3 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm,km). 
  !   *  1 ʿȿ,  2 Ӿȿ,  3 ưºɸɽ. 
  !   * nm ϵĴȡκȿǤ, ֥롼 wq_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * nr : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,km). 
  !   *  1 ʿȿɽ. nm ϵĴȡκȿǤ, 
  !     ֥롼 wq_Initial ˤƤ餫ꤷƤ.
  !
  ! * wr : ʿڥȥ, ư³ʻǡ.
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),km).
  !
  ! * wq_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xyr_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * xvr_ ǻϤޤؿ֤ͤ 3 ʬʻǡƱ.
  !
  ! * wr_ ǻϤޤؿ֤ͤϿʿڥȥ, ư³ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  ! 
  !
  !== ѿ³
  !
  !====  
  !
  ! wq_mpi_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, x_Lon_Weight,  ::  ʻɸ()ȽŤߤǼ 1 
  ! y_Lat, y_Lat_Weight   ::  ʻɸ()ȽŤߤǼ 1 
  ! v_Lat, v_Lat_Weight   ::  ʬʻɸ()ȽŤߤǼ 1 
  ! r_Rad, r_Rad_Weight   ::  ʻɸ(Ʊ)ȽŤߤǼ 1 
  ! xyr_Lon, xyr_Lat, xyr_Rad :: ʻǡη١١ưºɸ(X,Y,Z) (ʻǡ 3 )
  ! xvr_Lon, xvr_Lat, xvr_Rad :: ʻǡη١١ưºɸ(X,Y,Z) (ʬʻǡ 3 )
  !
  !==== Ѵ
  !
  ! xyr_wq, wq_xyr :: ڥȥǡ 3 ʻҥǡδ֤Ѵ
  !                   (Ĵȡ, ӥѴ)
  !
  ! xvr_wq, wq_xvr :: ڥȥǡ 3 ʬʻҥǡδ֤Ѵ
  !                   (Ĵȡ, ӥѴ)
  !
  ! xyr_wr, wr_xyr :: 3 ʻҥǡȿʿڥȥ롦ư³ʻҥǡȤ
  !                   ֤Ѵ (Ĵȡ)
  !
  ! xvr_wr, wr_xvr :: 3 ʬʻҥǡȿʿڥȥ롦ư³ʻҥǡȤ
  !                   ֤Ѵ (Ĵȡ)
  !
  ! wr_wq, wq_wr   :: ڥȥǡȿʿڥȥ롦ư³ʻҥǡȤ
  !                   ֤Ѵ (ӥѴ)
  !
  ! w_xy, xy_w     :: ڥȥǡ 2 ʿʻҥǡ
  !                   ֤Ѵ(ĴȡѴ) 
  !
  ! w_xv, xv_w     :: ڥȥǡ 2 ʿʬʻҥǡ
  !                   ֤Ѵ(ĴȡѴ) 
  !
  ! l_nm, nm_l     :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! wq_RadDRad_wq       :: ڥȥǡưʬ r/r Ѥ
  ! wr_DivRad_wq        :: ڥȥǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wr_DivRad_xyr       :: ʻǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wr_DivRad_xvr       :: ʻǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wr_RotDRad_wq       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wr_RotDRad_wr       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wq_RotDRad_wr       :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wq_Lapla_wq         :: ڥȥǡ˥ץ饷Ѥ
  ! xyr_GradLon_wq      :: ڥȥǡ˸۷ʬ
  !                        1/rcosա/ߦˤѤ
  ! xvr_GradLon_wq      :: ڥȥǡ˸۷ʬ
  !                        1/rcosա/ߦˤѤ
  ! xyr_GradLat_wq      :: ڥȥǡ˸۷ʬ
  !                        1/r/ߦդѤ
  ! xvr_GradLat_wq      :: ڥȥǡ˸۷ʬ
  !                        1/r/ߦդѤ
  ! wr_DivLon_xyr       :: ʻҥǡȯʬ
  !                        1/rcosա/ߦˤѤ
  ! wr_DivLon_xvr       :: ʻҥǡȯʬ
  !                        1/rcosա/ߦˤѤ
  ! wr_DivLat_xyr       :: ʻҥǡȯʬ
  !                        1/rcosա(g cos)/ߦդѤ
  ! wr_DivLat_xvr       :: ʻҥǡȯʬ
  !                        1/rcosա(g cos)/ߦդѤ
  ! wr_Div_xyr_xyr_xyr  :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyr_Div_xyr_xyr_xyr :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyr_RotLon_wq_wq    :: ٥ȥβžηʬ׻
  ! xvr_RotLon_wq_wq    :: ٥ȥβžηʬ׻
  ! xyr_RotLat_wq_wq    :: ٥ȥβžΰʬ׻
  ! xvr_RotLat_wq_wq    :: ٥ȥβžΰʬ׻
  ! wr_RotRad_xyr_xyr   :: ٥ȥβžưʬ׻
  ! wr_RotRad_xvr_xvr   :: ٥ȥβžưʬ׻
  !
  !==== ȥݥ׻ʬ
  !
  ! wq_KxRGrad_wq     :: ڥȥǡ˷ʬ
  !                      kr = /ߦˤѤ
  ! xyr_KGrad_wq      :: ڥȥǡ˼ʬ
  !                      k = cos/r /ߦ + sinբ/r Ѥ
  ! xvr_KGrad_wq      :: ڥȥǡ˼ʬ
  !                      k = cos/r /ߦ + sinբ/r Ѥ
  ! wq_L2_wq          :: ڥȥǡ L2 黻 = -ʿץ饷
  !                      Ѥ
  ! wq_L2Inv_wq       :: ڥȥǡ L2 黻Ҥε = -տʿץ饷
  !                      Ѥ
  ! wq_QOperator_wq   :: ڥȥǡ˱黻
  !                      Q=(k-1/2(L2 k+ kL2)) Ѥ
  ! wr_RadRot_xyr_xyr :: ٥ȥ v α٤ư¥٥ȥ r  r(v) 
  !                      ׻
  ! wr_RadRot_xvr_xvr :: ٥ȥ v α٤ư¥٥ȥ r  r(v) 
  !                      ׻
  ! wr_RadRotRot_xyr_xyr_xyr :: ٥ȥ v  r(ߢv) ׻
  ! wr_RadRotRot_xvr_xvr_xvr :: ٥ȥ v  r(ߢv) ׻
  ! wq_RadRotRot_xyr_xyr_xyr :: ٥ȥ v  r(ߢv) ׻
  ! wq_RadRotRot_xvr_xvr_xvr :: ٥ȥ v  r(ߢv) ׻
  ! wq_Potential2Vector      :: ȥݥݥƥ󥷥뤫
  !                             ٥ȥ׻
  ! wq_Potential2VectorMPI   :: ȥݥݥƥ󥷥뤫
  !                             ٥ȥ׻
  ! wq_Potential2Rotation    :: ȥݥݥƥ󥷥ɽ
  !                             ȯ٥ȥβžγʬ׻
  ! wq_Potential2RotationMPI :: ȥݥݥƥ󥷥ɽ
  !                             ȯ٥ȥβžγʬ׻
  !
  !==== ݥ/ȥǥѥڥȥ
  !
  ! nmr_ToroidalEnergySpectrum_wq, nr_ToroidalEnergySpectrum_wq  ::
  !     ȥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  ! nmr_PoloidalEnergySpectrum_wq, nr_PoloidalEnergySpectrum_wq  ::
  !     ݥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  !
  !==== 
  !
  ! wq_BoundaryTau, wr_BoundaryGrid, wq_Boundary                         ::
  !     ǥꥯ, Υޥ󶭳ŬѤ(ˡ, ˡ)
  ! wq_TorBoundaryTau, wr_TorBoundaryGrid, wq_TorBoundary                ::
  !     ®٥ȥݥƥ󥷥ζŬѤ(ˡ,ˡ)       
  ! wq_LaplaPol2Pol_wq, wq_LaplaPol2PolTau_wq                            ::
  !     ®٥ݥݥƥ󥷥릵^2
  !     (Ϥ줾ʻӥڥȥ뷸)
  ! wq_TorMagBoundaryTau, wr_TorMagBoundaryGrid, wq_TorMagBoundary       ::
  !     ȥݥƥ󥷥ζŬѤ(ˡ, ˡ)
  ! wq_PolMagBoundaryTau, wr_PolMagBoundaryGrid, wq_PolMagBoundary       ::
  !     ȥݥƥ󥷥붭ζŬѤ(ˡ, ˡ)
  !
  !==== ʬʿ(3 ǡ)
  !
  ! IntLonLatRad_xyr, AvrLonLatRad_xyr :: 3 ʻǡ
  !                                       ΰʬʿ
  ! IntLonLatRad_xvr, AvrLonLatRad_xvr :: 3 ʻǡ
  !                                       ΰʬʿ
  ! r_IntLonLat_xyr, r_AvrLonLat_xyr   :: 3 ʻǡ
  !                                       ٷ(ʿ)ʬʿ
  ! r_IntLonLat_xvr, r_AvrLonLat_xvr   :: 3 ʻǡ
  !                                       ٷ(ʿ)ʬʿ
  ! y_IntLonRad_xyr, y_AvrLonRad_xyr   :: 3 ʻǡ
  !                                       ưʬʿ
  ! v_IntLonRad_xvr, v_AvrLonRad_xvr   :: 3 ʻǡ
  !                                       ưʬʿ
  ! x_IntLatRad_xyr,xr_AvrLatRad_xyr   :: 3 ʻǡ
  !                                       ư(Ҹ)ʬʿ
  ! x_IntLatRad_xvr,xr_AvrLatRad_xvr   :: 3 ʻǡ
  !                                       ư(Ҹ)ʬʿ
  ! yr_IntLon_xyr, yr_AvrLon_xyr       :: 3 ʻǡ
  !                                       ʬʿ
  ! vr_IntLon_xvr, vr_AvrLon_xvr       :: 3 ʻǡ
  !                                       ʬʿ
  ! xr_IntLat_xyr, xr_AvrLat_xyr       :: 3 ʻǡ
  !                                       ʬʿ
  ! xr_IntLat_xvr, xr_AvrLat_xvr       :: 3 ʻǡ
  !                                       ʬʿ
  ! xr_IntRad_xyr, xr_AvrRad_xyr       :: 3 ʻǡ
  !                                       ưʬʿ
  ! xr_IntRad_xvr, xr_AvrRad_xvr       :: 3 ʻǡ
  !                                       ưʬʿ
  !
  !==== ʬʿ(2 ǡ)
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡοʿ()ʬʿ
  ! IntLonLat_xv, AvrLonLat_xv :: 2 ʻǡοʿ()ʬʿ
  ! IntLonRad_xr, AvrLonRad_xr :: 2 (XZ)ʻǡηưʬ
  !                               ʿ
  ! IntLatRad_yr, AvrLatRad_yr :: 2 (YZ)ʻǡΰư(Ҹ)
  !                               ʬʿ 
  ! IntLatRad_vr, AvrLatRad_vr :: 2 (YZ)ʻǡΰư(Ҹ)
  !                               ʬʿ 
  ! y_IntLon_xy, y_AvrLon_xy   :: ʿ 2 ()ʻǡη
  !                               ʬʿ
  ! v_IntLon_xv, v_AvrLon_xv   :: ʿ 2 ()ʻǡη
  !                               ʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: ʿ2 ()ʻǡΰʬ
  !                               ʿ
  ! x_IntLat_xv, x_AvrLat_xv   :: ʿ2 ()ʻǡΰʬ
  !                               ʿ
  ! r_IntLon_xr, r_AvrLon_xr   :: 2 (XZ)ʻǡηʬ
  !                               ʿ
  ! x_IntRad_xr, x_AvrRad_xr   :: 2 (XZ)ʻǡưʬ
  !                               ʿ
  ! r_IntLat_yr, r_AvrLat_yr   :: 2 (YZ)ʻǡΰʬ
  !                               ʿ
  ! r_IntLat_vr, r_AvrLat_vr   :: 2 (YZ)ʻǡΰʬ
  !                               ʿ
  ! y_IntRad_yr, y_AvrRad_yr   :: 2 (YZ)ʻǡưʬ
  !                               ʿ                  
  ! v_IntRad_vr, v_AvrRad_vr   :: 2 (YZ)ʻǡưʬ
  !                               ʿ                  
  !
  !==== ʬʿ(1 ǡ)
  !
  ! IntLon_x, AvrLon_x  :: 1 (X)ʻǡηʬʿ
  ! IntLat_y, AvrLat_y  :: 1 (Y)ʻǡΰʬʿ
  ! IntLat_v, AvrLat_v  :: 1 (Y)ʻǡΰʬʿ
  ! IntRad_r, AvrRad_r  :: 1 (Z)ʻǡưʬʿ
  !
  ! 
  use dc_message
  use lumatrix
  use w_base_mpi_module
  use w_deriv_mpi_module
  use w_integral_mpi_module
  use wa_base_mpi_module
  use wa_deriv_mpi_module
  use wq_module
  use wa_module, only : wa_Lapla_wa
  use mpi
  implicit none
  integer :: ierr

  private

  public wq_mpi_Initial
  public jc

  public x_Lon, x_Lon_Weight
  public y_Lat, y_Lat_Weight
  public v_Lat, v_Lat_Weight
  public r_Rad, r_Rad_Weight
  public l_nm, nm_l
  public xy_Lon, xy_Lat
  public xv_Lon, xv_Lat
  public xyr_Lon, xyr_Lat, xyr_Rad
  public xvr_Lon, xvr_Lat, xvr_Rad
  public wr_Rad
  public wq_VMiss

  public w_xy, xy_w
  public w_xv, xv_w
  public wq_RadDRad_wq, q_RadDRad_q, wr_wq, wq_wr
  public wq_Rad2_wq, q_Rad2_q, wq_Rad2Inv_wq, q_Rad2Inv_q
  public xyr_wq, wq_xyr, xyr_wr, wr_xyr
  public xvr_wq, wq_xvr, xvr_wr, wr_xvr
  public wr_DivRad_wq, wr_RotDRad_wq, wr_RotDRad_wr, wq_Lapla_wq
  public wq_RotDRad_wr
  public xyr_GradLon_wq, xyr_GradLat_wq
  public xvr_GradLon_wq, xvr_GradLat_wq
  public wr_DivLon_xyr, wr_DivLat_xyr, wr_DivRad_xyr
  public wr_DivLon_xvr, wr_DivLat_xvr, wr_DivRad_xvr
  public wr_Div_xyr_xyr_xyr, xyr_Div_xyr_xyr_xyr
  public wr_Div_xvr_xvr_xvr, xvr_Div_xvr_xvr_xvr
  public xyr_RotLon_wq_wq, xyr_RotLat_wq_wq, wr_RotRad_xyr_xyr
  public xvr_RotLon_wq_wq, xvr_RotLat_wq_wq, wr_RotRad_xvr_xvr

  public yr_IntLon_xyr, xr_IntLat_xyr, xy_IntRad_xyr
  public vr_IntLon_xvr, xr_IntLat_xvr, xv_IntRad_xvr
  public x_IntLatRad_xyr, y_IntLonRad_xyr, r_IntLonLat_xyr
  public x_IntLatRad_xvr, v_IntLonRad_xvr, r_IntLonLat_xvr
  public IntLonLatRad_xyr
  public IntLonLatRad_xvr

  public x_IntLat_xy, y_IntLon_xy, IntLonLat_xy
  public x_IntLat_xv, v_IntLon_xv, IntLonLat_xv
  public r_IntLat_yr, y_IntRad_yr, IntLatRad_yr
  public r_IntLat_vr, v_IntRad_vr, IntLatRad_vr
  public r_IntLon_xr, x_IntRad_xr, IntLonRad_xr
  public IntLon_x, IntLat_y, IntRad_r
  public IntLat_v

  public yr_AvrLon_xyr, xr_AvrLat_xyr, xy_AvrRad_xyr
  public vr_AvrLon_xvr, xr_AvrLat_xvr, xv_AvrRad_xvr
  public x_AvrLatRad_xyr, y_AvrLonRad_xyr, r_AvrLonLat_xyr
  public x_AvrLatRad_xvr, v_AvrLonRad_xvr, r_AvrLonLat_xvr
  public AvrLonLatRad_xyr
  public AvrLonLatRad_xvr

  public x_AvrLat_xy, y_AvrLon_xy, AvrLonLat_xy
  public x_AvrLat_xv, v_AvrLon_xv, AvrLonLat_xv
  public r_AvrLat_yr, y_AvrRad_yr, AvrLatRad_yr
  public r_AvrLat_vr, v_AvrRad_vr, AvrLatRad_vr
  public r_AvrLon_xr, x_AvrRad_xr, AvrLonRad_xr
  public AvrLon_x, AvrLat_y, AvrRad_r
  public AvrLat_v

  public wq_KxRGrad_wq, xyr_KGrad_wq, wq_L2_wq, wq_L2Inv_wq, wq_QOperator_wq
  public xvr_KGrad_wq
  public wr_RadRot_xyr_xyr, wr_RadRotRot_xyr_xyr_xyr
  public wr_RadRot_xvr_xvr, wr_RadRotRot_xvr_xvr_xvr
  public wq_RadRotRot_xyr_xyr_xyr
  public wq_RadRotRot_xvr_xvr_xvr
  public wq_Potential2vector, wq_Potential2Rotation
  public wq_Potential2vectorMPI, wq_Potential2RotationMPI

  public nmr_ToroidalEnergySpectrum_wq, nr_ToroidalEnergySpectrum_wq
  public nmr_PoloidalEnergySpectrum_wq, nr_PoloidalEnergySpectrum_wq

  public wq_Boundary, wq_TorBoundary, wq_LaplaPol2Pol_wq ! wr_LaplaPol2Pol_wr
  public wq_TormagBoundary, wq_PolmagBoundary

  public wq_BoundaryTau, wq_TorBoundaryTau, wq_LaplaPol2PolTau_wq
  public wq_TormagBoundaryTau, wq_PolmagBoundaryTau

  public wr_BoundaryGrid, wr_TorBoundaryGrid
  public wr_TormagBoundaryGrid, wr_PolmagBoundaryGrid

  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=31         ! ȿ(ʿ, ư)
  real(8)            :: ra=1.0               ! Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: xvr_LON, xvr_LAT, xvr_RAD ! ɸ

  save im, jm, km, nm, lm, ra, xvr_Lon, xvr_Lat, xvr_Rad

  contains
  !---------------  -----------------
   subroutine wq_mpi_Initial(i,j,k,n,l,r,np,wa_init)
     !
     ! ڥȥѴγʻ, ȿ, ưºɸϰϤꤹ.
     !
     ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
     ! ʤФʤʤ. 
     !
     ! np  1 礭ͤꤹ ISPACK εĴȡѴ 
     ! OPENMP ׻롼Ѥ. ׻¹Ԥˤ, 
     ! ¹Ի˴Ķѿ OMP_NUM_THREADS  np ʲοꤹ
     ! ƥ˱ɬפȤʤ. 
     !
     ! np  1 礭ͤꤷʤ׻롼ϸƤФʤ.
     !
     !
     integer,intent(in) :: i              ! ʻ(٦)
     integer,intent(in) :: j              ! ʻ(٦)
     integer,intent(in) :: k              ! ʻ(ư r)
     integer,intent(in) :: n              ! ȿ(ʿȿ)
     integer,intent(in) :: l              ! ȿ(ưȿ)

     real(8),intent(in) :: r              ! Ⱦ

     integer,intent(in), optional :: np   ! OPENMP Ǥκ祹åɿ
     logical,intent(in), optional :: wa_init   ! wa_initial å

     logical    :: wa_initialize=.true.   ! wa_initial å

     integer :: nn, mm

     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ra = r

     if ( present(wa_init) ) then
        wa_initialize = wa_init
     else
        wa_initialize = .true.
     endif

     if ( present(np) ) then
        call wq_Initial(im,jm,km,nm,lm,ra,np,wa_initialize)
     else
        call wq_Initial(im,jm,km,nm,lm,ra,wa_init=wa_initialize)
     endif
     if ( wa_initialize ) then
        call w_base_mpi_Initial
        call w_deriv_mpi_Initial
        call wa_base_mpi_Initial
     endif

     allocate(xvr_Lon(0:im-1,jc,km))
     allocate(xvr_Lat(0:im-1,jc,km))
     allocate(xvr_Rad(0:im-1,jc,km))

     xvr_Lon = spread(xv_Lon,3,km)
     xvr_Lat = spread(xv_Lat,3,km)
     xvr_Rad = spread(spread(r_Rad,1,jc),1,im)

     call MessageNotify('M','wq_mpi_initial','wq_mpi_module (2011/09/08) is initialized')

  end subroutine wq_mpi_Initial

  !--------------- Ѵ -----------------

    function xvr_wq(wq)
      !
      ! ڥȥǡ 3 ʬʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jc,km)                       :: xvr_wq
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      xvr_wq = xva_wa(wr_wq(wq))

    end function xvr_wq

    function wq_xvr(xvr)
      !
      ! 3 ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wq_xvr
      !(out) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jc,km), intent(in)           :: xvr
      !(in) 3 ٰư³ʻǡ

      wq_xvr = wq_wr(wa_xva(xvr))

    end function wq_xvr

    function xvr_wr(wr)
      !
      ! ʿڥȥ롦ư³ʻǡ 3 ʬʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jc,km)                     :: xvr_wr
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km), intent(in) :: wr
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ

      xvr_wr = xva_wa(wr)

    end function xvr_wr

    function wr_xvr(xvr)
      !
      ! 3 ʻҥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),km)               :: wr_xvr
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ

      real(8), dimension(0:im-1,1:jc,km), intent(in)         :: xvr
      !(in) 3 ٰư³ʻǡ

      wr_xvr = wa_xva(xvr)

    end function wr_xvr

  !--------------- ʬ׻ -----------------
    function wr_DivRad_xvr(xvr)
      ! 
      ! ʻǡȯưʬ
      !
      !       1/r^2 /r (r^2  = /r + 2/= 1/r/(r.) + 1/r
      !
      ! Ѥ.
      !
      ! δؿϤư¼ȿʿȿζۤʤäƤ뤳Ȥ
      ! ꤷƤ. פƤˤ wr_DigRad_wq Ѥ뤳.
      !
      real(8), dimension(0:im-1,jc,km), intent(in) :: xvr
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),km)             :: wr_DivRad_xvr
      !(out) ȯưʬѤ줿ʿڥȥư³ʻǡ

      wr_DivRad_xvr = wr_wq(wq_RadDRad_wq(wq_xvr(xvr_Rad*xvr)))/wr_Rad**2 &
                    + 1/wr_Rad * wr_xvr(xvr)

    end function wr_DivRad_xvr

    function xvr_GradLon_wq(wq)
      !
      ! ڥȥǡ˸۷ʬ 1/rcosա/ߦ
      ! Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jc,km)    :: xvr_GradLon_wq
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xvr_GradLon_wq = xva_GradLon_wa(wr_wq(wq))/xvr_Rad

    end function xvr_GradLon_wq

    function xvr_GradLat_wq(wq) 
      !
      ! ڥȥǡ˸۷ʬ 1/r /ߦ Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jc,km)    :: xvr_GradLat_wq
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xvr_GradLat_wq = xva_GradLat_wa(wr_wq(wq))/xvr_Rad

    end function xvr_GradLat_wq

    function wr_DivLon_xvr(xvr)
      ! 
      ! ʻǡȯʬ 1/rcosա/ߦ Ѥ
      ! ڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in)     :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km)         :: wr_DivLon_xvr
      !(out) ȯʬѤ줿ʿڥȥư³ʻǡ

      wr_DivLon_xvr = wa_DivLon_xva(xvr/xvr_Rad)

    end function wr_DivLon_xvr

    function wr_DivLat_xvr(xvr)
      !
      ! ʻҥǡȯʬ 1/rcosա(f cos)/ߦ 
      ! Ѥڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in)     :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),km)         :: wr_DivLat_xvr
      !(out) ȯʬѤ줿ʿڥȥư³ʻǡ

      wr_DivLat_xvr = wa_DivLat_xva(xvr/xvr_Rad)

    end function wr_DivLat_xvr

    function wr_Div_xvr_xvr_xvr(xvr_Vlon,xvr_Vlat,xvr_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
      ! ڥȥǡ֤.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ, ȯ 
      !
      !      1/rcosաu/ߦ + 1/rcosա(v cos)/ߦ 
      !    + 1/r^2 /r (r^2 w)
      !
      ! ȷ׻.
      !
      ! 3ʬư¼ȿʿȿζƤ뤳ȤꤷƤ.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_Div_xvr_xvr_xvr
      !(out) ٥ȥȯ

      wr_Div_xvr_xvr_xvr =   wr_DivLon_xvr(xvr_Vlon) &
                           + wr_DivLat_xvr(xvr_Vlat) &
                           + wr_DivRad_xvr(xvr_Vrad)

    end function wr_Div_xvr_xvr_xvr

    function xvr_Div_xvr_xvr_xvr(xvr_Vlon,xvr_Vlat,xvr_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ.
      !
      ! ˤð򤹤뤿˥٥ȥ cos/r νŤߤ򤫤
      ! ׻Ƥ. 
      !
      !      div V = (r/cos)div (Vcos/r) + V_tan/r + V_r/r
      ! 
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jc,km)             :: xvr_Div_xvr_xvr_xvr
      !(out) ٥ȥȯ

      xvr_Div_xvr_xvr_xvr &
           = xvr_Rad/cos(xvr_Lat) &
                * xvr_wr(wr_Div_xvr_xvr_xvr(xvr_VLon*cos(xvr_Lat)/xvr_Rad,  &
                                            xvr_VLat*cos(xvr_Lat)/xvr_Rad,  &
                                            xvr_VRad*cos(xvr_Lat)/xvr_Rad ))&
             + xvr_VLat*tan(xvr_Lat)/xvr_Rad &
             + xvr_VRad/xvr_Rad

    end function xvr_Div_xvr_xvr_xvr

    function xvr_RotLon_wq_wq(wq_Vrad,wq_Vlat) 
      !
      ! ٥ȥưʬ, ʬǤ 1, 2  Vrad, Vlat 
      ! žηʬ 
      !
      !    1/r Vrad/ߦ-1/r (r Vlat)/r ׻.
      !
      ! ׻
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km)                 :: xvr_RotLon_wq_wq
      !(out) ٥ȥβžηʬ

      xvr_RotLon_wq_wq =   xvr_GradLat_wq(wq_Vrad) &
                         - xvr_wr(wr_RotDRad_wq(wq_Vlat))

    end function xvr_RotLon_wq_wq

    function xvr_RotLat_wq_wq(wq_Vlon,wq_Vrad) 
      !
      ! ٥ȥηʬ, ưʬǤ 1, 2  Vlon, Vrad 
      ! žΰʬ 
      !
      !    1/r (r Vlon)/r - 1/rcosաVrad/ߦ
      !
      ! ׻.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jc,km)                 :: xvr_RotLat_wq_wq
      !(out) ٥ȥβžΰʬ

      xvr_RotLat_wq_wq =   xvr_wr(wr_RotDRad_wq(wq_Vlon)) &
                         - xvr_GradLon_wq(wq_Vrad) 

    end function xvr_RotLat_wq_wq

    function wr_RotRad_xvr_xvr(xvr_Vlat,xvr_Vlon) 
      !
      ! ٥ȥΰʬ, ʬǤ 1, 2  Vlat, Vlon Ф
      ! ٥ȥβžưʬ 
      !
      !    1/rcosաVlat/ߦ - 1/rcosա(Vlon cos)/ߦ
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),km)       :: wr_RotRad_xvr_xvr
      !(out) ٥ȥβžưʬ

      wr_RotRad_xvr_xvr =   wr_DivLon_xvr(xvr_Vlat) &
                          - wr_DivLat_xvr(xvr_Vlon)

    end function wr_RotRad_xvr_xvr

  !--------------- ʬ׻ -----------------
    !----(ϥǡ xvr)---
    function vr_IntLon_xvr(xvr)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʬ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jc,km)  :: vr_IntLon_xvr
      !(out) (Ӿ)ʬ줿 2 Ҹ̳ʻǡ

      integer :: i

      vr_IntLon_xvr = 0.0d0
      do i=0,im-1
         vr_IntLon_xvr(:,:) = vr_IntLon_xvr(:,:) &
                       + xvr(i,:,:) * x_Lon_Weight(i)
      enddo
    end function vr_IntLon_xvr

    function xr_IntLat_xvr(xvr)
      !
      ! 3 ʻǡΰʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) cos d ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,km)  :: xr_IntLat_xvr   
      !(out) ʬ줿 2 ư³ʻǡ
      ! ٱ߳ʻǡ

      real(8), dimension(0:im-1,km)  :: xr_IntLatTMP
      integer :: j

      xr_IntLat_xvr = 0.0d0
      do j=1,jc
         xr_IntLat_xvr(:,:) = xr_IntLat_xvr(:,:) &
                       + xvr(:,j,:) * v_Lat_Weight(j)
      enddo
      xr_IntLatTmp=xr_IntLat_xvr
      CALL MPI_ALLREDUCE(xr_IntLatTMP,xr_IntLat_xvr,im*km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function xr_IntLat_xvr

    function xv_IntRad_xvr(xvr)  ! ưʬ
      !
      ! 3 ʻǡưʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jc)  :: xv_IntRad_xvr
      !(out) ưʬ줿 2 ٰ(ʿ, )ʻǡ

      integer :: k

      xv_IntRad_xvr = 0.0d0
      do k=1,km
         xv_IntRad_xvr(:,:) = xv_IntRad_xvr(:,:) &
                       + xvr(:,:,k) * r_Rad_Weight(k) 
      enddo

    end function xv_IntRad_xvr

    function x_IntLatRad_xvr(xvr)
      !
      ! 3 ʻǡΰư(Ҹ)ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRad_xvr
      !(out) ư(Ҹ)ʬ줿 1 ٳʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRadTMP
      integer :: j, k

      x_IntLatRad_xvr = 0.0D0
      do k=1,km
         do j=1,jc
            x_IntLatRad_xvr = x_IntLatRad_xvr &
                 + xvr(:,j,k) * v_Lat_Weight(j) * r_Rad_Weight(k)
         enddo
      enddo

      x_IntLatRadTmp=x_IntLatRad_xvr
      CALL MPI_ALLREDUCE(x_IntLatRadTMP,x_IntLatRad_xvr,im,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function x_IntLatRad_xvr

    function v_IntLonRad_xvr(xvr)
      !
      ! 3 ʻǡηư(ٱ)ʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jc)       :: v_IntLonRad_xvr
      !(out) ư(ٱ)ʬ줿 1 ٳʻǡ

      integer :: i, k

      v_IntLonRad_xvr = 0.0D0
      do k=1,km
         do i=0,im-1
            v_IntLonRad_xvr = v_IntLonRad_xvr &
                 + xvr(i,:,k) * x_Lon_Weight(i) * r_Rad_Weight(k)
         enddo
      enddo

    end function v_IntLonRad_xvr

    function r_IntLonLat_xvr(xvr)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(km)     :: r_IntLonLat_xvr
      !(out) ٷ(ʿ, )ʬ줿 1 ư³ʻǡ

      real(8), dimension(km)     :: r_IntLonLatTMP
      integer :: i, j

      r_IntLonLat_xvr = 0.0D0
      do j=1,jc
         do i=0,im-1
            r_IntLonLat_xvr = r_IntLonLat_xvr &
                 + xvr(i,j,:) * x_Lon_Weight(i) * v_Lat_Weight(j)
         enddo
      enddo

      r_IntLonLatTmp=r_IntLonLat_xvr
      CALL MPI_ALLREDUCE(r_IntLonLatTMP,r_IntLonLat_xvr,km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function r_IntLonLat_xvr

    function IntLonLatRad_xvr(xvr) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2cos dddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr 
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: IntLonLatRad_xvr 
      !(out) ʬ

      real(8)                     :: IntLonLatRadTMP
      integer :: i, j, k

      IntLonLatRad_xvr = 0.0D0
      do k=1,km
         do j=1,jc
            do i=0,im-1
               IntLonLatRad_xvr = IntLonLatRad_xvr &
                    + xvr(i,j,k) * x_Lon_Weight(i) &
                         * v_Lat_Weight(j) * r_Rad_Weight(k)
            enddo
         enddo
      enddo

      IntLonLatRadTmp=IntLonLatRad_xvr
      CALL MPI_ALLREDUCE(IntLonLatRadTMP,IntLonLatRad_xvr,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntLonLatRad_xvr

    !----(ϥǡ vr)---
    function r_IntLat_vr(vr)  ! ʬ
      !
      ! 2 (VR)ʻǡΰʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) cos d ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(km)  :: r_IntLat_vr
      !(out) ʬ줿 1 ư³ʻǡ

      real(8), dimension(km)  :: r_IntLatTMP
      integer :: j

      r_IntLat_vr = 0.0d0
      do j=1,jc
         r_IntLat_vr(:) = r_IntLat_vr(:) + vr(j,:) * v_Lat_Weight(j)
      enddo
      r_IntLatTmp=r_IntLat_vr
      CALL MPI_ALLREDUCE(r_IntLatTMP,r_IntLat_vr,km,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function r_IntLat_vr

    function v_IntRad_vr(vr)  ! ưʬ
      !
      ! 2 (VR)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2dr ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jc)  :: v_IntRad_vr
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      v_IntRad_vr = 0.0d0
      do k=1,km
         v_IntRad_vr(:) = v_IntRad_vr(:) &
                       + vr(:,k) * r_Rad_Weight(k) 
      enddo

    end function v_IntRad_vr

    function IntLatRad_vr(vr)
      !
      ! 2 (VR)ʻǡΰưʬ(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2cos ddr ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: IntLatRad_vr
      !(out) ʬ

      real(8)                   :: IntLatRadTMP
      integer :: j, k

      IntLatRad_vr = 0.0D0
      do k=1,km
         do j=1,jc
            IntLatRad_vr = IntLatRad_vr &
                 + vr(j,k) * v_Lat_Weight(j) * r_Rad_Weight(k)
         enddo
      enddo

      IntLatRadTmp=IntLatRad_vr
      CALL MPI_ALLREDUCE(IntLatRadTMP,IntLatRad_vr,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntLatRad_vr

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ xvr)---
    function vr_AvrLon_xvr(xvr)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jc,km)  :: vr_AvrLon_xvr
      !(out) (Ӿ)ʿѤ줿 2 Ҹ̳ʻǡ

      vr_AvrLon_xvr = vr_IntLon_xvr(xvr)/sum(x_Lon_Weight)

    end function vr_AvrLon_xvr

    function xr_AvrLat_xvr(xvr)  ! ʬ
      !
      ! 3 ʻǡΰʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)cos d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,km)  :: xr_AvrLat_xvr
      !(out) ʿѤ줿 2 ư³ʻǡ

      xr_AvrLat_xvr = xr_IntLat_xvr(xvr)/sum(y_Lat_Weight)

    end function xr_AvrLat_xvr

    function xv_AvrRad_xvr(xvr)
      !
      ! 3 ʻǡưʿ.
      !
      ! 3 ǡ f(,,r) Ф 
      !
      !    f(,,r) r^2dr/((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jc)  :: xv_AvrRad_xvr
      !(out) ưʿѤ줿 2 ٰ(ʿ, )ʻǡ
      ! ʿʻǡ

      xv_AvrRad_xvr = xv_IntRad_xvr(xvr)/sum(r_Rad_Weight)

    end function xv_AvrRad_xvr

    function x_AvrLatRad_xvr(xvr)  ! ư(Ҹ)ʬ
      !
      ! 3 ʻǡΰư(Ҹ)ʿ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_AvrLatRad_xvr
      !(out) ư(Ҹ)ʿѤ줿 1 ٳʻǡ

      x_AvrLatRad_xvr = x_IntLatRad_xvr(xvr) &
                   /( sum(y_Lat_Weight)*sum(r_Rad_Weight) )

    end function x_AvrLatRad_xvr

    function v_AvrLonRad_xvr(xvr)  ! ư(ٱ)ʬ
      !
      ! 3 ʻǡηư(ٱ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jc)       :: v_AvrLonRad_xvr
      !(out) ư(ٱ)ʿѤ줿 1 ٳʻǡ

      v_AvrLonRad_xvr = v_IntLonRad_xvr(xvr) &
                 /(sum(x_Lon_Weight)*sum(r_Rad_Weight))

    end function v_AvrLonRad_xvr

    function r_AvrLonLat_xvr(xvr)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd /4 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(km)     :: r_AvrLonLat_xvr
      !(out) ٷ(ʿ, )ʿѤ줿 1 ư³ʻǡ

      r_AvrLonLat_xvr = r_IntLonLat_xvr(xvr) &
                 /(sum(x_Lon_Weight)*sum(y_Lat_Weight))

    end function r_AvrLonLat_xvr

    function AvrLonLatRad_xvr(xvr) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos dddr /(4(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: AvrLonLatRad_xvr
      !(out) ʿ

      AvrLonLatRad_xvr = IntLonLatRad_xvr(xvr) &
            /(sum(x_Lon_Weight)*sum(y_Lat_Weight) * sum(r_Rad_Weight))

    end function AvrLonLatRad_xvr

    !----(ϥǡ vr)---
    function r_AvrLat_vr(vr)
      !
      ! 2 (VR)ʻǡΰʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) cos d/2 ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(km)  :: r_AvrLat_vr
      !(out) ʿѤ줿 1 ư³ʻǡ

      r_AvrLat_vr = r_IntLat_vr(vr)/sum(y_Lat_Weight)

    end function r_AvrLat_vr

    function v_AvrRad_vr(vr)
      !
      ! 2 (VR)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jc)  :: v_AvrRad_vr
      !(out) ưʿѤ줿 1 ٳʻǡ

      v_AvrRad_vr = v_IntRad_vr(vr)/sum(r_Rad_Weight)

    end function v_AvrRad_vr

    function AvrLatRad_vr(vr)  ! ư(Ҹ)ʬ
      !
      ! 2 (VR)ʻǡΰư(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф
      !
      !    f(,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(1:jc,km), intent(in) :: vr
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: AvrLatRad_vr
      !(out) ʿ

      AvrLatRad_vr = IntLatRad_vr(vr)/(sum(y_Lat_Weight)*sum(r_Rad_Weight))

    end function AvrLatRad_vr

  !--------------- ݥ/ȥǥʬ -----------------

    function xvr_KGrad_wq(wq)    ! k = cos/r /ߦ + sinբ/r
      !
      ! ϥڥȥǡбʻҥǡ˼ʬ 
      !
      !    k = cos/r /ߦ + sinբ/r 
      !
      ! Ѥʻҥǡ֤. 
      ! ǥ٥ȥ k ϵ濴̶˸ñ̥٥ȥǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jc,km)                 :: xvr_KGrad_wq
      !(out) ʬѤ줿 2 ڥȥǡ

      xvr_KGrad_wq =  cos(xvr_Lat)*xvr_GradLat_wq(wq) &
                    + sin(xvr_Lat)*xvr_wq(wq_RadDRad_wq(wq))/xvr_Rad

    end function xvr_KGrad_wq

    function wr_RadRot_xvr_xvr(xvr_VLON,xvr_VLAT)  ! r(v)
      !
      ! ٥ȥα٤ư¥٥ȥ r(v) ׻.
      !
      !  1, 2 (v[], v[])줾٥ȥηʬ, ʬɽ.
      !
      !    r(v) = 1/cosաv[]/ߦ - 1/cosա(v[] cos)/ߦ
      !
      ! Υڥȥ ǡ֤.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_RadRot_xvr_xvr
      !(out) ٥ȥα٤ư¥٥ȥ

      wr_RadRot_xvr_xvr = wa_DivLon_xva(xvr_VLAT) - wa_DivLat_xva(xvr_VLON)
      
    end function wr_RadRot_xvr_xvr

    function wr_RadRotRot_xvr_xvr_xvr(xvr_VLON,xvr_VLAT,xvr_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),km)     :: wr_RadRotRot_xvr_xvr_xvr
      !(out) ٥ȥ v  r(ߢv) 

      wr_RadRotRot_xvr_xvr_xvr = &
                   wr_RotDRad_wr( &
                      wa_DivLon_xva(xvr_VLON)+ wa_DivLat_xva(xvr_VLAT)) &
             - wa_Lapla_wa(wr_xvr(xvr_VRAD/xvr_RAD))

    end function wr_RadRotRot_xvr_xvr_xvr

    function wq_RadRotRot_xvr_xvr_xvr(xvr_VLON,xvr_VLAT,xvr_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(in) :: xvr_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wq_RadRotRot_xvr_xvr_xvr
      !(out) ٥ȥ v  r(ߢv) 

      wq_RadRotRot_xvr_xvr_xvr = &
                   wq_RotDRad_wr( &
                      wa_DivLon_xva(xvr_VLON)+ wa_DivLat_xva(xvr_VLAT)) &
             - wa_Lapla_wa(wq_xvr(xvr_VRAD/xvr_RAD))

    end function wq_RadRotRot_xvr_xvr_xvr

    subroutine wq_Potential2VectorMPI(&
         xvr_VLON,xvr_VLAT,xvr_VRAD,wq_TORPOT,wq_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! γʬ׻
      !
      real(8), dimension(0:im-1,1:jc,km)     :: xvr_VLON
      !(out) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jc,km)     :: xvr_VLAT
      !(out) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jc,km)     :: xvr_VRAD
      !(out) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      xvr_VLON =   xvr_RAD * xvr_GradLat_wq(wq_TORPOT) &
                 + xva_GradLon_wa(wr_RotDRad_wq(wq_POLPOT))
      xvr_VLAT = - xvr_RAD * xvr_GradLon_wq(wq_TORPOT) &
                 + xva_GradLat_wa(wr_RotDRad_wq(wq_POLPOT))
      xvr_VRAD = xvr_wq(wq_L2_wq(wq_POLPOT))/xvr_RAD

    end subroutine wq_Potential2VectorMPI

    subroutine wq_Potential2RotationMPI(&
       xvr_RotVLON,xvr_RotVLAT,xvr_RotVRAD,wq_TORPOT,wq_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! Ф, βž
      !
      !     xv = xx(r) + xxx(r) = xx(r) - x((^2)r)
      !
      ! ׻. 
      
      ! ٥ȥβž
      real(8), dimension(0:im-1,1:jc,km), intent(OUT) :: xvr_RotVLON
      !(out) žηʬ

      real(8), dimension(0:im-1,1:jc,km), intent(OUT) :: xvr_RotVLAT
      !(out) žΰʬ

      real(8), dimension(0:im-1,1:jc,km), intent(OUT) :: xvr_RotVRAD
      !(out) žưʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wq_POLPOT
      !(in) ݥݥƥ󥷥

      call wq_Potential2VectorMPI( &
           xvr_RotVLON,xvr_RotVLAT,xvr_RotVRAD, &
           -wq_Lapla_wq(wq_POLPOT), wq_TORPOT)

    end subroutine wq_Potential2RotationMPI

end module wq_mpi_module
