!--
!----------------------------------------------------------------------
!     Copyright 2011 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  eea_module_fftj
!
!      spml/eea_module_fftj ⥸塼ϼβǤ 2 ΰ
!      ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
!      󶡤. 
!
!       ISPACK/P2PACK  Fortran77 ֥롼ƤǤ. 
!      ڥȥǡӳʻǡγǼˡˤĤƤ
!      ISPACK/P2PACK Υޥ˥奢򻲾Ȥ줿. 
!
!  2011/12/10  ݹ
!
!++
module eea_module_fftj
  !
  != eea_module_fftj
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: ee_module.f90,v 1.22 2009-07-31 03:06:18 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  ! spml/eea_module_fftj ⥸塼ϼβǤ 2 ΰ
  ! ήαư򥹥ڥȥˡˤͷ׻뤿 Fortran90 ؿ
  ! 󶡤. 
  !
  !  ee_module_fftj ֥롼ƤǤ. 
  ! ڥȥǡӳʻǡγǼˡˤĤƤ
  ! ISPACK/P2PACK Υޥ˥奢򻲾Ȥ줿. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !  
  ! * ؿ̾Ƭ (ee_, yx_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   eea_:: ڥȥǡ( 1,2 줾 Y,X ȿ, 3Ǥ)
  !   yxa_:: 3 ʻǡ( 1,2 줾 Y,X γʻ,, 3Ǥ)
  !   xya_:: 3 ʻǡ( 1,2 줾 X,Y γʻ,, 3Ǥ)
  !   ee_ :: ڥȥǡ( 1,2 줾 Y,X ȿ)
  !   yx_ :: 2 ʻǡ( 1,2 줾 Y,X γʻ)
  !   xy_ :: 2 ʻǡ( 1,2 줾 X,Y γʻ)
  !   x_  :: X  1 ʻǡ, y_ : Y  1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(Dx, Dy, Lapla, LaplaInv, Jacobian), 
  !   δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_ee_ee, _ee, _yx, _x, _y) , ѿη
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _eea   :: ʣΥڥȥǡ
  !   _ee    :: ڥȥǡ
  !   _ee_ee :: 2 ĤΥڥȥǡ
  !   _yxa   :: 3 ʻǡ
  !   _yx    :: 2 ʻǡ
  !   _xy    :: 2 ʻǡ
  !   _x     :: X  1 ʻǡ
  !   _y     :: Y  1 ʻǡ.
  !  
  !=== ƥǡμ
  !  
  ! * yxa : 3 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm-1,0:im-1,:). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼 
  !     eea_initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * xya : 3 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:im-1,0:jm-1,:). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼 
  !     eea_initial ˤƤ餫ꤷƤ.
  !   *  1  X ɸγʻֹ,  2  Y ɸ
  !     ʻֹǤ.
  !
  ! * eea : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-lm:lm,-km:km,:). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼 
  !     ee_initial ˤƤ餫ꤷƤ.
  !     (X, Y ȿνǤϤʤ)Ȥ. 
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * yx : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:jm-1,0:im-1). 
  !   * im, jm Ϥ줾 X, Y ɸγʻǤ, ֥롼 
  !     ee_initial ˤƤ餫ꤷƤ.
  !   *  1  Y ɸγʻֹ,  2  X ɸ
  !     ʻֹǤ (X, Y νǤϤʤ)Ȥ.
  !
  ! * ee : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(-lm:lm,-km:km). 
  !   * km, lm Ϥ줾 X, Y κȿǤ, ֥롼 
  !     ee_initial ˤƤ餫ꤷƤ.
  !     (X, Y ȿνǤϤʤ)Ȥ. 
  !   * ڥȥǡγǼΤˤĤƤ...
  !
  ! * x, y : X, Y  1 ʻǡ.
  !   * ѿμȼϤ줾
  !     real(8), dimension(0:im-1)  real(8), dimension(0:jm-1).
  !
  ! * ee_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * yx_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !== ѿ³
  !
  !====  
  !
  ! eea_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  !
  !==== ɸѿ
  !
  ! x_X, y_Y     ::  ʻɸ(X,Yɸ)Ǽ 1 
  ! x_X_Weight, y_Y_Weight ::  ŤߺɸǼ 1 
  ! yx_X, yx_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  ! xy_X, xy_Y   :: ʻǡ XY ɸ(X,Y)(ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! yxa_eea :: ڥȥǡʻҥǡؤѴ
  ! eea_yxa :: ʻҥǡ饹ڥȥǡؤѴ
  ! xya_yxa :: ʻҥǡμ
  ! yxa_xya :: ʻҥǡμ
  ! yx_ee   :: ڥȥǡʻҥǡؤѴ
  ! ee_yx   :: ʻҥǡ饹ڥȥǡؤѴ
  !
  !==== ʬ
  !
  ! eea_Lapla_eea       :: ڥȥǡ˥ץ饷Ѥ
  ! eea_LaplaInv_eea    :: ڥȥǡ˥ץ饷εѴѤ
  ! eea_Dx_eea          :: ڥȥǡ X ʬѤ
  ! eea_Dy_eea          :: ڥȥǡ Y ʬѤ
  ! eea_Jacobian_eea_eea :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  ! ee_Lapla_ee       :: ڥȥǡ˥ץ饷Ѥ
  ! ee_LaplaInv_ee    :: ڥȥǡ˥ץ饷εѴѤ
  ! ee_Dx_ee          :: ڥȥǡ X ʬѤ
  ! ee_Dy_ee          :: ڥȥǡ Y ʬѤ
  ! ee_Jacobian_ee_ee :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== ʬʿ
  !
  ! a_IntYX_yxa, a_AvrYX_yxa :: 2 ʻǡΰʬʿ
  ! ya_IntX_yxa, ya_AvrX_yxa :: 2 ʻǡ X ʬʿ
  ! a_IntX_xa, a_AvrX_xa     :: 1 (X)ʻǡ X ʬʿ
  ! xa_IntY_yxa, xa_AvrY_yxa :: 2 ʻǡ Y ʬʿ
  ! a_IntY_ya, a_AvrY_ya     :: 1 (Y)ʻǡ Y ʬʿ
  !
  ! IntYX_yx, AvrYX_yx   :: 2 ʻǡΰʬʿ
  ! y_IntX_yx, y_AvrX_yx :: 2 ʻǡ X ʬʿ
  ! IntX_x, AvrX_x       :: 1 (X)ʻǡ X ʬʿ
  ! x_IntY_yx, x_AvrY_yx :: 2 ʻǡ Y ʬʿ
  ! IntY_y, AvrY_y       :: 1 (Y)ʻǡ Y ʬʿ
  !
  !==== ڥȥ
  !
  ! eea_EnergyFromStreamfunc_eea    :: 
  ! ee_EnergyFromStreamfunc_ee      :: 
  ! ήؿ饨ͥ륮ڥȥ׻
  !
  ! eea_EnstrophyFromStreamfunc_eea :: 
  ! ee_EnstrophyFromStreamfunc_ee   :: 
  ! ήؿ饨󥹥ȥեڥȥ׻
  !
  !==== ַ׻
  !
  ! a_Interpolate_eea       :: Ǥդͤ򥹥ڥȥǡ׻
  ! Interpolate_ee          :: Ǥդͤ򥹥ڥȥǡ׻
  !
  use dc_message, only : MessageNotify
  use ee_module_fftj
  implicit none

  private
  public eea_Initial                                       ! 롼

  public yxa_eea, eea_yxa                                 ! Ѵ
  public yxa_xya, xya_yxa                                 ! Ѵ
  public yx_ee, ee_yx                                     ! Ѵ

  public eea_Lapla_eea, eea_LaplaInv_eea, eea_Dx_eea, eea_Dy_eea  ! ʬ
  public ee_Lapla_ee, ee_LaplaInv_ee, ee_Dx_ee, ee_Dy_ee  ! ʬ

  public eea_JacobianZ_eea, eea_Jacobian_eea_eea          ! ׻
  public ee_JacobianZ_ee, ee_Jacobian_ee_ee               ! ׻

  public a_IntYX_yxa, ya_IntX_yxa, xa_IntY_yxa, a_IntX_xa, a_IntY_ya   ! ʬ
  public a_AvrYX_yxa, ya_AvrX_yxa, xa_AvrY_yxa, a_AvrX_xa, a_AvrY_ya   ! ʿ
  public IntYX_yx, y_IntX_yx, x_IntY_yx, IntX_x, IntY_y   ! ʬ
  public AvrYX_yx, y_AvrX_yx, x_AvrY_yx, AvrX_x, AvrY_y   ! ʿ

  public eea_EnergyFromStreamfunc_eea                     ! ͥ륮
  public ee_EnergyFromStreamfunc_ee                       ! ͥ륮
  public eea_EnstrophyFromStreamfunc_eea                  ! 󥹥ȥե
  public ee_EnstrophyFromStreamfunc_ee                    ! 󥹥ȥե

  public a_Interpolate_eea                                ! 
  public Interpolate_ee                                   ! 

  public x_X, y_Y, x_X_Weight, y_Y_Weight, yx_X, yx_Y, xy_X, xy_Y   ! ɸѿ

  integer   :: im=32, jm=32                      ! ʻ(X,Y)
  integer   :: km=10, lm=10                      ! ȿ(X,Y)
  real(8)   :: xl=1.0, yl=1.0                    ! ΰ礭

  real(8), allocatable :: xy_X(:,:), xy_Y(:,:)

  real(8), parameter  :: pi=3.1415926535897932385D0

  save im, jm, km, lm, xy_X, xy_Y

  contains
  !---------------  -----------------
    subroutine eea_Initial(i,j,k,l,xmin,xmax,ymin,ymax)
      !
      ! ڥȥѴγʻ, ȿ, ΰ礭ꤹ.
      !
      ! ¾δؿѿƤ, ǽˤΥ֥롼Ƥ
      ! 򤷤ʤФʤʤ.
      !
      integer,intent(in) :: i           ! ʻ(X)
      integer,intent(in) :: j           ! ʻ(Y)
      integer,intent(in) :: K           ! ȿ(X)
      integer,intent(in) :: l           ! ȿ(Y)

      real(8),intent(in) :: xmin, xmax     ! X ɸϰ
      real(8),intent(in) :: ymin, ymax     ! Y ɸϰ

      im = i ; jm = j ; km = k ; lm = l

      call ee_Initial(i,j,k,l,xmin,xmax,ymin,ymax)

      allocate(xy_X(0:im-1,0:jm-1),xy_Y(0:im-1,0:jm-1))
      xy_X = transpose(yx_X) ;  xy_Y = transpose(yx_Y)

      call MessageNotify('M','eea_initial','eae_module_fftj (2011/12/10) is initialized')
    end subroutine eea_Initial

  !--------------- Ѵ -----------------
    function yxa_eea(eea)
      !
      ! ڥȥǡʻҥǡѴ.
      !
      real(8), dimension(-lm:,-km:,:), intent(in) :: eea
      !(in)  ڥȥǡ

      real(8), dimension(0:jm-1,0:im-1,size(eea,3))             :: yxa_eea
      !(out) ʻǡ

      integer :: n
      ! DO LOOP ѿ

      do n = 1, size(eea,3)
         yxa_eea(:,:,n) = yx_ee(eea(:,:,n))
      end do

    end function yxa_eea

    function eea_yxa(yxa)
      !
      ! ʻҥǡ饹ڥȥǡѴ.
      !
      real(8), dimension(0:,0:,:), intent(in)  :: yxa
      !(in) ʻǡ

      real(8), dimension(-lm:lm,-km:km,size(yxa,3))              :: eea_yxa
      !(out)  ڥȥǡ

      integer :: n
      ! DO LOOP ѿ

      do n = 1, size(yxa,3)
         eea_yxa(:,:,n) = ee_yx(yxa(:,:,n))
      end do

    end function eea_yxa

    function xya_yxa(yxa)
      !
      ! ʻҥǡμ
      !
      real(8), dimension(0:,0:,:), intent(in)          :: yxa
      !(in) ʻǡ

      real(8), dimension(0:im-1,0:jm-1,size(yxa,3))    :: xya_yxa
      !(out)  ڥȥǡ

      integer :: n
      ! DO LOOP ѿ

      do n = 1, size(yxa,3)
         xya_yxa(:,:,n) = transpose(yxa(:,:,n))
      end do

    end function xya_yxa

    function yxa_xya(xya)
      !
      ! ʻҥǡμ
      !
      real(8), dimension(0:,0:,:), intent(in)        :: xya
      !(in) ʻǡ

      real(8), dimension(0:jm-1,0:im-1,size(xya,3))  :: yxa_xya
      !(out)  ڥȥǡ

      integer :: n
      ! DO LOOP ѿ

      do n = 1, size(xya,3)
         yxa_xya(:,:,n) = transpose(xya(:,:,n))
      end do

    end function yxa_xya

  !--------------- ʬ׻ -----------------
    function eea_Lapla_eea(eea)
      !
      ! ϥڥȥǡ˥ץ饷(xx+yy)Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) 򤫤
      ! ׻ԤäƤ. 
      !
      real(8), dimension(-lm:,-km:,:), intent(in)    :: eea
      !(in) ϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea,3))  :: eea_Lapla_eea
      !(out) ڥȥǡΥץ饷

      integer n
      ! ѿ

      do n=1,size(eea,3)
         eea_Lapla_eea(:,:,n) = ee_Lapla_ee(eea(:,:,n))
      enddo
    end function eea_Lapla_eea

    function eea_LaplaInv_eea(eea)
      !
      ! ϥڥȥǡ˵եץ饷(xx+yy)**(-1)Ѥ.
      !
      ! ڥȥǡεեץ饷Ȥ, бʻǡ
      ! եץ饷ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡȿ (k**2 + l**2) ǳ
      ! ׻ԤäƤ. k=l=0 ʬˤ 0 Ƥ. 
      !
      real(8), dimension(-lm:,-km:,:), intent(in)   :: eea
      !(in) ڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea,3)) :: eea_LaplaInv_eea
      !(out) ڥȥǡεեץ饷

      integer n

      do n=1,size(eea,3)
         eea_LaplaInv_eea(:,:,n) = ee_LaplaInv_ee(eea(:,:,n))
      enddo
    end function eea_LaplaInv_eea

    function eea_Dx_eea(eea)
      !
      ! ϥڥȥǡ X ʬ(x)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ X ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ k 򤫤
      ! sin(kx) <-> cos(kx) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-lm:,-km:,:), intent(in)   :: eea
      !(in) ϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea,3)) :: eea_Dx_eea
      !(out) ڥȥǡ X ʬ

      integer n
      ! ѿ

      do n=1,size(eea,3)
         eea_Dx_eea(:,:,n) = ee_Dx_ee(eea(:,:,n))
      enddo
    end function eea_Dx_eea

    function eea_Dy_eea(eea)
      !
      ! ϥڥȥǡ Y ʬ(y)Ѥ.
      !
      ! ڥȥǡ X ʬȤ, бʻǡ Y ʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      ! ºݤˤϥڥȥǡ X ȿ l 򤫤
      ! sin(ky) <-> cos(ky) ʬ촹׻ԤäƤ.
      !
      real(8), dimension(-lm:,-km:,:), intent(in)   :: eea
      !(in) ϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea,3)) :: eea_Dy_eea
      !(out) ڥȥǡ Y ʬ

      integer n
      ! ѿ

      do n=1,size(eea,3)
         eea_Dy_eea(:,:,n) = ee_Dy_ee(eea(:,:,n))
      enddo

    end function eea_Dy_eea

    function eea_Jacobian_eea_eea(eea_a,eea_b)
      !
      !  2 ĤΥڥȥǡ䥳ӥ
      !
      !     J(A,B)=(xA)(yB)-(yA)(xB)
      !
      !  ׻.
      !
      !  2 ĤΥڥȥǡΥ䥳ӥȤ, б 2 Ĥ
      !  ʻǡΥ䥳ӥΥڥȥѴΤȤǤ.
      !
      real(8), dimension(-lm:,-km:,:), intent(in)  :: eea_a
      !(in) 1ܤϥڥȥǡ

      real(8), dimension(-lm:,-km:,:), intent(in)  :: eea_b
      !(in) 2ܤϥڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea_a,3)) :: eea_Jacobian_eea_eea
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      integer n
      ! ѿ

      do n=1,size(eea_a,3)
         eea_Jacobian_eea_eea(:,:,n) = ee_Jacobian_ee_ee(eea_a(:,:,n),eea_b(:,:,n))
      end do

    end function eea_Jacobian_eea_eea

    function eea_JacobianZ_eea(eea_zeta)
      !
      ! ٥ڥȥǡ  ήؿȱ٤Υ䥳ӥ
      !
      !     J(,)=(x)(y)-(y)(x)
      !
      !  ׻.   (xx+yy)= ήؿǤ.
      !
      real(8), dimension(-lm:,-km:,:), intent(in)  :: eea_Zeta
      !(in) ٥ڥȥǡ

      real(8), dimension(-lm:lm,-km:km,size(eea_Zeta,3)) :: eea_JacobianZ_eea
      !(out) ήؿȱ٤Υ䥳ӥ

      integer n
      ! ѿ

      do n=1,size(eea_Zeta,3)
         eea_JacobianZ_eea(:,:,n) = ee_JacobianZ_ee(eea_Zeta(:,:,n))
      end do

    end function eea_JacobianZ_eea

  !--------------- ʬ׻ -----------------
    function a_IntYX_yxa(yxa)
      !
      ! 3 ʻǡοʿΰʬʿ.
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), dimension(0:,0:,:)     :: yxa
      !(in)  2 ʻǡ

      real(8), dimension(size(yxa,3)) :: a_IntYX_yxa
      !(out) ʬ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         a_IntYX_yxa(n) = IntYX_yx(yxa(:,:,n))
      enddo
    end function a_IntYX_yxa

    function ya_IntX_yxa(yxa)
      !
      ! 3 ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:,0:,:)   :: yxa
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1,size(yxa,3))  :: ya_IntX_yxa
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         ya_IntX_yxa(:,n) = y_IntX_yx(yxa(:,:,n))
      enddo
    end function ya_IntX_yxa

    function xa_IntY_yxa(yxa)
      !
      ! 3 ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:,0:,:)             :: yxa    
      !(in)  3 ʻǡ

      real(8), dimension(0:im-1,size(yxa,3))  :: xa_IntY_yxa
      !(out) ʬ줿 2 (X)ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         xa_IntY_yxa(:,n) = x_IntY_yx(yxa(:,:,n))
      enddo
    end function xa_IntY_yxa

    function a_IntX_xa(xa)
      !
      ! 2 (X)ʻǡ X ʬ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:,:)       :: xa            !(in)  1 ʻǡ
      !(in)  2 ʻǡ

      real(8), dimension(size(xa,2)) :: a_IntX_xa     !(out) ʬ
      !(out) ʬ줿 1 ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(xa,2)
         a_IntX_xa(n) = IntX_x(xa(:,n))
      enddo

    end function a_IntX_xa

    function a_IntY_ya(ya)      ! Y ʬ
      !
      ! 2 (Y)ʻǡ Y ʬ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), dimension(0:,:)       :: ya            !(in)  1 ʻǡ
      !(in)  2 ʻǡ

      real(8), dimension(size(ya,2)) :: a_IntY_ya   !(out) ʬ
      !(out) ʬ줿 1 ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(ya,2)
         a_IntY_ya(n) = IntY_y(ya(:,n))
      enddo

    end function a_IntY_ya

  !--------------- ʿѷ׻ -----------------
    function a_AvrYX_yxa(yxa)
      !
      ! 3 ʻǡοʿΰʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:,0:,:)     :: yxa
      !(in)  2 ʻǡ

      real(8), dimension(size(yxa,3)) :: a_AvrYX_yxa
      !(out) ʿ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         a_AvrYX_yxa(n) = AvrYX_yx(yxa(:,:,n))
      end do
    end function a_AvrYX_yxa

    function ya_AvrX_yxa(yxa)
      !
      ! 3 ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:,0:,:)   :: yxa
      !(in) 2 ʻǡ

      real(8), dimension(0:jm-1,size(yxa,3)) :: ya_AvrX_yxa
      !(out) ʿѤ줿 1 (Y)ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         ya_AvrX_yxa(:,n) = y_AvrX_yx(yxa(:,:,n))
      end do
    end function ya_AvrX_yxa

    function xa_AvrY_yxa(yxa)
      !
      ! 3 ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:,0:,:)            :: yxa
      !(in) 2 ʻǡ

      real(8), dimension(0:im-1,size(yxa,3)) :: xa_AvrY_yxa
      !(out) ʿѤ줿 2 (X)ʻǡ

      integer :: n
      ! ѿ

      do n=1,size(yxa,3)
         xa_AvrY_yxa(:,n) = x_AvrY_yx(yxa(:,:,n))
      end do

    end function xa_AvrY_yxa

    function a_AvrX_xa(xa)
      !
      ! 2 (X)ʻǡ X ʿ
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:,:)       :: xa            !(in)  1 ʻǡ
      real(8), dimension(size(xa,2)) :: a_AvrX_xa     !(out) ʿ

      integer :: n
      ! ѿ

      do n=1,size(xa,2)
         a_AvrX_xa(n) = AvrX_x(xa(:,n))
      end do

    end function a_AvrX_xa

    function a_AvrY_ya(ya)
      !
      ! 2 (Y)ʻǡ Y ʿ
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), dimension(0:,:)       :: ya          !(in)  1 ʻǡ
      real(8), dimension(size(ya,2)) :: a_AvrY_ya     !(out) ʿ

      integer :: n
      ! ѿ

      do n=1,size(ya,2)
         a_AvrY_ya(n) = AvrY_y(ya(:,n))
      end do

    end function a_AvrY_ya

  !--------------- ڥȥ׻ -----------------
    function eea_EnergyFromStreamfunc_eea(eea_StrFunc)
      !
      ! ήؿ饨ͥ륮ڥȥ׻. 
      !
      !   E_kl = (1/2)(k^2+l^2)|\psi_kl|^2
      !
      ! * E_kl ¤ʿѱưͥ륮Ȥʤ. 
      ! * ΰѤ򤫤ưͥ륮Ȥʤ. 
      !
      real(8), dimension(-lm:,-km:,:), intent(in) :: eea_StrFunc
      ! ήؿ

      real(8), dimension(-lm:lm,-km:km,size(eea_StrFunc,3))  :: eea_EnergyFromStreamfunc_eea
      ! ͥ륮ڥȥ

      integer n
      ! ѿ

      do n=1,size(eea_StrFunc,3)
         eea_EnergyFromStreamfunc_eea(:,:,n) &
              = ee_EnergyFromStreamfunc_ee(eea_StrFunc(:,:,n))
      enddo

    end function eea_EnergyFromStreamfunc_eea

    function eea_EnstrophyFromStreamfunc_eea(eea_StrFunc)
      !
      ! ήؿ饨󥹥ȥեڥȥ׻. 
      !
      !   Q_kl = (1/2)(k^2+l^2)^2|\psi_kl|^2
      !
      ! * Q_kl ¤ʿѥ󥹥ȥեȤʤ. 
      ! * ΰѤ򤫤󥹥ȥեȤʤ. 
      !
      real(8), dimension(-lm:,-km:,:), intent(in) :: eea_StrFunc
      ! ήؿ

      real(8), dimension(-lm:lm,-km:km,size(eea_StrFunc,3)) :: eea_EnstrophyFromStreamfunc_eea
      ! 󥹥ȥեڥȥ

      integer n
      ! ѿ

      do n=1,size(eea_StrFunc,3)
         eea_EnstrophyFromStreamfunc_eea(:,:,n) &
              = ee_EnstrophyFromStreamfunc_ee(eea_StrFunc(:,:,n))
      enddo

    end function eea_EnstrophyFromStreamfunc_eea

  !--------------- ַ׻ -----------------
    function a_Interpolate_eea( eea_Data, xa, ya )
      real(8), intent(IN)  :: eea_data(-lm:,-km:,:)  ! ڥȥǡ
      real(8), intent(IN)  :: xa(:)                   ! ֤ x ɸ 
      real(8), intent(IN)  :: ya(:)                   ! ֤ y ɸ 
      real(8)              :: a_Interpolate_eea(size(xa)) ! ֤

      integer :: n

      do n=1,size(xa)
         a_Interpolate_eea(n) = Interpolate_ee(eea_Data(:,:,n),xa(n),ya(n))
      end do

    end function a_Interpolate_eea

end module eea_module_fftj
