!--
!----------------------------------------------------------------------
! Copyright (c) 2009 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  w_zonal_module_sjpack
!
!   spml/w_zonal_module_sjpack ⥸塼ϵ̾Ǥη˰ͤ
!   ӾŪ 1 ήαư른ɥ¿༰Ѥڥȥˡˤä
!   ͷ׻뤿 Fortran90 ؿ󶡤. 
!
!    l_module_sjpack ѤƤ. ǲǤϥ른ɥ¿༰Ѵ
!   Υ󥸥Ȥ ISPACK  Fortran77 ֥롼ѤƤ.
!
!   ؿ, ֥롼̾ȵǽ w_zonal_module ΤΤƱ߷פƤ. 
!   ä use ʸ l_module  w_zonal_module_sjpack ѹ 
!   SJPACK εǽȤ褦ˤʤ. 
!
!
!  2009/09/22  ݹ  w_zonal_module  SJPACK Ѥ˲¤
!
!++
module w_zonal_module_sjpack
  !
  != w_zonal_module_sjpack
  !
  ! Authors:: Shin-ichi Takehiro
  ! Version:: $Id: w_zonal_module_sjpack.f90,v 1.1 2009-09-24 07:12:09 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !   spml/w_zonal_module_sjpack ⥸塼ϵ̾Ǥη˰ͤ
  !   ӾŪ 1 ήαư른ɥ¿༰Ѥڥȥˡˤä
  !   ͷ׻뤿 Fortran90 ؿ󶡤. 
  !
  !    l_module_sjpack ѤƤ. ǲǤϥ른ɥ¿༰Ѵ
  !   Υ󥸥Ȥ ISPACK  Fortran77 ֥롼ѤƤ.
  !
  !   ؿ, ֥롼̾ȵǽ w_zonal_module ΤΤƱ߷פƤ. 
  !   ä use ʸ l_module  w_zonal_module_sjpack ѹ 
  !   SJPACK εǽȤ褦ˤʤ. 
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (w_, nm_, n_, xy_, x_, y_) , ֤ͤη򼨤Ƥ.
  !   w_   ::  ڥȥǡ
  !   xy_  ::  2 ʻǡ
  !   nm_  ::  ڥȥǡ¤ 3 (ڥȥǡ¤Ӥ
  !            ȿ n, Ӿȿ m ǻꤵ 2 )
  !   n_   ::  ڥȥǡ¤ 2  (ڥȥǡ¤Ӥ
  !            ȿ n ǻꤵ 1 )
  !   x_   ::   1 ʻǡ
  !   y_   ::   1 ʻǡ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla, 
  !   LaplaInv, Jacobian), δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_w_w, _w, _xy, _x, _y) , ѿηڥȥǡ
  !   ӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _w   :: ڥȥǡ
  !   _w_w :: 2 ĤΥڥȥǡ
  !   _xy  :: 2 ʻǡ
  !   _x   ::  1 ʻǡ
  !   _y   ::  1 ʻǡ
  !
  !=== ƥǡμ
  !
  ! * xy : 2 ʻǡ.
  !   * ѿμȼ real(8), dimension(0:im-1,1:jm). 
  !   * im, jm Ϥ줾, ٺɸγʻǤ, ֥롼
  !     w_Initial ˤƤ餫ꤷƤ.
  !
  ! * w : ڥȥǡ.
  !   * ѿμȼ real(8), dimension(nm+1). 
  !   * nm ϥ른ɥ¿༰κ缡Ǥ, ֥롼 w_Initial ˤ
  !     餫ꤷƤ. w_module 礭ۤʤ뤳Ȥ. 
  !
  ! * nm : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm). 
  !      1 ʿȿ,   2 Ӿȿ(ߡ)ɽ. 
  !   * nm ϥ른ɥ¿༰κ缡Ǥ, ֥롼 w_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * n : ڥȥǡ¤ 1 .
  !   * ѿμȼ real(8), dimension(0:nm). 
  !   *  1 ʿȿɽ. nm ϵĴȡκȿǤ, 
  !     ֥롼 w_Initial ˤƤ餫ꤷƤ.
  !
  ! * x, y : ,  1 ʻǡ.
  !   * ѿμȼϤ줾 real(8), dimension(0:im-1) 
  !      real(8), dimension(1:jm).
  !
  ! * w_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xy_ ǻϤޤؿ֤ͤ 2 ʻǡƱ.
  !
  ! * x_, y_ ǻϤޤؿ֤ͤ 1 ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! w_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, y_Lat     ::  ʻɸ(, ٺɸ)Ǽ 1 
  ! x_Lon_Weight, y_Lat_Weight ::  ŤߺɸǼ 1 
  ! xy_Lon, xy_Lat   :: ʻǡη١ٺɸ(X,Y)
  !                     (ʻǡ 2 )
  !
  !==== Ѵ
  !
  ! xy_w :: ڥȥǡʻҥǡؤѴ
  ! w_xy :: ʻҥǡ饹ڥȥǡؤѴ
  ! l_nm, nm_l :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! w_Lapla_w       :: ڥȥǡ˥ץ饷Ѥ
  ! rn              :: ڥȥǡΥץ饷׻뤿η. 
  ! irm             :: ʬ黻
  ! w_LaplaInv_w    :: ڥȥǡ˥ץ饷εѴѤ
  ! w_DLon_w        :: ڥȥǡ˷ʬ/ߦˤѤ
  ! xy_GradLon_w    :: ڥȥǡ
  !                    ۷ʬ 1/cosա/ߦˤѤ
  ! xy_GradLat_w    :: ڥȥǡ˸۷ʬ/ߦդѤ
  ! w_DivLon_xy     :: ʻҥǡ
  !                    ȯʬ 1/cosա/ߦˤѤ
  ! w_DivLat_xy     :: ʻҥǡ
  !                    ȯʬ 1/cosա(g cos)/ߦդѤ
  ! w_Div_xy_xy     :: ٥ȥʬǤ 2 ĤγʻҥǡȯѤ
  ! w_Jacobian_w_w  :: 2 ĤΥڥȥǡ䥳ӥ׻
  !
  !==== ʬ(,=sin ɸ)
  !
  ! xy_GradLambda_w :: ڥȥǡ˸۷ʬ/ߦˤѤ
  ! xy_GradMu_w     :: ڥȥǡ
  !                    ۷ʬ (1-^2)/ߦ̤Ѥ
  ! w_DivLambda_xy  :: ʻҥǡ
  !                    ȯʬ 1/(1-^2)/ߦˤѤ
  ! w_DivMu_xy      :: ʻҥǡȯʬ/ߦ̤Ѥ
  !
  !==== 
  !
  ! Interpolate_w :: ڥȥǡǤդǤͤ. 
  !
  !==== ʬʿ
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡΰʬʿ
  ! y_IntLon_xy, y_AvrLon_xy   :: 2 ʻǡηʬʿ
  ! IntLon_x, AvrLon_x         :: 1 (X)ʻǡηʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: 2 ʻǡΰʬʿ
  ! IntLat_y, AvrLat_y         :: 1 (Y)ʻǡΰʬʿ
  !
  !==== ڥȥ
  !
  ! nm_EnergyFromStreamfunc_w  :: ήؿ饨ͥ륮ڥȥ
  !                               ׻ (ʿȿ n, Ӿȿ m )
  ! n_EnergyFromStreamfunc_w   :: ήؿ饨ͥ륮ڥȥ
  !                               ׻ (ʿȿ n ) 
  ! nm_EnstrophyFromStreamfunc_w  :: ήؿ饨󥹥ȥեڥȥ
  !                                  ׻ (ʿȿ n, Ӿȿ m )
  ! n_EnstrophyFromStreamfunc_w   :: ήؿ饨󥹥ȥեڥȥ
  !                                  ׻ (ʿȿ n )
  ! w_spectrum_VMiss              ::  »
  !
  !
  use dc_message
  use l_module_sjpack, w_y => l_y, y_w => y_l, &
       y_GradLat_w => y_GradLat_l, w_DivLat_y => l_DivLat_y, &
       w_Lapla_w => l_Lapla_l, w_LaplaInv_w => l_LaplaInv_l, &
       Interpolate_alat_w => Interpolate_l

  implicit none

  integer               :: im=64            ! ʻ()
  integer               :: jm=32            ! ʻ()
  integer               :: nm=21            ! ȿ
  integer               :: np=1             ! OPENMP 祹åɿ

  real(8), allocatable  :: x_Lon(:)                  ! ٷ
  real(8), allocatable  :: x_Lon_Weight(:)           ! ɸŤ
  real(8), allocatable  :: xy_Lon(:,:), xy_Lat(:,:)

  real(8), allocatable  :: rn(:,:)
  integer, allocatable  :: irm(:,:)

  real(8), parameter    :: pi=3.1415926535897932385D0

  real(8) :: w_spectrum_VMiss = -999.000    ! »ͽ

  private

  public w_Initial                            ! 

  public x_Lon, y_Lat                         ! ʻҺɸ
  public x_Lon_weight, y_Lat_Weight           ! ʻҺɸŤ
  public xy_Lon, xy_Lat                       ! ʻҺɸ(im,jm)
  public xy_w, w_xy, l_nm, nm_l               ! Ѵؿ

  public rn, irm                              ! ץ饷/ʬ黻

  public w_Lapla_w, w_LaplaInv_w              ! ץ饷ȵձ黻
  public w_DLon_w                             ! ʬ
  public xy_GradLon_w, xy_GradLat_w           ! ۷ʬ
  public w_DivLon_xy, w_DivLat_xy             ! ȯʬ
  public w_Div_xy_xy                          ! ȯʬ
  public w_Jacobian_w_w                       ! 䥳ӥ
  public xy_GradLambda_w, xy_GradMu_w         ! ۷ʬ(,̺ɸ)
  public w_DivLambda_xy, w_DivMu_xy           ! ȯʬ(,̺ɸ)

  public Interpolate_w                        ! ִؿ

  public IntLonLat_xy                         ! ٷʬ
  public y_IntLon_xy, IntLon_x                ! ʬ    
  public x_IntLat_xy, IntLat_y                ! ʬ    
  public AvrLonLat_xy                         ! ٷʿ
  public y_AvrLon_xy, AvrLon_x                ! ʿ    
  public x_AvrLat_xy, AvrLat_y                ! ʿ    

  public nm_EnergyFromStreamfunc_w            ! ͥ륮ڥȥ           
                                              ! (ʿȿ n, Ӿȿ m )
  public n_EnergyFromStreamfunc_w             ! ͥ륮ڥȥ
                                              ! (ʿȿ n ) 
  public nm_EnstrophyFromStreamfunc_w         ! 󥹥ȥեڥȥ     
                                              ! (ʿȿ n, Ӿȿ m )
  public n_EnstrophyFromStreamfunc_w          ! 󥹥ȥեڥȥ  
                                              !  (ʿȿ n )
  public w_spectrum_VMiss                     ! »

  interface l_nm
     module procedure l_nm_array00
     module procedure l_nm_array01
     module procedure l_nm_array10
     module procedure l_nm_array11
  end interface

  interface nm_l
     module procedure nm_l_int
     module procedure nm_l_array
  end interface

  save im, jm, nm                             ! ʻ, ȿ򵭲

contains

  !---------------  -----------------
    subroutine w_initial(n_in,i_in,j_in,np_in)
      !
      ! ڥȥѴγʻ, ȿ OPENMP ѻ
      ! 祹åɿꤹ.
      !
      ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
      ! ʤФʤʤ. 
      !
      ! np_in  w_module ȤθߴΤˤƤǤ. 
      ! OPENMP ׻ϼƤʤ. 
      !
      integer,intent(in) :: i_in              !(in) ʻ()
      integer,intent(in) :: j_in              !(in) ʻ()
      integer,intent(in) :: n_in              !(in) ȿ
      integer,intent(in), optional :: np_in   !(in) OPENMP Ǥκ祹åɿ

      integer :: i, j, n

      if ( present (np_in) )then
         call MessageNotify('W','w_initial','OPENMP calculation not supported')
      endif

      if ( i_in /= 1  )then
         call MessageNotify('W','w_initial','Longitudinal dimension should be 1')
      endif

      im = i_in  ; jm = j_in  ; nm = n_in

      allocate(x_Lon(0:im-1))                ! ʻɸǼ()
      allocate(x_Lon_Weight(0:im-1))
      allocate(xy_Lon(0:im-1,1:jm))
      allocate(xy_Lat(0:im-1,1:jm))          ! ʻɸǼ

      allocate(rn(0:nm,2),irm(nm+1,2))

      call l_initial(n_in,j_in)

      do i=0,im-1
         x_Lon(i)  = 2*pi/im*i               ! ٺɸ
         x_Lon_Weight(i) = 2*pi/im           ! ٺɸŤ
      enddo

      do j=1,jm
         xy_Lon(:,j) = x_Lon
      enddo

      do i=0,im-1
         xy_Lat(i,:) = y_Lat
      enddo

      do n=0,nm
         rn(n,1) = -n*(n+1)
      enddo

      rn(0,2) = 1.0D0
      do n=1,nm
         rn(n,2) = -1/(n*(n+1))
      enddo

      do n=1,nm+1
         irm(n,1) = n
         irm(n,2) = 0
      enddo

      call MessageNotify('M','w_initial',&
           'w_zonal_module_sjpack (2009/09/22) is initialized')

    end subroutine w_initial

  !--------------- Ѵ -----------------

    function l_nm_array00(n,m)
      !
      ! ȿ(n)ȿ(m,ߡ)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  n,m Ȥͤξ, ֤ͤ. 
      !
      integer               :: l_nm_array00   
      !(out) ڥȥǡγǼ 

      integer, intent(in)   :: n     !(in) ȿ
      integer, intent(in)   :: m     !(in) Ӿȿ           

      if ( m /= 0 ) then
         call MessageNotify('E','l_nm_array00', &
              'zonal wavenumber should be zero in w_zonal_module')
      end if

      l_nm_array00 = n+1

    end function l_nm_array00

    function l_nm_array01(n,marray)           ! ڥȥǡγǼ 
      !
      ! ȿ(n)ȿ(m, ߡ)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  n ,  2  marray  1 ξ, 
      ! marray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: n               !(in) ȿ
      integer, intent(in)  :: marray(:)       !(in) Ӿȿ
      integer              :: l_nm_array01(size(marray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(marray)
         l_nm_array01(i) = l_nm_array00(n,marray(i))
      enddo
    end function l_nm_array01

    function l_nm_array10(narray,m)
      !
      ! ȿ(n)ȿ(m,ߡ)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1  narray  1 ,  2   m ξ, 
      ! narray Ʊ礭 1 ֤. 
      !
      integer, intent(in)  :: narray(:)           !(in) ȿ  
      integer, intent(in)  :: m                   !(in) Ӿȿ
      integer              :: l_nm_array10(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      do i=1, size(narray)
         l_nm_array10(i) = l_nm_array00(narray(i),m)
      enddo
    end function l_nm_array10

    function l_nm_array11(narray,marray)
      !
      ! ȿ(n)ȿ(m)餽ΥڥȥǡγǼ֤֤.
      ! 
      !  1,2  narray, marray Ȥ 1 ξ, 
      ! narray, marray Ʊ礭 1 ֤. 
      ! narray, marray Ʊ礭ǤʤФʤʤ. 
      !
      integer, intent(in)  :: narray(:)          !(in) ȿ  
      integer, intent(in)  :: marray(:)          !(in) Ӿȿ
      integer              :: l_nm_array11(size(narray))
      !(out) ڥȥǡ

      integer              :: i 

      if ( size(narray) .ne. size(marray) ) then
         call MessageNotify('E','l_nm_array11',&
              'dimensions of input arrays  n and m are different.')
      endif

      do i=1, size(narray)
         l_nm_array11(i) = l_nm_array00(narray(i),marray(i))
      enddo
    end function l_nm_array11

    function nm_l_int(l)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  l ͤξ, бȿӾȿ
      ! Ĺ 2  1 ֤ͤ. 
      ! nm_l(1) ȿ, nm_l(2) ӾȿǤ. 
      !
      integer               :: nm_l_int(2)  !(out) ȿ, Ӿȿ
      integer, intent(in)   :: l            !(in) ڥȥǡγǼ
      
      nm_l_int(1) = l-1
      nm_l_int(2) = 0
    end function nm_l_int

    function nm_l_array(larray)
      ! 
      ! ڥȥǡγǼ(l)ȿ(n)ȿ(m)֤.
      !
      !  larray  1 ξ, 
      ! larray б n, m Ǽ 2 ֤. 
      ! nm_l_array(:,1) ȿ, nm_l_array(:,2) ӾȿǤ. 
      !
      integer, intent(in)  :: larray(:)
      !(out) ȿ, Ӿȿ

      integer              :: nm_l_array(size(larray),2)
      !(in) ڥȥǡγǼ

      integer              :: i

      do i=1, size(larray)
         nm_l_array(i,:) = nm_l_int(larray(i))
      enddo
    end function nm_l_array

    function xy_w(w_data,ipow,iflag)
      !
      ! ڥȥǡʻҥǡѴ(1 ).
      !
      real(8)               :: xy_w(0:im-1,1:jm)
      !(out) ʻǡ

      real(8), intent(in)   :: w_data(nm+1)
      !(in) ڥȥǡ

      integer, intent(in), optional  :: ipow      
      !(in) Ѥ 1/cos μ. ά 0. 

      integer, intent(in), optional  :: iflag
      !(in) Ѵμ
      !    0 : ̾Ѵ
      !    1 : ʬ cosա/ߦ ѤѴ
      !   -1 : ʬѤѴ
      !    2 : sinդѤѴ()
      !    ά 0.
      !
      integer, parameter  :: ipow_default  = 0
      integer, parameter  :: iflag_default = 0

      integer ipval, ifval, i

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      if ( ifval == -1 ) then                          ! ʬ 0 
         xy_w = 0.0D0        
      else if ( ifval == 1 ) then                    ! ʬ
         do i=0,im-1
            xy_w(i,:) = y_GradLat_w(w_data) * cos(y_Lat)
         enddo
      else if ( ifval == 2 ) then                     ! sin 򤫤Ѵ
         do i=0,im-1
            xy_w(i,:) = y_w(w_data)
         enddo
         xy_w = xy_w * sin(xy_Lat)
      else
         do i=0,im-1
            xy_w(i,:) = y_w(w_data)
         enddo
      endif

      if ( ipval /= 0 ) then
         xy_w = xy_w/cos(xy_Lat)**ipval
      end if

    end function xy_w

    function w_xy(xy_data,ipow,iflag)
      !
      ! ʻҥǡ饹ڥȥǡ()Ѵ(1 ).
      !
      real(8)               :: w_xy(nm+1)
      !(out) ڥȥǡ

      real(8), intent(in)   :: xy_data(0:im-1,1:jm)
      !(in) ʻǡ

      integer, intent(in), optional  :: ipow
      !(in) ѴƱ˺Ѥ 1/cos μ. ά 0.

      integer, intent(in), optional  :: iflag
      ! Ѵμ
      !    0 : ̾Ѵ
      !    1 : ʬ 1/cosա(f cos^2)/ߦ ѤѴ
      !   -1 : ʬѤѴ
      !    2 : sinդѤѴ
      !  ά 0.


      integer, parameter  :: ipow_default  = 0    ! åǥե
      integer, parameter  :: iflag_default = 0    ! åǥե

      integer ipval, ifval

      real(8)             :: xy_work(0:im-1,1:jm) ! ʻǡ

      if (present(ipow)) then
         ipval = ipow
      else
         ipval = ipow_default
      endif

      if (present(iflag)) then
         ifval = iflag
      else
         ifval = iflag_default
      endif

      xy_work = xy_data/cos(xy_Lat)**ipval

      if ( ifval == -1 ) then                         ! ʬ 0 
         w_xy = 0.0D0        
      else if ( ifval == 1 ) then                     ! ʬ
         xy_work = xy_work * cos(xy_Lat)
         w_xy = w_DivLat_y(xy_work(0,:))
      else if ( ifval == 2 ) then                     ! sin 򤫤Ѵ
         xy_work = xy_work * sin(xy_Lat)
         w_xy = w_y(xy_work(0,:))
      else
         w_xy = w_y(xy_work(0,:))
      endif
      
    end function w_xy

  !--------------- ʬ׻ -----------------
    function w_DLon_w(w_data)
      !
      ! ڥȥǡ˷ʬ /ߦ Ѥ(1 ).
      !
      ! ڥȥǡηʬȤ, бʻǡ
      ! ʬ/ߦˤѤǡΥڥȥѴΤȤǤ.
      ! 
      real(8)              :: w_DLon_w(nm+1)
      !(out) ڥȥǡηʬ

      real(8), intent(in)  :: w_data(nm+1)
      !(in) ϥڥȥǡ

      w_DLon_w = 0.0D0

    end function w_DLon_w

    function xy_GradLon_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ 1/cosա/ߦ 
      ! Ѥʻǡ֤(1 ).
      !
      real(8)              :: xy_GradLon_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data(nm+1)
      !(in) ϥڥȥǡ

      xy_GradLon_w = xy_w(w_data,ipow=1,iflag=-1)

    end function xy_GradLon_w

    function xy_GradLat_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ
      ! ʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradLat_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data(nm+1)
      !(in) ϥڥȥǡ

      xy_GradLat_w = xy_w(w_data,ipow=1,iflag=1)

    end function xy_GradLat_w

    function w_DivLon_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLon_xy(nm+1)
      !(out) ʻǡȯʬڥȥǡ
      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLon_xy = w_xy(xy_data,ipow=1,iflag=-1)

    end function w_DivLon_xy

    function w_DivLat_xy(xy_data)
      !
      ! ʻǡȯʬ 1/cosա(f cos)/ߦ Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLat_xy(nm+1)
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLat_xy = w_xy(xy_data,ipow=1,iflag=1)

    end function w_DivLat_xy

    function w_Div_xy_xy(xy_u,xy_v)
      !
      ! 2 Ĥϳʻǡ٥ȥʬȤȯ׻, 
      ! ڥȥǡȤ֤(1 ).
      !
      real(8)              :: w_Div_xy_xy(nm+1)
      !(out) 2 Ĥϳʻǡ٥ȥʬȤȯΥڥȥǡ

      real(8), intent(in)  :: xy_u(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      real(8), intent(in)  :: xy_v(0:im-1,1:jm)
      !(in) ٥ȥʬγʻǡ

      w_Div_xy_xy = w_Divlon_xy(xy_u) + w_Divlat_xy(xy_v)

    end function w_Div_xy_xy

    function w_Jacobian_w_w(w_a,w_b)
      ! 2 ĤΥڥȥǡ˥䥳ӥ
      !
      !   J(f,g) = f/ߦˡg/ߦ - g/ߦˡf/ߦ
      !          = f/ߦˡ1/cosաg/ߦ
      !             - g/ߦˡ1/cosաf/ߦ
      !
      ! Ѥ(1 ).

      real(8)             :: w_Jacobian_w_w(nm+1)
      !(out) 2 ĤΥڥȥǡΥ䥳ӥ

      real(8), intent(in) :: w_a((nm+1)*(nm+1))
      !(in) 1ܤϥڥȥǡ
      
      real(8), intent(in) :: w_b((nm+1)*(nm+1))
      !(in) 2ܤϥڥȥǡ

      w_Jacobian_w_w = 0.0D0      

    end function w_Jacobian_w_w

  !--------------- ʬ׻ (,̺ɸ) -----------------
    function xy_GradLambda_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ /ߦ Ѥ(1 ).
      !
      real(8)              :: xy_GradLambda_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data(nm+1)
      !(in) ϥڥȥǡ
      
      xy_GradLambda_w = xy_w(w_data,ipow=0,iflag=-1)

    end function xy_GradLambda_w

    function xy_GradMu_w(w_data)
      !
      ! ڥȥǡ˸۷ʬ (1-^2)/ߦ  (=sin)
      ! ѤƳʻǡѴ֤(1 ).
      !
      real(8)              :: xy_GradMu_w(0:im-1,1:jm)
      !(out) ڥȥǡ۷ʬʻǡ

      real(8), intent(in)  :: w_data(nm+1)
      !(in) ϥڥȥǡ

      xy_GradMu_w = xy_w(w_data,ipow=0,iflag=1)

    end function xy_GradMu_w

    function w_DivLambda_xy(xy_data)
      !
      ! ʻǡȯʬ 1/(1-^2)/ߦ (=sin) 
      ! ѤƥڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivLambda_xy(nm+1)
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivLambda_xy = w_xy(xy_data,ipow=2,iflag=-1)

    end function w_DivLambda_xy

    function w_DivMu_xy(xy_data)
      !
      ! ʻǡȯʬ /ߦ (=sin)Ѥ
      ! ڥȥǡѴ֤(1 ).
      !
      real(8)              :: w_DivMu_xy(nm+1)
      !(out) ʻǡȯʬڥȥǡ

      real(8), intent(in)  :: xy_data(0:im-1,1:jm)
      !(in) ϳʻǡ

      w_DivMu_xy = w_xy(xy_data,ipow=2,iflag=1)

    end function w_DivMu_xy

  !--------------- ַ׻ -----------------
    function Interpolate_w(w_data,alon,alat)
      real(8), intent(IN) :: w_data(nm+1)   ! ڥȥǡ
      real(8), intent(IN) :: alon           ! ֤()
      real(8), intent(IN) :: alat           ! ֤()
      real(8)             :: Interpolate_w  ! ֤
      
      Interpolate_w = Interpolate_alat_w(w_data,alat)

    end function Interpolate_w

  !--------------- ʬ׻ -----------------
    function IntLon_x(x_data)
      !
      ! 1 (X)ʻǡ X ʬ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ.
      !
      real(8), intent(in) :: x_data(0:im-1)   !(in)  1 (X)ʻǡ
      real(8)             :: IntLon_x         !(out) ʬ

      IntLon_x = sum(x_data * x_Lon_weight)

    end function IntLon_x

    function x_IntLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)           
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8)             :: x_IntLat_xy(0:im-1) 
      !(out) ʬ줿 1 (X)ʻǡ

      integer :: j

      x_IntLat_xy = 0.0D0
      do j=1,jm
         x_IntLat_xy = x_IntLat_xy + xy_data(:,j) * y_Lat_weight(j)
      enddo

    end function x_IntLat_xy

    function y_IntLon_xy(xy_data)
      !
      ! 2 ٷٳʻǡη(X)ʬ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻Ƥ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8)             :: y_IntLon_xy(1:jm)
      !(out) ʬ줿 1 (Y)ʻǡ

      integer :: i

      y_IntLon_xy = 0.0D0
      do i=0,im-1
         y_IntLon_xy = y_IntLon_xy + xy_data(i,:) * x_Lon_weight(i)
      enddo

    end function y_IntLon_xy

    function IntLonLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰʬ(1 ). 
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻Ƥ. 
      !
      real(8), intent(in)   :: xy_data(0:im-1,1:jm)         
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)

      real(8) :: IntLonLat_xy                         
      !(out) ʬ

      IntLonLat_xy = IntLon_x(x_IntLat_xy(xy_data))

    end function IntLonLat_xy

  !--------------- ʿѷ׻ -----------------
    function AvrLon_x(x_data)
      !
      ! 1 (X)ʻǡη(X)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: x_data(0:im-1)
      !(in)  1 (X)ʻǡ
      real(8)             :: AvrLon_x       
      !(out) ʿ

      AvrLon_x = IntLon_x(x_data)/sum(x_Lon_weight)

    end function AvrLon_x


    function x_AvrLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰ(Y)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ y_Y_Weight 򤫤¤׻, 
      ! y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)
      real(8)             :: x_AvrLat_xy(im)
      !(out) ʿѤ줿 1 (X)ʻǡ

      x_AvrLat_xy = x_IntLat_xy(xy_data)/sum(y_Lat_weight)

    end function x_AvrLat_xy

    function y_AvrLon_xy(xy_data)
      !
      ! 2 ٷٳʻǡη(X)ʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight 򤫤¤׻, 
      ! x_X_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in) :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ(0:im-1,1:jm)
      real(8)             :: y_AvrLon_xy(1:jm)
      !(out) ʿѤ줿 1 (Y)ʻ

      y_AvrLon_xy = y_IntLon_xy(xy_data)/sum(x_Lon_weight)

    end function y_AvrLon_xy


    function AvrLonLat_xy(xy_data)
      !
      ! 2 ٷٳʻǡΰʿ(1 ).
      !
      ! ºݤˤϳʻǡ x_X_Weight, y_Y_Weight 򤫤
      ! ¤׻, x_X_Weight*y_Y_Weight ¤ǳ뤳ȤʿѤƤ. 
      !
      real(8), intent(in)   :: xy_data(0:im-1,1:jm)
      !(in) 2 ٰٳʻǡ

      real(8) :: AvrLonLat_xy
      !(out) ʿ

      AvrLonLat_xy = AvrLon_x(x_AvrLat_xy(xy_data))

    end function AvrLonLat_xy

  !--------------- ͥ륮ڥȥ׻ -----------------
    function nm_EnergyFromStreamfunc_w(w_Strfunc)
      ! 
      ! ήؿΥڥȥǡ饨ͥ륮εĴȡʬ
      ! (ڥȥ)׻(1 ).
      !
      !  * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥ (1/2)n(n+1)(n,m)^2 ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤4Ф򤫤Τ̾Ǥ
      !    ͥ륮.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ(ʿȿ n, Ӿȿ m )

      integer :: n, m

      nm_EnergyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=1,n
            nm_EnergyFromStreamfunc_w(n,m)  = 0.0D0
            nm_EnergyFromStreamfunc_w(n,-m) = 0.0D0
         enddo
         nm_EnergyFromStreamfunc_w(n,0) &
              = 0.5 * n*(n+1) * w_Strfunc(l_nm(n,0))**2
      enddo
    end function nm_EnergyFromStreamfunc_w

    function n_EnergyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 ).
      !
      !  * ȿ n ήؿΥڥȥʬ(n,m) 
      !    ͥ륮ڥȥϦ[m=-nm]^nm(1/2)n(n+1)(n,m)^2 
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ 4Ф򤫤Τ
      !    ̾Ǥͥ륮.
      !

      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnergyFromStreamfunc_w
      !(out) ͥ륮ڥȥ (ʿȿ n ) 

      integer :: n

      do n=0,nm
         n_EnergyFromStreamfunc_w(n)  &
              = 0.5 * n*(n+1) * w_StrFunc(l_nm(n,0))**2
      enddo

    end function n_EnergyFromStreamfunc_w

  !--------------- 󥹥ȥեڥȥ׻ -----------------
    function nm_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡ饨󥹥ȥեεĴȡʬ
      ! (ڥȥ)׻(1 ). 
      !
      ! * ȿ n, Ӿȿ m ήؿΥڥȥʬ(n,m) 
      !    󥹥ȥեڥȥ (1/2)n^2(n+1)^2(n,m)^2 ȷ׻.
      !
      ! * ƤΥ󥹥ȥեڥȥʬ¤4/R^2򤫤Τ
      !   ̾Ǥ󥹥ȥե.  R ϵ̤Ⱦ¤Ǥ.
      !
      ! * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !   »ͤͤϥ⥸塼ѿ w_spectrum_VMiss ˤäǤ
      !   (ͤ -999.0)
      !
      real(8), intent(in)   :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm,-nm:nm) :: nm_EnstrophyFromStreamfunc_w
      ! 󥹥ȥեڥȥ (ʿȿ n, Ӿȿ m )

      integer :: n, m

      nm_EnstrophyFromStreamfunc_w = w_spectrum_VMiss

      do n=0,nm
         do m=1,n
            nm_EnstrophyFromStreamfunc_w(n,m) = 0.0
            nm_EnstrophyFromStreamfunc_w(n,-m) = 0.0
         enddo
         nm_EnstrophyFromStreamfunc_w(n,0) &
                 = 0.5 * n**2 * (n+1)**2 * w_Strfunc(l_nm(n,0))**2
      enddo

    end function nm_EnstrophyFromStreamfunc_w

    function n_EnstrophyFromStreamfunc_w(w_Strfunc)
      !
      ! ήؿΥڥȥǡȿΥͥ륮ʬ(ڥȥ)
      ! ׻(1 )
      !
      ! * ȿ n ήؿΥڥȥʬ(n,m) 饨󥹥ȥե
      !   ڥȥϦ[m=-nm]^nm(1/2)n^2(n+1)^2(n,m)^2 ȷ׻.
      !    
      ! * ƤΥͥ륮ڥȥʬ¤ 4/R^2 򤫤Τ
      !   ̾Ǥ󥹥ȥե.
      !
      real(8), intent(in)      :: w_Strfunc(:)
      !(in) ήؿ(ڥȥǡ)

      real(8), dimension(0:nm) :: n_EnstrophyFromStreamfunc_w  
      !(out) 󥹥ȥեڥȥ(ʿȿ n )

      integer :: n

      do n=0,nm
         n_EnstrophyFromStreamfunc_w(n)  &
              = 0.5 * n**2 * (n+1)**2 * w_StrFunc(l_nm(n,0))**2
      enddo
    end function n_EnstrophyFromStreamfunc_w

end module w_zonal_module_sjpack
