!--
!----------------------------------------------------------------------
! Copyright(c) 2011 SPMDODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wt_module_sjpack_cuda
!
!    spml/wt_module_sjpack_cuda ⥸塼ϵ̾太ӵǤήαư
!    ڥȥˡˤäƿͷ׻뤿 Fortran90 ؿ󶡤
!    ΤǤ. 
!
!    ʿ˵ĴȡѴӾ岼ζɤ򰷤
!    ӥѴѤΥڥȥ׻ΤΤޤޤ
!    ؿ󶡤. 
!
!     wa_module_sjpack_cuda, at_module ѤƤ. ǲǤ
!    ĴѴӥӥѴΥ󥸥Ȥ ISPACK  
!    Fortran77 ֥롼ѤƤ.
!
!    ؿ, ֥롼̾ȵǽ wt_module, wt_module_sjpack 
!    ΤƱǤ. ä use ʸ wt_module  
!    wt_module_sjpack_cuda ѹ SJPACK εǽȤ褦ˤʤ. 
! 
!     l_nm, nm_l λȤˤդ줿. wt_module  l_nm, nm_l 
!    wt_Initial ǽʤȤѤ뤳ȤǤ(̤ȿ˰ͤʤ),
!    wt_module_sjpack_cua ΤΤϽΤˤȤȤǤʤ. 
!
!
!  2011/03/12  ݹ  wt_module_sjpack  CUDA б˲¤
!
!
!      ǡ index
!        x :          y :         z : ư
!        w : Ĵ´ؿڥȥ
!        n : Ĵ´ؿڥȥ(ʿȿ)
!        m : Ĵ´ؿڥȥ(Ӿȿ)
!        t : ӥմؿڥȥ
!        a : Ǥդμ
!
!        xyz : 3 ʻǡ
!        xy  : ʿ 2 ʻǡ
!        yz  : Ҹ 2 ʻǡ
!        xz  :  2 ʻǡ
!
!        wz  : ʿڥȥư³ʻǡ
!        wt  : ڥȥǡ
!
!++
module wt_module_sjpack_cuda
  !
  != wt_module_sjpack_cuda
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wt_module_sjpack_cuda.f90,v 1.2 2011-03-12 13:10:03 takepiro Exp $
  ! Copyright&License:: See COPYRIGHT[link:../COPYRIGHT]
  !
  !== 
  !
  !    spml/wt_module_sjpack_cuda ⥸塼ϵ̾太ӵǤήαư
  !    ڥȥˡˤäƿͷ׻뤿 Fortran90 ؿ󶡤
  !    ΤǤ. 
  !
  !    ʿ˵ĴȡѴӾ岼ζɤ򰷤
  !    ӥѴѤΥڥȥ׻ΤΤޤޤ
  !    ؿ󶡤. 
  !
  !     wa_module_sjpack_cuda, at_module ѤƤ. ǲǤ
  !    ĴѴӥӥѴΥ󥸥Ȥ ISPACK  
  !    Fortran77 ֥롼ѤƤ.
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ (wt_, nmz_, nz_, xyz_, wz_, w_, xy_, x_, y_, z_, a_) , 
  !   ֤ͤη򼨤Ƥ.
  !   wt_  :: ڥȥǡ(ĴȡӥѴ)
  !   nmz_ :: ʿڥȥǡ(ȿ n, Ӿȿʬ, ư)
  !   nz_  :: ʿڥȥǡ(ȿ n, ư)
  !   xyz_ :: 3 ʻǡ(١١ư)
  !   wz_  :: ʿڥȥ, ư³ʻǡ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla,..)
  !   , δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (wt_, xyz_, wz_, w_, xy_, x_, y_, z_, a_) , ѿ
  !   ڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !   _wt      :: ڥȥǡ
  !   _xyz     :: 3 ʻǡ
  !   _xyz_xyz :: 2 Ĥ3 ʻǡ, ...
  !
  !=== ƥǡμ
  !
  ! * xyz : 3 ʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,1:jm,0:km). 
  !   * im, jm, km Ϥ줾, , ưºɸγʻǤ, 
  !     ֥롼 wt_Initial ˤƤ餫ꤷƤ.
  !
  ! * wt : ڥȥǡ
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:lm). 
  !   * nm ϵĴȡκȿ, lm ϥӥ¿༰κ缡
  !     Ǥ, ֥롼 wt_Initial ˤƤ餫ꤷƤ. 
  !   * ʿڥȥǡγǼΤϴؿ l_nm, nm_l ˤäĴ٤
  !     ȤǤ.
  !
  ! * nmz : ʿڥȥǡ¤ 3 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm,0:km). 
  !   *  1 ʿȿ,  2 Ӿȿ,  3 ưºɸɽ. 
  !   * nm ϵĴȡκȿǤ, ֥롼 wt_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * nz : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,0:km). 
  !   *  1 ʿȿɽ. nm ϵĴȡκȿǤ, 
  !     ֥롼 wt_Initial ˤƤ餫ꤷƤ.
  !
  ! * wz : ʿڥȥ, ư³ʻǡ.
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:km).
  !
  ! * wt_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xyz_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * wz_ ǻϤޤؿ֤ͤϿʿڥȥ, ư³ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  ! 
  !
  !== ѿ³
  !
  !====  
  !
  ! wt_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, y_Lat, z_Rad          :: ʻɸ(, , ưºɸ)
  !                                 Ǽ1 
  ! x_Lon_Weight, y_Lat_Weight, z_Rad_Weight :: ŤߺɸǼ 1 
  ! xyz_Lon, xyz_Lat, xyz_Rad    :: ʻǡη١١ưºɸ(X,Y,Z)
  !                                 (ʻǡ 3 )
  !
  !==== Ѵ
  !
  ! xyz_wt, wt_xyz :: ڥȥǡ 3 ʻҥǡδ֤Ѵ
  !                   (Ĵȡ, ӥѴ)
  ! xyz_wz, wz_xyz :: 3 ʻҥǡȿʿڥȥ롦ư³ʻҥǡȤδ
  !                   Ѵ (Ĵȡ)
  ! wz_wt, wt_wz   :: ڥȥǡȿʿڥȥ롦ư³ʻҥǡȤδ
  !                   Ѵ (ӥѴ)
  ! w_xy, xy_w     :: ڥȥǡ 2 ʿʻҥǡδ֤Ѵ
  !                   (ĴȡѴ) 
  ! az_at, at_az   :: ƱʣĹԤ (ӥѴ)ʻҥǡ
  !                   ӥեǡδ֤Ѵ
  ! l_nm, nm_l     :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! wt_DRad_wt          :: ڥȥǡưʬ/r Ѥ
  ! wt_DivRad_wt        :: ڥȥǡȯưʬ
  !                        1/r^2 /r r^2 = /r + 2/r Ѥ
  ! wt_RotRad_wt        :: ڥȥǡ˲žưʬ
  !                        1/r /rr = /r + 1/r Ѥ
  ! wt_Lapla_wt         :: ڥȥǡ˥ץ饷Ѥ
  ! xyz_GradLon_wt      :: ڥȥǡ˸۷ʬ
  !                        1/rcosա/ߦˤѤ
  ! xyz_GradLat_wt      :: ڥȥǡ˸۷ʬ
  !                        1/r/ߦդѤ
  ! wt_DivLon_xyz       :: ʻҥǡȯʬ
  !                        1/rcosա/ߦˤѤ
  ! wt_DivLat_xyz       :: ʻҥǡȯʬ
  !                        1/rcosա(g cos)/ߦդѤ
  ! wt_Div_xyz_xyz_xyz  :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyz_Div_xyz_xyz_xyz :: ٥ȥʬǤ 3 Ĥγʻҥǡ
  !                        ȯѤ
  ! xyz_RotLon_wt_wt    :: ٥ȥβžηʬ׻
  ! xyz_RotLat_wt_wt    :: ٥ȥβžΰʬ׻
  ! wt_RotRad_xyz_xyz   :: ٥ȥβžưʬ׻
  !
  !==== ȥݥ׻ʬ
  !
  ! wt_KxRGrad_wt            :: ڥȥǡ
  !                             ʬ kr = /ߦˤѤ
  ! xyz_KGrad_wt             :: ڥȥǡ˼ʬ
  !                             k = cos/r /ߦ + sinբ/r 
  !                             Ѥ
  ! wt_L2_wt                 :: ڥȥǡ 
  !                             L2 黻 = -ʿץ饷Ѥ
  ! wt_L2Inv_wt              :: ڥȥǡ 
  !                             L2 黻Ҥε = -տʿץ饷Ѥ
  ! wt_QOperator_wt          :: ڥȥǡ
  !                             黻 Q=(k-1/2(L2 k+ kL2)) 
  !                             Ѥ
  ! wt_RadRot_xyz_xyz        :: ٥ȥ v α٤ư¥٥ȥ r 
  !                             r(v) ׻
  ! wt_RadRotRot_xyz_xyz_xyz :: ٥ȥ v  r(ߢv) ׻
  ! wt_Potential2Vector      :: ȥݥݥƥ󥷥뤫
  !                             ٥ȥ׻
  ! wt_Potential2Rotation    :: ȥݥݥƥ󥷥ɽ
  !                             ȯ٥ȥβžγʬ׻
  !
  !==== ׻
  !
  ! wt_VGradV    ::  ٥ȥ v  vv ׻
  !
  !==== ݥ/ȥǥѥڥȥ
  !
  ! nmz_ToroidalEnergySpectrum_wt, nz_ToroidalEnergySpectrum_wt   ::
  !     ȥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  ! nmz_PoloidalEnergySpectrum_wt, nz_PoloidalEnergySpectrum_wt   :: 
  !     ݥݥƥ󥷥뤫饨ͥ륮εĴȡʬ׻
  !
  !==== 
  !
  ! wt_BoundariesTau, wt_BoundariesGrid, wt_Boundaries                   ::
  !     ǥꥯ, Υޥ󶭳ŬѤ(ˡ, ˡ)
  ! wt_TorBoundariesTau, wt_TorBoundariesGrid, wt_TorBoundaries          ::
  !     ®٥ȥݥƥ󥷥ζŬѤ(ˡ,ˡ) 
  !
  ! wz_LaplaPol2Pol_wz, wt_LaplaPol2Pol_wt                               ::
  !     ®٥ݥݥƥ󥷥릵^2
  !     (Ϥ줾ӥճʻ,ӥշ)
  ! wt_TorMagBoundariesTau, wt_TorMagBoundariesGrid, wt_TorMagBoundaries ::
  !     ȥݥƥ󥷥ζŬѤ(ˡ, ˡ)
  !
  ! wt_PolMagBoundariesTau, wt_PolMagBoundariesGrid, wt_PolMagBoundaries ::
  !     ȥݥƥ󥷥붭ζŬѤ(ˡ, ˡ)
  !
  !==== ʬʿ(3 ǡ)
  !
  ! IntLonLatRad_xyz, AvrLonLatRad_xyz :: 3 ʻǡ
  !                                       ΰʬʿ
  ! z_IntLonLat_xyz, z_AvrLonLat_xyz   :: 3 ʻǡ
  !                                       ٷ(ʿ)ʬʿ
  ! y_IntLonRad_xyz, y_AvrLonRad_xyz   :: 3 ʻǡ
  !                                       ưʬʿ
  ! z_IntLatRad_xyz, z_AvrLatRad_xyz   :: 3 ʻǡ
  !                                       ư(Ҹ)ʬʿ
  ! yz_IntLon_xyz, yz_AvrLon_xyz       :: 3 ʻǡ
  !                                       ʬʿ
  ! xz_IntLat_xyz, xz_AvrLat_xyz       :: 3 ʻǡ
  !                                       ʬʿ
  ! xz_IntRad_xyz, xz_AvrRad_xyz       :: 3 ʻǡ
  !                                       ưʬʿ
  !
  !==== ʬʿ(2 ǡ)
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡοʿ()ʬʿ
  ! IntLonRad_xz, AvrLonRad_xz :: 2 (XZ)ʻǡηưʬ
  !                               ʿ
  ! IntLatRad_yz, AvrLatRad_yz :: 2 (YZ)ʻǡΰư(Ҹ)
  !                               ʬʿ 
  ! y_IntLon_xy, y_AvrLon_xy   :: ʿ 2 ()ʻǡη
  !                               ʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: ʿ2 ()ʻǡΰʬ
  !                               ʿ
  ! z_IntLon_xz, z_AvrLon_xz   :: 2 (XZ)ʻǡηʬ
  !                               ʿ
  ! x_IntRad_xz, x_AvrRad_xz   :: 2 (XZ)ʻǡưʬ
  !                               ʿ
  ! z_IntLat_yz, z_AvrLat_yz   :: 2 (YZ)ʻǡΰʬ
  !                               ʿ
  ! y_IntRad_yz, y_AvrRad_yz   :: 2 (YZ)ʻǡưʬ
  !                               ʿ                  
  !
  !==== ʬʿ(1 ǡ)
  !
  ! IntLon_x, AvrLon_x  :: 1 (X)ʻǡηʬʿ
  ! IntLat_y, AvrLat_y  :: 1 (Y)ʻǡΰʬʿ
  ! IntRad_z, AvrRad_z  :: 1 (Z)ʻǡưʬʿ
  !
  !==== ַ׻
  !
  ! Interpolate_wt :: ڥȥǡǤդ֤ͤ. 
  ! 
  use dc_message
  use lumatrix
  use wa_module_sjpack_cuda
  use at_module, z_RAD => g_X, z_RAD_WEIGHT => g_X_WEIGHT, &
                 at_az => at_ag, az_at => ag_at, &
                 t_Dr_t => t_Dx_t, at_Dr_at => at_Dx_at
  implicit none
  private

  public wt_Initial

  public x_Lon, x_Lon_Weight
  public y_Lat, y_Lat_Weight
  public z_Rad, z_Rad_Weight
  public l_nm, nm_l
  public xy_Lon, xy_Lat
  public xyz_Lon, xyz_Lat, xyz_Rad
  public wz_Rad
  public wt_VMiss

  public w_xy, xy_w
  public at_Dr_at, t_Dr_t, az_at, at_az
  public xyz_wt, wt_xyz, xyz_wz, wz_xyz, wz_wt, wt_wz
  public wt_DRad_wt, wt_DivRad_wt, wt_RotRad_wt, wt_Lapla_wt
  public xyz_GradLon_wt, xyz_gradlat_wt
  public wt_DivLon_xyz, wt_DivLat_xyz
  public wt_Div_xyz_xyz_xyz, xyz_Div_xyz_xyz_xyz
  public xyz_RotLon_wt_wt, xyz_RotLat_wt_wt, wt_RotRad_xyz_xyz

  public yz_IntLon_xyz, xz_IntLat_xyz, xy_IntRad_xyz
  public x_IntLatRad_xyz, y_IntLonRad_xyz, z_IntLonLat_xyz
  public IntLonLatRad_xyz

  public x_IntLat_xy, y_IntLon_xy, IntLonLat_xy
  public z_IntLat_yz, y_IntRad_yz, IntLatRad_yz
  public z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
  public IntLon_x, IntLat_y, IntRad_z

  public yz_AvrLon_xyz, xz_AvrLat_xyz, xy_AvrRad_xyz
  public x_AvrLatRad_xyz, y_AvrLonRad_xyz, z_AvrLonLat_xyz
  public AvrLonLatRad_xyz

  public x_AvrLat_xy, y_AvrLon_xy, AvrLonLat_xy
  public z_AvrLat_yz, y_AvrRad_yz, AvrLatRad_yz
  public z_AvrLon_xz, x_AvrRad_xz, AvrLonRad_xz
  public AvrLon_x, AvrLat_y, AvrRad_z

  public wt_KxRGrad_wt, xyz_KGrad_wt, wt_L2_wt, wt_L2Inv_wt, wt_QOperator_wt
  public wt_RadRot_xyz_xyz, wt_RadRotRot_xyz_xyz_xyz
  public wt_Potential2vector, wt_Potential2Rotation
  public wt_VGradV

  public Interpolate_wt

  public nmz_ToroidalEnergySpectrum_wt, nz_ToroidalEnergySpectrum_wt
  public nmz_PoloidalEnergySpectrum_wt, nz_PoloidalEnergySpectrum_wt

  public wt_Boundaries, wt_TorBoundaries, wz_LaplaPol2Pol_wz
  public wt_TormagBoundaries, wt_PolmagBoundaries

  public wt_BoundariesTau, wt_TorBoundariesTau
  public wt_TormagBoundariesTau, wt_PolmagBoundariesTau

  public wt_BoundariesGrid, wt_TorBoundariesGrid, wt_LaplaPol2PolGrid_wt
  public wt_TormagBoundariesGrid, wt_PolmagBoundariesGrid

  interface wt_Boundaries
     module procedure wt_BoundariesTau
  end interface

  interface wt_TorBoundaries
     module procedure wt_TorBoundariesTau
  end interface

  interface wt_TorMagBoundaries
     module procedure wt_TorMagBoundariesTau
  end interface

  interface wt_PolMagBoundaries
     module procedure wt_PolMagBoundariesTau
  end interface

  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=16         ! ȿ(ʿ, ư)
  real(8)            :: ri=0.0, ro=1.0       ! ⳰Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: xyz_LON, xyz_LAT, xyz_RAD ! ɸ
  real(8), dimension(:,:), allocatable   :: wz_RAD                    ! ɸ

  real(8) :: wt_VMiss = -999.0        ! »

  save im, jm, km, nm, lm, ri, ro

  contains
  !---------------  -----------------
   subroutine wt_Initial(i,j,k,n,l,r_in,r_out,np,wa_init)
     !
     ! ڥȥѴγʻ, ȿ, ưºɸϰϤꤹ.
     !
     ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
     ! ʤФʤʤ. 
     !
     ! np  1 礭ͤꤹ ISPACK εĴȡѴ 
     ! OPENMP ׻롼Ѥ. ׻¹Ԥˤ, 
     ! ¹Ի˴Ķѿ OMP_NUM_THREADS  np ʲοꤹ
     ! ƥ˱ɬפȤʤ. 
     !
     ! np  1 礭ͤꤷʤ׻롼ϸƤФʤ.
     !
     !
     integer,intent(in) :: i              ! ʻ(٦)
     integer,intent(in) :: j              ! ʻ(٦)
     integer,intent(in) :: k              ! ʻ(ư r)
     integer,intent(in) :: n              ! ȿ(ʿȿ)
     integer,intent(in) :: l              ! ȿ(ưȿ)

     real(8),intent(in) :: r_in           ! Ⱦ
     real(8),intent(in) :: r_out          ! ̳Ⱦ

     integer,intent(in), optional :: np   ! OPENMP Ǥκ祹åɿ
     logical,intent(in), optional :: wa_init   ! wa_initial å

     logical    :: wa_initialize=.true.   ! wa_initial å
     
     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ri = r_in ; ro = r_out

     if ( present(wa_init) ) then
        wa_initialize = wa_init
     else
        wa_initialize = .true.
     endif

     if ( wa_initialize ) then
        if ( present(np) ) then
           call wa_Initial(nm,im,jm,km+1,np)
        else
           call wa_Initial(nm,im,jm,km+1)
        endif
     endif

     call at_Initial(km,lm,r_in,r_out)

     allocate(xyz_Lon(0:im-1,1:jm,0:km))
     allocate(xyz_Lat(0:im-1,1:jm,0:km))
     allocate(xyz_Rad(0:im-1,1:jm,0:km))

     allocate(wz_Rad((nm+1)*(nm+1),0:km))

     xyz_Lon = spread(xy_Lon,3,km+1)
     xyz_Lat = spread(xy_Lat,3,km+1)
     xyz_Rad = spread(spread(z_Rad,1,jm),1,im)

     wz_Rad = spread(z_Rad,1,(nm+1)*(nm+1))

     z_Rad_Weight = z_Rad_Weight * z_Rad**2       ! r^2 dr ʬŤ

     call MessageNotify('M','wt_initial', &
          'wt_module_sjpack_cuda (2011/03/12) is initialized')

   end subroutine wt_initial

  !--------------- Ѵ -----------------

    function xyz_wt(wt)
      !
      ! ڥȥǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ
      real(8), dimension(0:im-1,1:jm,0:km)               :: xyz_wt
      !(out) 3 ٰư³ʻǡ

      xyz_wt = xya_wa(wz_wt(wt))

    end function xyz_wt

    function wt_xyz(xyz)
      !
      ! 3 ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:lm)           :: wt_xyz
      !(out) 2 Ĵȡӥեڥȥǡ

      wt_xyz = wt_wz(wa_xya(xyz))

    end function wt_xyz

    function xyz_wz(wz)
      !
      ! ʿڥȥ롦ư³ʻǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wz
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ
      real(8), dimension(0:im-1,1:jm,0:km)               :: xyz_wz
      !(out) 3 ٰư³ʻǡ

      xyz_wz = xya_wa(wz)

    end function xyz_wz

    function wz_xyz(xyz)
      !
      ! 3 ʻҥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in)   :: xyz
      !(in) 3 ٰư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_xyz
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ

      wz_xyz = wa_xya(xyz)

    end function wz_xyz

    function wz_wt(wt)
      !
      ! ڥȥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_wt
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ

      wz_wt = az_at(wt)

    end function wz_wt

    function wt_wz(wz)
      !
      ! ʿڥȥ롦ư³ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wz
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_wz
      !(out) 2 Ĵȡӥեڥȥǡ

      wt_wz = at_az(wz)

    end function wt_wz

  !--------------- ʬ׻ -----------------
    function wt_DRad_wt(wt)
      !
      ! ϥڥȥǡưʬ /r Ѥ.
      !
      ! ڥȥǡưʬȤ, бʻǡưʬ
      ! ѤǡΥڥȥѴΤȤǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_DRad_wt
      !(in) ưʬ줿2 Ĵȡӥեڥȥǡ

      wt_DRad_wt = at_Dr_at(wt)

    end function wt_DRad_wt

    function wt_DivRad_wt(wt)
      ! 
      ! ϥڥȥǡȯưʬ
      !
      !       1/r^2 /r (r^2 .)= /r + 2/r
      !
      ! Ѥ.
      !
      ! ڥȥǡȯưʬȤ, бʻǡ
      ! ȯưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_DivRad_wt
      !(out) ȯưʬѤ줿 2 ڥȥǡ

      wt_DivRad_wt = wt_Drad_wt(wt) + wt_wz(2/wz_rad*wz_wt(wt))


    end function wt_DivRad_wt

    function wt_RotRad_wt(wt)
      !
      ! ϥڥȥǡ˲žưʬ
      !
      !      1/r (r.)/r = (.)/r + (.)/r
      !
      ! Ѥ.
      !
      ! ڥȥǡβžưʬȤ, бʻǡ
      ! žưʬѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_RotRad_wt
      !(out) žưʬѤ줿 2 ڥȥǡ

      wt_RotRad_wt = wt_Drad_wt(wt) + wt_wz(1/wz_Rad*wz_wt(wt))

    end function wt_RotRad_wt

    function wt_Lapla_wt(wt)
      ! ϥڥȥǡ˥ץ饷
      !
      !     ^2 =   1/r^2 cos^2ա^2/ߦ^2 
      !            + 1/r^2 cosա/ߦ(cosբ/ߦ) 
      !            + 1/r^2 /r (r^2 /r) 
      !
      ! Ѥ.
      !
      ! ڥȥǡΥץ饷Ȥ, бʻǡ
      ! ץ饷ѤǡΥڥȥѴΤȤǤ. 
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_Lapla_wt
      !(out) ץ饷Ѥ줿 2 ڥȥǡ

      wt_Lapla_wt = wt_DivRad_wt(wt_Drad_wt(wt)) &
                   + wt_wz(wz_wt(wa_Lapla_wa(wt))/wz_Rad**2)

    end function wt_Lapla_wt

    function xyz_GradLon_wt(wt)
      !
      ! ڥȥǡ˸۷ʬ 1/rcosա/ߦ
      ! Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,0:km)   :: xyz_GradLon_wt
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xyz_GradLon_wt = xya_GradLon_wa(wz_wt(wt))/xyz_Rad

    end function xyz_GradLon_wt

    function xyz_GradLat_wt(wt) 
      !
      ! ڥȥǡ˸۷ʬ 1/r /ߦ Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,0:km)    :: xyz_GradLat_wt
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xyz_GradLat_wt = xya_GradLat_wa(wz_wt(wt))/xyz_Rad

    end function xyz_GradLat_wt

    function wt_DivLon_xyz(xyz)
      ! 
      ! ʻǡȯʬ 1/rcosա/ߦ Ѥ
      ! ڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in)   :: xyz
      !(in) 3 ٰư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLon_xyz
      !(out) ȯʬѤ줿 2 ڥȥǡ

      wt_DivLon_xyz = wt_wz(wa_DivLon_xya(xyz/xyz_Rad))

    end function wt_DivLon_xyz

    function wt_DivLat_xyz(xyz)
      !
      ! ʻҥǡȯʬ 1/rcosա(f cos)/ߦ 
      ! Ѥڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in)   :: xyz
      !(in) 3 ٰư³ʻǡ
      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLat_xyz
      !(out) ȯʬѤ줿 2 ڥȥǡ

      wt_DivLat_xyz = wt_wz(wa_divlat_xya(xyz/xyz_Rad))

    end function wt_DivLat_xyz

    function wt_Div_xyz_xyz_xyz(xyz_Vlon,xyz_Vlat,xyz_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
      ! ڥȥǡ֤.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ, ȯ 
      !
      !      1/rcosաu/ߦ + 1/rcosա(v cos)/ߦ 
      !    + 1/r^2 /r (r^2 w)
      !
      ! ȷ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlon
      !(in) ٥ȥηʬ
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_Div_xyz_xyz_xyz
      !(out) ٥ȥȯ

      wt_Div_xyz_xyz_xyz =   wt_DivLon_xyz(xyz_Vlon) &
                           + wt_DivLat_xyz(xyz_Vlat) &
                           + wt_DivRad_wt(wt_xyz(xyz_Vrad))

    end function wt_Div_xyz_xyz_xyz

    function xyz_Div_xyz_xyz_xyz(xyz_Vlon,xyz_Vlat,xyz_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ.
      !
      ! ˤð򤹤뤿˥٥ȥ cos/r νŤߤ򤫤
      ! ׻Ƥ. 
      !
      !      div V = (r/cos)div (Vcos/r) + V_tan/r + V_r/r
      ! 
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jm,0:km)             :: xyz_Div_xyz_xyz_xyz
      !(out) ٥ȥȯ

      xyz_Div_xyz_xyz_xyz &
           = xyz_Rad/cos(xyz_Lat) &
                * xyz_wt(wt_Div_xyz_xyz_xyz(xyz_VLon*cos(xyz_Lat)/xyz_Rad,  &
                                            xyz_VLat*cos(xyz_Lat)/xyz_Rad,  &
                                            xyz_VRad*cos(xyz_Lat)/xyz_Rad ))&
             + xyz_VLat*tan(xyz_Lat)/xyz_Rad &
             + xyz_VRad/xyz_Rad

    end function xyz_Div_xyz_xyz_xyz

    function xyz_RotLon_wt_wt(wt_Vrad,wt_Vlat) 
      !
      ! ٥ȥưʬ, ʬǤ 1, 2  Vrad, Vlat 
      ! žηʬ 
      !
      !    1/r Vrad/ߦ-1/r (r Vlat)/r ׻.
      !
      ! ׻
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km)                     :: xyz_RotLon_wt_wt
      !(out) ٥ȥβžηʬ

        xyz_RotLon_wt_wt =   xyz_GradLat_wt(wt_Vrad) &
                           - xyz_wt(wt_RotRad_wt(wt_Vlat))

    end function xyz_RotLon_wt_wt

    function xyz_RotLat_wt_wt(wt_Vlon,wt_Vrad) 
      !
      ! ٥ȥηʬ, ưʬǤ 1, 2  Vlon, Vrad 
      ! žΰʬ 
      !
      !    1/r (r Vlon)/r - 1/rcosաVrad/ߦ
      !
      ! ׻.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,1:jm,0:km)                     :: xyz_RotLat_wt_wt
      !(out) ٥ȥβžΰʬ

        xyz_RotLat_wt_wt =   xyz_wt(wt_RotRad_wt(wt_Vlon)) &
                           - xyz_GradLon_wt(wt_Vrad) 

    end function xyz_RotLat_wt_wt

    function wt_RotRad_xyz_xyz(xyz_Vlat,xyz_Vlon) 
      !
      ! ٥ȥΰʬ, ʬǤ 1, 2  Vlat, Vlon Ф
      ! ٥ȥβžưʬ 
      !
      !    1/rcosաVlat/ߦ - 1/rcosա(Vlon cos)/ߦ
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RotRad_xyz_xyz
      !(out) ٥ȥβžưʬ

        wt_RotRad_xyz_xyz =   wt_DivLon_xyz(xyz_Vlat) &
                            - wt_DivLat_xyz(xyz_Vlon)

    end function wt_RotRad_xyz_xyz

  !--------------- ʬ׻ -----------------
    !----(ϥǡ xyz)---
    function yz_IntLon_xyz(xyz)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʬ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm,0:km)  :: yz_IntLon_xyz
      !(out) (Ӿ)ʬ줿 2 Ҹ̳ʻǡ

      integer :: i

      yz_IntLon_xyz = 0.0d0
      do i=0,im-1
         yz_IntLon_xyz(:,:) = yz_IntLon_xyz(:,:) &
                       + xyz(i,:,:) * x_Lon_Weight(i)
      enddo
    end function yz_IntLon_xyz

    function xz_IntLat_xyz(xyz)
      !
      ! 3 ʻǡΰʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) cos d ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,0:km)  :: xz_IntLat_xyz        
      !(out) ʬ줿 2 ư³ʻǡ.
      ! ٱ߳ʻǡ

      integer :: j

      xz_IntLat_xyz = 0.0d0
      do j=1,jm
         xz_IntLat_xyz(:,:) = xz_IntLat_xyz(:,:) &
                       + xyz(:,j,:) * y_Lat_Weight(j)
      enddo
    end function xz_IntLat_xyz

    function xy_IntRad_xyz(xyz)  ! ưʬ
      !
      ! 3 ʻǡưʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jm)  :: xy_IntRad_xyz
      !(out) ưʬ줿 2 ٰ(ʿ, )ʻǡ

      integer :: k

      xy_IntRad_xyz = 0.0d0
      do k=0,km
         xy_IntRad_xyz(:,:) = xy_IntRad_xyz(:,:) &
                       + xyz(:,:,k) * z_Rad_Weight(k) 
      enddo
    end function xy_IntRad_xyz

    function x_IntLatRad_xyz(xyz)
      !
      ! 3 ʻǡΰư(Ҹ)ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRad_xyz
      !(out) ư(Ҹ)ʬ줿 1 ٳʻǡ

      integer :: j, k

      x_IntLatRad_xyz = 0.0D0
      do k=0,km
         do j=1,jm
            x_IntLatRad_xyz = x_IntLatRad_xyz &
                 + xyz(:,j,k) * y_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo
    end function x_IntLatRad_xyz

    function y_IntLonRad_xyz(xyz)
      !
      ! 3 ʻǡηư(ٱ)ʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm)       :: y_IntLonRad_xyz
      !(out) ư(ٱ)ʬ줿 1 ٳʻǡ

      integer :: i, k

      y_IntLonRad_xyz = 0
      do k=0,km
         do i=0,im-1
            y_IntLonRad_xyz = y_IntLonRad_xyz &
                 + xyz(i,:,k) * x_Lon_Weight(i) * z_Rad_Weight(k)
         enddo
      enddo
    end function y_IntLonRad_xyz

    function z_IntLonLat_xyz(xyz)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:km)     :: z_IntLonLat_xyz
      !(out) ٷ(ʿ, )ʬ줿 1 ư³ʻǡ

      integer :: i, j

      z_IntLonLat_xyz = 0
      do j=1,jm
         do i=0,im-1
            z_IntLonLat_xyz = z_IntLonLat_xyz &
                 + xyz(i,j,:) * x_Lon_Weight(i) * y_Lat_Weight(j)
         enddo
      enddo
    end function z_IntLonLat_xyz

    function IntLonLatRad_xyz(xyz) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2cos dddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz 
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: IntLonLatRad_xyz 
      !(out) ʬ

      integer :: i, j, k

      IntLonLatRad_xyz = 0
      do k=0,km
         do j=1,jm
            do i=0,im-1
               IntLonLatRad_xyz = IntLonLatRad_xyz &
                    + xyz(i,j,k) * x_Lon_Weight(i) &
                         * y_Lat_Weight(j) * z_Rad_Weight(k)
            enddo
         enddo
      enddo
    end function IntLonLatRad_xyz

    !----(ϥǡ yz)---
    function z_IntLat_yz(yz)  ! ʬ
      !
      ! 2 (YZ)ʻǡΰʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) cos d ׻.
      !
      real(8), dimension(jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(0:km)  :: z_IntLat_yz
      !(out) ʬ줿 1 ư³ʻǡ

      integer :: j

      z_IntLat_yz = 0.0d0
      do j=1,jm
         z_IntLat_yz(:) = z_IntLat_yz(:) + yz(j,:) * y_Lat_Weight(j)
      enddo
    end function z_IntLat_yz

    function y_IntRad_yz(yz)  ! ưʬ
      !
      ! 2 (YZ)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2dr ׻.
      !
      real(8), dimension(1:jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jm)  :: y_IntRad_yz
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      y_IntRad_yz = 0.0d0
      do k=0,km
         y_IntRad_yz(:) = y_IntRad_yz(:) &
                       + yz(:,k) * z_Rad_Weight(k) 
      enddo
    end function y_IntRad_yz

    function IntLatRad_yz(yz)
      !
      ! 2 (YZ)ʻǡΰưʬ(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2cos ddr ׻.
      !
      real(8), dimension(1:jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: IntLatRad_yz
      !(out) ʬ
      integer :: j, k

      IntLatRad_yz = 0
      do k=0,km
         do j=1,jm
            IntLatRad_yz = IntLatRad_yz &
                 + yz(j,k) * y_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo
    end function IntLatRad_yz

    !----(ϥǡ xz)---
    function z_IntLon_xz(xz)
      !
      ! 2 (XZ)ʻǡηʬ.
      !
      ! 2 ǡ f(,r) Ф f(,r)d ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:km)  :: z_IntLon_xz
      !(out) ʬ줿 1 ư³ʻǡ

      integer :: i

      z_IntLon_xz = 0.0d0
      do i=0,im-1
         z_IntLon_xz(:) = z_IntLon_xz(:) + xz(i,:) * x_Lon_Weight(i)
      enddo

    end function z_IntLon_xz

    function x_IntRad_xz(xz)
      !
      ! 2 (XZ)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:im-1)  :: x_IntRad_xz
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      x_IntRad_xz = 0.0d0
      do k=0,km
         x_IntRad_xz(:) = x_IntRad_xz(:) &
                       + xz(:,k) * z_Rad_Weight(k) 
      enddo

    end function x_IntRad_xz

    function IntLonRad_xz(xz)  ! ư(ٱ)ʬ
      !
      ! 2 (XZ)ʻǡηưʬ
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz
      !(in) 2 ư³ʻǡ

      real(8)                                 :: IntLonRad_xz
      !(out) ʬ

      integer :: i, k

      IntLonRad_xz = 0
      do k=0,km
         do i=0,im-1
            IntLonRad_xz = IntLonRad_xz &
                 + xz(i,k) * x_Lon_Weight(i) * z_Rad_Weight(k)
         enddo
      enddo
    end function IntLonRad_xz

    !----(ϥǡ z)---
    function IntRad_z(z)  ! ưʬ
      !
      ! 1 (Z)ʻǡưʬ.
      !
      ! 1 ǡ f(r) Ф f(r) r^2dr ׻.
      !
      real(8), dimension(0:km), intent(in) :: z
      !(in) 1 ư³ʻǡ

      real(8)                              :: IntRad_z
      !(out) ʬ

      integer :: k

      IntRad_z = 0.0d0
      do k=0,km
         IntRad_z = IntRad_z + z(k) * z_Rad_Weight(k) 
      enddo
    end function IntRad_z

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ xyz)---
    function yz_AvrLon_xyz(xyz)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm,0:km)  :: yz_AvrLon_xyz
      !(out) (Ӿ)ʿѤ줿 2 Ҹ̳ʻǡ

      yz_AvrLon_xyz = yz_IntLon_xyz(xyz)/sum(x_Lon_Weight)

    end function yz_AvrLon_xyz

    function xz_AvrLat_xyz(xyz)  ! ʬ
      !
      ! 3 ʻǡΰʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)cos d/2 ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,0:km)  :: xz_AvrLat_xyz
      !(out) ʿѤ줿 2 ư³ʻǡ

      xz_AvrLat_xyz = xz_IntLat_xyz(xyz)/sum(y_Lat_Weight)

    end function xz_AvrLat_xyz

    function xy_AvrRad_xyz(xyz)
      !
      ! 3 ʻǡưʿ.
      !
      ! 3 ǡ f(,,r) Ф 
      !
      !    f(,,r) r^2dr/((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,1:jm)  :: xy_AvrRad_xyz          
      !(out) ưʿѤ줿 2 ٰ(ʿ, )ʻǡ
      ! ʿʻǡ

      xy_AvrRad_xyz = xy_IntRad_xyz(xyz)/sum(z_Rad_Weight)

    end function xy_AvrRad_xyz

    function x_AvrLatRad_xyz(xyz)  ! ư(Ҹ)ʬ
      !
      ! 3 ʻǡΰư(Ҹ)ʿ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_AvrLatRad_xyz
      !(out) ư(Ҹ)ʿѤ줿 1 ٳʻǡ

      x_AvrLatRad_xyz = x_IntLatRad_xyz(xyz) &
                   /( sum(y_Lat_Weight)*sum(z_Rad_Weight) )

    end function x_AvrLatRad_xyz

    function y_AvrLonRad_xyz(xyz)  ! ư(ٱ)ʬ
      !
      ! 3 ʻǡηư(ٱ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(1:jm)       :: y_AvrLonRad_xyz
      !(out) ư(ٱ)ʿѤ줿 1 ٳʻǡ

      y_AvrLonRad_xyz = y_IntLonRad_xyz(xyz) &
                 /(sum(x_Lon_Weight)*sum(z_Rad_Weight))

    end function y_AvrLonRad_xyz

    function z_AvrLonLat_xyz(xyz)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd /4 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:km)     :: z_AvrLonLat_xyz
      !(out) ٷ(ʿ, )ʿѤ줿 1 ư³ʻǡ

      z_AvrLonLat_xyz = z_IntLonLat_xyz(xyz) &
                 /(sum(x_Lon_Weight)*sum(y_Lat_Weight))

    end function z_AvrLonLat_xyz

    function AvrLonLatRad_xyz(xyz) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos dddr /(4(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: AvrLonLatRad_xyz
      !(out) ʿ

      AvrLonLatRad_xyz = IntLonLatRad_xyz(xyz) &
            /(sum(x_Lon_Weight)*sum(y_Lat_Weight) * sum(z_Rad_Weight))

    end function AvrLonLatRad_xyz

    !----(ϥǡ yz)---
    function z_AvrLat_yz(yz)
      !
      ! 2 (YZ)ʻǡΰʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) cos d/2 ׻.
      !
      real(8), dimension(1:jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(0:km)  :: z_AvrLat_yz
      !(out) ʿѤ줿 1 ư³ʻǡ

      z_AvrLat_yz = z_IntLat_yz(yz)/sum(y_Lat_Weight)

    end function z_AvrLat_yz

    function y_AvrRad_yz(yz)
      !
      ! 2 (YZ)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(1:jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(1:jm)  :: y_AvrRad_yz
      !(out) ưʿѤ줿 1 ٳʻǡ

      y_AvrRad_yz = y_IntRad_yz(yz)/sum(z_Rad_Weight)

    end function y_AvrRad_yz

    function AvrLatRad_yz(yz)  ! ư(Ҹ)ʬ
      !
      ! 2 (YZ)ʻǡΰư(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф
      !
      !    f(,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3)
      !
      ! ׻.
      !
      real(8), dimension(1:jm,0:km), intent(in) :: yz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: AvrLatRad_yz
      !(out) ʿ

      AvrLatRad_yz = IntLatRad_yz(yz)/(sum(y_Lat_Weight)*sum(z_Rad_Weight))

    end function AvrLatRad_yz

    !----(ϥǡ xz)---
    function z_AvrLon_xz(xz)  ! (Ӿ)ʬ
      !
      ! 2 (XZ)ʻǡηʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:km)  :: z_AvrLon_xz 
      !(out) ʿѤ줿 1 ư³ʻǡ

      z_AvrLon_xz = z_IntLon_xz(xz)/sum(x_Lon_Weight)

    end function z_AvrLon_xz

    function x_AvrRad_xz(xz)  ! ưʬ
      !
      ! 2 (XZ)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф
      !
      !   f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz
      !(in) 2 ư³ʻǡ

      real(8), dimension(0:im-1)  :: x_AvrRad_xz
      !(out) ưʿѤ줿 1 ٳʻǡ

      x_AvrRad_xz = x_IntRad_xz(xz)/sum(z_Rad_Weight)

    end function x_AvrRad_xz

    function AvrLonRad_xz(xz)  ! ư(ٱ)ʬ
      !
      ! 2 (XZ)ʻǡηưʿ
      !
      ! 2 ǡ f(,r) Ф 
      ! 
      !    f(,r) r^2ddr /(2(r[o]^3-r[i]^3)/3)
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,0:km), intent(in) :: xz    
      ! (in) 2 ʻǡ
      real(8)                                 :: AvrLonRad_xz      
      ! ʬ

      AvrLonRad_xz = IntLonRad_xz(xz)/(sum(x_Lon_Weight)*sum(z_Rad_Weight))

    end function AvrLonRad_xz

    !----(ϥǡ z)---
    function AvrRad_z(z)
      !
      ! 1 (Z)ʻǡưʿ.
      !
      ! 1 ǡ f(r) Ф f(r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(0:km), intent(in) :: z
      !(in) 1 ư³ʻǡ
      real(8)                              :: AvrRad_z
      !(out) ʿ

      AvrRad_z = IntRad_z(z)/sum(z_Rad_Weight)

    end function AvrRad_z

  !--------------- ݥ/ȥǥʬ -----------------

    function wt_KxRGrad_wt(wt)
      !
      ! ϥڥȥǡ˷ʬ kr = /ߦˤѤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_KxRGrad_wt
      !(out) ʬѤ줿 2 ڥȥǡ

      wt_KxRGrad_wt =  wa_Dlon_wa(wt)

    end function wt_KxRGrad_wt

    function xyz_KGrad_wt(wt)    ! k = cos/r /ߦ + sinբ/r
      !
      ! ϥڥȥǡбʻҥǡ˼ʬ 
      !
      !    k = cos/r /ߦ + sinբ/r 
      !
      ! Ѥʻҥǡ֤. 
      ! ǥ٥ȥ k ϵ濴̶˸ñ̥٥ȥǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,1:jm,0:km)                     :: xyz_KGrad_wt
      !(out) ʬѤ줿 2 ڥȥǡ

      xyz_KGrad_wt =  cos(xyz_Lat)*xyz_GradLat_wt(wt) &
                    + sin(xyz_Lat)*xyz_wt(wt_Drad_wt(wt))

    end function xyz_KGrad_wt

    function wt_L2_wt(wt)
      !
      ! ϥڥȥǡ L^2 黻(=-ʿץ饷)Ѥ.
      !
      ! L^2 黻Ҥñ̵̾οʿץ饷εˤ. 
      !  ϥڥȥ бʻǡ˱黻 
      !
      !     L^2 = -1/cos^2ա^2/ߦ^2 - 1/cosա/ߦ(cosբ/ߦ)
      !
      ! ѤǡΥڥȥѴ֤.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_L2_wt
      !(out) L^2 黻ҤѤ줿 2 ڥȥǡ

      wt_L2_wt = -wa_Lapla_wa(wt)

    end function wt_L2_wt

    function wt_L2Inv_wt(wt)
      !
      ! ϥڥȥǡ L^2 黻Ҥεձ黻(-տʿץ饷)
      ! Ѥ.
      !
      ! ڥȥǡ L^2 黻ҤѤؿ wt_L2_wt εշ׻
      ! ԤؿǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_L2Inv_wt
      !(out) L^2 黻Ҥεձ黻Ѥ줿 2 ڥȥǡ

      wt_L2Inv_wt = -wa_LaplaInv_wa(wt)

    end function wt_L2Inv_wt

    function wt_QOperator_wt(wt)
      !
      ! ϥڥȥǡбʻǡ˱黻 
      !
      !    Q=(k-1/2(L2 k+ kL2)) 
      !
      ! ѤǡΥڥȥѴ֤.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_QOperator_wt
      !(out) Q 黻ҤѤ줿 2 ڥȥǡ

      wt_QOperator_wt = &
             wt_xyz(xyz_KGrad_wt(wt) - xyz_KGrad_wt(wt_L2_wt(wt))/2) &
           - wt_L2_wt(wt_xyz(xyz_KGrad_wt(wt)))/2

    end function wt_QOperator_wt

    function wt_RadRot_xyz_xyz(xyz_VLON,xyz_VLAT)  ! r(v)
      !
      ! ٥ȥα٤ư¥٥ȥ r(v) ׻.
      !
      !  1, 2 (v[], v[])줾٥ȥηʬ, ʬɽ.
      !
      !    r(v) = 1/cosաv[]/ߦ - 1/cosա(v[] cos)/ߦ
      !
      ! Υڥȥ ǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRot_xyz_xyz
      !(out) ٥ȥα٤ư¥٥ȥ

      wt_RadRot_xyz_xyz = wt_wz(wa_DivLon_xya(xyz_VLAT) &
                                - wa_DivLat_xya(xyz_VLON))
      
    end function wt_RadRot_xyz_xyz

    function wt_RadRotRot_xyz_xyz_xyz(xyz_VLON,xyz_VLAT,xyz_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(in) :: xyz_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRotRot_xyz_xyz_xyz
      !(out) ٥ȥ v  r(ߢv) 

      wt_RadRotRot_xyz_xyz_xyz = &
               wt_RotRad_wt(wt_wz( &
                   (wa_DivLon_xya(xyz_VLON)+ wa_DivLat_xya(xyz_VLAT)))) &
             + wt_L2_wt(wt_xyz(xyz_VRAD/xyz_RAD))

    end function wt_RadRotRot_xyz_xyz_xyz

    subroutine wt_Potential2Vector(&
         xyz_VLON,xyz_VLAT,xyz_VRAD,wt_TORPOT,wt_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! γʬ׻
      !
      real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_VLON
      !(out) ٥ȥηʬ

      real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_VLAT
      !(out) ٥ȥΰʬ

      real(8), dimension(0:im-1,1:jm,0:km)     :: xyz_VRAD
      !(out) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      xyz_VLON =   xyz_RAD * xyz_GradLat_wt(wt_TORPOT) &
                 + xya_GradLon_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xyz_VLAT = - xyz_RAD * xyz_GradLon_wt(wt_TORPOT) &
                 + xya_GradLat_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xyz_VRAD = xyz_wt(wt_L2_wt(wt_POLPOT))/xyz_RAD

    end subroutine wt_Potential2Vector

    subroutine wt_Potential2Rotation(&
       xyz_RotVLON,xyz_RotVLAT,xyz_RotVRAD,wt_TORPOT,wt_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! Ф, βž
      !
      !     xv = xx(r) + xxx(r) = xx(r) - x((^2)r)
      !
      ! ׻. 
      
      ! ٥ȥβž
      real(8), dimension(0:im-1,1:jm,0:km), intent(OUT) :: xyz_RotVLON
      !(out) žηʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(OUT) :: xyz_RotVLAT
      !(out) žΰʬ

      real(8), dimension(0:im-1,1:jm,0:km), intent(OUT) :: xyz_RotVRAD
      !(out) žưʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      call wt_Potential2Vector( &
           xyz_RotVLON,xyz_RotVLAT,xyz_RotVRAD, &
           -wt_Lapla_wt(wt_POLPOT), wt_TORPOT)

    end subroutine wt_Potential2Rotation

 !------------------- ׻ ----------------------
    subroutine wt_VGradV(xyz_VGRADV_LON,xyz_VGRADV_LAT,xyz_VGRADV_RAD, &
                          xyz_VLON,xyz_VLAT,xyz_VRAD )
      !
      ! ٥ȥ vv ׻.
      !
      ! ٥ȥ v=(v[],v[],v[r]) Фvvγʬ
      ! Τ褦˷׻.
      !
      !   (vv)[] = (v[]v) + v[]v[r]/r - v[]v[]tan()/r
      !   (vv)[] = (v[]v) + v[]v[r]/r - v[]^2tan()/r
      !   (vv)[r] = (v[r]v) + (v[]^2+v[]^2)/r
      !
      ! ȯ®پФƤϥݥƥ󥷥뤫 wt_Potential2Rotation 
      ! ѤƲž׻,  vv = (v[2^/2) - vxxv 
      ! Ѥ褤.
      !
      real(8), dimension(0:im-1,1:jm,0:km),intent(out)   :: xyz_VGRADV_LON
      !(out) (vv) ʬ

      real(8), dimension(0:im-1,1:jm,0:km),intent(out)   :: xyz_VGRADV_LAT
      !(out) (vv) ʬ

      real(8), dimension(0:im-1,1:jm,0:km),intent(out)   :: xyz_VGRADV_RAD
      !(out) (vv) ưʬ

      real(8), dimension(0:im-1,1:jm,0:km),intent(in)    :: xyz_VLON
      !(in) ٥ȥ v ηʬ

      real(8), dimension(0:im-1,1:jm,0:km),intent(in)    :: xyz_VLAT
      !(in) ٥ȥ v ΰʬ

      real(8), dimension(0:im-1,1:jm,0:km),intent(in)    :: xyz_VRAD
      !(in) ٥ȥ v ưʬ

      xyz_VGRADV_LON = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VLON * xyz_VLON, xyz_VLON*xyz_VLAT, xyz_VLON*xyz_VRAD ) &
            + xyz_VLON*xyz_VRAD/xyz_RAD              &
            - xyz_VLON*xyz_VLAT*tan(xyz_LAT)/xyz_RAD 

      xyz_VGRADV_LAT = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VLAT*xyz_VLON, xyz_VLAT*xyz_VLAT, xyz_VLAT*xyz_VRAD ) &
            + xyz_VLAT*xyz_VRAD/xyz_RAD        &
            + xyz_VLON**2*tan(xyz_LAT)/xyz_RAD 

      xyz_VGRADV_RAD = &
              xyz_Div_xyz_xyz_xyz( &
                  xyz_VRAD*xyz_VLON, xyz_VRAD*xyz_VLAT, xyz_VRAD*xyz_VRAD ) &
            - (xyz_VLON**2 + xyz_VLAT**2)/xyz_RAD 

    end subroutine wt_VGradV

  !--------------- ַ׻ -----------------
    function Interpolate_wt(wt_data,alon,alat,arad)
      !
      !  alon,  alat ư arad ˤؿͤ
      ! εĴѴ wa_data ַ׻
      !
      real(8), intent(IN) :: wt_data((nm+1)**2,0:km)  ! ڥȥǡ
      real(8), intent(IN) :: alon                     ! ֤()
      real(8), intent(IN) :: alat                     ! ֤()
      real(8), intent(IN) :: arad                     ! ֤(ư)
      real(8) :: Interpolate_wt                       ! ֤
      
      Interpolate_wt = &
           Interpolate_w(a_Interpolate_at(wt_data,arad),alon,alat)

    end function Interpolate_wt

  !--------------- ݥ/ȥǥѥڥȥ ----------------

    function nmz_ToroidalEnergySpectrum_wt(wt_TORPOT)
      !
      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
      ! Ĵȡȿ n, Ӿȿ m γʬ׻
      !
      !  * ȿ n, Ӿȿ m Υȥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n, Ӿȿ m ʬΥȥ륨ͥ륮
      !    ڥȥ  (1/2)n(n+1)4r^2|(n,m,r)|^2  ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !    
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    wt_VMiss ˤäǤ (ͤ -999.0)
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,-nm:nm,0:km) :: nmz_ToroidalEnergySpectrum_wt
      !(out) ͥ륮ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA   ! ΰ
      integer :: n, m

      nmz_ToroidalEnergySpectrum_wt = wt_VMiss

      wz_DATA = wz_wt(wt_TORPOT)
      do n=0,nm
         nmz_ToroidalEnergySpectrum_wt(n,0,:) &
              = 0.5 * n*(n+1)* (4*pi) * z_Rad**2 &
                * wz_DATA(l_nm(n,0),:)**2
         do m=1,n
            nmz_ToroidalEnergySpectrum_wt(n,m,:) &
              = 0.5 * n*(n+1)* (4*pi) * z_Rad**2 &
                * (wz_DATA(l_nm(n,m),:)**2+wz_DATA(l_nm(n,-m),:)**2)
            nmz_ToroidalEnergySpectrum_wt(n,-m,:) &
                 = nmz_ToroidalEnergySpectrum_wt(n,m,:) 
         enddo
      enddo

    end function nmz_ToroidalEnergySpectrum_wt

    function nz_ToroidalEnergySpectrum_wt(wt_TORPOT)
      !
      ! ȥݥƥ󥷥뤫, ȥ륨ͥ륮
      ! Ĵȡȿγʬ׻.
      !
      !  * ȿ n, Ӿȿ m Υȥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n ʬΥȥ륨ͥ륮ڥȥ
      !    [m=-n]^n(1/2)n(n+1)4r^2|(n,m,r)|^2 ȷ׻.
      !
      ! * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension(0:nm,0:km) :: nz_ToroidalEnergySpectrum_wt 
      !(out) ͥ륮ڥȥȥʬ

      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA   ! ΰ
      integer :: n, m

      wz_DATA = wz_wt(wt_TORPOT)
      do n=0,nm
         nz_ToroidalEnergySpectrum_wt(n,:) &
              = 0.5 * n*(n+1)* (4*pi) * z_Rad**2 * wz_Data(l_nm(n,0),:)**2
         do m=1,n
            nz_ToroidalEnergySpectrum_wt(n,:) &
                 = nz_ToroidalEnergySpectrum_wt(n,:) &
                 + 0.5 * n*(n+1)* (4*pi) * z_Rad**2  &
                 * 2* (wz_Data(l_nm(n,m),:)**2 + wz_Data(l_nm(n,-m),:)**2)
         enddo
      enddo

    end function nz_ToroidalEnergySpectrum_wt

    function nmz_PoloidalEnergySpectrum_wt(wt_POLPOT)
      !
      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
      ! Ĵȡȿ n, Ӿȿ m γʬ׻.
      !
      !  * ȿ n, Ӿȿ m Υݥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n, Ӿȿ m ʬΥݥ륨ͥ륮
      !    ڥȥ 
      !
      !      (1/2)n(n+1)4{|d(r(n,m,r))/dr|^2 + n(n+1)|(n,m,r)|^2} 
      !
      !    ȷ׻.
      !
      !  * ƤΥͥ륮ڥȥʬ¤ưʬ(r^2νŤ̵)
      !    Ǥͥ륮.
      !
      !  * ǡ¸ߤʤȿ n, Ӿȿ m ˤϷ»ͤǼ.
      !    »ͤͤϥ⥸塼ѿ wt_VMiss ˤäǤ
      !    (ͤ -999.0)
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      real(8), dimension(0:nm,-nm:nm,0:km) :: nmz_PoloidalEnergySpectrum_wt 
      !(out) ͥ륮ڥȥݥʬ


      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA2   ! ΰ
      integer :: n, m

      nmz_PoloidalEnergySpectrum_wt = wt_VMiss

      wz_Data1 = wz_wt(wt_POLPOT)
      wz_Data2 = wz_Rad*wz_wt(wt_DRad_wt(wt_POLPOT)) &    ! d(r)/dr
               + wz_wt(wt_POLPOT)                         ! = rd/dr+

      do n=0,nm
         nmz_PoloidalEnergySpectrum_wt(n,0,:) = &
                 + 0.5* n*(n+1)* (4*pi) &
                 *( wz_Data2(l_nm(n,0),:)**2  &
                   + n*(n+1)*wz_Data1(l_nm(n,0),:)**2 )
         do m=1,n
            nmz_PoloidalEnergySpectrum_wt(n,m,:) = &
                 + 0.5* n*(n+1)* (4*pi) &
                 *( wz_Data2(l_nm(n,m),:)**2 + wz_Data2(l_nm(n,-m),:)**2 &
                 + n*(n+1)* ( wz_Data1(l_nm(n,m),:)**2 + wz_Data1(l_nm(n,-m),:)**2))
            nmz_PoloidalEnergySpectrum_wt(n,-m,:) = &
                 nmz_PoloidalEnergySpectrum_wt(n,m,:)
         enddo
      enddo

    end function nmz_PoloidalEnergySpectrum_wt

    function nz_PoloidalEnergySpectrum_wt(wt_POLPOT)
      !
      ! ݥݥƥ󥷥뤫, ݥ륨ͥ륮
      ! Ĵȡȿγʬ׻
      !
      !  * ȿ n, Ӿȿ m Υݥݥƥ󥷥Υڥȥʬ
      !    (n,m,r)ȿ n ʬΥݥ륨ͥ륮ڥȥ
      !
      !      [m=-n]^n ((1/2)n(n+1)4{|d(r(n,m,r))/dr|^2 
      !                 + n(n+1)|(n,m,r)|^2} 
      !
      !    ȷ׻.
      !
      !  * ƤȿФƤΥͥ륮ڥȥʬ¤ưʬ
      !    (r^2νŤ̵)Ǥͥ륮.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      real(8), dimension(0:nm,0:km) :: nz_PoloidalEnergySpectrum_wt
      !(out) ͥ륮ڥȥݥʬ

      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA1   ! ΰ
      real(8), dimension((nm+1)*(nm+1),0:km) ::wz_DATA2   ! ΰ
      integer :: n, m

      wz_Data1 = wz_wt(wt_POLPOT)
      wz_Data2 = wz_Rad*wz_wt(wt_DRad_wt(wt_POLPOT)) &    ! d(r)/dr
               + wz_wt(wt_POLPOT)                         ! = rd/dr+

      do n=0,nm
         nz_PoloidalEnergySpectrum_wt(n,:) &
              = 0.5* n*(n+1)* (4*pi) &
              *( wz_Data2(l_nm(n,0),:)**2  + n*(n+1)*wz_Data1(l_nm(n,0),:)**2 )
         do m=1,n
            nz_PoloidalEnergySpectrum_wt(n,:) &
                 = nz_PoloidalEnergySpectrum_wt(n,:) &
                 + 2 * 0.5* n*(n+1)* (4*pi) &
                 *( wz_Data2(l_nm(n,m),:)**2 + wz_Data2(l_nm(n,-m),:)**2 &
                 + n*(n+1)*(wz_Data1(l_nm(n,m),:)**2 +wz_Data1(l_nm(n,-m),:)**2))
         enddo
      enddo

    end function nz_PoloidalEnergySpectrum_wt


  !---------------  -----------------

    subroutine wt_BoundariesTau(wt,values,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! Chebyshev ֤ǤζŬ(ˡ)
      !
      ! ӥն֤ˤƶ٤⼡η
      ! ˡȤäƤ(ˡ).
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ. 
              !     ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              !(in) . ά 'DD'
              !        DD : ξüǥꥯ
              !        DN : üǥꥯ, üΥޥ
              !        ND : üΥޥ, üǥꥯ
              !        NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_BoundariesTau_DD(wt,values)
         else
            call at_BoundariesTau_DD(wt)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesTau_NN(wt,values)
         else
            call at_BoundariesTau_NN(wt)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesTau_DN(wt,values)
         else
            call at_BoundariesTau_DN(wt)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesTau_ND(wt,values)
         else
            call at_BoundariesTau_ND(wt)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesTau_DD(wt,values)
         else
            call at_BoundariesTau_DD(wt)
         endif
      case default
         call MessageNotify('E','wt_BoundariesTau','B.C. not supported')
      end select

    end subroutine wt_BoundariesTau

    subroutine wt_BoundariesGrid(wt,values,cond)
      !
      ! ڥȥǡ˥ǥꥯ졦Υޥ󶭳ŬѤ
      ! ¶֤ǤζŬ
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ 
      ! wt_Initial ˤꤹӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              !(in) Ǥ / ʬۤʿڥȥѴΤͿ. 
              !    ά/ 0 Ȥʤ. 

      character(len=2), intent(in), optional             :: cond
              !(in) . ά 'DD'
              !        DD : ξüǥꥯ
              !        DN : üǥꥯ, üΥޥ
              !        ND : üΥޥ, üǥꥯ
              !        NN : ξüΥޥ

      if (.not. present(cond)) then
         if (present(values)) then
            call at_boundariesGrid_DD(wt,values)
         else
            call at_boundariesGrid_DD(wt)
         endif
         return
      endif

      select case(cond)
      case ('NN')
         if (present(values)) then
            call at_BoundariesGrid_NN(wt,values)
         else
            call at_BoundariesGrid_NN(wt)
         endif
      case ('DN')
         if (present(values)) then
            call at_BoundariesGrid_DN(wt,values)
         else
            call at_BoundariesGrid_DN(wt)
         endif
      case ('ND')
         if (present(values)) then
            call at_BoundariesGrid_ND(wt,values)
         else
            call at_BoundariesGrid_ND(wt)
         endif
      case ('DD')
         if (present(values)) then
            call at_BoundariesGrid_DD(wt,values)
         else
            call at_BoundariesGrid_DD(wt)
         endif
      case default
         call MessageNotify('E','wt_BoundariesGrid','B.C. not supported')
      end select

    end subroutine wt_BoundariesGrid

    subroutine wt_TorBoundariesTau(wt_TORPOT,values,cond,new) 
      !
      ! ®٥ȥݥƥ󥷥ФƶŬѤ. 
      ! Chebyshev ֤ǤζŬ. 
      !
      ! ®٥ȥݥƥ󥷥릷ФͿ붭
      !
      !   * Ǵ :  = b(lon,lat). b ϶̤Ǥ®ʬ. 
      !                                   default  0(Ż߾).
      !
      !   * Ϥʤ : (/r)/r = 0.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt_TORPOT
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              !(in) ξüǤΥȥݥƥ󥷥
              !     ǴλΤͭ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:), allocatable  :: alu
      integer, dimension(:), allocatable    :: kp
      real(8), dimension(0:lm,0:lm)         :: tt_data
      real(8), dimension(0:lm,0:km)         :: tg_data
      logical                               :: rigid1, rigid2   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_TorBoundariesTau','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu(0:lm,0:lm),kp(0:lm))

         tt_data = 0.0D0
         do l=0,lm
            tt_data(l,l)=1
         enddo
         alu = tt_data

         ! ϳŪǴ 
         if ( rigid1 ) then
            tg_data = az_at(tt_data)
         else
            tg_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(lm-1,:) = tg_data(:,0)       !  k=0 ǤξＰ

         if ( rigid2 ) then
            tg_data = az_at(tt_data)    
         else
            tg_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(lm,:)   = tg_data(:,km)      !  k=km ǤξＰ

         call ludecomp(alu,kp)

         if ( rigid1 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid1 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid1) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesTau',&
                 'Boundary value k=0 cannot be set under stress-free condition.')
         endif

         if ( rigid2 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid2 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesTau',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid2) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesTau',&
                 'Boundary value k=0 cannot be set under stress-free condition.')
         endif

         call MessageNotify('M','wt_TorBoundariesTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      if ( rigid1 .AND. present(values) ) then
         wt_torpot(:,lm-1) = values(:,1)
      else
         wt_torpot(:,lm-1) = 0.0D0
      endif
      if ( rigid2 .AND. present(values) ) then
         wt_torpot(:,lm)   = values(:,2)
      else
         wt_torpot(:,lm) = 0.0D0
      endif

      wt_torpot = lusolve(alu,kp,wt_TORPOT)

    end subroutine wt_TorBoundariesTau

    subroutine wt_TorBoundariesGrid(wt_TORPOT,values,cond,new) 
      !
      ! ®٥ȥݥƥ󥷥ФƶŬѤ.
      ! ¶֤ǤζŬ
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ 
      ! wt_Initial ˤꤹӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ. 
      !
      ! ®٥ȥݥƥ󥷥릷ФͿ붭
      !
      !   * Ǵ :  = b(lon,lat). b ϶̤Ǥ®ʬ. 
      !                                   default  0 (Ż߾).
      !
      !   * Ϥʤ : (/r)/r = 0.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)      :: wt_TORPOT
              !(inout) ŬѤǡ. 줿֤ͤ. 

      real(8), dimension((nm+1)*(nm+1),2), intent(in), optional :: values
              !(in) ξüǤΥȥݥƥ󥷥
              !     ǴλΤͭ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension((nm+1)*(nm+1),0:km):: wz_TORPOT
      real(8), dimension(:,:), allocatable  :: alu
      integer, dimension(:), allocatable    :: kp
      real(8), dimension(0:lm,0:lm)         :: tt_data
      real(8), dimension(0:lm,0:km)         :: tz_data
      logical                               :: rigid1, rigid2   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_TorBoundariesGrid','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','TorBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu(0:km,0:lm),kp(0:lm))

         tt_data = 0.0D0
         do l=0,lm
            tt_data(l,l)=1.0D0
         enddo
         tz_data = az_at(tt_data)
         alu = transpose(tz_data)       ! ΰǤͤϤΤޤ

         if ( rigid1 ) then
            tz_data = az_at(tt_data)
         else
            tz_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(0,:) = tz_data(:,0)        !  k=0 ǤξＰ

         if ( rigid2 ) then
            tz_data = az_at(tt_data)
         else
            tz_data = az_at(at_dr_at(at_az( &
                 az_at(tt_data)/spread(z_rad,1,lm+1))))
         endif
         alu(km,:)   = tz_data(:,km)    !  k=km ǤξＰ

         call ludecomp(alu,kp)

         if ( rigid1 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=0 was given by the optional variable.')
         else if ( rigid1 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=0 was set to zero.')
         else if ( (.NOT. rigid1) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesGrid',&
                 'Boundary value at k=0 cannot be set under stress-free condition.')
         endif

         if ( rigid2 .AND. present(values) ) then 
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=km was given by the optional variable.')
         else if ( rigid2 .AND. (.NOT.present(values)) ) then
            call MessageNotify('M','wt_TorBoundariesGrid',&
                 'Toroidal potential at k=km was set to zero.')
         else if ( (.NOT. rigid2) .AND. present(values) ) then
            call MessageNotify('W','wt_TorBoundariesGrid',&
                 'Boundary value at k=km cannot be set under stress-free condition.')
         endif

         call MessageNotify('M','wt_TorBoundariesGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wz_TorPot       = wz_wt(wt_TorPot)

      if ( rigid1 .AND. present(values) ) then
         wz_TorPot(:,0)  = values(:,1)
      else
         wz_TorPot(:,0)  = 0.0D0
      endif

      if ( rigid2 .AND. present(values) ) then
         wz_TorPot(:,km) = values(:,2)
      else
         wz_TorPot(:,km) = 0.0D0
      endif

      wt_torpot = lusolve(alu,kp,wz_TorPot)

    end subroutine wt_TorBoundariesGrid

    function wz_LaplaPol2Pol_wz(wz,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      !
      ! ӥճʻ֤ǶŬѤƤ. 
      ! δؿѤ뤿ˤ wt_Initial ˤꤹ
      ! ӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ. 
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !   ^2 = f
      !      = const. at boundaries.
      !     ߦ/r = 0 at boundaries           (Ǵ) 
      !     or ^2/r^2 = 0 at boundaries    (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:km),intent(in)  :: wz
              !(in) Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_LaplaPol2Pol_wz
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_work
      real(8), dimension(0:km,0:km)           :: gg
      real(8), dimension(0:km,0:km)           :: gg_work
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: k,n
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_laplapol2pol_wt','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','wz_LaplaPol2Pol_wz', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((nm+1)*(nm+1),0:km,0:km),kp((nm+1)*(nm+1),0:km))

         do k=0,km
            wz_work = 0.0D0 ; wz_work(:,k) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,k) = wz_wt(wt_lapla_wt(wt_wz(wz_work)))
         enddo

         ! ưŪ. ή϶ǰ
         gg = 0.0D0
         do k=0,km
            gg(k,k)=1.0D0
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,0,:)   = gg(:,0)
            alu(n,km,:)  = gg(:,km)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            gg_work=az_at(at_dr_at(at_az(gg)))
         else
            gg_work=az_at(at_dr_at(at_dr_at(at_az(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,1,:) = gg_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            gg_work=az_at(at_dr_at(at_az(gg)))
         else
            gg_work=az_at(at_dr_at(at_dr_at(at_az(gg))))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,km-1,:) = gg_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','wz_LaplaPol2Pol_wz',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wz_work         = wz
      wz_work(:,1)    = 0.0D0               ! ϳŪ
      wz_work(:,km-1) = 0.0D0               ! ϳŪ
      wz_work(:,0)    = 0.0D0               ! ưŪ
      wz_work(:,km)   = 0.0D0               ! ưŪ 

      wz_laplapol2pol_wz = lusolve(alu,kp,wz_work)

    end function wz_LaplaPol2Pol_wz

    function wt_LaplaPol2PolGrid_wt(wt,cond,new)
      !
      ! ®٥ݥݥƥ󥷥릵^2׻.
      ! ӥճʻ֤ǶŬѤƤ. 
      !
      ! δؿѤ뤿ˤ wt_Initial ˤꤹ
      ! ӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ. 
      !
      ! ®٥ݥݥƥ󥷥릵 f = ^2뼰
      !
      !    ^2 = f
      !       = const. at boundaries.
      !      ߦ/r = 0 at boundaries          (Ǵ) 
      !      or ^2/r^2 = 0 at boundaries   (Ϥʤ)
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      ! ǽŪ˥ӥշβߤˤ, wz_LaplaPol2Pol_wz 
      ! ٤ƥӥ -- ʻѴ 1 ʬʤƺѤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(in)  :: wt
              !(in) Ϣ^2ʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_LaplaPol2PolGrid_wt
              !(out) ϥݥݥƥ󥷥ʬ

      character(len=2), intent(in), optional  :: cond
              !(in) 凉å. ά 'RR'
              !     RR    : ξüǴ
              !     RF    : üǴ, üϤʤ
              !     FR    : üϤʤ, üǴ
              !     FF    : ξüϤʤ

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_work
      real(8), dimension((nm+1)*(nm+1),0:lm)  :: wt_work
      real(8), dimension(0:lm,0:lm)           :: tt_I
      real(8), dimension(0:lm,0:km)           :: tz_work
      logical                                 :: rigid1, rigid2   ! 

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer :: l,n
      save    :: alu, kp, first

      if (.not. present(cond)) then
         rigid1=.TRUE. ; rigid2=.TRUE.
      else
         select case (cond)
         case ('RR')
            rigid1 = .TRUE.  ; rigid2 = .TRUE.
         case ('RF')
            rigid1 = .TRUE.  ; rigid2 = .FALSE.
         case ('FR')
            rigid1 = .FALSE. ; rigid2 = .TRUE.
         case ('FF')
            rigid1 = .FALSE. ; rigid2 = .FALSE.
         case default
            call MessageNotify('E','wt_LaplaPol2PolGrid_wt','B.C. not supported')
         end select
      endif

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','wt_LaplaPol2PolGrid_wt', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         allocate(alu((nm+1)*(nm+1),0:km,0:lm),kp((nm+1)*(nm+1),0:lm))

         do l=0,lm
            wt_work = 0.0D0 ; wt_work(:,l) = 1.0D0

            ! ƿʿȿ˴ؤΩμ
            alu(:,:,l) = wz_wt(wt_Lapla_wt(wt_work))
         enddo

         ! ưŪ. ή϶ǰ
         tt_I = 0.0D0
         do l=0,lm
            tt_I(l,l)=1.0D0
         enddo

         ! ŵƳ
         tz_work = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,0,:)  = tz_work(:,0)
            alu(n,km,:) = tz_work(:,km)
         enddo

         ! ϳŪǴ 
         if ( rigid1 ) then
            tz_work=az_at(at_Dr_at(tt_I))
         else
            tz_work=az_at(at_Dr_at(at_Dr_at(tt_I)))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,1,:) = tz_work(:,0)
         enddo

         ! ϳŪǴ 
         if ( rigid2 ) then
            tz_work=az_at(at_Dr_at(tt_I))
         else
            tz_work=az_at(at_Dr_at(at_Dr_at(tt_I)))
         endif
         do n=1,(nm+1)*(nm+1)
            alu(n,km-1,:) = tz_work(:,km)
         enddo

         call ludecomp(alu,kp)

         call MessageNotify('M','wt_LaplaPol2PolGrid_wt',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wz_work         = wz_wt(wt)
      wz_work(:,1)    = 0.0D0               ! ϳŪ
      wz_work(:,km-1) = 0.0D0               ! ϳŪ
      wz_work(:,0)    = 0.0D0               ! ưŪ
      wz_work(:,km)   = 0.0D0               ! ưŪ 

      wt_LaplaPol2PolGrid_wt = lusolve(alu,kp,wz_work)

    end function wt_LaplaPol2PolGrid_wt

    subroutine wt_TormagBoundariesTau(wt_TOR,new)
      
      ! ȥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    wt_psi = 0   at the outer boundary
      ! ¦
      !    wt_psi = 0       at the inner boundary
      ! 
      ! Ǥ뤫 wt_Boundaries бǽ, ΤӺƤ.
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_TOR
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, n
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(tt_I) ) deallocate(tt_I)
         if ( allocated(tz_PSI) ) deallocate(tz_PSI)
         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km))

         tt_I = 0.0D0
         do l=0,lm
            tt_I(l,l)=1.0D0
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = tt_I
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,lm-1,:) = tz_PSI(:,0)
            alu(n,lm,:)   = tz_PSI(:,km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI)

         call MessageNotify('M','TormagBoundariesTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wt_TOR(:,lm-1) = 0.0D0
      wt_TOR(:,lm)   = 0.0D0
      wt_TOR = lusolve(alu,kp,wt_TOR)

    end subroutine wt_TormagBoundariesTau

    subroutine wt_TormagBoundariesGrid(wt_TOR,new)
      !
      ! ȥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ.
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ 
      ! wt_Initial ˤꤹӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ. 
      !
      ! ߤΤȤʪŵƳΤξΤбƤ. 
      ! ξ, ȥݥƥ󥷥ζ
      !
      ! ¦
      !    wt_psi = 0   at the outer boundary
      ! ¦
      !    wt_psi = 0       at the inner boundary
      ! 
      ! ǤΤ wt_Boundaries бǽ, ΤӺƤ
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_TOR
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_TOR

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, n
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','TorMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(tt_I) ) deallocate(tt_I)
         if ( allocated(tz_PSI) ) deallocate(tz_PSI)
         allocate(alu((nm+1)*(nm+1),0:km,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km))

         tt_I = 0.0D0
         do l=0,lm
            tt_I(l,l)=1.0D0
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = transpose(az_at(tt_I))   ! ΰͤΤޤ.
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)

         do n=1,(nm+1)*(nm+1)
            alu(n,0,:) = tz_PSI(:,0)
            alu(n,km,:)   = tz_PSI(:,km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI)

         call MessageNotify('M','TormagBoundariesGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif
      
      wz_TOR       = wz_wt(wt_TOR)
      wz_TOR(:,0)  = 0.0D0
      wz_TOR(:,km) = 0.0D0
      wt_TOR = lusolve(alu,kp,wz_TOR)

    end subroutine wt_TormagBoundariesGrid

    subroutine wt_PolmagBoundariesTau(wt_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! Chebyshev ֤ǤζŬ
      !
      ! ӥն֤ˤƶ٤⼡ηˡ
      ! ȤäƤ(ˡ). ߤΤȤʪŵƳΤξΤ
      ! бƤ. ξ, ݥݥƥ󥷥γƿʿڥȥ
      ! ʬ h ˤƶ郎Ϳ,
      !
      !  * ¦ : dh/dr + (n+1)h/r = 0
      !  * ¦ : dh/dr - nh/r = 0
      !
      ! Ǥ.  n  h οʿȿǤ. 
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_POL
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension(:,:), allocatable    :: tz_DPSIDR

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, n, nn(2)
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( allocated(alu) ) deallocate(alu)
         if ( allocated(kp) ) deallocate(kp)
         if ( allocated(tt_I) ) deallocate(tt_I)
         if ( allocated(tz_PSI) ) deallocate(tz_PSI)
         if ( allocated(tz_DPSIDR) ) deallocate(tz_DPSIDR)

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km),tz_DPSIDR(0:lm,0:km))

         tt_I = 0.0D0
         do l=0,lm
            tt_I(l,l)=1.0D0
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = tt_I
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)
         tz_DPSIDR = az_at(at_dr_at(tt_I))

         do n=1,(nm+1)*(nm+1)
            nn=nm_l(n)
            alu(n,lm-1,:) = tz_DPSIDR(:,0) + (nn(1)+1) * tz_PSI(:,0)/z_RAD(0)
            alu(n,lm,:)   = tz_DPSIDR(:,km) - nn(1) * tz_PSI(:,km)/z_RAD(km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI,tz_DPSIDR)

         call MessageNotify('M','PolmagBoundariesTau',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wt_POL(:,lm-1) = 0.0D0
      wt_POL(:,lm)   = 0.0D0
      wt_POL = lusolve(alu,kp,wt_POL)

    end subroutine wt_PolmagBoundariesTau

    subroutine wt_PolmagBoundariesGrid(wt_POL,new)
      !
      ! ݥݥƥ󥷥ФƶŬѤ.
      ! ľ¶֤ǤζŬ. 
      !
      ! ľ³ʻ֤ˤΰͤȶ褦
      ! ݤƤ(ˡ). Υ롼Ѥ뤿ˤ 
      ! wt_Initial ˤꤹӥȿ(lm)ȱľʻ(km)
      ! Ƥɬפ. 
      !
      ! ߤΤȤʪŵƳΤξΤбƤ. 
      ! ξ, ݥݥƥ󥷥γƿʿڥȥʬ h 
      ! ƶ郎Ϳ,
      !
      !  * ¦ : dh/dr + (n+1)h/r = 0
      !  * ¦ : dh/dr - nh/r = 0
      !
      ! Ǥ.  n  h οʿȿǤ. 
      !
      ! ǽ˸ƤФȤϥץʥ new ˴طʤꤵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm),intent(inout)   :: wt_POL
              !(inout) ŬѤǡ. 줿֤ͤ. 

      logical, intent(IN), optional :: new
              !(in) true ȶ׻ѹŪ˿˺.
              !     default  false.

      real(8), dimension(:,:,:), allocatable  :: alu
      integer, dimension(:,:), allocatable    :: kp

      real(8), dimension(:,:), allocatable    :: tt_I
      real(8), dimension(:,:), allocatable    :: tz_PSI
      real(8), dimension(:,:), allocatable    :: tz_DPSIDR
      real(8), dimension((nm+1)*(nm+1),0:km)  :: wz_POL

      logical :: first = .true.
      logical :: new_matrix = .false.
      integer  :: l, n, nn(2)
      save     :: alu, kp, first

      if (.not. present(new)) then
         new_matrix=.false.
      else 
         new_matrix=new
      endif

      if ( first .OR. new_matrix ) then
         first = .false.

         if ( lm /= km ) then
            call MessageNotify('E','PolMagBoundariesGrid', &
             'Chebyshev truncation and number of grid points should be same.')
         endif

         if ( allocated(alu) ) then 
           deallocate(alu)
         endif
         if ( allocated(kp) ) then 
           deallocate(kp)
         endif
         if ( allocated(tt_I) ) then
           deallocate(tt_I)
         endif
         if ( allocated(tz_PSI) ) then 
           deallocate(tz_PSI)
         endif
         if ( allocated(tz_DPSIDR) ) then 
           deallocate(tz_DPSIDR)
         endif

         allocate(alu((nm+1)*(nm+1),0:lm,0:lm),kp((nm+1)*(nm+1),0:lm))
         allocate(tt_I(0:lm,0:lm),tz_PSI(0:lm,0:km),tz_DPSIDR(0:lm,0:km))

         tt_I = 0.0D0
         do l=0,lm
            tt_I(l,l)=1.0D0
         enddo
         do n=1,(nm+1)*(nm+1)
            alu(n,:,:) = transpose(az_at(tt_I))  ! ΰͤϤΤޤ
         enddo

         ! ŵƳ
         tz_PSI = az_at(tt_I)
         tz_DPSIDR = az_at(at_dr_at(tt_I))

         do n=1,(nm+1)*(nm+1)
            nn=nm_l(n)
            alu(n,0,:)  = tz_DPSIDR(:,0) + (nn(1)+1) * tz_PSI(:,0)/z_RAD(0)
            alu(n,km,:) = tz_DPSIDR(:,km) - nn(1) * tz_PSI(:,km)/z_RAD(km)
         enddo
         call ludecomp(alu,kp)

         deallocate(tt_I,tz_PSI,tz_DPSIDR)

         call MessageNotify('M','PolmagBoundariesGrid',&
                           'Matrix to apply  b.c. newly produced.')
      endif

      wz_POL       = wz_wt(wt_POL)
      wz_POL(:,0)  = 0.0D0
      wz_POL(:,km) = 0.0D0
      wt_POL = lusolve(alu,kp,wz_POL)

    end subroutine wt_PolmagBoundariesGrid

end module wt_module_sjpack_cuda
