!------------------------------------------------------------------------
! Copyright (c) 2011 SPMODEL Development Group. All rights reserved.
!------------------------------------------------------------------------
!
!ɽ  eea_module ƥȥץ
!
!  2011/12/10  ݹ
!
program eea_test_intavr

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use eea_module
  implicit none

 !---- ֲ ----
  integer, parameter :: im=16, jm=16            ! ʻ(X,Y)
  integer, parameter :: km=5, lm=5              ! ȿ(X,Y)

 !---- ѿ ----
  real(8)            :: yxa_Data(0:jm-1,0:im-1,2)    ! ʻҥǡ
  real(8)            :: xa_Data(0:im-1,2)            ! ʻҥǡ
  real(8)            :: ya_Data(0:jm-1,2)            ! ʻҥǡ
  real(8)            :: a_Data(2)                    ! ʻҥǡ

 !---- ɸѿʤ ----
  real(8), parameter :: xmin = -1.0d0, xmax=1.0d0
  real(8), parameter :: ymin = -1.0d0, ymax=1.0d0

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -11
  integer :: j

  real(8), parameter :: pi=3.1415926535897932385D0

  call MessageNotify('M','eea_test_intavr', &
       'eea_module integral/average function tests')

 !---------------- ɸͤ ---------------------
  call eea_initial(im,jm,km,lm,xmin,xmax,ymin,ymax)    ! ڥȥ

 !-------------------  ----------------------
  yxa_Data(:,:,1) = sin(pi*yx_X) * cos(pi*yx_Y)
  yxa_Data(:,:,2) = (1 - sin(pi*yx_X)) * cos(pi*yx_Y)**2
  write(6,*) 'f1 = sin(pi*X)*cos(pi*Y), f2 = (1-sin(pi*X)) * cos(pi*Y)**2'

    a_Data(1) = 0.0d0 ; a_Data(2) = 2.0d0
    call check1d(a_IntYX_yxa(yxa_Data),  a_Data, 'a_IntYX_yxa')
    a_Data(1) = 0.0d0 ; a_Data(2) = 5.0d-1
    call check1d(a_AvrYX_yxa(yxa_Data),  a_Data, 'a_AvrYX_yxa')

    ya_Data(:,1) = 0.0d0 ; ya_Data(:,2) = 2.0d0*cos(pi*y_Y)**2
    call check2d(ya_IntX_yxa(yxa_Data), ya_Data, 'ya_IntX_yxa')
    ya_Data(:,1) = 0.0d0 ; ya_Data(:,2) = cos(pi*y_Y)**2
    call check2d(ya_AvrX_yxa(yxa_Data), ya_Data, 'ya_AvrX_yxa')

    xa_Data(:,1) = 0.0d0 ;  xa_Data(:,2) = (1.0d0-sin(pi*x_X))
    call check2d(xa_IntY_yxa(yxa_Data), xa_Data, 'xa_IntY_yxa')
    xa_Data(:,1) = 0.0d0 ;  xa_Data(:,2) = (5.0d-1)*(1.0d0-sin(pi*x_X))
    call check2d(xa_AvrY_yxa(yxa_Data), xa_Data, 'xa_AvrY_yxa')


  xa_Data(:,1) = 1 - sin(2*pi*x_X)
  xa_Data(:,2) = cos(pi*x_X)**2
  write(6,*) 'f1 = 1-sin(2*pi*X), f2 = cos(pi*X)**2'

    a_Data(1) = 2.0d0 ; a_Data(2) = 1.0d0
    call check1d(a_IntX_xa(xa_Data), a_Data, 'a_IntX_xa')
    a_Data(1) = 1.0d0 ; a_Data(2) = 5.0d-1
    call check1d(a_AvrX_xa(xa_Data), a_Data, 'a_AvrX_xa')

  ya_Data(:,1) = 1 - sin(2*pi*y_Y)
  ya_Data(:,2) = cos(pi*y_Y)**2
  write(6,*) 'f1 = 1-sin(2*pi*Y), f2 = cos(pi*Y)**2'

    a_Data(1) = 2.0d0 ; a_Data(2) = 1.0d0
    call check1d(a_IntY_ya(xa_Data), a_Data, 'a_IntY_ya')
    a_Data(1) = 1.0d0 ; a_Data(2) = 5.0d-1
    call check1d(a_AvrY_ya(ya_Data), a_Data, 'a_AvrY_ya')

  call MessageNotify('M','eea_test_intavr', &
       'eea_module integral/average function tests succeeded!')

contains

  subroutine check1d(var1,sol1,funcname)
    real(8) :: var1(:)                  ! Ƚꤹ
    real(8) :: sol1(:)                  ! ϲ
    character(len=*) :: funcname        ! ؿ̾

    call AssertEqual(     &
      message = funcname, &
      answer = sol1,       &
      check = var1,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check1d

  subroutine check2d(var2,sol2,funcname)
    real(8) :: var2(:,:)                  ! Ƚꤹ
    real(8) :: sol2(:,:)                  ! ϲ
    character(len=*) :: funcname          ! ؿ̾

    call AssertEqual(      &
      message = funcname,  &
      answer = sol2,       &
      check = var2,        &
      significant_digits = check_digits, ignore_digits = ignore     )

  end subroutine check2d

end program eea_test_intavr
