!----------------------------------------------------------------------
! Copyright(c) 2009-2011 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  INDEXX :" ֹդ ƥȥץ
!
!  2009/02/06  ݹ
!      2011/03/06  ʿ
!
program indexx_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  implicit none

  interface
    function indexx(arrin)
      real(8), dimension(:), intent(in)  :: arrin
      integer, dimension(size(arrin))    :: indexx
    end function indexx
  end interface

  integer, parameter         :: narray = 5
  real(8), dimension(narray) :: array
  integer, dimension(narray) :: indary
  integer, dimension(narray) :: indary_sol

  array = (/-1.0D0, 1.0D0, -3.0D0, 2.0D0, 0.0D0/)
  indary = indexx(array)

  call MessageNotify('M','indexx_test','test of index sorting')

  indary_sol = (/3,1,5,2,4/)
  call AssertEqual(                            &
    message = 'Index check, increasing order', &
    answer  =  indary_sol,                     &
    check   =  indary )

  indary_sol = (/4,2,5,1,3/)
  call AssertEqual(                            &
    message = 'Index check, decreasing order', &
    answer  =  indary_sol,                     &
    check   =  indary(narray:1:-1) )

  call MessageNotify('M','indexx_test','test of index sorting succeeded!')

end program indexx_test
