!----------------------------------------------------------------------
! Copyright (c) 2008-2011 SPMODEL Development GroupAll rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtu_module ƥȥץ:
!      xyz_GradLon_wt, xyz_GradLat_wt, wt_Div_xyz_xyz_xyz
!
!  2008/01/13  ݹ  wt_test_derivative2.f90 
!      2008/07/05  ʿ  ѹ
!      2011/08/18  ʿ use dc_test
!
program wtu_test_derivative2

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use dc_string, only: CPrintf
  use wtu_module
  implicit none

  integer, parameter  :: im=32, jm=16      ! ʻ(, , ư)
  integer, parameter  :: kmo=16, kmi=8     ! ʻ(ư, ư)
  integer, parameter  :: nm=10             ! ȿ(ʿ)
  integer, parameter  :: lmo=16, lmi=8     ! ȿ(ư, ư)
  real(8), parameter  :: ri=0.5, ro=1.5    ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_VLon
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_VLat
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_VRad
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_GradLon
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_GradLat
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Div
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Psi
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -10
  integer, parameter :: n=2

  call MessageNotify('M','wtu_test_derivative2', &
       'wtu_module derivative function test #2')

  call wtu_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

! -----------------  1 --------------------
  xyz_VRad = 0.0D0
  xyz_Psi = xyz_Rad**n * cos(xyz_Lat)*sin(xyz_Lon)   ! r**2 P_1^1

  xyz_GradLon =  xyz_Rad**(n-1)*cos(xyz_Lon)
  xyz_GradLat = -xyz_Rad**(n-1)*sin(xyz_Lat)*sin(xyz_Lon)

  xyz_Div = - 2.0d0 * xyz_Psi/xyz_Rad**2

!!  write(6,*)
!!  write(6,*)'P11 field'
  call checkresult('P11 field')

! -----------------  2 --------------------
  xyz_VRad = 0.0D0
  xyz_Psi = xyz_Rad**n * cos(xyz_Lat)*sin(xyz_Lat) * sin(xyz_Lon) ! P_2^1

  xyz_GradLon =  xyz_Rad**(n-1)*sin(xyz_Lat)*cos(xyz_Lon)
  xyz_GradLat =  xyz_Rad**(n-1)*cos(2*xyz_Lat)*sin(xyz_Lon)

  xyz_Div = - 6.0d0 * xyz_Psi/xyz_Rad**2

  call checkresult('P21 field')

  call MessageNotify('M','wt_test_derivative2', &
       'wt_module derivative function test #2 succeeded!')

contains

  subroutine checkresult(mess)
    character(len=*) :: mess

    xyz_VLon = xyz_GradLon_wt(wt_xyz(xyz_Psi))
    call AssertEqual( &
      message = CPrintf(&
                fmt="GradLon(1/r cos(lat) d/dlon), %c", c1=mess), &
      answer = xyz_GradLon, &
      check  = xyz_VLon, &
      significant_digits = check_digits, ignore_digits = ignore &
      )

    xyz_VLat = xyz_GradLat_wt(wt_xyz(xyz_Psi))
    call AssertEqual( &
      message = CPrintf(&
                fmt="GradLat(1/r d/dlat), %c", c1=mess), &
      answer = xyz_GradLat, &
      check  = xyz_VLat, &
      significant_digits = check_digits, ignore_digits = ignore &
      )

    call AssertEqual( &
      message = CPrintf(fmt="Divergence, %c", c1=mess), &
      answer = xyz_Div, &
      check  = xyz_wt(wt_Div_xyz_xyz_xyz(xyz_VLon, xyz_VLat, xyz_VRad)), &
      significant_digits = check_digits, ignore_digits = ignore &
      )

  end subroutine checkresult

end program wtu_test_derivative2

