!----------------------------------------------------------------------
! Copyright (c) 2008-2011 SPMODEL Development GroupAll rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wtu_module ƥȥץ ::
!      wt_DivLon_xyz, wt_DivLat_xyz
!
!  2008/01/13  ݹ  wt_test_derivative3.f90 
!      2008/07/05  ʿ  ѹ
!      2011/08/18  ʿ use dc_test
!
program wtu_test_derivative3

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wtu_module
  implicit none

  integer,parameter  :: im=32, jm=16   ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=8  ! ʻ(ư, ư)
  integer,parameter  :: nm=10          ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=8  ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5 ! ⳰Ⱦ

  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_VLon
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_VLat
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_DivLon
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_DivLat
  real(8), dimension(0:im-1,1:jm,0:kmo)     :: xyz_Data
  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -10
  integer, parameter :: n = 2

  call MessageNotify('M','wtu_test_derivative3', &
       'wtu_module derivative function test #3')

  call wtu_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

!!  write( 6,* ) 'Test for wt_DivLon_xyz, wt_DivLat_xyz'
!!  write( 6,* ) 'Output is displayed if computational error is larger than',eps

! -----------------  1 --------------------
  xyz_VLon   = xyz_rad**n * cos(xyz_Lat)**2*sin(xyz_Lon)
  xyz_DivLon = xyz_rad**(n-1)*cos(xyz_Lat)*cos(xyz_Lon)

  xyz_VLat   = xyz_rad**n * cos(xyz_Lat)**2*sin(xyz_Lon)
  xyz_DivLat = -3.0d0*xyz_rad**(n-1)*cos(xyz_Lat)*sin(xyz_Lat)*sin(xyz_Lon)

!!  write(6,*)'  xyz_VLon=xyz_rad**n * cos(xyz_Lat)**2*sin(xyz_Lon)'
!!  write(6,*)'  xyz_VLat=xyz_rad**n * cos(xyz_Lat)**2*sin(xyz_Lon)'

  call checkresult

  call MessageNotify('M','wt_test_derivative3', &
       'wt_module derivative function test #3 succeeded!')

contains

  subroutine checkresult

  call AssertEqual( &
    message = 'DivLon (1/r cos(Lat) dLon)', &
    answer = xyz_DivLon, &
    check  = xyz_wt(wt_DivLon_xyz(xyz_VLon)), &
    significant_digits = check_digits, ignore_digits = ignore &
    )

  call AssertEqual( &
    message = 'DivLat (1/r cos(Lat) d/dLat cos(Lat))', &
    answer = xyz_DivLat, &
    check  = xyz_wt(wt_DivLat_xyz(xyz_VLon)), &
    significant_digits = check_digits, ignore_digits = ignore &
    )

  end subroutine checkresult


end program wtu_test_derivative3

