!----------------------------------------------------------------------
! Copyright (c) 2008-2011 SPMODEL Development GroupAll rights reserved.
!----------------------------------------------------------------------
!
!ɽ  wt_module ƥȥץ ::
!       wt_Potential2Rotation
!
!  2008/01/13  ݹ  wt_test_derivative7.f90 
!      2008/07/05  ʿ  ѹ
!      2011/08/18  ʿ use dc_test
!
program wtu_test_derivative7

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use dc_string, only: CPrintf
  use wtu_module
  implicit none

  integer,parameter  :: im=32, jm=16      ! ʻ(, , ư)
  integer,parameter  :: kmo=16, kmi=8     ! ʻ(ư, ư)
  integer,parameter  :: nm=10             ! ȿ(ʿ)
  integer,parameter  :: lmo=16, lmi=8     ! ȿ(ư, ư)
  real(8),parameter  :: ri=0.5, ro=1.5    ! ⳰Ⱦ

  real(8), dimension((nm+1)*(nm+1),0:lmo) :: wt_VTor  ! ȥݥƥ󥷥
  real(8), dimension((nm+1)*(nm+1),0:lmo) :: wt_VPol  ! ݥݥƥ󥷥

  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotVLon  ! ()
  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotVLat  ! ()
  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotVrad  ! (ư)
  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotV0Lon ! (, )
  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotV0Lat ! (, )
  real(8), dimension(0:im-1,1:jm,0:kmo)   :: xyz_RotV0rad ! (,ư)

  real(8), parameter :: eps = 1D-9
  ! Ƚ
  integer, parameter :: check_digits = 9
  integer, parameter :: ignore = -9

  call MessageNotify('M','wtu_test_derivative7', &
       'wtu_module derivative subroutine test #7')

  call wtu_Initial(im,jm,kmi,kmo,nm,lmi,lmo,ri,ro)

!!  write( 6,* ) 'Test for wt_Rotation'
!!  write( 6,* ) 'Output is displayed if computational error is larger than',eps

! -----------------  1 --------------------
  ! βž
  wt_VTor = wt_xyz(xyz_Rad * sin(xyz_Lat))
  wt_VPol = 0.0D0

  xyz_RotV0lon = 0.0D0
  xyz_RotV0lat = 2.0D0*cos(xyz_LAT)
  xyz_RotV0rad = 2.0D0*sin(xyz_LAT)

  write(6,*)
  write(6,*)
  write(6,*)'Example 1 : rigid rotation'
  write(6,*)'    xyz_Vlon = xyz_Rad * cos(xyz_Lat)'
  write(6,*)'    xyz_Vlat = 0.0'
  write(6,*)'    xyz_VRad = 0.0'

  call checkresult('Rigid rotation: east-west')

! -----------------  2 --------------------
  ! βž(ή)
  wt_VTor = wt_xyz(xyz_Rad * cos(xyz_Lat) * sin(xyz_Lon))
  wt_VPol = 0.0D0

  xyz_RotV0Lon =  2.0D0*cos(xyz_Lon)
  xyz_RotV0Lat = -2.0D0*sin(xyz_Lon)*sin(xyz_Lat)
  xyz_RotV0Rad =  2.0D0*sin(xyz_Lon)*cos(xyz_Lat)

  call checkresult('Rigid rotation: north-south')

! -----------------  3 --------------------
 ! ̵

  wt_VTor = 0.0D0
  wt_VPol = wt_xyz(xyz_Rad * sin(xyz_Lat))

  xyz_RotV0lon = 0.0D0
  xyz_RotV0lat = 0.0D0
  xyz_RotV0rad = 0.0D0

  call checkresult('Poloidal field: no rotation')

! -----------------  4 --------------------
 ! ݥ®پ

  wt_VTor = 0.0D0
  wt_VPol = wt_xyz(xyz_Rad**2 * cos(xyz_Lat)*sin(xyz_Lon))

  xyz_RotV0lon = 4.0D0*sin(xyz_Lat)*sin(xyz_Lon)
  xyz_RotV0lat = 4.0D0*cos(xyz_Lon)
  xyz_RotV0rad = 0.0D0

  call checkresult('Poloidal field: rotating')

  call MessageNotify('M','wtu_test_derivative7', &
       'wt_module derivative function test #7 succeeded!')

contains

 !-------  -------
  subroutine checkresult(mess)
    character(len=*) :: mess

    call wt_Potential2Rotation(&
      xyz_RotVLon,xyz_RotVLat,xyz_RotVRad, wt_VTor, wt_VPol )

    call AssertEqual( &
      message = CPrintf(fmt="%c, RotV_Lon", c1=mess), &
      answer = xyz_RotV0Lon, &
      check  = xyz_RotVLon, &
      significant_digits = check_digits, ignore_digits = ignore &
      )

    call AssertEqual( &
      message = CPrintf(fmt="%c, RotV_Lat", c1=mess), &
      answer = xyz_RotV0Lat, &
      check  = xyz_RotVLat, &
      significant_digits = check_digits, ignore_digits = ignore &
      )

    call AssertEqual( &
      message = CPrintf(fmt="%c, RotV_Rad", c1=mess), &
      answer = xyz_RotV0Rad, &
      check  = xyz_RotVRad, &
      significant_digits = check_digits, ignore_digits = ignore &
      )

  end subroutine checkresult

end program wtu_test_derivative7
