!------------------------------------------------------------------------
! Copyright(c) 2009-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ؿΥƥ
!      xyz_GradLon_wu, xyz_GradLat_wu, wu_Div_xyz_xyz_xyz
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_derivative2

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLon
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VLat
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_VRad
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_GradLon
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_GradLat
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Div
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Data
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Psi

  ! Ƚ
  integer, parameter :: check_digits = 10
  integer, parameter :: ignore = -10

  call MessageNotify('M','wu_test_derivative2', &
       'wu_module derivative function test #2')

  call wu_Initial(im,jm,km,nm,lm,ra)

  ! -----------------  1 --------------------
  ! r**2 P_1^1
  xyr_VRad = 0.0D0
  xyr_Psi = xyr_Rad**2*cos(xyr_Lat)*sin(xyr_Lon)

  xyr_GradLon =  xyr_Rad*cos(xyr_Lon)
  xyr_GradLat = -xyr_Rad*sin(xyr_Lat)*sin(xyr_Lon)

  xyr_Div = - 2.0d0* xyr_Psi/xyr_Rad**2

  call MessageNotify('M','wu_test_derivative2', 'P11 field')
  call checkresult

  ! -----------------  2 --------------------
  ! P_2^1
  xyr_VRad = 0.0D0
  xyr_Psi = xyr_Rad**2*cos(xyr_Lat)*sin(xyr_Lat) * sin(xyr_Lon)

  xyr_GradLon =  xyr_Rad*sin(xyr_Lat)*cos(xyr_Lon)
  xyr_GradLat =  xyr_Rad*cos(2*xyr_Lat)*sin(xyr_Lon)

  xyr_Div = - 6.0d0*xyr_Psi/xyr_Rad**2

  call MessageNotify('M','wu_test_derivative2', 'P21 field')

  call checkresult

  call MessageNotify('M','wu_test_derivative2', &
       'wu_module derivative function test #2 succeeded!')

contains

  subroutine checkresult

    xyr_VLon =  xyr_GradLon_wu(wu_xyr(xyr_Psi))
    call check3d(xyr_GradLon, xyr_VLon, 'Checking GradLon (1/r cos(Lat) d/dLon)')

    xyr_VLat =  xyr_GradLat_wu(wu_xyr(xyr_Psi))
    call check3d(xyr_GradLat, xyr_VLat, 'Checking GradLat (1/r dLat)')

    xyr_Data = xyr_wr(wr_Div_xyr_xyr_xyr(xyr_VLon,xyr_VLat,xyr_VRad))
    call check3d(xyr_Div, xyr_Data, 'Checking Divergence')

  end subroutine checkresult

  subroutine check3d(sol, ans, mess)
    real(8) :: sol(:,:,:)
    real(8) :: ans(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message = mess,                                           &
      answer = ans,                                             &
      check = sol,                                              &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

end program wu_test_derivative2

