!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!      ʬʿѷ׻
!
!  2008/01/01  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_intavr

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module
  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=1.5d0             ! Ⱦ
  real(8), dimension(0:im-1,1:jm,0:km) :: xyr_Data
  real(8), dimension(0:im-1,1:jm)      :: xy_Data
  real(8), dimension(1:jm,0:km)        :: yr_Data
  real(8), dimension(0:im-1,0:km)      :: xr_Data
  real(8), dimension(0:im-1)           :: x_Data
  real(8), dimension(1:jm)             :: y_Data
  real(8), dimension(0:km)             :: r_Data

  ! Ƚ
  integer, parameter :: check_digits = 4
  integer, parameter :: ignore = -5
  real(8), parameter :: eps = 1D-4
  real(8), parameter :: pi=3.1415926535897932385D0
  !=============================== ʬ =================================

  call wu_Initial(im,jm,km,nm,lm,ra)

  call MessageNotify('M','wu_test_intavr', &
       'wu_module integration function tests')

  call MessageNotify('M', 'wu_test_intavr', 'Constant field: 1.0D0')
  ! data setting...
  xyr_Data = 1.0D0
  ! test
  yr_Data  = 2.0d0 * pi
  call check2d(yr_Data, yr_IntLon_xyr(xyr_Data), 'test of IntLon')
  xr_Data = 2.0d0
  call check2d(xr_Data, xr_IntLat_xyr(xyr_Data), 'test of IntLat')
  xy_Data = 1.0D0/3.0D0 * ra**3
  call check2d(xy_Data, xy_IntRad_xyr(xyr_Data), 'test of IntRad')
  r_Data = 4.0d0 * pi
  call check1d(r_Data, r_IntLonLat_xyr(xyr_Data), 'test of IntLonLat')
  x_Data = (2.0d0/3.0d0) * ra ** 3
  call check1d(x_Data, x_IntLatRad_xyr(xyr_Data), 'test of IntLatRad')
  y_Data = (2.0d0*pi/3.0d0) * ra ** 3
  call check1d(y_Data, y_IntLonRad_xyr(xyr_Data), 'test of IntLonRad')
  call check0d((4.0d0*pi/3.0d0)*ra**3, IntLonLatRad_xyr(xyr_Data), &
    'test of IntLonLatRad')

  call MessageNotify('M', 'wu_test_intavr', 'Constant field: r')
  ! data setting
  xyr_Data = xyr_Rad
  ! test
  yr_Data  = 2.0d0 * pi * xyr_Rad(1,:,:)
  call check2d(yr_Data, yr_IntLon_xyr(xyr_Data), 'test of IntLon')
  xr_Data = 2.0d0 * xyr_Data(:,1,:)
  call check2d(xr_Data, xr_IntLat_xyr(xyr_Data), 'test of IntLat')
  xy_Data = 1.0D0/4.0D0 * ra**4
  call check2d(xy_Data, xy_IntRad_xyr(xyr_Data), 'test of IntRad')
  r_Data = 4.0d0 * pi * xyr_Data(1,1,:)
  call check1d(r_Data, r_IntLonLat_xyr(xyr_Data), 'test of IntLonLat')
  x_Data = (1.0d0/2.0d0) * ra ** 4
  call check1d(x_Data, x_IntLatRad_xyr(xyr_Data), 'test of IntLatRad')
  y_Data = (pi/2.0d0) * ra ** 4
  call check1d(y_Data, y_IntLonRad_xyr(xyr_Data), 'test of IntLonRad')
  call check0d(pi*ra**4, IntLonLatRad_xyr(xyr_Data), &
    'test of IntLonLatRad')

  call MessageNotify('M', 'wu_test_intavr', 'Constant field: sin(lat)**2')
  ! data setting
  xyr_Data = sin(xyr_Lat)**2
  ! test
  yr_Data  = 2.0d0 * pi * xyr_Data(1,:,:)
  call check2d(yr_Data, yr_IntLon_xyr(xyr_Data), 'test of IntLon')
  xr_Data = 2.0d0/3.0d0
  call check2d(xr_Data, xr_IntLat_xyr(xyr_Data), 'test of IntLat')
  xy_Data = 1.0D0/3.0D0 * ra**3 * xyr_Data(:,:,1)
  call check2d(xy_Data, xy_IntRad_xyr(xyr_Data), 'test of IntRad')
  r_Data = 4.0d0 * pi/3.0d0
  call check1d(r_Data, r_IntLonLat_xyr(xyr_Data), 'test of IntLonLat')
  x_Data = (2.0d0/9.0d0) * ra ** 3
  call check1d(x_Data, x_IntLatRad_xyr(xyr_Data), 'test of IntLatRad')
  y_Data = (2.0d0 * pi/3.0d0) * ra ** 3 * xyr_Data(1,:,1)
  call check1d(y_Data, y_IntLonRad_xyr(xyr_Data), 'test of IntLonRad')
  call check0d((4.0d0*pi/9.0d0)*ra**3, IntLonLatRad_xyr(xyr_Data), &
    'test of IntLonLatRad')

!!=============================== ʿ =================================

  call MessageNotify('M','wu_test_intavr', &
       'wu_module averaging function tests')

  call MessageNotify('M', 'wu_test_intavr', 'Constant field: 1.0D0')
  ! data setting...
  xyr_Data = 1.0D0
  ! test
  yr_Data = 1.0d0
  call check2d(yr_Data, yr_AvrLon_xyr(xyr_Data), 'test of AvrLon')
  xr_Data = 1.0d0
  call check2d(xr_Data, xr_AvrLat_xyr(xyr_Data), 'test of AvrLat')
  xy_Data = 1.0d0
  call check2d(xy_Data, xy_AvrRad_xyr(xyr_Data), 'test of AvrRad')
  r_Data = 1.0d0
  call check1d(r_Data, r_AvrLonLat_xyr(xyr_Data), 'test of AvrLonLat')
  x_Data = 1.0d0
  call check1d(x_Data, x_AvrLatRad_xyr(xyr_Data), 'test of AvrLatRad')
  y_Data = 1.0d0
  call check1d(y_Data, y_AvrLonRad_xyr(xyr_Data), 'test of AvrLonRad')
  call check0d(1.0d0, AvrLonLatRad_xyr(xyr_Data), 'test of AvrLonLatRad')


  call MessageNotify('M', 'wu_test_intavr', 'Constant field: r')
  ! data setting...
  xyr_Data = xyr_Rad
  ! test
  call check2d(xyr_Rad(1,:,:), yr_AvrLon_xyr(xyr_Data), 'test of AvrLon')
  xr_Data = 1.0d0
  call check2d(xyr_Data(:,1,:), xr_AvrLat_xyr(xyr_Data), 'test of AvrLat')
  xy_Data = ((1.0d0/4.0d0)*ra**4)/((1.0d0/3.0d0)*ra**3)
  call check2d(xy_Data, xy_AvrRad_xyr(xyr_Data), 'test of AvrRad')
  call check1d(xyr_Data(1,1,:), r_AvrLonLat_xyr(xyr_Data), 'test of AvrLonLat')
  x_Data = ((1.0d0/2.0d0) * ra ** 4)/((2.0d0/3.0d0)*ra**3)
  call check1d(x_Data, x_AvrLatRad_xyr(xyr_Data), 'test of AvrLatRad')
  y_Data = (pi/2.0d0)*ra**4/((2.0d0*pi/3.0d0)*ra**3)
  call check1d(y_Data, y_AvrLonRad_xyr(xyr_Data), 'test of AvrLonRad')
  call check0d( (pi*ra**4)/((4.0d0/3.0d0)*pi*ra**3), &
    AvrLonLatRad_xyr(xyr_Data), 'test of AvrLonLatRad')

  call MessageNotify('M', 'wu_test_intavr', 'Constant field: sin(lat)**2')
  ! data setting...
  xyr_Data = sin(xyr_Lat)**2
  ! test
  yr_Data = xyr_Data(1,:,:)
  call check2d(yr_Data, yr_AvrLon_xyr(xyr_Data), 'test of AvrLon')
  xr_Data = 1.0d0/3.0d0
  call check2d(xr_Data, xr_AvrLat_xyr(xyr_Data), 'test of AvrLat')
  xy_Data = xyr_Data(:,:,1)
  call check2d(xy_Data, xy_AvrRad_xyr(xyr_Data), 'test of AvrRad')
  r_Data = 1.0d0/3.0d0
  call check1d(r_Data, r_AvrLonLat_xyr(xyr_Data), 'test of AvrLonLat')
  x_Data = 1.0d0/3.0d0
  call check1d(x_Data, x_AvrLatRad_xyr(xyr_Data), 'test of AvrLatRad')
  y_Data = xyr_Data(1,:,1)
  call check1d(y_Data, y_AvrLonRad_xyr(xyr_Data), 'test of AvrLonRad')
  call check0d(1.0d0/3.0d0, AvrLonLatRad_xyr(xyr_Data), &
    'test of AvrLonLatRad')

  call MessageNotify('M','wu_test_intavr', &
       'wu_module integration/averaging function tests succeeded!')

contains
  subroutine check0d(sol0, ans0, mess)
    real(8) :: sol0
    real(8) :: ans0
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans0,                                &
      check              = sol0,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check0d

  subroutine check1d(sol1, ans1, mess)
    real(8) :: sol1(:)
    real(8) :: ans1(:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans1,                                &
      check              = sol1,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d

  subroutine check2d(sol2, ans2, mess)
    real(8) :: sol2(:,:)
    real(8) :: ans2(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans2,                                &
      check              = sol2,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

  subroutine check3d(sol3, ans3, mess)
    real(8) :: sol3(:,:,:)
    real(8) :: ans3(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans3,                                &
      check              = sol3,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

end program wu_test_intavr
