!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2008/01/02  ݹ
!      2008/06/28  ʿ  ѹ
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_polmagbc

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=32  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=32         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=2.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)   :: xyr_POLMAG
  real(8), dimension(0:im-1,1:jm,0:km)   :: xyr_POLMAG_orig
  real(8), dimension((nm+1)*(nm+1),0:lm) :: wu_POLMAG
  real(8), dimension((nm+1)*(nm+1),0:km) :: wr_TopBoundary
  real(8), dimension((nm+1)*(nm+1),0:km) :: wr_SOL
  real(8), dimension((nm+1)*(nm+1),0:km) :: wr_n   ! ȿ

  real(8), parameter :: pi=3.1415926535897932385D0
  integer, parameter :: check_digits = 13
  integer, parameter :: ignore = -14

  integer :: i, j, k, n, nn(2)

  call wu_initial(im,jm,km,nm,lm,ra)

  call MessageNotify('M','wu_test_polmagbc', &
       'wu_module  wu_PolmagBoundary subroutine test')

  !=================== wu_PolmagBoundary =======================
  ! P_10
  xyr_POLMAG = sin(xyr_lat) * sin( pi*(xyr_rad-ra)/ra )

  ! P_1_1
  !xyr_POLMAG = cos(xyr_lat)*cos(xyr_lon)* sin( pi*(xyr_rad-ri)/(ro-ri) )
  !xyr_POLMAG = 2*sin(xyr_lat)**2 * sin( pi*(xyr_rad-ri)/(ro-ri) )

  xyr_POLMAG_orig = xyr_POLMAG
  wu_POLMAG = wu_xyr(xyr_POLMAG)
  call wu_PolmagBoundaryGrid(wu_POLMAG)
  xyr_POLMAG = xyr_wu(wu_POLMAG)

  call check3d(xyr_POLMAG_orig(:,:,1:km), &
    xyr_POLMAG(:,:,1:km), 'test of P_1^0')
  do k=0,km
    do n=1,(nm+1)**2
      nn=nm_l(n)
      wr_n(n,k) = nn(1)
    enddo
  enddo

  wr_TopBoundary = wr_DRad_wu(wu_POLMAG) &
               + (wr_n +1)*wr_wu(wu_POLMAG)/wr_RAD
  wr_SOL = 0.0D0

  call check1d(wr_SOL(:,0), wr_TopBoundary(:,0), 'test of P_1^0')

  call MessageNotify('M','wu_test_polmagbc', &
            'wu_PolmagBoundary test succeeded!')
 !=================== wu_PolmagBoundaryGrid =======================
 ! P_10
 !xyr_POLMAG = sin(xyr_lat) * sin( pi*(xyr_rad-ri)/(ro-ri) )

 ! P_1_1
 !xyr_POLMAG = cos(xyr_lat)*cos(xyr_lon)* sin( pi*(xyr_rad-ri)/(ro-ri) )
  xyr_POLMAG = 2.0d0*sin(xyr_lat)**2 * sin( pi*(xyr_rad-ra)/ra ) * xyr_Rad
  xyr_POLMAG_orig = xyr_POLMAG
  wu_POLMAG = wu_xyr(xyr_POLMAG)
  call wu_PolmagBoundaryGrid(wu_POLMAG)
  xyr_POLMAG = xyr_wu(wu_POLMAG)
  call check3d(xyr_POLMAG_orig(:,:,1:km), xyr_POLMAG(:,:,1:km), 'test of P_1^1')

  do k=0,km
    do n=1,(nm+1)**2
      nn=nm_l(n)
      wr_n(n,k) = nn(1)
    enddo
  enddo

  wr_TopBoundary = wr_DRad_wu(wu_POLMAG) &
                    + (wr_n +1)*wr_wu(wu_POLMAG)/wr_RAD
  wr_SOL = 0.0D0
  call check1d(wr_SOL(:,0), wr_TopBoundary(:,0), 'test of P_1^1')

  call MessageNotify('M','wu_test_polmagbc', &
       'wu_PolmagBoundaryGrid test succeeded!')

contains
  subroutine check3d(sol3, ans3, mess)
    real(8) :: sol3(:,:,:)
    real(8) :: ans3(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans3,                                &
      check              = sol3,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

  subroutine check2d(sol2, ans2, mess)
    real(8) :: sol2(:,:)
    real(8) :: ans2(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans2,                                &
      check              = sol2,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

  subroutine check1d(sol1, ans1, mess)
    real(8) :: sol1(:)
    real(8) :: ans1(:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans1,                                &
      check              = sol1,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d


end program wu_test_polmagbc

