!------------------------------------------------------------------------
! Copyright(c) 2008-2011 SPMODEL Development Group. All rights reserved.!
!------------------------------------------------------------------------
!
!ɽ  wu_module ƥȥץ
!
!      ݥݥƥ󥷥ζ
!
!  2008/01/01  ݹ
!      2008/01/01  ʿ  ν
!      2011/03/11  ʿ dc_test Ѥ褦˽
!
program wu_test_polvelbc

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use wu_module

  implicit none

  integer,parameter  :: im=32, jm=16, km=16  ! ʻ(, , ư)
  integer,parameter  :: nm=10, lm=16         ! ȿ(ʿ, ư)
  real(8),parameter  :: ra=0.5d0             ! Ⱦ

  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Poloidal
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_LaplaPol
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_LaplaPol1
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_True
  real(8), dimension(0:im-1,1:jm,0:km)     :: xyr_Calc
  real(8), dimension((nm+1)**2,0:lm) :: wu_Poloidal
  character(len=1), dimension(2), parameter :: BCond=(/'F','R'/)

  real(8), parameter :: pi=3.1415926535897932385D0
  integer, parameter :: check_digits = 13
  integer, parameter :: ignore = -14

  integer :: l

  call MessageNotify('M','wu_test_polvelbc', &
       'wu_module  wu_LaplaPol2polGrid_wu function tests')

  call wu_initial(im,jm,km,nm,lm,ra)

  do l=1,2
     ! P_10
     xyr_Poloidal = sin(xyr_Lat) * xyr_Rad * ((xyr_Rad-ra)*(xyr_Rad+ra))**2
     xyr_LaplaPol = xyr_wr(wr_Lapla_wu(wu_xyr(xyr_Poloidal)))
     !xyr_LaplaPol = sin(xyr_Lat) * sin( pi*(xyr_Rad-ri)/(ro-ri) )
     ! P_1_1
     !xyr_LaplaPol = cos(xyr_Lat)*cos(xyr_Lon)* xyr_Rad * (xyr_Rad-ra)
     !xyr_LaplaPol = 2*sin(xyr_Lat)**2 * xyr_Rad * (xyr_Rad-ra)

     !xyr_Poloidal = xyr_wz(wr_LaplaPol2pol_wr(wr_xyr(xyr_LaplaPol),BCond(l)))
     !xyr_Poloidal = xyr_wu(wu_LaplaPol2PolTau_wu(wu_xyr(xyr_LaplaPol),BCond(l)))

     wu_Poloidal   = wu_LaplaPol2PolGrid_wu(wu_xyr(xyr_LaplaPol), &
       BCond(l), new=.true.)
     xyr_LaplaPol1 = xyr_wr(wr_Lapla_wu(wu_Poloidal))
     xyr_Poloidal  = xyr_wu(wu_Poloidal)

     !---------------- å -----------------------
     call check3d(xyr_LaplaPol1(:,:,2:km), xyr_LaplaPol(:,:,2:km), &
                'test of internal value')
    !--------- üå ----------
     xyr_True = 0.0d0
     call check2d(xyr_True(:,:,0), xyr_Poloidal(:,:,0), &
       'Polvel = 0.0 at Top Boundary')

    if( BCond(l)(1:1) == 'F' ) then
      xyr_Calc = xyr_wr(wr_DRad2_wu(wu_Poloidal))
    else
      xyr_Calc = xyr_wr(wr_DRad_wu(wu_Poloidal))
    endif

    call check2d(xyr_True(:,:,0), xyr_Calc(:,:,0), &
      Bcond(l)//' at Top Boundary')

  end do

  call MessageNotify('M','wu_test_polvelbc', &
       'wu_module  wu_LaplaPol2polGrid_wu function tests succeeded!')


contains
  subroutine check3d(sol3, ans3, mess)
    real(8) :: sol3(:,:,:)
    real(8) :: ans3(:,:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans3,                                &
      check              = sol3,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check3d

  subroutine check2d(sol2, ans2, mess)
    real(8) :: sol2(:,:)
    real(8) :: ans2(:,:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans2,                                &
      check              = sol2,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check2d

  subroutine check1d(sol1, ans1, mess)
    real(8) :: sol1(:)
    real(8) :: ans1(:)
    character(len=*) :: mess

    call AssertEqual(                                           &
      message            = mess,                                &
      answer             = ans1,                                &
      check              = sol1,                                &
      significant_digits = check_digits, ignore_digits = ignore &
      )
  end subroutine check1d

end program wu_test_polvelbc
