!--
!----------------------------------------------------------------------
! Copyright (c) 2002-2013 SPMODEL Development Group. All rights reserved.
!----------------------------------------------------------------------
!ɽ  wt_mpi_module
!
!    spml/wt_mpi_module ⥸塼ϵ̾太ӵǤήαư
!    ڥȥˡ MPI 󲽤ˤäƿͷ׻뤿 Fortran90 
!    ؿ󶡤ΤǤ. 
!
!    ʿ˵ĴȡѴӾ岼ζɤ򰷤
!    ӥѴѤΥڥȥ׻ΤΤޤޤ
!    ؿ󶡤. 
!
!     wa_mpi_module, wt_module ѤƤ. ǲǤϵĴѴ
!    ӥӥѴΥ󥸥Ȥ ISPACK  Fortran77 
!    ֥롼ѤƤ.
!
!
!  2002/05/19  ݹ  yt_module ⥸塼̾ѹ.
!                            ʻ̤ɬפ뤿. 
!      2002/06/10  ݹ  ݥ뼧춭롼ɲ
!      2002/11/10  ݹ  ¶֤Ǥζ롼ɲ
!      2002/11/24  ݹ  ӥշϤ
!                            ץ饷ղ򤭥롼ɲ
!      2002/11/28  ݹ  VGradV η׻ѹ.
!      2005/01/09  ݹ  msgdmp -> MessageNotify ѹ
!      2005/01/09  ݹ  ٥ȥβžγʬ׻ؿɲ.
!      2005/02/19  ݹ  ȥǴ嶭ˤ®پ
!                             Ϳ褦˥ץɲ
!      2005/02/19  ݹ  ѿ xy_Lon, xy_Lat ɲ
!      2005/03/18  ݹ  ʬʿѴؿɲ
!                            z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
!                            z_InRad_xz, y_IntRad_yz, IntLatRad_yz
!                            IntRad_z 
!                            z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
!                            z_InRad_xz, y_IntRad_yz, IntLatRad_yz
!                            IntRad_z 
!      2005/04/24  ݹ  ڥȥϷ׻롼ɲ
!                            nmz_ToroidalEnergySpectrum_wt
!                            nz_ToroidalEnergySpectrum_wt
!                            nmz_PoloidalEnergySpectrum_wt
!                            nz_PoloidalEnergySpectrum_wt
!                            ѿ» wt_VMiss ɲ
!      2005/07/09  ݹ  OPENMP Ѵ롼б
!      2006/03/03  ݹ  󥵥ߥ
!                            wt_wz, nmz_ToroidalEnergySpectrum_wt,
!                            nmz_PoloidalEnergySpectrum_wt
!      2006/03/08  ݹ  Ȥ RDoc Ѥ˽
!      2006/03/19  ݹ  ѿ³򥳥Ȥɲ
!      2007/08/11  ݹ  ͥ롼ΥȤ
!      2007/09/15  ݹ  ʬ롼ΥȤ
!      2007/11/02  ݹ  ַ׻롼ɲ
!      2007/11/11  ݹ  ؿ֥롼˹ꥹåƳ
!      2007/11/21  ݹ  ֥롼å
!      2008/01/07  ݹ  xyz_RotLon_wt_wt, xyz_RotLat_wt_wt Х
!      2008/01/13  ݹ  wa_initial åƳ
!      2008/05/29  ݹ  MPI 
!      2008/06/11  ݹ  OPENMP åƳ
!      2008/06/11  ݹ  źѹ
!      2009/02/27  ʿ RDoc ѤΥȤ
!      2010/01/07  ʿ  RDoc ѤΥɥȽ, 
!                              include 'mpif.h' -> use mpi
!      2011/09/08  ݹ   Ƚ
!      2011/09/12  ݹ   wt_mpi_Initial  wa_init åƳ
!      2012/05/25  ݹ   wt_QoperatorMPI_wt ɲ
!      2012/08/24  ݹ   wt_LaplaPol2Pol_wt ɲ
!      2013/08/20  ݹ  gnu fortran б
!                             
!
!      ǡ index
!        x :          y :     v : (ʬʻ)     z : ư
!        w : Ĵ´ؿڥȥ
!        n : Ĵ´ؿڥȥ(ʿȿ)
!        m : Ĵ´ؿڥȥ(Ӿȿ)
!        t : ӥմؿڥȥ
!        a : Ǥդμ
!
!        xyz : 3 ʻǡ
!        xvz : 3 ʬʻǡ
!        xy  : ʿ 2 ʻǡ
!        yz  : Ҹ 2 ʻǡ
!        xz  :  2 ʻǡ
!
!        wz  : ʿڥȥư³ʻǡ
!        wt  : ڥȥǡ
!
!++
module wt_mpi_module
  !
  != wt_mpi_module
  !
  ! Authors:: Shin-ichi Takehiro, Youhei SASAKI
  ! Version:: $Id: wt_mpi_module.f90 598 2013-08-20 03:23:44Z takepiro $
  ! Copyright&License:: See COPYRIGHT[link:../../COPYRIGHT]
  !
  !== 
  !
  ! spml/wt_mpi_module ⥸塼ϵ̾太ӵǤήαư
  ! ڥȥˡ MPI 󲽤ˤäƿͷ׻뤿 Fortran90 
  ! ؿ󶡤ΤǤ. 
  !
  ! ʿ˵ĴȡѴӾ岼ζɤ򰷤
  ! ӥѴѤΥڥȥ׻ΤΤޤޤ
  ! ؿ󶡤. 
  !
  !  wt_module, wa_mpi_module ѤƤ. ǲǤϵĴѴ
  ! ӥӥѴΥ󥸥Ȥ ISPACK  Fortran77 
  ! ֥롼ѤƤ.
  !
  !
  !== ؿѿ̾ȷˤĤ
  !
  !=== ̿̾ˡ
  !
  ! * ؿ̾Ƭ(wt_, nmz_, nz_, xyz_, xvz_ wz_, w_, xy_, x_, y_, z_, a_),
  !   ֤ͤη򼨤Ƥ.
  !      wt_ :: ڥȥǡ(ĴȡӥѴ)
  !      nmz_:: ʿڥȥǡ(ȿ n, Ӿȿʬ, ư)
  !      nz_ :: ʿڥȥǡ(ȿ n, ư)
  !     xyz_ :: 3 ʻǡ(١١ư)
  !     xvz_ :: 3 ʬʻǡ(١١ư)
  !      wz_ :: ʿڥȥ, ư³ʻǡ
  !
  ! * ؿ̾δ֤ʸ(DLon, GradLat, GradLat, DivLon, DivLat, Lapla,..)
  !   , δؿκѤɽƤ.
  !
  ! * ؿ̾κǸ (_wt, _xyz, _xvz, _wz_, _w, _xy, _xv, _x, _y, _z, _a) , 
  !   ѿηڥȥǡӳʻǡǤ뤳Ȥ򼨤Ƥ.
  !         _wt :: ڥȥǡ
  !        _xyz :: 3 ʻǡ
  !    _xyz_xyz :: 2 Ĥ3 ʻǡ, ...
  !        _xvz :: 3 ʬʻǡ
  !    _xvz_xvz :: 2 Ĥ3 ʬʻǡ, ...
  !
  !=== ƥǡμ
  !
  ! * xyz : 3 ʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,jm,0:km). 
  !   * im, jm, km Ϥ줾, , ưºɸγʻǤ, 
  !     ֥롼 wt_mpi_Initial ˤƤ餫ꤷƤ.
  !
  ! * xvz : 3 ʬʻǡ(١١ư)
  !   * ѿμȼ real(8), dimension(0:im-1,jc,0:km). 
  !   * im, km Ϥ줾, ưºɸγʻǤ, 
  !   * jc ϤΥץͭٳʻǤ. 
  !     ֥롼 wt_mpi_Initial Ƥ֤ jc ꤵ. 
  !
  ! * wt : ڥȥǡ
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:lm). 
  !   * nm ϵĴȡκȿ, lm ϥӥ¿༰κ缡
  !     Ǥ, ֥롼 wt_mpi_Initial ˤƤ餫ꤷƤ. 
  !   * ʿڥȥǡγǼΤϴؿ l_nm, nm_l ˤäĴ٤
  !     ȤǤ.
  !
  ! * nmz : ʿڥȥǡ¤ 3 .
  !   * ѿμȼ real(8), dimension(0:nm,-nm:nm,0:km). 
  !   *  1 ʿȿ,  2 Ӿȿ,  3 ưºɸɽ. 
  !   * nm ϵĴȡκȿǤ, ֥롼 wt_Initial ˤ
  !     餫ꤷƤ.
  !
  ! * nz : ڥȥǡ¤ 2 .
  !   * ѿμȼ real(8), dimension(0:nm,0:km). 
  !      1 ʿȿɽ. 
  !   * nm ϵĴȡκȿǤ, 
  !     ֥롼 wt_Initial ˤƤ餫ꤷƤ.
  !
  ! * wz : ʿڥȥ, ư³ʻǡ.
  !   * ѿμȼ real(8), dimension((nm+1)*(nm+1),0:km).
  !
  ! * wt_ ǻϤޤؿ֤ͤϥڥȥǡƱ.
  !
  ! * xyz_ ǻϤޤؿ֤ͤ 3 ʻǡƱ.
  !
  ! * xvz_ ǻϤޤؿ֤ͤ 3 ʬʻǡƱ.
  !
  ! * wz_ ǻϤޤؿ֤ͤϿʿڥȥ, ư³ʻǡƱ.
  !
  ! * ڥȥǡФʬκѤȤ, бʻǡ
  !   ʬʤɤѤǡ򥹥ڥȥѴΤȤǤ.
  !
  !
  !== ѿ³
  !
  !====  
  !
  ! wt_mpi_Initial :: ڥȥѴγʻ, ȿ, ΰ礭
  ! 
  !==== ɸѿ
  !
  ! x_Lon, x_Lon_Weight,  ::  ʻɸ()ȽŤߤǼ 1 
  ! y_Lat, y_Lat_Weight   ::  ʻɸ()ȽŤߤǼ 1 
  ! v_Lat, v_Lat_Weight   ::  ʬʻɸ()ȽŤߤǼ 1 
  ! z_Rad, z_Rad_Weight   ::  ʻɸ(Ʊ)ȽŤߤǼ 1 
  ! xyz_Lon, xyz_Lat, xyz_Rad :: ʻǡη١١ưºɸ(X,Y,Z) (ʻǡ 3 )
  ! xvz_Lon, xvz_Lat, xvz_Rad :: ʻǡη١١ưºɸ(X,Y,Z) (ʬʻǡ 3 )
  !
  !==== Ѵ
  !
  ! xyz_wt, wt_xyz :: ڥȥǡ 3 ʻҥǡδ֤Ѵ (Ĵȡ, ӥѴ)
  !
  ! xvz_wt, wt_xvz :: ڥȥǡ 3 ʬʻҥǡδ֤Ѵ (Ĵȡ, ӥѴ)
  !
  ! xyz_wz, wz_xyz :: 3 ʻҥǡȿʿڥȥ롦ư³ʻҥǡȤδ֤Ѵ (Ĵȡ)
  !
  ! xvz_wz, wz_xvz :: 3 ʬʻҥǡȿʿڥȥ롦ư³ʻҥǡȤδ֤Ѵ (Ĵȡ)
  !
  ! wz_wt, wt_wz   :: ڥȥǡȿʿڥȥ롦ư³ʻҥǡȤδ֤Ѵ (ӥѴ)
  !
  ! w_xy, xy_w     :: ڥȥǡ 2 ʿʻҥǡδ֤Ѵ(ĴȡѴ) 
  ! w_xv, xv_w     :: ڥȥǡ 2 ʿʬʻҥǡδ֤Ѵ(ĴȡѴ) 
  !
  ! az_at, at_az   :: ƱʣĹԤ (ӥѴ)ʻҥǡȥӥեǡδ֤Ѵ
  !
  ! l_nm, nm_l     :: ڥȥǡγǼ֤ȿӾȿѴ 
  !
  !==== ʬ
  !
  ! wt_DRad_wt     :: ڥȥǡưʬ/r Ѥ
  ! wt_DivRad_wt   :: ڥȥǡȯưʬ 1 /r^2 /r r^2 = /r + 2/r Ѥ
  !
  ! wt_RotRad_wt   :: ڥȥǡ˲žưʬ 1/r /rr = /r + 1/r Ѥ
  !
  ! wt_Lapla_wt    :: ڥȥǡ˥ץ饷Ѥ
  !
  ! xyz_GradLon_wt :: ڥȥǡ˸۷ʬ 1/rcosա/ߦˤѤ
  ! xvz_GradLon_wt :: ڥȥǡ˸۷ʬ 1/rcosա/ߦˤѤ
  !
  ! xyz_GradLat_wt :: ڥȥǡ˸۷ʬ 1/r/ߦդѤ
  ! xvz_GradLat_wt :: ڥȥǡ˸۷ʬ 1/r/ߦդѤ(ʬʻ)
  ! wt_DivLon_xyz  :: ʻҥǡȯʬ 1/rcosա/ߦˤѤ
  ! wt_DivLon_xvz  :: ʬʻҥǡȯʬ 1/rcosա/ߦˤѤa
  
  ! wt_DivLat_xyz  :: ʻҥǡȯʬ 1/rcosա(g cos)/ߦդѤ
  ! wt_DivLat_xvz  :: ʬʻҥǡȯʬ 1/rcosա(g cos)/ߦդѤ(ʬʻ)
  !
  ! wt_Div_xyz_xyz_xyz  :: ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
  ! wt_Div_xvz_xvz_xvz  :: ٥ȥʬǤ 3 ĤʬʻҥǡȯѤ
  ! xyz_Div_xyz_xyz_xyz :: ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
  ! xvz_Div_xvz_xvz_xvz :: ٥ȥʬǤ 3 ĤʬʻҥǡȯѤ
  ! xyz_RotLon_wt_wt  :: ٥ȥβžηʬ׻
  ! xvz_RotLon_wt_wt  :: ٥ȥβžηʬ׻(ʬʻ)
  ! xyz_RotLat_wt_wt  :: ٥ȥβžΰʬ׻
  ! xvz_RotLat_wt_wt  :: ٥ȥβžΰʬ׻(ʬʻ)
  ! wt_RotRad_xyz_xyz :: ٥ȥβžưʬ׻
  ! wt_RotRad_xvz_xvz :: ٥ȥβžưʬ׻(ʬʻ)
  !
  !==== ȥݥ׻ʬ
  !
  ! wt_KxRGrad_wt   :: ڥȥǡ˷ʬ kr = /ߦˤѤ
  !
  ! xyz_KGrad_wt    :: ڥȥǡ˼ʬ k = cos/r /ߦ + sinբ/r Ѥ
  ! xvz_KGrad_wt    :: ڥȥǡ˼ʬ k = cos/r /ߦ + sinբ/r Ѥ(ʬʻ)
  ! wt_L2_wt        :: ڥȥǡ L2 黻 = -ʿץ饷Ѥ
  !
  ! wt_L2Inv_wt     :: ڥȥǡ L2 黻Ҥε = -տʿץ饷Ѥ
  !
  ! wt_QOperator_wt :: ڥȥǡ˱黻 Q=(k-1/2(L2 k+ kL2)) Ѥ
  ! wt_QOperatorMPI_wt :: ڥȥǡ˱黻 Q=(k-1/2(L2 k+ kL2)) Ѥ(ʬʻ)
  !
  ! wt_RadRot_xyz_xyz :: ٥ȥ v α٤ư¥٥ȥ r  r(v) ׻
  ! wt_RadRot_xvz_xvz :: ٥ȥ v α٤ư¥٥ȥ r  r(v) ׻(ʬʻ)
  ! wt_RadRotRot_xyz_xyz_xyz :: ٥ȥ v  r(ߢv) ׻
  ! wt_RadRotRot_xvz_xvz_xvz :: ٥ȥ v  r(ߢv) ׻(ʬʻ)
  ! wt_Potential2Vector      :: ȥݥݥƥ󥷥뤫٥ȥ׻
  ! wt_Potential2VectorMPI   :: ȥݥݥƥ󥷥뤫٥ȥ׻(ʬʻ)
  !
  ! wt_Potential2Rotation    :: ȥݥݥƥ󥷥ɽȯ٥ȥβžγʬ׻
  ! wt_Potential2RotationMPI :: ȥݥݥƥ󥷥ɽȯ٥ȥβžγʬ׻(ʬʻ)
  !
  !
  !==== ׻
  !
  ! wt_VGradV    ::  ٥ȥ v  vv ׻
  ! wt_VGradVMPI ::  ٥ȥ v  vv ׻(ʬʻ)
  !
  !==== ݥ/ȥǥѥڥȥ
  !
  ! nmz_ToroidalEnergySpectrum_wt, :: ȥݥƥ󥷥뤫饨ͥ륮
  ! nz_ToroidalEnergySpectrum_wt   :: Ĵȡʬ׻
  ! 
  ! nmz_PoloidalEnergySpectrum_wt, :: ݥݥƥ󥷥뤫饨ͥ륮
  ! nz_PoloidalEnergySpectrum_wt   :: Ĵȡʬ׻
  !
  !==== 
  !
  ! wt_BoundariesTau,    :: ǥꥯ, Υޥ󶭳ŬѤ 
  ! wt_BoundariesGrid,   ::(ˡ, ˡ)
  ! wt_Boundaries        ::
  !
  ! wt_TorBoundariesTau,  :: ®٥ȥݥƥ󥷥ζ
  ! wt_TorBoundariesGrid, :: ŬѤ(ˡ,ˡ)            
  ! wt_TorBoundaries      ::
  !
  ! wz_LaplaPol2Pol_wz,   :: ®٥ݥݥƥ󥷥릵^2
  ! wt_LaplaPol2Pol_wt    ::  (Ϥ줾ӥճʻ,
  !                       :: ӥշ)
  !
  ! wt_TorMagBoundariesTau,  :: ȥݥƥ󥷥ζ
  ! wt_TorMagBoundariesGrid, :: ŬѤ(ˡ, ˡ)
  ! wt_TorMagBoundaries      ::
  !
  ! wt_PolMagBoundariesTau,  :: ȥݥƥ󥷥붭ζ
  ! wt_PolMagBoundariesGrid, :: ŬѤ(ˡ, ˡ)
  ! wt_PolMagBoundaries      ::                                         
  !
  !==== ʬʿ(3 ǡ)
  !
  ! IntLonLatRad_xyz, AvrLonLatRad_xyz :: 3 ʻǡΰʬʿ
  !
  ! z_IntLonLat_xyz, z_AvrLonLat_xyz :: 3 ʻǡΰٷ(ʿ)ʬʿ               
  !
  ! y_IntLonRad_xyz, y_AvrLonRad_xyz :: 3 ʻǡΰưʬʿ
  !
  ! z_IntLatRad_xyz, z_AvrLatRad_xyz :: 3 ʻǡηư(Ҹ)ʬʿ              
  !
  ! yz_IntLon_xyz, yz_AvrLon_xyz :: 3 ʻǡηʬʿ
  ! xz_IntLat_xyz, xz_AvrLat_xyz :: 3 ʻǡΰʬʿ
  ! xz_IntRad_xyz, xz_AvrRad_xyz :: 3 ʻǡưʬʿ
  !
  ! IntLonLatRad_xvz, AvrLonLatRad_xvz :: 3 ʻǡΰʬʿ
  !
  ! z_IntLonLat_xvz, z_AvrLonLat_xvz :: 3 ʻǡΰٷ(ʿ)ʬʿ               
  !
  ! v_IntLonRad_xvz, v_AvrLonRad_xvz :: 3 ʻǡΰưʬʿ
  !
  ! z_IntLatRad_xvz, z_AvrLatRad_xvz :: 3 ʻǡηư(Ҹ)ʬʿ              
  !
  ! vz_IntLon_xvz, vz_AvrLon_xvz :: 3 ʻǡηʬʿ
  ! xz_IntLat_xvz, xz_AvrLat_xvz :: 3 ʻǡΰʬʿ
  ! xy_IntRad_xvz, xy_AvrRad_xvz :: 3 ʻǡưʬʿ
  !
  !==== ʬʿ(2 ǡ)
  !
  ! IntLonLat_xy, AvrLonLat_xy :: 2 ʻǡοʿ()ʬʿ
  ! IntLonRad_xz, AvrLonRad_xz :: 2 (XZ)ʻǡηưʬ
  !                            :: ʿ
  ! IntLatRad_yz, AvrLatRad_yz :: 2 (YZ)ʻǡΰư(Ҹ)
  !                            :: ʬʿ 
  ! y_IntLon_xy, y_AvrLon_xy   :: ʿ 2 ()ʻǡη
  !                            :: ʬʿ
  ! x_IntLat_xy, x_AvrLat_xy   :: ʿ2 ()ʻǡΰʬ
  !                            :: ʿ
  ! z_IntLon_xz, z_AvrLon_xz   :: 2 (XZ)ʻǡηʬ
  !                            :: ʿ
  ! x_IntRad_xz, x_AvrRad_xz   :: 2 (XZ)ʻǡưʬ
  !                            :: ʿ
  ! z_IntLat_yz, z_AvrLat_yz   :: 2 (YZ)ʻǡΰʬ
  !                            :: ʿ
  ! y_IntRad_yz, y_AvrRad_yz   :: 2 (YZ)ʻǡưʬ
  !                            :: ʿ                  
  !
  ! IntLonLat_xv, AvrLonLat_xv :: 2 ʻǡοʿ()ʬʿ
  ! IntLonRad_xz, AvrLonRad_xz :: 2 (XZ)ʻǡηưʬ
  !                            :: ʿ
  ! IntLatRad_vz, AvrLatRad_vz :: 2 (YZ)ʻǡΰư(Ҹ)
  !                            :: ʬʿ 
  ! v_IntLon_xv, v_AvrLon_xv   :: ʿ 2 ()ʻǡη
  !                            :: ʬʿ
  ! v_IntLat_xv, x_AvrLat_xv   :: ʿ2 ()ʻǡΰʬ
  !                            :: ʿ
  ! z_IntLon_xz, z_AvrLon_xz   :: 2 (XZ)ʻǡηʬ
  !                            :: ʿ
  ! x_IntRad_xz, x_AvrRad_xz   :: 2 (XZ)ʻǡưʬ
  !                            :: ʿ
  ! z_IntLat_vz, z_AvrLat_vz   :: 2 (YZ)ʻǡΰʬ
  !                            :: ʿ
  ! v_IntRad_vz, v_AvrRad_vz   :: 2 (YZ)ʻǡưʬ
  !                            :: ʿ                  
  !
  !==== ʬʿ(1 ǡ)
  !
  ! IntLon_x, AvrLon_x  :: 1 (X)ʻǡηʬʿ
  ! IntLat_y, AvrLat_y  :: 1 (Y)ʻǡΰʬʿ
  ! IntRad_z, AvrRad_z  :: 1 (Z)ʻǡưʬʿ
  !
  ! IntLat_v, AvrLat_v  :: 1 (Y)ʻǡΰʬʿ
  !
  !==== ַ׻
  !
  ! Interpolate_wt :: ڥȥǡǤդ֤ͤ. 
  ! 
  use dc_message
  use lumatrix
  use mpi
  use w_base_mpi_module
  use w_deriv_mpi_module
  use w_integral_mpi_module
  use wa_base_mpi_module
  use wa_deriv_mpi_module
  use wt_module

  implicit none
  integer :: ierr

  private

  public wt_mpi_Initial
  public jc

  public x_Lon, x_Lon_Weight
  public y_Lat, y_Lat_Weight
  public v_Lat, v_Lat_Weight
  public z_Rad, z_Rad_Weight
  public l_nm, nm_l
  public xy_Lon, xy_Lat
  public xv_Lon, xv_Lat
  public xyz_Lon, xyz_Lat, xyz_Rad
  public xvz_Lon, xvz_Lat, xvz_Rad
  public wz_Rad
  public wt_VMiss

  public w_xy, xy_w
  public w_xv, xv_w
  public at_Dr_at, t_Dr_t, az_at, at_az
  public xyz_wt, wt_xyz, xyz_wz, wz_xyz, wz_wt, wt_wz
  public xvz_wt, wt_xvz, xvz_wz, wz_xvz
  public wt_DRad_wt, wt_DivRad_wt, wt_RotRad_wt, wt_Lapla_wt
  public xyz_GradLon_wt, xyz_Gradlat_wt
  public xvz_GradLon_wt, xvz_Gradlat_wt
  public wt_DivLon_xyz, wt_DivLat_xyz
  public wt_DivLon_xvz, wt_DivLat_xvz
  public wt_Div_xyz_xyz_xyz, xyz_Div_xyz_xyz_xyz
  public wt_Div_xvz_xvz_xvz, xvz_Div_xvz_xvz_xvz
  public xyz_RotLon_wt_wt, xyz_RotLat_wt_wt, wt_RotRad_xyz_xyz
  public xvz_RotLon_wt_wt, xvz_RotLat_wt_wt, wt_RotRad_xvz_xvz

  public yz_IntLon_xyz, xz_IntLat_xyz, xy_IntRad_xyz
  public x_IntLatRad_xyz, y_IntLonRad_xyz, z_IntLonLat_xyz
  public IntLonLatRad_xyz

  public vz_IntLon_xvz, xz_IntLat_xvz, xv_IntRad_xvz
  public x_IntLatRad_xvz, v_IntLonRad_xvz, z_IntLonLat_xvz
  public IntLonLatRad_xvz

  public x_IntLat_xy, y_IntLon_xy, IntLonLat_xy
  public z_IntLat_yz, y_IntRad_yz, IntLatRad_yz
  public z_IntLon_xz, x_IntRad_xz, IntLonRad_xz
  public IntLon_x, IntLat_y, IntRad_z

  public x_IntLat_xv, v_IntLon_xv, IntLonLat_xv
  public z_IntLat_vz, v_IntRad_vz, IntLatRad_vz
  public IntLat_v

  public yz_AvrLon_xyz, xz_AvrLat_xyz, xy_AvrRad_xyz
  public x_AvrLatRad_xyz, y_AvrLonRad_xyz, z_AvrLonLat_xyz
  public AvrLonLatRad_xyz

  public vz_AvrLon_xvz, xz_AvrLat_xvz, xv_AvrRad_xvz
  public x_AvrLatRad_xvz, v_AvrLonRad_xvz, z_AvrLonLat_xvz
  public AvrLonLatRad_xvz

  public x_AvrLat_xy, y_AvrLon_xy, AvrLonLat_xy
  public z_AvrLat_yz, y_AvrRad_yz, AvrLatRad_yz
  public z_AvrLon_xz, x_AvrRad_xz, AvrLonRad_xz
  public AvrLon_x, AvrLat_y, AvrRad_z

  public x_AvrLat_xv, v_AvrLon_xv, AvrLonLat_xv
  public z_AvrLat_vz, v_AvrRad_vz, AvrLatRad_vz
  public AvrLat_v

  public wt_KxRGrad_wt, xyz_KGrad_wt, xvz_KGrad_wt
  public wt_L2_wt, wt_L2Inv_wt, wt_QOperator_wt, wt_QOperatorMPI_wt
  public wt_RadRot_xyz_xyz, wt_RadRotRot_xyz_xyz_xyz
  public wt_RadRot_xvz_xvz, wt_RadRotRot_xvz_xvz_xvz
  public wt_Potential2vector, wt_Potential2Rotation
  public wt_Potential2vectorMPI, wt_Potential2RotationMPI
  public wt_VGradV
  public wt_VGradVMPI

  public Interpolate_wt

  public nmz_ToroidalEnergySpectrum_wt, nz_ToroidalEnergySpectrum_wt
  public nmz_PoloidalEnergySpectrum_wt, nz_PoloidalEnergySpectrum_wt

  public wt_Boundaries, wt_TorBoundaries
  public wt_LaplaPol2Pol_wt, wz_LaplaPol2Pol_wz
  public wt_TormagBoundaries, wt_PolmagBoundaries

  public wt_BoundariesTau, wt_TorBoundariesTau, wt_LaplaPol2PolTau_wt
  public wt_TormagBoundariesTau, wt_PolmagBoundariesTau

  public wt_BoundariesGrid, wt_TorBoundariesGrid, wt_LaplaPol2PolGrid_wt
  public wt_TormagBoundariesGrid, wt_PolmagBoundariesGrid

  integer            :: im=64, jm=32, km=16  ! ʻ(, , ư)
  integer            :: nm=21, lm=16         ! ȿ(ʿ, ư)
  real(8)            :: ri=0.0, ro=1.0       ! ⳰Ⱦ
  real(8), parameter :: pi=3.1415926535897932385D0

  real(8), dimension(:,:,:), allocatable :: xvz_LON, xvz_LAT, xvz_RAD ! ɸ

  save im, jm, km, nm, lm, ri, ro

  contains
  !---------------  -----------------
   subroutine wt_mpi_Initial(i,j,k,n,l,r_in,r_out,np,wa_init)
     !
     ! ڥȥѴγʻ, ȿ, ưºɸϰϤꤹ.
     !
     ! ¾δؿƤ, ǽˤΥ֥롼Ƥǽ
     ! ʤФʤʤ. 
     !
     integer,intent(in) :: i              ! ʻ(٦)
     integer,intent(in) :: j              ! ʻ(٦)
     integer,intent(in) :: k              ! ʻ(ư r)
     integer,intent(in) :: n              ! ȿ(ʿȿ)
     integer,intent(in) :: l              ! ȿ(ưȿ)

     real(8),intent(in) :: r_in           ! Ⱦ
     real(8),intent(in) :: r_out          ! ̳Ⱦ

     integer,intent(in), optional :: np   ! OPENMP Ǥκ祹åɿ
     logical,intent(in), optional :: wa_init   ! wa_initial å

     logical    :: wa_initialize=.true.   ! wa_initial å

     im = i  ; jm = j ; km = k
     nm = n  ; lm = l
     ri = r_in ; ro = r_out

     if ( present(wa_init) ) then
        wa_initialize = wa_init
     else
        wa_initialize = .true.
     endif

     if ( present(np) ) then
        call wt_Initial(im,jm,km,nm,lm,ri,ro,np=np,wa_init=wa_initialize)
     else
        call wt_Initial(im,jm,km,nm,lm,ri,ro,wa_init=wa_initialize)
     endif
     if ( wa_initialize ) then
        call w_base_mpi_Initial
        call w_deriv_mpi_Initial
        call wa_base_mpi_Initial
     endif

     allocate(xvz_Lon(0:im-1,jc,0:km))
     allocate(xvz_Lat(0:im-1,jc,0:km))
     allocate(xvz_Rad(0:im-1,jc,0:km))

     xvz_Lon = spread(xv_Lon,3,km+1)
     xvz_Lat = spread(xv_Lat,3,km+1)
     xvz_Rad = spread(spread(z_Rad,1,jc),1,im)

     call MessageNotify('M','wt_mpi_initial', &
          'wt_mpi_module (2013/08/20) is initialized')

   end subroutine wt_mpi_Initial

  !--------------- Ѵ -----------------

    function xvz_wt(wt)
      !
      ! ڥȥǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_wt
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      xvz_wt = xva_wa(wz_wt(wt))

    end function xvz_wt

    function wt_xvz(xvz)
      !
      ! 3 ʻǡ饹ڥȥǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_xvz
      !(out) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,jc,0:km), intent(in)         :: xvz
      !(in) 3 ٰư³ʻǡ

      wt_xvz = wt_wz(wa_xva(xvz))

    end function wt_xvz

    function xvz_wz(wz)
      !
      ! ʿڥȥ롦ư³ʻǡ 3 ʻǡ()Ѵ.
      !
      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_wz
      !(out) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:km), intent(in) :: wz
      !(in) 2 Ĵȡڥȥ롦ư³ʻǡ

      xvz_wz = xva_wa(wz)

    end function xvz_wz

    function wz_xvz(xvz)
      !
      ! 3 ʻҥǡʿڥȥ롦ư³ʻǡ()Ѵ.
      !
      real(8), dimension((nm+1)*(nm+1),0:km)             :: wz_xvz
      !(out) 2 Ĵȡڥȥ롦ư³ʻǡ

      real(8), dimension(0:im-1,jc,0:km), intent(in)         :: xvz
      !(in) 3 ٰư³ʻǡ

      wz_xvz = wa_xva(xvz)

    end function wz_xvz

  !--------------- ʬ׻ -----------------
    function xvz_GradLon_wt(wt)
      !
      ! ڥȥǡ˸۷ʬ 1/rcosա/ߦ
      ! Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_GradLon_wt
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xvz_GradLon_wt = xva_GradLon_wa(wz_wt(wt))/xvz_Rad

    end function xvz_GradLon_wt

    function xvz_GradLat_wt(wt) 
      !
      ! ڥȥǡ˸۷ʬ 1/r /ߦ Ѥ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_GradLat_wt
      !(out) ۷ʬѤ줿 2 ڥȥǡ

      xvz_GradLat_wt = xva_GradLat_wa(wz_wt(wt))/xvz_Rad
    end function xvz_GradLat_wt

    function wt_DivLon_xvz(xvz)
      ! 
      ! ʻǡȯʬ 1/rcosա/ߦ Ѥ
      ! ڥȥǡ֤.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in)   :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLon_xvz
      !(out) ȯʬѤ줿 2 ڥȥǡ

      wt_DivLon_xvz = wt_wz(wa_DivLon_xva(xvz/xvz_Rad))
    end function wt_DivLon_xvz

    function wt_DivLat_xvz(xvz)
      !
      ! ʻҥǡȯʬ 1/rcosա(f cos)/ߦ 
      ! Ѥڥȥǡ֤.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in)   :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)       :: wt_DivLat_xvz
      !(out) ȯʬѤ줿 2 ڥȥǡ

      wt_DivLat_xvz = wt_wz(wa_divlat_xva(xvz/xvz_Rad))
    end function wt_DivLat_xvz

    function wt_Div_xvz_xvz_xvz(xvz_Vlon,xvz_Vlat,xvz_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ
      ! ڥȥǡ֤.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ, ȯ 
      !
      !      1/rcosաu/ߦ + 1/rcosա(v cos)/ߦ 
      !    + 1/r^2 /r (r^2 w)
      !
      ! ȷ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_Div_xvz_xvz_xvz
      !(out) ٥ȥȯ

      wt_Div_xvz_xvz_xvz =   wt_DivLon_xvz(xvz_Vlon) &
                           + wt_DivLat_xvz(xvz_Vlat) &
                           + wt_DivRad_wt(wt_xvz(xvz_Vrad))

    end function wt_Div_xvz_xvz_xvz

    function xvz_Div_xvz_xvz_xvz(xvz_Vlon,xvz_Vlat,xvz_Vrad)
      !
      ! ٥ȥʬǤ 3 ĤγʻҥǡȯѤ.
      !
      !  1, 2 ,3 (u,v,w)줾٥ȥηʬ, ʬ, 
      ! ưʬɽ.
      !
      ! ˤð򤹤뤿˥٥ȥ cos/r νŤߤ򤫤
      ! ׻Ƥ. 
      !
      !      div V = (r/cos)div (Vcos/r) + V_tan/r + V_r/r
      ! 
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,jc,0:km)             :: xvz_Div_xvz_xvz_xvz
      !(out) ٥ȥȯ

      xvz_Div_xvz_xvz_xvz &
           = xvz_Rad/cos(xvz_Lat) &
                * xvz_wt(wt_Div_xvz_xvz_xvz(xvz_VLon*cos(xvz_Lat)/xvz_Rad,  &
                                            xvz_VLat*cos(xvz_Lat)/xvz_Rad,  &
                                            xvz_VRad*cos(xvz_Lat)/xvz_Rad ))&
             + xvz_VLat*tan(xvz_Lat)/xvz_Rad &
             + xvz_VRad/xvz_Rad

    end function xvz_Div_xvz_xvz_xvz

    function xvz_RotLon_wt_wt(wt_Vrad,wt_Vlat) 
      !
      ! ٥ȥưʬ, ʬǤ 1, 2  Vrad, Vlat 
      ! žηʬ 
      !
      !    1/r Vrad/ߦ-1/r (r Vlat)/r ׻.
      !
      ! ׻
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_RotLon_wt_wt
      !(out) ٥ȥβžηʬ

        xvz_RotLon_wt_wt =   xvz_GradLat_wt(wt_Vrad) &
                           - xvz_wt(wt_RotRad_wt(wt_Vlat))

    end function xvz_RotLon_wt_wt

    function xvz_RotLat_wt_wt(wt_Vlon,wt_Vrad) 
      !
      ! ٥ȥηʬ, ưʬǤ 1, 2  Vlon, Vrad 
      ! žΰʬ 
      !
      !    1/r (r Vlon)/r - 1/rcosաVrad/ߦ
      !
      ! ׻.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_Vrad
      !(in) ٥ȥưʬ

      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_RotLat_wt_wt
      !(out) ٥ȥβžΰʬ

        xvz_RotLat_wt_wt =   xvz_wt(wt_RotRad_wt(wt_Vlon)) &
                           - xvz_GradLon_wt(wt_Vrad) 

    end function xvz_RotLat_wt_wt

    function wt_RotRad_xvz_xvz(xvz_Vlat,xvz_Vlon) 
      !
      ! ٥ȥΰʬ, ʬǤ 1, 2  Vlat, Vlon Ф
      ! ٥ȥβžưʬ 
      !
      !    1/rcosաVlat/ߦ - 1/rcosա(Vlon cos)/ߦ
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlat
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_Vlon
      !(in) ٥ȥηʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RotRad_xvz_xvz
      !(out) ٥ȥβžưʬ

        wt_RotRad_xvz_xvz =   wt_DivLon_xvz(xvz_Vlat) &
                            - wt_DivLat_xvz(xvz_Vlon)

    end function wt_RotRad_xvz_xvz

  !--------------- ݥ/ȥǥʬ -----------------

    function xvz_KGrad_wt(wt)    ! k = cos/r /ߦ + sinբ/r
      !
      ! ϥڥȥǡбʻҥǡ˼ʬ 
      !
      !    k = cos/r /ߦ + sinբ/r 
      !
      ! Ѥʻҥǡ֤. 
      ! ǥ٥ȥ k ϵ濴̶˸ñ̥٥ȥǤ.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension(0:im-1,jc,0:km)                     :: xvz_KGrad_wt
      !(out) ʬѤ줿 2 ڥȥǡ

      xvz_KGrad_wt =  cos(xvz_Lat)*xvz_GradLat_wt(wt) &
                    + sin(xvz_Lat)*xvz_wt(wt_Drad_wt(wt))
    end function xvz_KGrad_wt

    function wt_QOperatorMPI_wt(wt)
      !
      ! ϥڥȥǡбʻǡ˱黻
      !
      !    Q=(k-1/2(L2 k+ kL2))
      !
      ! ѤǡΥڥȥѴ֤.
      !
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt
      !(in) 2 Ĵȡӥեڥȥǡ

      real(8), dimension((nm+1)*(nm+1),0:lm)             :: wt_QOperatorMPI_wt
      !(out) Q 黻ҤѤ줿 2 ڥȥǡ

      wt_QOperatorMPI_wt = &
             wt_xvz(xvz_KGrad_wt(wt) - xvz_KGrad_wt(wt_L2_wt(wt))/2) &
           - wt_L2_wt(wt_xvz(xvz_KGrad_wt(wt)))/2

    end function wt_QOperatorMPI_wt

    function wt_RadRot_xvz_xvz(xvz_VLON,xvz_VLAT)  ! r(v)
      !
      ! ٥ȥα٤ư¥٥ȥ r(v) ׻.
      !
      !  1, 2 (v[], v[])줾٥ȥηʬ, ʬɽ.
      !
      !    r(v) = 1/cosաv[]/ߦ - 1/cosա(v[] cos)/ߦ
      !
      ! Υڥȥ ǡ֤.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRot_xvz_xvz
      !(out) ٥ȥα٤ư¥٥ȥ

      wt_RadRot_xvz_xvz = wt_wz(wa_DivLon_xva(xvz_VLAT) &
                                - wa_DivLat_xva(xvz_VLON))
      
    end function wt_RadRot_xvz_xvz

    function wt_RadRotRot_xvz_xvz_xvz(xvz_VLON,xvz_VLAT,xvz_VRAD) 
      ! 
      ! ٥ȥ v Ф r(ߢv) ׻.
      !
      !  1, 2, 3 (v[], v[], v[r])줾٥ȥηʬ, 
      ! ʬ, ưʬɽ. 
      !
      !    r(ߢv)  = 1/r /r (r( 1/cosաv[]/ߦ 
      !                                  + 1/cosա(v[] cos)/ߦ ) ) 
      !                     + L^2 v[r]/r 
      !
      ! Υڥȥǡ֤.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_VLON
      !(in) ٥ȥηʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_VLAT
      !(in) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz_VRAD
      !(in) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm)     :: wt_RadRotRot_xvz_xvz_xvz
      !(out) ٥ȥ v  r(ߢv) 

      wt_RadRotRot_xvz_xvz_xvz = &
               wt_RotRad_wt(wt_wz( &
                   (wa_DivLon_xva(xvz_VLON)+ wa_DivLat_xva(xvz_VLAT)))) &
             + wt_L2_wt(wt_xvz(xvz_VRAD/xvz_RAD))

    end function wt_RadRotRot_xvz_xvz_xvz

    subroutine wt_Potential2VectorMPI(&
         xvz_VLON,xvz_VLAT,xvz_VRAD,wt_TORPOT,wt_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! γʬ׻
      !
      real(8), dimension(0:im-1,jc,0:km)     :: xvz_VLON
      !(out) ٥ȥηʬ

      real(8), dimension(0:im-1,jc,0:km)     :: xvz_VLAT
      !(out) ٥ȥΰʬ

      real(8), dimension(0:im-1,jc,0:km)     :: xvz_VRAD
      !(out) ٥ȥưʬ

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      xvz_VLON =   xvz_RAD * xvz_GradLat_wt(wt_TORPOT) &
                 + xva_GradLon_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xvz_VLAT = - xvz_RAD * xvz_GradLon_wt(wt_TORPOT) &
                 + xva_GradLat_wa(wz_wt(wt_RotRad_wt(wt_POLPOT)))
      xvz_VRAD = xvz_wt(wt_L2_wt(wt_POLPOT))/xvz_RAD

    end subroutine wt_Potential2VectorMPI

    subroutine wt_Potential2RotationMPI(&
       xvz_RotVLON,xvz_RotVLAT,xvz_RotVRAD,wt_TORPOT,wt_POLPOT)
      !
      ! ȥݥݥƥ󥷥릷,ɽȯ٥ȥ
      !
      !     v = x(r) + xx(r) 
      !
      ! Ф, βž
      !
      !     xv = xx(r) + xxx(r) = xx(r) - x((^2)r)
      !
      ! ׻. 
      
      ! ٥ȥβž
      real(8), dimension(0:im-1,jc,0:km), intent(OUT) :: xvz_RotVLON
      !(out) žηʬ

      real(8), dimension(0:im-1,jc,0:km), intent(OUT) :: xvz_RotVLAT
      !(out) žΰʬ

      real(8), dimension(0:im-1,jc,0:km), intent(OUT) :: xvz_RotVRAD
      !(out) žưʬ

      ! ϥ٥ȥɽݥƥ󥷥
      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_TORPOT
      !(in) ȥݥƥ󥷥

      real(8), dimension((nm+1)*(nm+1),0:lm), intent(in) :: wt_POLPOT
      !(in) ݥݥƥ󥷥

      call wt_Potential2VectorMPI( &
           xvz_RotVLON,xvz_RotVLAT,xvz_RotVRAD, &
           -wt_Lapla_wt(wt_POLPOT), wt_TORPOT)

    end subroutine wt_Potential2RotationMPI

 !------------------- ׻ ----------------------
    subroutine wt_VGradVMPI(xvz_VGRADV_LON,xvz_VGRADV_LAT,xvz_VGRADV_RAD, &
                            xvz_VLON,xvz_VLAT,xvz_VRAD )
      !
      ! ٥ȥ vv ׻.
      !
      ! ٥ȥ v=(v[],v[],v[r]) Фvvγʬ
      ! Τ褦˷׻.
      !
      !   (vv)[] = (v[]v) + v[]v[r]/r - v[]v[]tan()/r
      !   (vv)[] = (v[]v) + v[]v[r]/r - v[]^2tan()/r
      !   (vv)[r] = (v[r]v) + (v[]^2+v[]^2)/r
      !
      ! ȯ®پФƤϥݥƥ󥷥뤫 wt_Potential2Rotation 
      ! ѤƲž׻,  vv = (v[2^/2) - vxxv 
      ! Ѥ褤.
      !
      real(8), dimension(0:im-1,jc,0:km),intent(out)   :: xvz_VGRADV_LON
      !(out) (vv) ʬ

      real(8), dimension(0:im-1,jc,0:km),intent(out)   :: xvz_VGRADV_LAT
      !(out) (vv) ʬ

      real(8), dimension(0:im-1,jc,0:km),intent(out)   :: xvz_VGRADV_RAD
      !(out) (vv) ưʬ

      real(8), dimension(0:im-1,jc,0:km),intent(in)    :: xvz_VLON
      !(in) ٥ȥ v ηʬ

      real(8), dimension(0:im-1,jc,0:km),intent(in)    :: xvz_VLAT
      !(in) ٥ȥ v ΰʬ

      real(8), dimension(0:im-1,jc,0:km),intent(in)    :: xvz_VRAD
      !(in) ٥ȥ v ưʬ

      xvz_VGRADV_LON = &
              xvz_Div_xvz_xvz_xvz( &
                  xvz_VLON * xvz_VLON, xvz_VLON*xvz_VLAT, xvz_VLON*xvz_VRAD ) &
            + xvz_VLON*xvz_VRAD/xvz_RAD              &
            - xvz_VLON*xvz_VLAT*tan(xvz_LAT)/xvz_RAD 

      xvz_VGRADV_LAT = &
              xvz_Div_xvz_xvz_xvz( &
                  xvz_VLAT*xvz_VLON, xvz_VLAT*xvz_VLAT, xvz_VLAT*xvz_VRAD ) &
            + xvz_VLAT*xvz_VRAD/xvz_RAD        &
            + xvz_VLON**2*tan(xvz_LAT)/xvz_RAD 

      xvz_VGRADV_RAD = &
              xvz_Div_xvz_xvz_xvz( &
                  xvz_VRAD*xvz_VLON, xvz_VRAD*xvz_VLAT, xvz_VRAD*xvz_VRAD ) &
            - (xvz_VLON**2 + xvz_VLAT**2)/xvz_RAD 

    end subroutine wt_VGradVMPI

  !--------------- ʬ׻ -----------------
    !----(ϥǡ xvz)---
    function vz_IntLon_xvz(xvz)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʬ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(jc,0:km)  :: vz_IntLon_xvz
      !(out) (Ӿ)ʬ줿 2 Ҹ̳ʻǡ

      integer :: i

      vz_IntLon_xvz = 0.0d0
      do i=0,im-1
         vz_IntLon_xvz(:,:) = vz_IntLon_xvz(:,:) &
                       + xvz(i,:,:) * x_Lon_Weight(i)
      enddo
    end function vz_IntLon_xvz

    function xz_IntLat_xvz(xvz)
      !
      ! 3 ʻǡΰʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) cos d ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,0:km)  :: xz_IntLat_xvz        ! ٱ߳ʻǡ
      !(out) ʬ줿 2 ư³ʻǡ

      real(8), dimension(0:im-1,0:km)  :: xz_IntLatTMP
      integer :: j

      xz_IntLat_xvz = 0.0d0
      do j=1,jc
         xz_IntLat_xvz(:,:) = xz_IntLat_xvz(:,:) &
                       + xvz(:,j,:) * v_Lat_Weight(j)
      enddo
      xz_IntLatTmp=xz_IntLat_xvz
      CALL MPI_ALLREDUCE(xz_IntLatTMP,xz_IntLat_xvz,im*(km+1),MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function xz_IntLat_xvz

    function xv_IntRad_xvz(xvz)  ! ưʬ
      !
      ! 3 ʻǡưʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2dr ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,jc)  :: xv_IntRad_xvz
      !(out) ưʬ줿 2 ٰ(ʿ, )ʻǡ

      integer :: k

      xv_IntRad_xvz = 0.0d0
      do k=0,km
         xv_IntRad_xvz(:,:) = xv_IntRad_xvz(:,:) &
                       + xvz(:,:,k) * z_Rad_Weight(k) 
      enddo
    end function xv_IntRad_xvz

    function x_IntLatRad_xvz(xvz)
      !
      ! 3 ʻǡΰư(Ҹ)ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRad_xvz
      !(out) ư(Ҹ)ʬ줿 1 ٳʻǡ

      real(8), dimension(0:im-1)     :: x_IntLatRadTMP
      integer :: j, k

      x_IntLatRad_xvz = 0
      do k=0,km
         do j=1,jc
            x_IntLatRad_xvz = x_IntLatRad_xvz &
                 + xvz(:,j,k) * v_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo

      x_IntLatRadTmp=x_IntLatRad_xvz
      CALL MPI_ALLREDUCE(x_IntLatRadTMP,x_IntLatRad_xvz,im,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function x_IntLatRad_xvz

    function v_IntLonRad_xvz(xvz)
      !
      ! 3 ʻǡηư(ٱ)ʬ.
      !
      ! 3 ǡ f(,,r) ФƢf(,,r) r^2ddr ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(jc)       :: v_IntLonRad_xvz
      !(out) ư(ٱ)ʬ줿 1 ٳʻǡ

      integer :: i, k

      v_IntLonRad_xvz = 0
      do k=0,km
         do i=0,im-1
            v_IntLonRad_xvz = v_IntLonRad_xvz &
                 + xvz(i,:,k) * x_Lon_Weight(i) * z_Rad_Weight(k)
         enddo
      enddo
    end function v_IntLonRad_xvz

    function z_IntLonLat_xvz(xvz)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:km)     :: z_IntLonLat_xvz
      !(out) ٷ(ʿ, )ʬ줿 1 ư³ʻǡ

      real(8), dimension(0:km)     :: z_IntLonLatTMP
      integer :: i, j

      z_IntLonLat_xvz = 0
      do j=1,jc
         do i=0,im-1
            z_IntLonLat_xvz = z_IntLonLat_xvz &
                 + xvz(i,j,:) * x_Lon_Weight(i) * v_Lat_Weight(j)
         enddo
      enddo

      z_IntLonLatTmp=z_IntLonLat_xvz
      CALL MPI_ALLREDUCE(z_IntLonLatTMP,z_IntLonLat_xvz,km+1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function z_IntLonLat_xvz

    function IntLonLatRad_xvz(xvz) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2cos dddr 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz 
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: IntLonLatRad_xvz 
      !(out) ʬ

      real(8)                     :: IntLonLatRadTMP
      integer :: i, j, k

      IntLonLatRad_xvz = 0
      do k=0,km
         do j=1,jc
            do i=0,im-1
               IntLonLatRad_xvz = IntLonLatRad_xvz &
                    + xvz(i,j,k) * x_Lon_Weight(i) &
                         * v_Lat_Weight(j) * z_Rad_Weight(k)
            enddo
         enddo
      enddo

      IntLonLatRadTmp=IntLonLatRad_xvz
      CALL MPI_ALLREDUCE(IntLonLatRadTMP,IntLonLatRad_xvz,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntLonLatRad_xvz

    !----(ϥǡ vz)---
    function z_IntLat_vz(vz)  ! ʬ
      !
      ! 2 (VZ)ʻǡΰʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) cos d ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(0:km)  :: z_IntLat_vz
      !(out) ʬ줿 1 ư³ʻǡ

      real(8), dimension(0:km)  :: z_IntLatTMP
      integer :: j

      z_IntLat_vz = 0.0d0
      do j=1,jc
         z_IntLat_vz(:) = z_IntLat_vz(:) + vz(j,:) * v_Lat_Weight(j)
      enddo
      z_IntLatTmp=z_IntLat_vz
      CALL MPI_ALLREDUCE(z_IntLatTMP,z_IntLat_vz,km+1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function z_IntLat_vz

    function v_IntRad_vz(vz)  ! ưʬ
      !
      ! 2 (VZ)ʻǡưʬ.
      !
      ! 2 ǡ f(,r) ФƢf(,r) r^2dr ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(jc)  :: v_IntRad_vz
      !(out) ưʬ줿 1 ٳʻǡ

      integer :: k

      v_IntRad_vz = 0.0d0
      do k=0,km
         v_IntRad_vz(:) = v_IntRad_vz(:) &
                       + vz(:,k) * z_Rad_Weight(k) 
      enddo
    end function v_IntRad_vz

    function IntLatRad_vz(vz)
      !
      ! 2 (VZ)ʻǡΰưʬ(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2cos ddr ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: IntLatRad_vz
      !(out) ʬ

      real(8)                   :: IntLatRadTMP
      integer :: j, k

      IntLatRad_vz = 0
      do k=0,km
         do j=1,jc
            IntLatRad_vz = IntLatRad_vz &
                 + vz(j,k) * v_Lat_Weight(j) * z_Rad_Weight(k)
         enddo
      enddo

      IntLatRadTmp=IntLatRad_vz
      CALL MPI_ALLREDUCE(IntLatRadTMP,IntLatRad_vz,1,MPI_REAL8, &
                         MPI_SUM,MPI_COMM_WORLD,IERR)

    end function IntLatRad_vz

  !--------------- ʿѷ׻ -----------------
    !----(ϥǡ xvz)---
    function vz_AvrLon_xvz(xvz)  ! (Ӿ)ʬ
      !
      ! 3 ʻǡη(Ӿ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)d/2 ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(jc,0:km)  :: vz_AvrLon_xvz
      !(out) (Ӿ)ʿѤ줿 2 Ҹ̳ʻǡ

      vz_AvrLon_xvz = vz_IntLon_xvz(xvz)/sum(x_Lon_Weight)

    end function vz_AvrLon_xvz

    function xz_AvrLat_xvz(xvz)  ! ʬ
      !
      ! 3 ʻǡΰʿ.
      !
      ! 3 ǡ f(,,r) Ф f(,,r)cos d/2 ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(im,0:km)  :: xz_AvrLat_xvz
      !(out) ʿѤ줿 2 ư³ʻǡ

      xz_AvrLat_xvz = xz_IntLat_xvz(xvz)/sum(y_Lat_Weight)

    end function xz_AvrLat_xvz

    function xv_AvrRad_xvz(xvz)
      !
      ! 3 ʻǡưʿ.
      !
      ! 3 ǡ f(,,r) Ф 
      !
      !    f(,,r) r^2dr/((r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1,jc)  :: xv_AvrRad_xvz          ! ʿʻǡ
      !(out) ưʿѤ줿 2 ٰ(ʿ, )ʻǡ

      xv_AvrRad_xvz = xv_IntRad_xvz(xvz)/sum(z_Rad_Weight)

    end function xv_AvrRad_xvz

    function x_AvrLatRad_xvz(xvz)  ! ư(Ҹ)ʬ
      !
      ! 3 ʻǡΰư(Ҹ)ʿ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:im-1)     :: x_AvrLatRad_xvz
      !(out) ư(Ҹ)ʿѤ줿 1 ٳʻǡ

      x_AvrLatRad_xvz = x_IntLatRad_xvz(xvz) &
                   /( sum(y_Lat_Weight)*sum(z_Rad_Weight) )

    end function x_AvrLatRad_xvz

    function v_AvrLonRad_xvz(xvz)  ! ư(ٱ)ʬ
      !
      ! 3 ʻǡηư(ٱ)ʿ.
      !
      ! 3 ǡ f(,,r) Ф
      !
      !     f(,,r) r^2ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(jc)       :: v_AvrLonRad_xvz
      !(out) ư(ٱ)ʿѤ줿 1 ٳʻǡ

      v_AvrLonRad_xvz = v_IntLonRad_xvz(xvz) &
                 /(sum(x_Lon_Weight)*sum(z_Rad_Weight))

    end function v_AvrLonRad_xvz

    function z_AvrLonLat_xvz(xvz)  ! ٷ(ʿ)ʬ
      !
      ! 3 ʻǡΰٷ(ʿ, )ʬ
      ! 
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) cos dd /4 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8), dimension(0:km)     :: z_AvrLonLat_xvz
      !(out) ٷ(ʿ, )ʿѤ줿 1 ư³ʻǡ

      z_AvrLonLat_xvz = z_IntLonLat_xvz(xvz) &
                 /(sum(x_Lon_Weight)*sum(y_Lat_Weight))

    end function z_AvrLonLat_xvz

    function AvrLonLatRad_xvz(xvz) ! ٷư()ʬ
      !
      ! 3 ʻǡΰٷư()ʬ
      !
      ! 3 ǡ f(,,r) Ф
      !
      !    f(,,r) r^2cos dddr /(4(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(0:im-1,jc,0:km), intent(in) :: xvz
      !(in) 3 ٰư³ʻǡ

      real(8)                     :: AvrLonLatRad_xvz
      !(out) ʿ

      AvrLonLatRad_xvz = IntLonLatRad_xvz(xvz) &
            /(sum(x_Lon_Weight)*sum(y_Lat_Weight) * sum(z_Rad_Weight))

    end function AvrLonLatRad_xvz

    !----(ϥǡ vz)---
    function z_AvrLat_vz(vz)
      !
      ! 2 (VZ)ʻǡΰʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) cos d/2 ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(0:km)  :: z_AvrLat_vz
      !(out) ʿѤ줿 1 ư³ʻǡ

      z_AvrLat_vz = z_IntLat_vz(vz)/sum(y_Lat_Weight)
    end function z_AvrLat_vz

    function v_AvrRad_vz(vz)
      !
      ! 2 (VZ)ʻǡưʿ.
      !
      ! 2 ǡ f(,r) Ф f(,r) r^2dr /((r[o]^3-r[i]^3)/3) 
      ! ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8), dimension(jc)  :: v_AvrRad_vz
      !(out) ưʿѤ줿 1 ٳʻǡ

      v_AvrRad_vz = v_IntRad_vz(vz)/sum(z_Rad_Weight)

    end function v_AvrRad_vz

    function AvrLatRad_vz(vz)  ! ư(Ҹ)ʬ
      !
      ! 2 (VZ)ʻǡΰư(Ҹ)ʿ
      !
      ! 2 ǡ f(,r) Ф
      !
      !    f(,r) r^2cos ddr /(2(r[o]^3-r[i]^3)/3) 
      !
      ! ׻.
      !
      real(8), dimension(jc,0:km), intent(in) :: vz
      !(in) 2 ư(Ҹ)ʻǡ

      real(8)                   :: AvrLatRad_vz
      !(out) ʿ

      AvrLatRad_vz = IntLatRad_vz(vz)/(sum(y_Lat_Weight)*sum(z_Rad_Weight))

    end function AvrLatRad_vz

end module wt_mpi_module
