!----------------------------------------------------------------------
!     Copyright (c) 2013 Shin-ichi Takehiro. All rights reserved.
!----------------------------------------------------------------------
!
!ɽ  l_module ƥȥץ :: ѴؿΥƥ
!
!  2013/02/24  ݹ
!
program l_module_base_test

  use dc_message, only : MessageNotify
  use dc_test, only : AssertEqual
  use l_module
  implicit none

  integer :: jm(2)=(/16,32/)
  integer :: nm(2)=(/10,21/)

  real(8), allocatable :: l_data(:)
  real(8), allocatable :: y_data(:)

  ! Ƚ
  integer, parameter :: check_digits = 11
  integer, parameter :: ignore = -12

  integer :: n

  call MessageNotify('M','l_module_base_test', &
                         'l_module basic functions tests') 

  do n=1,2

  call l_Initial( nm(n), jm(n) )

  allocate(l_data(0:nm(n)))
  allocate(y_data(1:jm(n)))

  !---- P_1 Υƥ ----
  y_data = sqrt(3.0D0)*sin(y_Lat)
  l_data= 0.0D0 ; l_data(1)=1.0D0

  call AssertEqual(&
    message='P_1 Test of l_y(y_data)',                            &
    answer = l_data,                                              &
    check = l_y(y_data),                                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='P_1 Test of y_l(l_y(y_data))',                       &
    answer = y_data,                                              &
    check = y_l(l_y(y_data)),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- P_2 Υƥ ----
  y_data = sqrt(5.0D0)*(3.0/2*sin(y_Lat)**2-1/2.0)                 ! P_2
  l_data= 0.0D0 ; l_data(2)=1.0D0

  call AssertEqual(&
    message='P_2 Test of l_y(y_data)',                            &
    answer = l_data,                                              &
    check = l_y(y_data),                                          &
    significant_digits = check_digits, ignore_digits = ignore     &
    )
  call AssertEqual(&
    message='P_2 Test of y_l(l_y(y_data))',                       &
    answer = y_data,                                              &
    check = y_l(l_y(y_data)),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  !---- ŪؿΥƥ ----
  y_data = (sin(y_Lat)-1)**2*(sin(y_Lat)-0.5)*(sin(y_Lat)+1)

  call AssertEqual(&
    message='General func test of y_l(l_y(y_data))',              &
    answer = y_data,                                              &
    check = y_l(l_y(y_data)),                                     &
    significant_digits = check_digits, ignore_digits = ignore     &
    )

  deallocate(l_data)
  deallocate(y_data)

  call l_Finalize

  enddo

  call MessageNotify('M','l_module_base_test', &
                         'l_module basic functions tests succeeded!') 

end program l_module_base_test

