************************************************************************
* ISPACK FORTRAN SUBROUTINE LIBRARY FOR SCIENTIFIC COMPUTING
* Copyright (C) 1998--2013 Keiichi Ishioka <ishioka@gfd-dennou.org>
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
* 
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
* 02110-1301 USA.
************************************************************************
***********************************************************************
*     euler-mpi.f:
*              P3PACK-MPIȤä3ȯEuler򤯥ץ
*                                                  2002/05/07 K.Ishioka
***********************************************************************
      IMPLICIT REAL*8(A-H,O-Z)
      INCLUDE 'mpif.h'      

* ѥ᥿ 

      PARAMETER(NM=21,MM=21,LM=21) ! ȿ
      PARAMETER(NPROC=1) ! ¹ԻѤץΤȤꤦǾ
                         ! ⤷¿ΥץǤ׻ʤʤ
                         ! 򤽤Υץ˹碌뤳Ȥˤä
                         ! ɬפʥ̤︺Ǥ.      
      PARAMETER(N=(2*MM+1)*(2*NM+1)*2*2*(LM/NPROC+1))
      DIMENSION Z(N)   ! ٥٥ȥǼ뽾°ѿ
      DIMENSION W(N*3) ! ΰ
      EXTERNAL SBGDZN

* MPIνȥץֹ, ץμ.

      CALL MPI_INIT(IERR)
      CALL MPI_COMM_RANK(MPI_COMM_WORLD,IP,IERR)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

      IF(NP.LT.NPROC) THEN
        WRITE(6,*) 'NPROC MUST .LE. NUMBER OF PROCESSES.'
        STOP
      END IF

* Υץʬ֤륹ڥȥǡΤˤĤ,
* L θĿ(LC), L ͤκǾ(LS), L ͤκ(LE),
* ǡ ND .

      LP=LM/NP+1
      LS=LP*IP
      LE=MIN(LP*(IP+1)-1,LM)
      IF(LE.GE.LS) THEN
        LC=LE-LS+1
      ELSE
        LC=0
        LS=0
        LE=0
      END IF

      IF(LS.EQ.0.AND.LC.NE.0) THEN
        ND=(2*LC-1)*(2*MM+1)*(2*NM+1)*2
      ELSE IF(LC.NE.0) THEN
        ND=(2*LC)*(2*MM+1)*(2*NM+1)*2
      ELSE
        ND=0
      END IF

* ʬΤΥѥ᥿

      NSTEP=10                 !ȯŸ륹ƥå׿
      DT=0.01D0                !¸̤ΥåΤλֳִ
      M=1                      !Runge-KuttaǤΥƥåʬ

* ѥåȽ°ѿν

      CALL SBINIT
      CALL SBINIZ(Z)

* ȯŸ¸̤Υå

      T=0                       !Tϻɽѿ
      CALL SBGDCK(T,Z) 
      DO ISTEP=1,NSTEP
        CALL TDRK4U(ND,M,DT,T,Z,W,SBGDZN)
        CALL SBGDCK(T,Z)
      END DO

* MPIνλ

      CALL MPI_FINALIZE(IERR)      

      END
***********************************************************************
*     ʬɬפʼνޤȤ᤿֥롼ѥå
*----------------------------------------------------------------------
*     ѥåν򤹤륵֥롼
*----------------------------------------------------------------------
      SUBROUTINE SBINIT

      IMPLICIT REAL*8(A-H,O-Z)
      INCLUDE 'mpif.h'            
      PARAMETER(NM=21,MM=21,LM=21) ! main programƱͤͿ뤳.
      PARAMETER(KM=64,JM=64,IM=64) ! ʻΥ
      PARAMETER(NPROC=1) ! ¹ԻѤץΤȤꤦǾ
                         ! ⤷¿ΥץǤ׻ʤʤ
                         ! 򤽤Υץ˹碌뤳Ȥˤä
                         ! ɬפʥ̤︺Ǥ.      
      PARAMETER(N=(2*MM+1)*(2*NM+1)*2*2*(LM/NPROC+1))
      DIMENSION Z(-NM:NM,-MM:MM,2,0:*)  ! ٥٥ȥ2ʬ
      DIMENSION DZ(-NM:NM,-MM:MM,2,0:*) ! ZλѲΨ
      DIMENSION W(KM*IM*4*((JM-1)/NPROC+1))   ! ΰ
      ! JM=IM ξϤǤ褤, JMIM ξϰۤʤ礭
      ! ʤФʤʤ⤢Τդ뤳.
      DIMENSION ITK(5),TK(KM*2),ITJ(5),TJ(JM*2),ITI(5),TI(IM*2)
                                           ! P3PACKǻȤ
      SAVE

* ץֹ, ץμ.

      CALL MPI_COMM_RANK(MPI_COMM_WORLD,IP,IERR)
      CALL MPI_COMM_SIZE(MPI_COMM_WORLD,NP,IERR)

      IF(NP.LT.NPROC) THEN
        WRITE(6,*) 'NPROC MUST .LE. NUMBER OF PROCESSES.'
        STOP
      END IF

* Υץʬ֤륹ڥȥǡΤˤĤ,
* L θĿ(LC), L ͤκǾ(LS), L ͤκ(LE),
* ǡ ND .
* ʤ, LT  L Υǡ򻲾Ȥ뤿˻ȤͤǤ.

      LP=LM/NP+1
      LS=LP*IP
      LE=MIN(LP*(IP+1)-1,LM)
      IF(LE.GE.LS) THEN
        LC=LE-LS+1
      ELSE
        LC=0
        LS=0
        LE=0
      END IF

      LT=2*LC-1+LS

      IF(LS.EQ.0.AND.LC.NE.0) THEN
        ND=(2*LC-1)*(2*MM+1)*(2*NM+1)*2
      ELSE IF(LC.NE.0) THEN
        ND=(2*LC)*(2*MM+1)*(2*NM+1)*2
      ELSE
        ND=0
      END IF
      
* P3PACKν

      CALL P3INIT(KM,JM,IM,ITK,TK,ITJ,TJ,ITI,TI)

      RETURN
*----------------------------------------------------------------------
*     °ѿ(٥٥ȥ2ʬб)ν
*----------------------------------------------------------------------
      ENTRY SBINIZ(Z)

      CALL BSSET0(ND,Z)

      IF(LE.GE.1.AND.LS.LE.1) THEN
        Z( 0, 0, 1, 1-LS)= 1D0/4
        Z( 0, 0, 1, LT-1)= 1/(4*SQRT(3D0))
        Z( 0, 0, 2, 1-LS)= -1/(2*SQRT(3D0))
        Z( 0, 0, 2, LT-1)= 0
      END IF

      IF(IP.EQ.0) THEN
        Z( 0, 1, 1, 0)= 1D0/4
        Z( 0,-1, 1, 0)= 1/(4*SQRT(3D0))
        Z( 0, 1, 2, 0)= -1/(2*SQRT(3D0))
        Z( 0,-1, 2, 0)= 0
      
        Z( 1, 0, 1, 0)= 1D0/4
        Z(-1, 0, 1, 0)= 1/(4*SQRT(3D0))
        Z( 1, 0, 2, 0)= -1/(2*SQRT(3D0))
        Z(-1, 0, 2, 0)= 0
      END IF

      RETURN
*----------------------------------------------------------------------
*     °ѿ(٥٥ȥ2ʬб)λѲΨη׻
*----------------------------------------------------------------------
      ENTRY SBGDZN(T,Z,DZ)

      CALL P3EMNL(NM,MM,LM,KM,JM,IM,Z,DZ,W,ITK,TK,ITJ,TJ,ITI,TI)

      RETURN
*----------------------------------------------------------------------
*     ¸̤Υå(ͥ륮(E)ӥإꥷƥ(H))
*----------------------------------------------------------------------
      ENTRY SBGDCK(T,Z)

      CALL P3CMSV(NM,MM,LM,Z,E,H)
      IF(IP.EQ.0) THEN ! ץ0ǤΤ߽
        WRITE(6,'(A,F5.2,2(A,F17.15))')
     &    'TIME = ',T,'  ENERGY = ',E,'  HELICITY = ',H
      END IF

      END
