#
# u2d1.rb
#   $Id: u2d1.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include NMath

nt = 51
nz = 21
tmin = 0.0
tmax = 5.0
zmin = 20.0
zmax = 50.0
dt = (tmax-tmin)/(nt-1)
dz = (zmax-zmin)/(nz-1)

u = NArray.sfloat(nt, nz)

#-- data ----
zj = NArray.sfloat(nz).indgen! * dz
uz = exp(-0.2*zj)*(zj**0.5)
tz = -2.0*exp(-0.1*zj)
for i in 0..nt-1
  u[i,true] = uz*sin(3.0*(tz+i*dt))
end

#-- graph ----
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws
DCL::grfrm

DCL::grswnd(tmin, tmax, zmin, zmax)
DCL::uspfit
DCL::grstrf

DCL::ussttl('TIME', 'YEAR', 'HEIGHT', 'km')
DCL::usdaxs

DCL::udcntr(u)

DCL::grcls

