#
# sgtclr.rb
#
# $Id: sgtclr.rb,v 1.1.1.1 2011-02-23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


np = 5
nt = 10
dd = 0.07
ds = 0.003
dx = dd+ds*2
dy = 1.0 / nt

#-- data ---
xbox = NArray[0.0, 1.0, 1.0, 0.0, 0.0]
ybox = NArray[0.0, 0.0, 1.0, 1.0, 0.0]

#-- graph ---
iw = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gliset('MAXMSG', 300)
DCL::sgopn iw

DCL::sglset('LFULL', true)
DCL::sglset('LSOFTF', false)
DCL::sgiset('INDEX', 1)
DCL::slrat(0.85, 1.0)
DCL::slmgn(0.0, 0.0, 0.05, 0.1)
DCL::slsttl('TEST OF SGTONE', 'T', 0.0, -0.5, 0.025, 1)

DCL::sgfrm

DCL::sgswnd(0.0, 1.0, 0.0, 1.0)
DCL::sgstrn(1)

for j in 0..9
  for i in 0..9
    x1=dx*i+ds+(1-dx*nt)/2
    x2=x1+dd
    y1=dy*(9-j)+ds
    y2=y1+dd
    level=(i+j*10)*1000+999
    DCL::sgsvpt(x1, x2, y1, y2)
    DCL::sgstrf
    chr = format("%5d", level)
    DCL::sgtnzu(xbox, ybox, level)
    DCL::sgplzu(xbox, ybox, 1, 1)
    DCL::sgtxzv(x2, y2+(dy-dd)/2, chr, 0.01, 0, 1, 1)
  end
end

DCL::sgcls

