#
# uupk04.rb
#
# $Id: uupk04.rb,v 1.1.1.1 2011/02/23 07:21:27 horinout Exp $
#

require "narray"
require "numru/dcl"

include NumRu
include Math


n = 20
m = 5
y1 = NArray.sfloat(n)
y2 = NArray.sfloat(n)
a = NArray.sfloat(m)
rundef = DCL::glrget('RUNDEF')

#-----------------------------------------------------------------------
dt = 1.0/(n-1)
for j in 0..m-1
  jj = j*2+1
  a[j] = (-1.0)**(j+1) *2.0/(jj*PI)
end

for i in 0..n-1
  t = dt*i*2*PI
  y1[i] = a[0]*cos(t)
  y2[i] = 0.0
  for j in 0..m-1
    jj = j*2+1
    yy = a[j]*cos(jj*t)
    y2[i]  = y2[i] + yy
  end

end

#-----------------------------------------------------------------------
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm
DCL::sglset('LCLIP', true)

DCL::usspnt(rundef, y1)
DCL::usspnt(rundef, y2)
DCL::grswnd(0.0, 1.0, rundef, rundef)
DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uusarp(2999, 3999)
DCL::uvbra(rundef, y1, y2)
DCL::uvbrf(rundef, y1, y2)

DCL::uuslni(41)
DCL::uvbrl(rundef, y1)
DCL::uuslnt(3)
DCL::uvbrl(rundef, y2)

DCL::grfrm

DCL::usspnt(y1, rundef)
DCL::usspnt(y1, rundef)
DCL::grswnd(rundef, rundef, 0.0, 1.0)
DCL::uspfit
DCL::grstrf

DCL::usdaxs

DCL::uusarp(2999, 3999)
DCL::uhbra(y1, y2, rundef)
DCL::uhbrf(y1, y2, rundef)

DCL::uuslni(41)
DCL::uhbrl(y1, rundef)
DCL::uuslnt(3)
DCL::uhbrl(y2, rundef)

DCL::grcls

