#
# u2d3.rb
#   $Id: u2d3.rb,v 1.1.1.1 2011/02/23 07:21:26 horinout Exp $
#


require "narray"
require "numru/dcl"
include NumRu
include Math


nx = 37
ny = 37
my = 7
xmin = 0
xmax = 360
ymin = -90
ymax = 90
drad = PI / 180
p = NArray.sfloat(nx, ny)
uy1 = NArray.sfloat(ny)
uy2 = NArray.sfloat(my)

ch = ['SP ', '60S', '30S', 'EQ ', '30N', '60N', 'NP ']

#-- data ---
for j in 0..ny-1
  for i in 0..nx-1
    alon = (xmin + (xmax-xmin)*i/(nx-1)) * drad
    alat = (ymin + (ymax-ymin)*j/(ny-1)) * drad
    slat = sin(alat)
    uy1[j] = slat
    p[i,j] = 3*sqrt(1-slat**2)*slat*cos(alon) - 0.5*(3*slat**2-1)
  end
end

for j in 0..my-1
  uy2[j] = sin((ymin + (ymax-ymin)*j/(my-1)) * drad )
end

#-- graph ---
iws = (ARGV[0] || (puts ' WORKSTATION ID (I)  ? ;'; DCL::sgpwsn; gets)).to_i
DCL::gropn iws

DCL::grfrm

DCL::grswnd(xmin, xmax, -1.0, 1.0)
DCL::grsvpt(0.2, 0.8, 0.2, 0.8)
DCL::grstrn(1)
DCL::grstrf

DCL::uxaxdv('B', 10.0, 60.0)
DCL::uxaxdv('T', 10.0, 60.0)
DCL::uxsttl('B', 'LONGITUDE', 0.0)

DCL::uyaxdv('L', 0.1, 0.5)
DCL::uysttl('L', 'SINE LATITUDE', 0.0)

DCL::uzlset('LABELYR', true)
DCL::uyaxlb('R', uy1, uy2, ch, 3)
DCL::uysttl('R', 'LATITUDE', 0.0)

DCL::uwsgxb(xmin, xmax, nx)
DCL::uwsgya(uy1)

DCL::udcntr(p)

DCL::grcls

