/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

static VALUE
dcl_vrintr(obj, rx, n, jx)
    VALUE obj, rx, n, jx;
{
    real *io_rx;
    integer i_n;
    integer i_jx;

    if (TYPE(rx) == T_FLOAT) {
      rx = rb_Array(rx);
    }
    /* if ((TYPE(rx) != T_ARRAY) && 
           (rb_obj_is_kind_of(rx, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    io_rx = dcl_obj2crealary(rx);


    vrintr_(io_rx, &i_n, &i_jx);

    {int array_shape[1] = {i_jx*(i_n-1)+1};
     rx = dcl_crealary2obj(io_rx, i_jx*(i_n-1)+1, 1, array_shape);
    }

    dcl_freecrealary(io_rx);

    return rx;

}

static VALUE
dcl_vcintr(obj, cx, n, jx)
    VALUE obj, cx, n, jx;
{
    complex *io_cx;
    integer i_n;
    integer i_jx;

    /* checktype: not implemented for cx (ComplexInputOutputArrayVariable) */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(jx) != T_BIGNUM) || (TYPE(jx) != T_FIXNUM)) {
      jx = rb_funcall(jx, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_jx = NUM2INT(jx);
    /* initialization: not implemented for cx (ComplexInputOutputArrayVariable) */


    vcintr_(io_cx, &i_n, &i_jx);

    /* getresult: not implemented for cx (ComplexInputOutputArrayVariable) */


    return cx;

}
void
init_math2_intrlib(mDCL)
VALUE mDCL;
{
    rb_define_module_function(mDCL, "vrintr", dcl_vrintr, 3);
    rb_define_module_function(mDCL, "vcintr", dcl_vcintr, 3);
}
