*-----------------------------------------------------------------------
*     TMSTLA : THE ROUTINE FOR DRAWING STREAM LINES (COORD. OF ANNULAR)
*-----------------------------------------------------------------------
*     COPYRIGHT (C) 2000-2017 GFD DENNOU CLUB. ALL RIGHTS RESERVED.
*-----------------------------------------------------------------------
      SUBROUTINE TMSTLA( R, T, U, V, NX, NY )

      IMPLICIT NONE

*-- AGREENMENT
      INTEGER  NX        !* GRID NUMBERS FOR X-DIRECTION
      INTEGER  NY        !* GRID NUMBERS FOR Y-DIRECTION
      REAL     U(NX,NY)  !* VECTOR COMPONENT OF X-DIRECTION
      REAL     V(NX,NY)  !* VECTOR COMPONENT OF Y-DIRECTION
      REAL     R(NX)     !* GRID POINTS OF RADIAL DIR. [UNIT:LENGTH]
      REAL     T(NY)     !* GRID POINTS OF TANGENT DIR. [UNIT:DEGREE]

*-- INTERNAL VARIABLES
      REAL     TRX(NX*NY,NX*NY,2)  !* STREAM LINE OF X-COORDINATE
      REAL     TRY(NX*NY,NX*NY,2)  !* STREAM LINE OF Y-COORDINATE
      INTEGER  I, J, K             !* TMP VALUES
      INTEGER  COUNTER             !* NUMBER OF STREAM LINE
      INTEGER  NM(NX*NY,2)         !* ARRAY NUMBER IN EACH STREAM LINE
      REAL     X(NX), Y(NY)
      REAL     TMPU(NX,NY), TMPV(NX,NY)
      REAL     ARROW_THRES
      REAL     DXA, DYA
      REAL     ARROW_LENG
      REAL     VXMIN, VXMAX, VYMIN, VYMAX
      REAL     UXMIN, UXMAX, UYMIN, UYMAX
      REAL     VRRATIO
      REAL     RCOE
      REAL     CIRC_FLAG
      REAL     UNDEF
      INTEGER  N, M, IBLKGE, ARRCNT
      LOGICAL  NO_SHORT, END_ARR

*-- EXTERNAL FUNCTION
      REAL     RFPI
      EXTERNAL RFPI

      RCOE=RFPI()/180.0

*-- GETTING TMPACK'S PARAMETERS
      CALL TMRGET( 'ARRWINTV', ARROW_THRES )
      CALL TMLGET( 'NODRSHRT', NO_SHORT )

      CALL GLRGET( 'RMISS', UNDEF )
      CALL GLLSET( 'LMISS', .TRUE. )

*-- GETTING VIEWPORT PARAMETERS
      CALL SGQVPT( VXMIN, VXMAX, VYMIN, VYMAX)
      CALL SGQWND( UXMIN, UXMAX, UYMIN, UYMAX)
      VRRATIO=(VXMAX-VXMIN)/(UXMAX-UXMIN)

*-- CONVERTING DEGREE TO RADIAN
      DO 11 I=1,NX
         X(I)=R(I)
 11   CONTINUE
      DO 12 J=1,NY
         Y(J)=T(J)*RCOE
 12   CONTINUE

*-- CONVERTING VECTORS TO THEMSELVES INCLUDING SCALE PARAMETER
      DO 20 J=1,NY
         DO 21 I=1,NX
            IF(U(I,J).NE.UNDEF.AND.V(I,J).NE.UNDEF
     &         .AND.R(I).NE.0.0)THEN
               TMPU(I,J)=U(I,J)
               TMPV(I,J)=V(I,J)/R(I)
            ELSE
               TMPU(I,J)=UNDEF
               TMPV(I,J)=UNDEF
            END IF
 21      CONTINUE
 20   CONTINUE

      DO 71 K=1,2
         DO 70 I=1,NX*NY
            NM(I,K)=0
 70      CONTINUE
 71   CONTINUE

*-- DOING TMSTLN ROUTINE
      CALL TMSTLN( X, Y, TMPU, TMPV, NX, NY, TRX, TRY, NM )

*-- GETTING STREAM LINE NUMBERS
      CALL TMIGET( 'STLNNUM', COUNTER )

*-- CONVERTING TRY(RADIAN) TO TRY(DEGREE)
      DO 32 K=1,2
         DO 30 I=1,COUNTER
            DO 31 J=1,NM(I,K)
               IF(TRX(J,I,K).NE.UNDEF.AND.TRY(J,I,K).NE.UNDEF)THEN
                  TRY(J,I,K)=TRY(J,I,K)/RCOE
               END IF
 31         CONTINUE
 30      CONTINUE
 32   CONTINUE

*-- SETTING PARAMETER FOR ARROW. (NOW, CONSTANT VALUES)
      CALL SGLSET('LPROP',.FALSE.)
      CALL SGRSET('CONST',0.01)

*-- DRAWING STREAM LINES
      DO 82 K=1,2
         DO 81 I=1,COUNTER

*-- CALCULATING THE INTERVAL LENGTH OF DRAWING ARROWS.
            ARROW_LENG=0.0
            ARRCNT=0
            IF((NM(I,K).GT.1).AND.(NM(I,K).LE.NX*NY))THEN
               DO 80 J=2,NM(I,K)
                  IF(TRX(J,I,K).NE.UNDEF.AND.TRY(J,I,K).NE.UNDEF.AND.
     &               TRX(J-1,I,K).NE.UNDEF.AND.TRY(J-1,I,K).NE.UNDEF
     &               )THEN
                     DXA=(TRX(J,I,K)-TRX(J-1,I,K))*VRRATIO
                     DYA=(TRY(J,I,K)-TRY(J-1,I,K))*VRRATIO
     &                                            *TRX(J,I,K)*RCOE
                     ARROW_LENG=ARROW_LENG+SQRT(DXA*DXA+DYA*DYA)
                     IF(ARROW_LENG.GE.ARROW_THRES)THEN
                        CALL SGLAU( TRX(J-1,I,K), TRY(J-1,I,K),
     &                              TRX(J,I,K), TRY(J,I,K) )
                        ARROW_LENG=0.0
                        ARRCNT=ARRCNT+1
                     END IF
                  END IF
 80            CONTINUE

*-- IF NO_SHORT IS TRUE, NO DRAWING STREAM LINE WHOSE ARROW NUMBER IS ZERO
*-- ήλȽˤ, ĤήȤߤʤ.
*-- 𱩤Ͻ.
               IF(ARRCNT.EQ.0)THEN
                  IF(NO_SHORT.EQV..TRUE.)THEN
                     IF(NM(I,K).LE.2)THEN
                        GO TO 81
                     ELSE
                        N=IBLKGE( R, NX, TRX(1,I,K) )
                        M=IBLKGE( R, NX, TRX(NM(I,K),I,K) )
                        IF(ABS(N-M).GT.1)THEN
                           GO TO 81
                        ELSE
*-- ƤΤ, ûʤΤΥå
*--  , , νƤа.
                           CIRC_FLAG=
     &                         (TRX(NM(I,K),I,K)-TRX(NM(I,K)-1,I,K))
     &                         *(TRX(1,I,K)-TRX(NM(I,K),I,K))
                           IF(CIRC_FLAG.LT.0.0)THEN  ! ñû
                              GO TO 81
                           ELSE
                              N=IBLKGE( T, NY, TRY(1,I,K) )
                              M=IBLKGE( T, NY, TRY(NM(I,K),I,K) )
                              IF(ABS(N-M).GT.1)THEN
                                 GO TO 81
                              ELSE
                                 CIRC_FLAG=
     &                             (TRY(NM(I,K),I,K)-TRY(NM(I,K)-1,I,K))
     &                             *(TRY(1,I,K)-TRY(NM(I,K),I,K))
                                 IF(CIRC_FLAG.LT.0.0)THEN
                                    GO TO 81
!                                 ELSE
!                                 CALL SGLAU( TRX(NM(I)-1,I), TRY(NM(I)-1,I),
!     &                                       TRX(NM(I),I), TRY(NM(I),I) )
                                 END IF
                              END IF
                           END IF
                        END IF
                     END IF
                  ELSE
                     IF(END_ARR.EQV..TRUE.)THEN
                        CALL SGLAU( TRX(NM(I,K)-1,I,K),
     &                              TRY(NM(I,K)-1,I,K),
     &                              TRX(NM(I,K),I,K),
     &                              TRY(NM(I,K),I,K) )
                     END IF
                  END IF
               END IF

               CALL UULIN( NM(I,K), TRX(1:NM(I,K),I,K),
     &                     TRY(1:NM(I,K),I,K) )

            END IF

 81      CONTINUE

 82   CONTINUE

      CALL MSGDMP( 'M', 'TMSTLA', 'DRAWING FINISHED.' )

      END SUBROUTINE TMSTLA

