/*
 * $Id: p_header,v 1.3 2015/03/18 03:27:42 horinout Exp $
 */

#include <stdio.h>
#include "ruby.h"
#include "libtinyf2c.h"
#include "narray.h"
#include "cdcl.h"

/* for compatibility with ruby 1.6 */
#ifndef StringValuePtr
#define StringValuePtr(s) STR2CSTR(s)
#endif

#define DFLT_SIZE 32

extern char    *dcl_obj2ccharary(VALUE, int, int);
extern integer *dcl_obj2cintegerary(VALUE);
extern real    *dcl_obj2crealary(VALUE);
extern complex *dcl_obj2ccomplexary(VALUE);
extern logical *dcl_obj2clogicalary(VALUE);

extern VALUE dcl_ccharary2obj(char *, int, int);
extern VALUE dcl_cintegerary2obj(integer *, int, int, int *);
extern VALUE dcl_crealary2obj(real *, int, int, int *);
extern VALUE dcl_ccomplexary2obj(complex *, int, char *);
extern VALUE dcl_clogicalary2obj(logical *, int, int, int *);

extern void dcl_freeccharary(char *);
extern void dcl_freecintegerary(integer *);
extern void dcl_freecrealary(real *);
extern void dcl_freeccomplexary(complex *);
extern void dcl_freeclogicalary(logical *);

/* for functions which return real */
/* fnclib */
extern real rd2r_(real *);
extern real rr2d_(real *);
extern real rexp_(real *, integer *, integer *);
extern real rfpi_(void);
extern real rmod_(real *, real *);
/* gnmlib */
extern real rgnlt_(real *);
extern real rgnle_(real *);
extern real rgngt_(real *);
extern real rgnge_(real *);
/* rfalib */
extern real rmax_(real *, integer *, integer *);
extern real rmin_(real *, integer *, integer *);
extern real rsum_(real *, integer *, integer *);
extern real rave_(real *, integer *, integer *);
extern real rvar_(real *, integer *, integer *);
extern real rstd_(real *, integer *, integer *);
extern real rrms_(real *, integer *, integer *);
extern real ramp_(real *, integer *, integer *);
/* rfblib */
extern real rprd_(real *, real *, integer *, integer *, integer *);
extern real rcov_(real *, real *, integer *, integer *, integer *);
extern real rcor_(real *, real *, integer *, integer *, integer *);


extern VALUE mDCL;

#if DCLVER >= 544

static VALUE
dcl_clrgsv(obj, r, g, b, n, m)
    VALUE obj, r, g, b, n, m;
{
    integer *i_r;
    integer *i_g;
    integer *i_b;
    real *o_h;
    real *o_s;
    real *o_v;
    integer i_n;
    integer i_m;
    VALUE h;
    VALUE s;
    VALUE v;

    if ((TYPE(r) == T_BIGNUM) || (TYPE(r) == T_FIXNUM)) {
      r = rb_Array(r);
    }
    /* if ((TYPE(r) != T_ARRAY) && 
           (rb_obj_is_kind_of(r, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(g) == T_BIGNUM) || (TYPE(g) == T_FIXNUM)) {
      g = rb_Array(g);
    }
    /* if ((TYPE(g) != T_ARRAY) && 
           (rb_obj_is_kind_of(g, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(b) == T_BIGNUM) || (TYPE(b) == T_FIXNUM)) {
      b = rb_Array(b);
    }
    /* if ((TYPE(b) != T_ARRAY) && 
           (rb_obj_is_kind_of(b, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(m) != T_BIGNUM) || (TYPE(m) != T_FIXNUM)) {
      m = rb_funcall(m, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_m = NUM2INT(m);
    i_r = dcl_obj2cintegerary(r);
    i_g = dcl_obj2cintegerary(g);
    i_b = dcl_obj2cintegerary(b);

    o_h= ALLOCA_N(real, (i_n*i_m));
    o_s= ALLOCA_N(real, (i_n*i_m));
    o_v= ALLOCA_N(real, (i_n*i_m));

    clrgsv_(i_r, i_g, i_b, o_h, o_s, o_v, &i_n, &i_m);

    {int array_shape[2] = {i_n, i_m};
     h = dcl_crealary2obj(o_h, (i_n*i_m), 2, array_shape);
    }
    {int array_shape[2] = {i_n, i_m};
     s = dcl_crealary2obj(o_s, (i_n*i_m), 2, array_shape);
    }
    {int array_shape[2] = {i_n, i_m};
     v = dcl_crealary2obj(o_v, (i_n*i_m), 2, array_shape);
    }

    dcl_freecintegerary(i_r);
    dcl_freecintegerary(i_g);
    dcl_freecintegerary(i_b);

    return rb_ary_new3(3, h, s, v);

}

static VALUE
dcl_clsvrg(obj, h, s, v, n, m)
    VALUE obj, h, s, v, n, m;
{
    real *i_h;
    real *i_s;
    real *i_v;
    integer *o_r;
    integer *o_g;
    integer *o_b;
    integer i_n;
    integer i_m;
    VALUE r;
    VALUE g;
    VALUE b;

    if (TYPE(h) == T_FLOAT) {
      h = rb_Array(h);
    }
    /* if ((TYPE(h) != T_ARRAY) && 
           (rb_obj_is_kind_of(h, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(s) == T_FLOAT) {
      s = rb_Array(s);
    }
    /* if ((TYPE(s) != T_ARRAY) && 
           (rb_obj_is_kind_of(s, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if (TYPE(v) == T_FLOAT) {
      v = rb_Array(v);
    }
    /* if ((TYPE(v) != T_ARRAY) && 
           (rb_obj_is_kind_of(v, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(m) != T_BIGNUM) || (TYPE(m) != T_FIXNUM)) {
      m = rb_funcall(m, rb_intern("to_i"), 0);
    }

    i_n = NUM2INT(n);
    i_m = NUM2INT(m);
    i_h = dcl_obj2crealary(h);
    i_s = dcl_obj2crealary(s);
    i_v = dcl_obj2crealary(v);

    o_r= ALLOCA_N(integer, (i_n*i_m));
    o_g= ALLOCA_N(integer, (i_n*i_m));
    o_b= ALLOCA_N(integer, (i_n*i_m));

    clsvrg_(i_h, i_s, i_v, o_r, o_g, o_b, &i_n, &i_m);

    {int array_shape[2] = {i_n, i_m};
     r = dcl_cintegerary2obj(o_r, (i_n*i_m), 2, array_shape);
    }
    {int array_shape[2] = {i_n, i_m};
     g = dcl_cintegerary2obj(o_g, (i_n*i_m), 2, array_shape);
    }
    {int array_shape[2] = {i_n, i_m};
     b = dcl_cintegerary2obj(o_b, (i_n*i_m), 2, array_shape);
    }

    dcl_freecrealary(i_h);
    dcl_freecrealary(i_s);
    dcl_freecrealary(i_v);

    return rb_ary_new3(3, r, g, b);

}

static VALUE
dcl_inorml(obj, v, n, m, x, y)
    VALUE obj, v, n, m, x, y;
{
    integer *i_v;
    real *o_w;
    integer i_n;
    integer i_m;
    real i_x;
    real i_y;
    VALUE w;

    if ((TYPE(v) == T_BIGNUM) || (TYPE(v) == T_FIXNUM)) {
      v = rb_Array(v);
    }
    /* if ((TYPE(v) != T_ARRAY) && 
           (rb_obj_is_kind_of(v, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(m) != T_BIGNUM) || (TYPE(m) != T_FIXNUM)) {
      m = rb_funcall(m, rb_intern("to_i"), 0);
    }
    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_m = NUM2INT(m);
    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_v = dcl_obj2cintegerary(v);

    o_w= ALLOCA_N(real, (i_n*i_m));

    inorml_(i_v, o_w, &i_n, &i_m, &i_x, &i_y);

    {int array_shape[2] = {i_n, i_m};
     w = dcl_crealary2obj(o_w, (i_n*i_m), 2, array_shape);
    }

    dcl_freecintegerary(i_v);

    return w;

}

static VALUE
dcl_rnorml(obj, v, n, m, x, y)
    VALUE obj, v, n, m, x, y;
{
    real *i_v;
    real *o_w;
    integer i_n;
    integer i_m;
    real i_x;
    real i_y;
    VALUE w;

    if (TYPE(v) == T_FLOAT) {
      v = rb_Array(v);
    }
    /* if ((TYPE(v) != T_ARRAY) && 
           (rb_obj_is_kind_of(v, cNArray) != Qtrue)) {
         rb_raise(rb_eTypeError, "invalid type");
       }  -- no check since obj2c*ary will do that */
    if ((TYPE(n) != T_BIGNUM) || (TYPE(n) != T_FIXNUM)) {
      n = rb_funcall(n, rb_intern("to_i"), 0);
    }
    if ((TYPE(m) != T_BIGNUM) || (TYPE(m) != T_FIXNUM)) {
      m = rb_funcall(m, rb_intern("to_i"), 0);
    }
    if (TYPE(x) != T_FLOAT) {
      x = rb_funcall(x, rb_intern("to_f"), 0);
    }
    if (TYPE(y) != T_FLOAT) {
      y = rb_funcall(y, rb_intern("to_f"), 0);
    }

    i_n = NUM2INT(n);
    i_m = NUM2INT(m);
    i_x = (real)NUM2DBL(x);
    i_y = (real)NUM2DBL(y);
    i_v = dcl_obj2crealary(v);

    o_w= ALLOCA_N(real, (i_n*i_m));

    rnorml_(i_v, o_w, &i_n, &i_m, &i_x, &i_y);

    {int array_shape[2] = {i_n, i_m};
     w = dcl_crealary2obj(o_w, (i_n*i_m), 2, array_shape);
    }

    dcl_freecrealary(i_v);

    return w;

}

#endif
void
init_math1_clsplib(mDCL)
VALUE mDCL;
{
#if DCLVER >= 544
    rb_define_module_function(mDCL, "clrgsv", dcl_clrgsv, 5);
    rb_define_module_function(mDCL, "clsvrg", dcl_clsvrg, 5);
    rb_define_module_function(mDCL, "inorml", dcl_inorml, 5);
    rb_define_module_function(mDCL, "rnorml", dcl_rnorml, 5);
#endif
}
