#ifndef AVIPLAY_READSTREAMA_H
#define AVIPLAY_READSTREAMA_H

#include "ReadStream.h"

AVM_BEGIN_NAMESPACE;

class IAudioDecoder;
class AudioInfoMp3;

class ReadStreamA : public ReadStream
{
public:
    ReadStreamA(IMediaReadStream* stream);
    virtual ~ReadStreamA();
    virtual size_t GetAudioFormat(void* format = 0, size_t size = 0) const;
    virtual IAudioDecoder* GetAudioDecoder() const { return m_pAudiodecoder; }
    virtual size_t GetFrameSize() const;
    virtual size_t GetOutputFormat(void* format = 0, size_t size = 0) const;
    virtual framepos_t GetPos() const;
    virtual double GetTime(framepos_t frame = ERR) const;
    virtual bool IsStreaming() const;
    virtual int SkipTo(double pos);
    virtual int ReadFrames(void* buffer, size_t bufsize, size_t samples,
			   size_t& samples_read, size_t& bytes_read);
    virtual int SeekTime(double pos);
    virtual int StartStreaming(const char*);
    virtual int StopStreaming();

protected:
    static const size_t MINSIZE = 8192;
    static const size_t SRCSIZE = 1536;

    virtual void Flush();
    IAudioDecoder* m_pAudiodecoder;
    uint_t m_uiBps;
    size_t m_uiMinSize;
    size_t m_uiSrcSize;
    size_t m_uiSampleSize;
    size_t m_uiRead;
    bool m_bIsMp3;
};

AVM_END_NAMESPACE;

#endif // AVIPLAY_READSTREAMA_H
