/*
 * Decompiled with CFR 0.152.
 */
package com.kreative.rsrc.pict;

import com.kreative.rsrc.pict.ColorTable;
import com.kreative.rsrc.pict.PICTUtilities;
import com.kreative.rsrc.pict.PixMap;
import com.kreative.rsrc.pict.Point;
import com.kreative.rsrc.pict.Polygon;
import com.kreative.rsrc.pict.RGBColor;
import com.kreative.rsrc.pict.Rect;
import com.kreative.rsrc.pict.Region;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class PICTInstruction {
    public int opcode;

    public static final PICTInstruction read(DataInputStream in, int v) throws IOException {
        int opcode = v < 2 ? in.readUnsignedByte() : in.readUnsignedShort();
        PICTInstruction op = null;
        switch (opcode) {
            case 0: {
                op = new NOP();
                break;
            }
            case 1: {
                op = new Clip();
                break;
            }
            case 2: {
                op = new BkPat();
                break;
            }
            case 3: {
                op = new TxFont();
                break;
            }
            case 4: {
                op = new TxFace();
                break;
            }
            case 5: {
                op = new TxMode();
                break;
            }
            case 6: {
                op = new SpExtra();
                break;
            }
            case 7: {
                op = new PnSize();
                break;
            }
            case 8: {
                op = new PnMode();
                break;
            }
            case 9: {
                op = new PnPat();
                break;
            }
            case 10: {
                op = new FillPat();
                break;
            }
            case 11: {
                op = new OvSize();
                break;
            }
            case 12: {
                op = new Origin();
                break;
            }
            case 13: {
                op = new TxSize();
                break;
            }
            case 14: {
                op = new FgColor();
                break;
            }
            case 15: {
                op = new BkColor();
                break;
            }
            case 16: {
                op = new TxRatio();
                break;
            }
            case 17: {
                op = new VersionOp();
                break;
            }
            case 18: {
                op = new BkPixPat();
                break;
            }
            case 19: {
                op = new PnPixPat();
                break;
            }
            case 20: {
                op = new FillPixPat();
                break;
            }
            case 21: {
                op = new PnLocHFrac();
                break;
            }
            case 22: {
                op = new ChExtra();
                break;
            }
            case 23: {
                op = new Reserved0017();
                break;
            }
            case 24: {
                op = new Reserved0018();
                break;
            }
            case 25: {
                op = new Reserved0019();
                break;
            }
            case 26: {
                op = new RGBFgCol();
                break;
            }
            case 27: {
                op = new RGBBkCol();
                break;
            }
            case 28: {
                op = new HiliteMode();
                break;
            }
            case 29: {
                op = new HiliteColor();
                break;
            }
            case 30: {
                op = new DefHilite();
                break;
            }
            case 31: {
                op = new OpColor();
                break;
            }
            case 32: {
                op = new Line();
                break;
            }
            case 33: {
                op = new LineFrom();
                break;
            }
            case 34: {
                op = new ShortLine();
                break;
            }
            case 35: {
                op = new ShortLineFrom();
                break;
            }
            case 36: {
                op = new Reserved0024();
                break;
            }
            case 37: {
                op = new Reserved0025();
                break;
            }
            case 38: {
                op = new Reserved0026();
                break;
            }
            case 39: {
                op = new Reserved0027();
                break;
            }
            case 40: {
                op = new LongText();
                break;
            }
            case 41: {
                op = new DHText();
                break;
            }
            case 42: {
                op = new DVText();
                break;
            }
            case 43: {
                op = new DHDVText();
                break;
            }
            case 44: {
                op = new FontName();
                break;
            }
            case 45: {
                op = new LineJustify();
                break;
            }
            case 46: {
                op = new GlyphState();
                break;
            }
            case 47: {
                op = new Reserved002F();
                break;
            }
            case 48: {
                op = new FrameRect();
                break;
            }
            case 49: {
                op = new PaintRect();
                break;
            }
            case 50: {
                op = new EraseRect();
                break;
            }
            case 51: {
                op = new InvertRect();
                break;
            }
            case 52: {
                op = new FillRect();
                break;
            }
            case 53: {
                op = new Reserved0035();
                break;
            }
            case 54: {
                op = new Reserved0036();
                break;
            }
            case 55: {
                op = new Reserved0037();
                break;
            }
            case 56: {
                op = new FrameSameRect();
                break;
            }
            case 57: {
                op = new PaintSameRect();
                break;
            }
            case 58: {
                op = new EraseSameRect();
                break;
            }
            case 59: {
                op = new InvertSameRect();
                break;
            }
            case 60: {
                op = new FillSameRect();
                break;
            }
            case 61: {
                op = new Reserved003D();
                break;
            }
            case 62: {
                op = new Reserved003E();
                break;
            }
            case 63: {
                op = new Reserved003F();
                break;
            }
            case 64: {
                op = new FrameRRect();
                break;
            }
            case 65: {
                op = new PaintRRect();
                break;
            }
            case 66: {
                op = new EraseRRect();
                break;
            }
            case 67: {
                op = new InvertRRect();
                break;
            }
            case 68: {
                op = new FillRRect();
                break;
            }
            case 69: {
                op = new Reserved0045();
                break;
            }
            case 70: {
                op = new Reserved0046();
                break;
            }
            case 71: {
                op = new Reserved0047();
                break;
            }
            case 72: {
                op = new FrameSameRRect();
                break;
            }
            case 73: {
                op = new PaintSameRRect();
                break;
            }
            case 74: {
                op = new EraseSameRRect();
                break;
            }
            case 75: {
                op = new InvertSameRRect();
                break;
            }
            case 76: {
                op = new FillSameRRect();
                break;
            }
            case 77: {
                op = new Reserved004D();
                break;
            }
            case 78: {
                op = new Reserved004E();
                break;
            }
            case 79: {
                op = new Reserved004F();
                break;
            }
            case 80: {
                op = new FrameOval();
                break;
            }
            case 81: {
                op = new PaintOval();
                break;
            }
            case 82: {
                op = new EraseOval();
                break;
            }
            case 83: {
                op = new InvertOval();
                break;
            }
            case 84: {
                op = new FillOval();
                break;
            }
            case 85: {
                op = new Reserved0055();
                break;
            }
            case 86: {
                op = new Reserved0056();
                break;
            }
            case 87: {
                op = new Reserved0057();
                break;
            }
            case 88: {
                op = new FrameSameOval();
                break;
            }
            case 89: {
                op = new PaintSameOval();
                break;
            }
            case 90: {
                op = new EraseSameOval();
                break;
            }
            case 91: {
                op = new InvertSameOval();
                break;
            }
            case 92: {
                op = new FillSameOval();
                break;
            }
            case 93: {
                op = new Reserved005D();
                break;
            }
            case 94: {
                op = new Reserved005E();
                break;
            }
            case 95: {
                op = new Reserved005F();
                break;
            }
            case 96: {
                op = new FrameArc();
                break;
            }
            case 97: {
                op = new PaintArc();
                break;
            }
            case 98: {
                op = new EraseArc();
                break;
            }
            case 99: {
                op = new InvertArc();
                break;
            }
            case 100: {
                op = new FillArc();
                break;
            }
            case 101: {
                op = new Reserved0065();
                break;
            }
            case 102: {
                op = new Reserved0066();
                break;
            }
            case 103: {
                op = new Reserved0067();
                break;
            }
            case 104: {
                op = new FrameSameArc();
                break;
            }
            case 105: {
                op = new PaintSameArc();
                break;
            }
            case 106: {
                op = new EraseSameArc();
                break;
            }
            case 107: {
                op = new InvertSameArc();
                break;
            }
            case 108: {
                op = new FillSameArc();
                break;
            }
            case 109: {
                op = new Reserved006D();
                break;
            }
            case 110: {
                op = new Reserved006E();
                break;
            }
            case 111: {
                op = new Reserved006F();
                break;
            }
            case 112: {
                op = new FramePoly();
                break;
            }
            case 113: {
                op = new PaintPoly();
                break;
            }
            case 114: {
                op = new ErasePoly();
                break;
            }
            case 115: {
                op = new InvertPoly();
                break;
            }
            case 116: {
                op = new FillPoly();
                break;
            }
            case 117: {
                op = new Reserved0075();
                break;
            }
            case 118: {
                op = new Reserved0076();
                break;
            }
            case 119: {
                op = new Reserved0077();
                break;
            }
            case 120: {
                op = new FrameSamePoly();
                break;
            }
            case 121: {
                op = new PaintSamePoly();
                break;
            }
            case 122: {
                op = new EraseSamePoly();
                break;
            }
            case 123: {
                op = new InvertSamePoly();
                break;
            }
            case 124: {
                op = new FillSamePoly();
                break;
            }
            case 125: {
                op = new Reserved007D();
                break;
            }
            case 126: {
                op = new Reserved007E();
                break;
            }
            case 127: {
                op = new Reserved007F();
                break;
            }
            case 128: {
                op = new FrameRgn();
                break;
            }
            case 129: {
                op = new PaintRgn();
                break;
            }
            case 130: {
                op = new EraseRgn();
                break;
            }
            case 131: {
                op = new InvertRgn();
                break;
            }
            case 132: {
                op = new FillRgn();
                break;
            }
            case 133: {
                op = new Reserved0085();
                break;
            }
            case 134: {
                op = new Reserved0086();
                break;
            }
            case 135: {
                op = new Reserved0087();
                break;
            }
            case 136: {
                op = new FrameSameRgn();
                break;
            }
            case 137: {
                op = new PaintSameRgn();
                break;
            }
            case 138: {
                op = new EraseSameRgn();
                break;
            }
            case 139: {
                op = new InvertSameRgn();
                break;
            }
            case 140: {
                op = new FillSameRgn();
                break;
            }
            case 141: {
                op = new Reserved008D();
                break;
            }
            case 142: {
                op = new Reserved008E();
                break;
            }
            case 143: {
                op = new Reserved008F();
                break;
            }
            case 144: {
                op = new BitsRect();
                break;
            }
            case 145: {
                op = new BitsRgn();
                break;
            }
            case 146: {
                op = new Reserved0092();
                break;
            }
            case 147: {
                op = new Reserved0093();
                break;
            }
            case 148: {
                op = new Reserved0094();
                break;
            }
            case 149: {
                op = new Reserved0095();
                break;
            }
            case 150: {
                op = new Reserved0096();
                break;
            }
            case 151: {
                op = new Reserved0097();
                break;
            }
            case 152: {
                op = new PackBitsRect();
                break;
            }
            case 153: {
                op = new PackBitsRgn();
                break;
            }
            case 154: {
                op = new DirectBitsRect();
                break;
            }
            case 155: {
                op = new DirectBitsRgn();
                break;
            }
            case 156: {
                op = new Reserved009C();
                break;
            }
            case 157: {
                op = new Reserved009D();
                break;
            }
            case 158: {
                op = new Reserved009E();
                break;
            }
            case 159: {
                op = new Reserved009F();
                break;
            }
            case 160: {
                op = new ShortComment();
                break;
            }
            case 161: {
                op = new LongComment();
                break;
            }
            case 255: {
                op = new OpEndPic();
                break;
            }
            case 3072: {
                op = new HeaderOp();
                break;
            }
            case 33280: {
                op = new CompressedQuickTime();
                break;
            }
            case 33281: {
                op = new UncompressedQuickTime();
                break;
            }
            default: {
                op = opcode >= 33024 ? new Reserved8100toFFFF() : (opcode >= 32768 ? new Reserved8000to80FF() : (opcode >= 256 ? new Reserved0100to7FFF() : (opcode >= 208 ? new Reserved00D0to00FF() : (opcode >= 176 ? new Reserved00B0to00CF() : (opcode >= 162 ? new Reserved00A2to00AF() : (opcode >= 32 ? new ShortDataInstruction(){} : new ImpliedInstruction(){}))))));
            }
        }
        op.opcode = opcode;
        ((PICTInstruction)op).readImpl(in, v >= 2);
        return op;
    }

    public final void write(DataOutputStream out, int v) throws IOException {
        if (v < 2) {
            out.writeByte(this.opcode);
        } else {
            out.writeShort(this.opcode);
        }
        this.writeImpl(out, v >= 2);
    }

    public final String toString() {
        return (String.valueOf(this.getClass().getSimpleName()) + " " + this.toStringImpl()).trim();
    }

    protected abstract void readImpl(DataInputStream var1, boolean var2) throws IOException;

    protected abstract void writeImpl(DataOutputStream var1, boolean var2) throws IOException;

    protected abstract String toStringImpl();

    public static String patternToString(long pat) {
        String h = "0000000000000000" + Long.toHexString(pat).toUpperCase();
        return h.substring(h.length() - 16);
    }

    public static String modeToString(int m) {
        String suffix = "";
        if (m >= 64) {
            m -= 64;
            suffix = " ditherCopy" + suffix;
        }
        if (m >= 50) {
            m -= 50;
            suffix = " hilite" + suffix;
        }
        switch (m) {
            case 0: {
                return "srcCopy" + suffix;
            }
            case 1: {
                return "srcOr" + suffix;
            }
            case 2: {
                return "srcXor" + suffix;
            }
            case 3: {
                return "srcBic" + suffix;
            }
            case 4: {
                return "notSrcCopy" + suffix;
            }
            case 5: {
                return "notSrcOr" + suffix;
            }
            case 6: {
                return "notSrcXor" + suffix;
            }
            case 7: {
                return "notSrcBic" + suffix;
            }
            case 32: {
                return "blend" + suffix;
            }
            case 33: {
                return "addPin" + suffix;
            }
            case 34: {
                return "addOver" + suffix;
            }
            case 35: {
                return "subPin" + suffix;
            }
            case 36: {
                return "transparent" + suffix;
            }
            case 37: {
                return "addMax" + suffix;
            }
            case 38: {
                return "subOver" + suffix;
            }
            case 39: {
                return "addMin" + suffix;
            }
            case 49: {
                return "grayishTextOr" + suffix;
            }
        }
        return String.valueOf(m) + suffix;
    }

    public static String colorToString(int color) {
        switch (color) {
            case 30: {
                return "white";
            }
            case 33: {
                return "black";
            }
            case 69: {
                return "yellow";
            }
            case 137: {
                return "magenta";
            }
            case 205: {
                return "red";
            }
            case 273: {
                return "cyan";
            }
            case 341: {
                return "green";
            }
            case 409: {
                return "blue";
            }
        }
        return Integer.toString(color);
    }

    public static int colorToRGB(int color) {
        switch (color) {
            case 0: {
                return -1;
            }
            case 1: {
                return -16777216;
            }
            case 30: {
                return -1;
            }
            case 33: {
                return -16777216;
            }
            case 69: {
                return -265723;
            }
            case 137: {
                return -980860;
            }
            case 205: {
                return -2357242;
            }
            case 273: {
                return -16602390;
            }
            case 341: {
                return -16744687;
            }
            case 409: {
                return -16777005;
            }
        }
        return -16777216;
    }

    public static String commentToString(int kind) {
        switch (kind) {
            case 100: {
                return "ApplicationComment";
            }
            case 130: {
                return "DrawingBegin";
            }
            case 131: {
                return "DrawingEnd";
            }
            case 140: {
                return "GroupBegin";
            }
            case 141: {
                return "GroupEnd";
            }
            case 142: {
                return "BitmapBegin";
            }
            case 143: {
                return "BitmapEnd";
            }
            case 150: {
                return "TextBegin";
            }
            case 151: {
                return "TextEnd";
            }
            case 152: {
                return "StringBegin";
            }
            case 153: {
                return "StringEnd";
            }
            case 154: {
                return "TextCenter";
            }
            case 155: {
                return "LineLayoutOff";
            }
            case 156: {
                return "LineLayoutOn";
            }
            case 157: {
                return "ClientLineLayout";
            }
            case 160: {
                return "PolyBegin";
            }
            case 161: {
                return "PolyEnd";
            }
            case 163: {
                return "PolyIgnore";
            }
            case 164: {
                return "PolySmooth";
            }
            case 165: {
                return "PolyClose";
            }
            case 170: {
                return "ArrowBeginStart";
            }
            case 171: {
                return "ArrowBeginEnd";
            }
            case 172: {
                return "ArrowBeginBoth";
            }
            case 173: {
                return "ArrowEnd";
            }
            case 180: {
                return "DashedLine";
            }
            case 181: {
                return "DashedStop";
            }
            case 182: {
                return "SetLineWidth";
            }
            case 190: {
                return "PostScriptBegin";
            }
            case 191: {
                return "PostScriptEnd";
            }
            case 192: {
                return "PostScriptHandle";
            }
            case 193: {
                return "PostScriptFile";
            }
            case 194: {
                return "TextIsPostScript";
            }
            case 195: {
                return "ResourcePS";
            }
            case 196: {
                return "PSBeginNoSave";
            }
            case 197: {
                return "SetGrayLevel";
            }
            case 200: {
                return "RotateBegin";
            }
            case 201: {
                return "RotateEnd";
            }
            case 202: {
                return "RotateCenter";
            }
            case 210: {
                return "FormsPrinting";
            }
            case 211: {
                return "EndFormsPrinting";
            }
            case 220: {
                return "CMBeginProfile";
            }
            case 221: {
                return "CMEndProfile";
            }
            case 222: {
                return "CMEnableMatching";
            }
            case 223: {
                return "CMDisableMatching";
            }
            case 12345: {
                return "Lasso";
            }
        }
        return Integer.toString(kind);
    }

    public static String osTypeToString(int osType) {
        byte[] d = new byte[]{(byte)(osType >>> 24 & 0xFF), (byte)(osType >>> 16 & 0xFF), (byte)(osType >>> 8 & 0xFF), (byte)(osType & 0xFF)};
        return PICTUtilities.decodeString(d);
    }

    public static String fontToString(int fontID) {
        switch (fontID) {
            case 0: {
                return "Chicago";
            }
            case 1: {
                return "Geneva";
            }
            case 2: {
                return "New York";
            }
            case 3: {
                return "Geneva";
            }
            case 4: {
                return "Monaco";
            }
            case 5: {
                return "Venice";
            }
            case 6: {
                return "London";
            }
            case 7: {
                return "Athens";
            }
            case 8: {
                return "San Francisco";
            }
            case 9: {
                return "Toronto";
            }
            case 11: {
                return "Cairo";
            }
            case 12: {
                return "Los Angeles";
            }
            case 13: {
                return "Zapf Dingbats";
            }
            case 14: {
                return "Bookman";
            }
            case 15: {
                return "Helvetica Narrow";
            }
            case 16: {
                return "Palatino";
            }
            case 18: {
                return "Zapf Chancery";
            }
            case 20: {
                return "Times";
            }
            case 21: {
                return "Helvetica";
            }
            case 22: {
                return "Courier";
            }
            case 23: {
                return "Symbol";
            }
            case 24: {
                return "Mobile";
            }
            case 33: {
                return "Avant Garde";
            }
            case 34: {
                return "New Century Schoolbook";
            }
            case 98: {
                return ".Keyboard";
            }
            case 99: {
                return ".Last Resort";
            }
            case 642: {
                return "Zapfino";
            }
            case 1024: {
                return "Lucida Grande";
            }
            case 1109: {
                return "Trebuchet MS";
            }
            case 1236: {
                return "ITC Zapf Dingbats";
            }
            case 1237: {
                return "ITC Zapf Chancery";
            }
            case 1238: {
                return "ITC Bookman";
            }
            case 2000: {
                return "Arial Narrow";
            }
            case 2001: {
                return "Arial";
            }
            case 2002: {
                return "Charcoal";
            }
            case 2003: {
                return "Capitals";
            }
            case 2004: {
                return "Sand";
            }
            case 2005: {
                return "Courier New";
            }
            case 2006: {
                return "Techno";
            }
            case 2007: {
                return "Monotype Sorts";
            }
            case 2008: {
                return "Century Schoolbook";
            }
            case 2009: {
                return "Monotype Corsiva";
            }
            case 2010: {
                return "Times New Roman";
            }
            case 2011: {
                return "Wingdings";
            }
            case 2013: {
                return "Hoefler Text";
            }
            case 2018: {
                return "Hoefler Text Ornaments";
            }
            case 2039: {
                return "Impact";
            }
            case 2040: {
                return "Skia";
            }
            case 2052: {
                return "Wingdings 3";
            }
            case 2305: {
                return "Textile";
            }
            case 2307: {
                return "Gadget";
            }
            case 2311: {
                return "Apple Chancery";
            }
            case 4513: {
                return "Comic Sans MS";
            }
            case 7102: {
                return "Andale Mono";
            }
            case 7203: {
                return "Verdana";
            }
            case 12077: {
                return "Arial Black";
            }
            case 12171: {
                return "Georgia";
            }
            case 14213: {
                return "Webdings";
            }
            case 16383: {
                return "Chicago";
            }
            case 16384: {
                return "Osaka";
            }
            case 16896: {
                return "Taipei";
            }
            case 17082: {
                return "BiauKai";
            }
            case 17168: {
                return "Apple LiGothic";
            }
            case 17170: {
                return "Apple LiSung";
            }
            case 17408: {
                return "Seoul";
            }
            case 17409: {
                return "Apple Myungjo";
            }
            case 17410: {
                return "Apple Gothic";
            }
            case 19459: {
                return "Geneva CY";
            }
            case 19460: {
                return "Monaco CY";
            }
            case 19461: {
                return "Charcoal CY";
            }
            case 19492: {
                return "Helvetica CY";
            }
            case 19540: {
                return "Times CY";
            }
            case 28672: {
                return "Beijing";
            }
            case 28929: {
                return "Song";
            }
            case 28930: {
                return "Hei";
            }
            case 28931: {
                return "Kai";
            }
            case 28932: {
                return "Fang Song";
            }
            case 30723: {
                return "Geneva CE";
            }
            case 30724: {
                return "Monaco CE";
            }
            case 30740: {
                return "Times CE";
            }
            case 30741: {
                return "Helvetica CE";
            }
            case 30742: {
                return "Courier CE";
            }
        }
        return "Geneva";
    }

    public static String styleToString(int style) {
        if ((style & 0xFF) == 0) {
            return "plain";
        }
        StringBuffer sb = new StringBuffer();
        if ((style & 1) != 0) {
            sb.append(", bold");
        }
        if ((style & 2) != 0) {
            sb.append(", italic");
        }
        if ((style & 4) != 0) {
            sb.append(", underline");
        }
        if ((style & 8) != 0) {
            sb.append(", outline");
        }
        if ((style & 0x10) != 0) {
            sb.append(", shadow");
        }
        if ((style & 0x20) != 0) {
            sb.append(", condense");
        }
        if ((style & 0x40) != 0) {
            sb.append(", extend");
        }
        if ((style & 0x80) != 0) {
            sb.append(", group");
        }
        return sb.toString().substring(2);
    }

    public static abstract class ArcInstruction
    extends PICTInstruction {
        public Rect rect;
        public int startAngle;
        public int arcAngle;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.rect = Rect.read(in);
            this.startAngle = in.readShort();
            this.arcAngle = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.rect.write(out);
            out.writeShort(this.startAngle);
            out.writeShort(this.arcAngle);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.rect.toString()) + " " + this.startAngle + " " + this.arcAngle;
        }
    }

    public static class BitsRect
    extends CopyBitsRectInstruction {
        public static final int OPCODE = 144;

        public BitsRect() {
            this.opcode = 144;
        }

        public BitsRect(PixMap pm, ColorTable ct, Rect src, Rect dst, int mode, byte[] data) {
            this.opcode = 144;
            this.pixMap = pm;
            this.colorTable = ct;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.pixData = data;
        }
    }

    public static class BitsRgn
    extends CopyBitsRegionInstruction {
        public static final int OPCODE = 145;

        public BitsRgn() {
            this.opcode = 145;
        }

        public BitsRgn(PixMap pm, ColorTable ct, Rect src, Rect dst, int mode, Region rgn, byte[] data) {
            this.opcode = 145;
            this.pixMap = pm;
            this.colorTable = ct;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.maskRgn = rgn;
            this.pixData = data;
        }
    }

    public static class BkColor
    extends ColorInstruction {
        public static final int OPCODE = 15;

        public BkColor() {
            this.opcode = 15;
        }

        public BkColor(int color) {
            this.opcode = 15;
            this.color = color;
        }
    }

    public static class BkPat
    extends PatternInstruction {
        public static final int OPCODE = 2;

        public BkPat() {
            this.opcode = 2;
        }

        public BkPat(long pat) {
            this.opcode = 2;
            this.pat = pat;
        }
    }

    public static class BkPixPat
    extends PixelPatternInstruction {
        public static final int OPCODE = 18;

        public BkPixPat() {
            this.opcode = 18;
        }

        public BkPixPat(long pat) {
            this.opcode = 18;
            this.patType = 0;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public BkPixPat(long pat, RGBColor color) {
            this.opcode = 18;
            this.patType = 2;
            this.pat1Data = pat;
            this.rgb = color;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public BkPixPat(long pat, PixMap pm, ColorTable ct, byte[] data) {
            this.opcode = 18;
            this.patType = 1;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = pm;
            this.colorTable = ct;
            this.pixData = data;
        }
    }

    public static class ChExtra
    extends PICTInstruction {
        public static final int OPCODE = 22;
        public int chExtra;

        public ChExtra() {
            this.opcode = 22;
        }

        public ChExtra(int chExtra) {
            this.opcode = 22;
            this.chExtra = chExtra;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.chExtra = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.chExtra);
        }

        @Override
        protected String toStringImpl() {
            return Integer.toString(this.chExtra);
        }
    }

    public static class Clip
    extends RegionInstruction {
        public static final int OPCODE = 1;

        public Clip() {
            this.opcode = 1;
        }

        public Clip(Region rgn) {
            this.opcode = 1;
            this.rgn = rgn;
        }
    }

    public static interface ColorConstants {
        public static final int WHITE = 30;
        public static final int BLACK = 33;
        public static final int YELLOW = 69;
        public static final int MAGENTA = 137;
        public static final int RED = 205;
        public static final int CYAN = 273;
        public static final int GREEN = 341;
        public static final int BLUE = 409;
    }

    public static abstract class ColorInstruction
    extends PICTInstruction
    implements ColorConstants {
        public int color;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.color = in.readInt();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeInt(this.color);
        }

        @Override
        protected String toStringImpl() {
            return ColorInstruction.colorToString(this.color);
        }

        public int toRGB() {
            return ColorInstruction.colorToRGB(this.color);
        }
    }

    public static interface CommentConstants {
        public static final int APPLICATION_COMMENT = 100;
        public static final int DRAWING_BEGIN = 130;
        public static final int DRAWING_END = 131;
        public static final int GROUP_BEGIN = 140;
        public static final int GROUP_END = 141;
        public static final int BITMAP_BEGIN = 142;
        public static final int BITMAP_END = 143;
        public static final int TEXT_BEGIN = 150;
        public static final int TEXT_END = 151;
        public static final int STRING_BEGIN = 152;
        public static final int STRING_END = 153;
        public static final int TEXT_CENTER = 154;
        public static final int LINE_LAYOUT_OFF = 155;
        public static final int LINE_LAYOUT_ON = 156;
        public static final int CLIENT_LINE_LAYOUT = 157;
        public static final int POLY_BEGIN = 160;
        public static final int POLY_END = 161;
        public static final int POLY_IGNORE = 163;
        public static final int POLY_SMOOTH = 164;
        public static final int POLY_CLOSE = 165;
        public static final int ARROW_BEGIN_START = 170;
        public static final int ARROW_BEGIN_END = 171;
        public static final int ARROW_BEGIN_BOTH = 172;
        public static final int ARROW_END = 173;
        public static final int DASHED_LINE = 180;
        public static final int DASHED_STOP = 181;
        public static final int SET_LINE_WIDTH = 182;
        public static final int POSTSCRIPT_BEGIN = 190;
        public static final int POSTSCRIPT_END = 191;
        public static final int POSTSCRIPT_HANDLE = 192;
        public static final int POSTSCRIPT_FILE = 193;
        public static final int TEXT_IS_POSTSCRIPT = 194;
        public static final int RESOURCE_PS = 195;
        public static final int PS_BEGIN_NO_SAVE = 196;
        public static final int SET_GRAY_LEVEL = 197;
        public static final int ROTATE_BEGIN = 200;
        public static final int ROTATE_END = 201;
        public static final int ROTATE_CENTER = 202;
        public static final int FORMS_PRINTING = 210;
        public static final int END_FORMS_PRINTING = 211;
        public static final int CM_BEGIN_PROFILE = 220;
        public static final int CM_END_PROFILE = 221;
        public static final int CM_ENABLE_MATCHING = 222;
        public static final int CM_DISABLE_MATHING = 223;
        public static final int LASSO = 12345;
        public static final int APPLICATION_SUPERPAINT = 1397771860;
        public static final int APPLICATION_POWERPAINT = 1263554132;
    }

    public static class CompressedQuickTime
    extends LongDataInstruction {
        public static final int OPCODE = 33280;

        public CompressedQuickTime() {
            this.opcode = 33280;
        }

        public CompressedQuickTime(byte[] data) {
            this.opcode = 33280;
            this.data = data;
        }
    }

    public static abstract class CopyBitsRectInstruction
    extends PICTInstruction
    implements ModeConstants {
        public PixMap pixMap;
        public ColorTable colorTable;
        public Rect srcRect;
        public Rect dstRect;
        public int mode;
        public byte[] pixData;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pixMap = PixMap.read(in, false);
            this.colorTable = this.pixMap.hasColorTable() ? ColorTable.read(in) : null;
            this.srcRect = Rect.read(in);
            this.dstRect = Rect.read(in);
            this.mode = in.readShort();
            this.pixData = this.pixMap.readPixData(in, true);
            if (v2 && (this.pixData.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pixMap.write(out, false);
            if (this.colorTable != null) {
                this.colorTable.write(out);
            }
            this.srcRect.write(out);
            this.dstRect.write(out);
            out.writeShort(this.mode);
            this.pixMap.writePixData(out, this.pixData);
            if (v2 && (this.pixData.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.pixMap.toString());
            if (this.colorTable != null) {
                sb.append(" " + this.colorTable.toString());
            }
            sb.append(" " + this.srcRect.toString());
            sb.append(" " + this.dstRect.toString());
            sb.append(" " + CopyBitsRectInstruction.modeToString(this.mode));
            if (this.pixData.length <= 64) {
                sb.append(" ");
                byte[] byArray = this.pixData;
                int n = this.pixData.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append(" Data[" + this.pixData.length + "]");
            }
            return sb.toString();
        }
    }

    public static abstract class CopyBitsRegionInstruction
    extends PICTInstruction
    implements ModeConstants {
        public PixMap pixMap;
        public ColorTable colorTable;
        public Rect srcRect;
        public Rect dstRect;
        public int mode;
        public Region maskRgn;
        public byte[] pixData;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pixMap = PixMap.read(in, false);
            this.colorTable = this.pixMap.hasColorTable() ? ColorTable.read(in) : null;
            this.srcRect = Rect.read(in);
            this.dstRect = Rect.read(in);
            this.mode = in.readShort();
            this.maskRgn = Region.read(in);
            this.pixData = this.pixMap.readPixData(in, true);
            if (v2 && (this.pixData.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pixMap.write(out, false);
            if (this.colorTable != null) {
                this.colorTable.write(out);
            }
            this.srcRect.write(out);
            this.dstRect.write(out);
            out.writeShort(this.mode);
            this.maskRgn.write(out);
            this.pixMap.writePixData(out, this.pixData);
            if (v2 && (this.pixData.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.pixMap.toString());
            if (this.colorTable != null) {
                sb.append(" " + this.colorTable.toString());
            }
            sb.append(" " + this.srcRect.toString());
            sb.append(" " + this.dstRect.toString());
            sb.append(" " + CopyBitsRegionInstruction.modeToString(this.mode));
            sb.append(" " + this.maskRgn.toString());
            if (this.pixData.length <= 64) {
                sb.append(" ");
                byte[] byArray = this.pixData;
                int n = this.pixData.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append(" Data[" + this.pixData.length + "]");
            }
            return sb.toString();
        }
    }

    public static class DHDVText
    extends PICTInstruction {
        public static final int OPCODE = 43;
        public int dh;
        public int dv;
        public String text;

        public DHDVText() {
            this.opcode = 43;
        }

        public DHDVText(int dh, int dv, String s) {
            this.opcode = 43;
            this.dh = dh;
            this.dv = dv;
            this.text = s;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.dh = in.readByte();
            this.dv = in.readByte();
            byte[] td = new byte[in.readUnsignedByte()];
            in.readFully(td);
            this.text = PICTUtilities.decodeString(td);
            if (v2 && (td.length & 1) == 0) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.dh);
            out.writeByte(this.dv);
            byte[] td = PICTUtilities.encodeString(this.text);
            out.writeByte(td.length);
            out.write(td);
            if (v2 && (td.length & 1) == 0) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return (this.dh < 0 ? Integer.valueOf(this.dh) : "+" + this.dh) + "," + (this.dv < 0 ? Integer.valueOf(this.dv) : "+" + this.dv) + " " + this.text.trim();
        }
    }

    public static class DHText
    extends PICTInstruction {
        public static final int OPCODE = 41;
        public int dh;
        public String text;

        public DHText() {
            this.opcode = 41;
        }

        public DHText(int dh, String s) {
            this.opcode = 41;
            this.dh = dh;
            this.text = s;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.dh = in.readByte();
            byte[] td = new byte[in.readUnsignedByte()];
            in.readFully(td);
            this.text = PICTUtilities.decodeString(td);
            if (v2 && (td.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.dh);
            byte[] td = PICTUtilities.encodeString(this.text);
            out.writeByte(td.length);
            out.write(td);
            if (v2 && (td.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return (this.dh < 0 ? Integer.valueOf(this.dh) : "+" + this.dh) + " " + this.text.trim();
        }
    }

    public static class DVText
    extends PICTInstruction {
        public static final int OPCODE = 42;
        public int dv;
        public String text;

        public DVText() {
            this.opcode = 42;
        }

        public DVText(int dv, String s) {
            this.opcode = 42;
            this.dv = dv;
            this.text = s;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.dv = in.readByte();
            byte[] td = new byte[in.readUnsignedByte()];
            in.readFully(td);
            this.text = PICTUtilities.decodeString(td);
            if (v2 && (td.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.dv);
            byte[] td = PICTUtilities.encodeString(this.text);
            out.writeByte(td.length);
            out.write(td);
            if (v2 && (td.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return (this.dv < 0 ? Integer.valueOf(this.dv) : "+" + this.dv) + " " + this.text.trim();
        }
    }

    public static class DefHilite
    extends ImpliedInstruction {
        public static final int OPCODE = 30;

        public DefHilite() {
            this.opcode = 30;
        }
    }

    public static class DirectBitsRect
    extends DirectBitsRectInstruction {
        public static final int OPCODE = 154;

        public DirectBitsRect() {
            this.opcode = 154;
        }

        public DirectBitsRect(PixMap pm, Rect src, Rect dst, int mode, byte[] data) {
            this.opcode = 154;
            this.pixMap = pm;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.pixData = data;
        }
    }

    public static abstract class DirectBitsRectInstruction
    extends PICTInstruction
    implements ModeConstants {
        public PixMap pixMap;
        public Rect srcRect;
        public Rect dstRect;
        public int mode;
        public byte[] pixData;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pixMap = PixMap.read(in, true);
            this.srcRect = Rect.read(in);
            this.dstRect = Rect.read(in);
            this.mode = in.readShort();
            this.pixData = this.pixMap.readPixData(in, true);
            if (v2 && (this.pixData.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pixMap.write(out, true);
            this.srcRect.write(out);
            this.dstRect.write(out);
            out.writeShort(this.mode);
            this.pixMap.writePixData(out, this.pixData);
            if (v2 && (this.pixData.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.pixMap.toString());
            sb.append(" " + this.srcRect.toString());
            sb.append(" " + this.dstRect.toString());
            sb.append(" " + DirectBitsRectInstruction.modeToString(this.mode));
            if (this.pixData.length <= 64) {
                sb.append(" ");
                byte[] byArray = this.pixData;
                int n = this.pixData.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append(" Data[" + this.pixData.length + "]");
            }
            return sb.toString();
        }
    }

    public static abstract class DirectBitsRegionInstruction
    extends PICTInstruction
    implements ModeConstants {
        public PixMap pixMap;
        public Rect srcRect;
        public Rect dstRect;
        public int mode;
        public Region maskRgn;
        public byte[] pixData;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pixMap = PixMap.read(in, true);
            this.srcRect = Rect.read(in);
            this.dstRect = Rect.read(in);
            this.mode = in.readShort();
            this.maskRgn = Region.read(in);
            this.pixData = this.pixMap.readPixData(in, true);
            if (v2 && (this.pixData.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pixMap.write(out, true);
            this.srcRect.write(out);
            this.dstRect.write(out);
            out.writeShort(this.mode);
            this.maskRgn.write(out);
            this.pixMap.writePixData(out, this.pixData);
            if (v2 && (this.pixData.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.pixMap.toString());
            sb.append(" " + this.srcRect.toString());
            sb.append(" " + this.dstRect.toString());
            sb.append(" " + DirectBitsRegionInstruction.modeToString(this.mode));
            sb.append(" " + this.maskRgn.toString());
            if (this.pixData.length <= 64) {
                sb.append(" ");
                byte[] byArray = this.pixData;
                int n = this.pixData.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append(" Data[" + this.pixData.length + "]");
            }
            return sb.toString();
        }
    }

    public static class DirectBitsRgn
    extends DirectBitsRegionInstruction {
        public static final int OPCODE = 155;

        public DirectBitsRgn() {
            this.opcode = 155;
        }

        public DirectBitsRgn(PixMap pm, Rect src, Rect dst, int mode, Region rgn, byte[] data) {
            this.opcode = 155;
            this.pixMap = pm;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.maskRgn = rgn;
            this.pixData = data;
        }
    }

    public static class EraseArc
    extends ArcInstruction {
        public static final int OPCODE = 98;

        public EraseArc() {
            this.opcode = 98;
        }

        public EraseArc(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 98;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class EraseOval
    extends RectangleInstruction {
        public static final int OPCODE = 82;

        public EraseOval() {
            this.opcode = 82;
        }

        public EraseOval(Rect rect) {
            this.opcode = 82;
            this.rect = rect;
        }
    }

    public static class ErasePoly
    extends PolygonInstruction {
        public static final int OPCODE = 114;

        public ErasePoly() {
            this.opcode = 114;
        }

        public ErasePoly(Polygon poly) {
            this.opcode = 114;
            this.poly = poly;
        }
    }

    public static class EraseRRect
    extends RectangleInstruction {
        public static final int OPCODE = 66;

        public EraseRRect() {
            this.opcode = 66;
        }

        public EraseRRect(Rect rect) {
            this.opcode = 66;
            this.rect = rect;
        }
    }

    public static class EraseRect
    extends RectangleInstruction {
        public static final int OPCODE = 50;

        public EraseRect() {
            this.opcode = 50;
        }

        public EraseRect(Rect rect) {
            this.opcode = 50;
            this.rect = rect;
        }
    }

    public static class EraseRgn
    extends RegionInstruction {
        public static final int OPCODE = 130;

        public EraseRgn() {
            this.opcode = 130;
        }

        public EraseRgn(Region rgn) {
            this.opcode = 130;
            this.rgn = rgn;
        }
    }

    public static class EraseSameArc
    extends SameArcInstruction {
        public static final int OPCODE = 106;

        public EraseSameArc() {
            this.opcode = 106;
        }

        public EraseSameArc(int startAngle, int arcAngle) {
            this.opcode = 106;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class EraseSameOval
    extends ImpliedInstruction {
        public static final int OPCODE = 90;

        public EraseSameOval() {
            this.opcode = 90;
        }
    }

    public static class EraseSamePoly
    extends ImpliedInstruction {
        public static final int OPCODE = 122;

        public EraseSamePoly() {
            this.opcode = 122;
        }
    }

    public static class EraseSameRRect
    extends ImpliedInstruction {
        public static final int OPCODE = 74;

        public EraseSameRRect() {
            this.opcode = 74;
        }
    }

    public static class EraseSameRect
    extends ImpliedInstruction {
        public static final int OPCODE = 58;

        public EraseSameRect() {
            this.opcode = 58;
        }
    }

    public static class EraseSameRgn
    extends ImpliedInstruction {
        public static final int OPCODE = 138;

        public EraseSameRgn() {
            this.opcode = 138;
        }
    }

    public static class FgColor
    extends ColorInstruction {
        public static final int OPCODE = 14;

        public FgColor() {
            this.opcode = 14;
        }

        public FgColor(int color) {
            this.opcode = 14;
            this.color = color;
        }
    }

    public static class FillArc
    extends ArcInstruction {
        public static final int OPCODE = 100;

        public FillArc() {
            this.opcode = 100;
        }

        public FillArc(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 100;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class FillOval
    extends RectangleInstruction {
        public static final int OPCODE = 84;

        public FillOval() {
            this.opcode = 84;
        }

        public FillOval(Rect rect) {
            this.opcode = 84;
            this.rect = rect;
        }
    }

    public static class FillPat
    extends PatternInstruction {
        public static final int OPCODE = 10;

        public FillPat() {
            this.opcode = 10;
        }

        public FillPat(long pat) {
            this.opcode = 10;
            this.pat = pat;
        }
    }

    public static class FillPixPat
    extends PixelPatternInstruction {
        public static final int OPCODE = 20;

        public FillPixPat() {
            this.opcode = 20;
        }

        public FillPixPat(long pat) {
            this.opcode = 20;
            this.patType = 0;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public FillPixPat(long pat, RGBColor color) {
            this.opcode = 20;
            this.patType = 2;
            this.pat1Data = pat;
            this.rgb = color;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public FillPixPat(long pat, PixMap pm, ColorTable ct, byte[] data) {
            this.opcode = 20;
            this.patType = 1;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = pm;
            this.colorTable = ct;
            this.pixData = data;
        }
    }

    public static class FillPoly
    extends PolygonInstruction {
        public static final int OPCODE = 116;

        public FillPoly() {
            this.opcode = 116;
        }

        public FillPoly(Polygon poly) {
            this.opcode = 116;
            this.poly = poly;
        }
    }

    public static class FillRRect
    extends RectangleInstruction {
        public static final int OPCODE = 68;

        public FillRRect() {
            this.opcode = 68;
        }

        public FillRRect(Rect rect) {
            this.opcode = 68;
            this.rect = rect;
        }
    }

    public static class FillRect
    extends RectangleInstruction {
        public static final int OPCODE = 52;

        public FillRect() {
            this.opcode = 52;
        }

        public FillRect(Rect rect) {
            this.opcode = 52;
            this.rect = rect;
        }
    }

    public static class FillRgn
    extends RegionInstruction {
        public static final int OPCODE = 132;

        public FillRgn() {
            this.opcode = 132;
        }

        public FillRgn(Region rgn) {
            this.opcode = 132;
            this.rgn = rgn;
        }
    }

    public static class FillSameArc
    extends SameArcInstruction {
        public static final int OPCODE = 108;

        public FillSameArc() {
            this.opcode = 108;
        }

        public FillSameArc(int startAngle, int arcAngle) {
            this.opcode = 108;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class FillSameOval
    extends ImpliedInstruction {
        public static final int OPCODE = 92;

        public FillSameOval() {
            this.opcode = 92;
        }
    }

    public static class FillSamePoly
    extends ImpliedInstruction {
        public static final int OPCODE = 124;

        public FillSamePoly() {
            this.opcode = 124;
        }
    }

    public static class FillSameRRect
    extends ImpliedInstruction {
        public static final int OPCODE = 76;

        public FillSameRRect() {
            this.opcode = 76;
        }
    }

    public static class FillSameRect
    extends ImpliedInstruction {
        public static final int OPCODE = 60;

        public FillSameRect() {
            this.opcode = 60;
        }
    }

    public static class FillSameRgn
    extends ImpliedInstruction {
        public static final int OPCODE = 140;

        public FillSameRgn() {
            this.opcode = 140;
        }
    }

    public static abstract class FixedDataInstruction
    extends PICTInstruction {
        public byte[] data;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.data = new byte[(this.opcode & 0xFF00) >>> 7];
            in.readFully(this.data);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            byte[] outdata = new byte[(this.opcode & 0xFF00) >>> 7];
            int i = 0;
            while (i < this.data.length && i < outdata.length) {
                outdata[i] = this.data[i];
                ++i;
            }
            out.write(outdata);
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            if (this.data.length <= 64) {
                byte[] byArray = this.data;
                int n = this.data.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append("Data[" + this.data.length + "]");
            }
            return sb.toString();
        }
    }

    public static interface FontConstants {
        public static final int CHICAGO = 0;
        public static final int NEW_YORK = 2;
        public static final int GENEVA = 3;
        public static final int MONACO = 4;
        public static final int VENICE = 5;
        public static final int LONDON = 6;
        public static final int ATHENS = 7;
        public static final int SAN_FRANCISCO = 8;
        public static final int TORONTO = 9;
        public static final int CAIRO = 11;
        public static final int LOS_ANGELES = 12;
        public static final int ZAPF_DINGBATS = 13;
        public static final int BOOKMAN = 14;
        public static final int HELVETICA_NARROW = 15;
        public static final int PALATINO = 16;
        public static final int ZAPF_CHANCERY = 18;
        public static final int TIMES = 20;
        public static final int HELVETICA = 21;
        public static final int COURIER = 22;
        public static final int SYMBOL = 23;
        public static final int MOBILE = 24;
        public static final int AVANT_GARDE = 33;
        public static final int NEW_CENTURY_SCHOOLBOOK = 34;
        public static final int KEYBOARD = 98;
        public static final int LAST_RESORT = 99;
        public static final int ZAPFINO = 642;
        public static final int LUCIDA_GRANDE = 1024;
        public static final int TREBUCHET_MS = 1109;
        public static final int ITC_ZAPF_DINGBATS = 1236;
        public static final int ITC_ZAPF_CHANCERY = 1237;
        public static final int ITC_BOOKMAN = 1238;
        public static final int ARIAL_NARROW = 2000;
        public static final int ARIAL = 2001;
        public static final int CHARCOAL = 2002;
        public static final int CAPITALS = 2003;
        public static final int SAND = 2004;
        public static final int COURIER_NEW = 2005;
        public static final int TECHNO = 2006;
        public static final int MONOTYPE_SORTS = 2007;
        public static final int CENTURY_SCHOOLBOOK = 2008;
        public static final int MONOTYPE_CORSIVA = 2009;
        public static final int TIMES_NEW_ROMAN = 2010;
        public static final int WINGDINGS = 2011;
        public static final int HOEFLER_TEXT = 2013;
        public static final int HOEFLER_TEXT_ORNAMENTS = 2018;
        public static final int IMPACT = 2039;
        public static final int SKIA = 2040;
        public static final int WINGDINGS_3 = 2052;
        public static final int TEXTILE = 2305;
        public static final int GADGET = 2307;
        public static final int APPLE_CHANCERY = 2311;
        public static final int COMIC_SANS_MS = 4513;
        public static final int ANDALE_MONO = 7102;
        public static final int VERDANA = 7203;
        public static final int ARIAL_BLACK = 12077;
        public static final int GEORGIA = 12171;
        public static final int WEBDINGS = 14213;
        public static final int OSAKA = 16384;
        public static final int TAIPEI = 16896;
        public static final int BIAUKAI = 17082;
        public static final int APPLE_LIGOTHIC = 17168;
        public static final int APPLE_LISUNG = 17170;
        public static final int SEOUL = 17408;
        public static final int APPLE_MYUNGJO = 17409;
        public static final int APPLE_GOTHIC = 17410;
        public static final int GENEVA_CY = 19459;
        public static final int MONACO_CY = 19460;
        public static final int CHARCOAL_CY = 19461;
        public static final int HELVETICA_CY = 19492;
        public static final int TIMES_CY = 19540;
        public static final int BEIJING = 28672;
        public static final int SONG = 28929;
        public static final int HEI = 28930;
        public static final int KAI = 28931;
        public static final int FANG_SONG = 28932;
        public static final int GENEVA_CE = 30723;
        public static final int MONACO_CE = 30724;
        public static final int TIMES_CE = 30740;
        public static final int HELVETICA_CE = 30741;
        public static final int COURIER_CE = 30742;
    }

    public static class FontName
    extends PICTInstruction
    implements FontConstants {
        public static final int OPCODE = 44;
        public int fontID;
        public String fontName;

        public FontName() {
            this.opcode = 44;
        }

        public FontName(int fontID, String fontName) {
            this.opcode = 44;
            this.fontID = fontID;
            this.fontName = fontName;
        }

        public FontName(String fontName) {
            this.opcode = 44;
            if (fontName.equalsIgnoreCase("Chicago")) {
                this.fontID = 0;
            } else {
                boolean found = false;
                int i = 2;
                while (i < 32768) {
                    if (FontName.fontToString(i).equalsIgnoreCase(fontName)) {
                        this.fontID = i;
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    this.fontID = -((int)Math.ceil(Math.random() * 32767.0 + 1.0));
                }
            }
            this.fontName = fontName;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            in.readShort();
            this.fontID = in.readShort();
            byte[] fnd = new byte[in.readUnsignedByte()];
            in.readFully(fnd);
            this.fontName = PICTUtilities.decodeString(fnd);
            if (v2 && (fnd.length & 1) == 0) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            byte[] fnd = PICTUtilities.encodeString(this.fontName);
            out.writeShort(3 + fnd.length);
            out.writeShort(this.fontID);
            out.writeByte(fnd.length);
            out.write(fnd);
            if (v2 && (fnd.length & 1) == 0) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.fontID) + " " + this.fontName.trim();
        }
    }

    public static class FrameArc
    extends ArcInstruction {
        public static final int OPCODE = 96;

        public FrameArc() {
            this.opcode = 96;
        }

        public FrameArc(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 96;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class FrameOval
    extends RectangleInstruction {
        public static final int OPCODE = 80;

        public FrameOval() {
            this.opcode = 80;
        }

        public FrameOval(Rect rect) {
            this.opcode = 80;
            this.rect = rect;
        }
    }

    public static class FramePoly
    extends PolygonInstruction {
        public static final int OPCODE = 112;

        public FramePoly() {
            this.opcode = 112;
        }

        public FramePoly(Polygon poly) {
            this.opcode = 112;
            this.poly = poly;
        }
    }

    public static class FrameRRect
    extends RectangleInstruction {
        public static final int OPCODE = 64;

        public FrameRRect() {
            this.opcode = 64;
        }

        public FrameRRect(Rect rect) {
            this.opcode = 64;
            this.rect = rect;
        }
    }

    public static class FrameRect
    extends RectangleInstruction {
        public static final int OPCODE = 48;

        public FrameRect() {
            this.opcode = 48;
        }

        public FrameRect(Rect rect) {
            this.opcode = 48;
            this.rect = rect;
        }
    }

    public static class FrameRgn
    extends RegionInstruction {
        public static final int OPCODE = 128;

        public FrameRgn() {
            this.opcode = 128;
        }

        public FrameRgn(Region rgn) {
            this.opcode = 128;
            this.rgn = rgn;
        }
    }

    public static class FrameSameArc
    extends SameArcInstruction {
        public static final int OPCODE = 104;

        public FrameSameArc() {
            this.opcode = 104;
        }

        public FrameSameArc(int startAngle, int arcAngle) {
            this.opcode = 104;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class FrameSameOval
    extends ImpliedInstruction {
        public static final int OPCODE = 88;

        public FrameSameOval() {
            this.opcode = 88;
        }
    }

    public static class FrameSamePoly
    extends ImpliedInstruction {
        public static final int OPCODE = 120;

        public FrameSamePoly() {
            this.opcode = 120;
        }
    }

    public static class FrameSameRRect
    extends ImpliedInstruction {
        public static final int OPCODE = 72;

        public FrameSameRRect() {
            this.opcode = 72;
        }
    }

    public static class FrameSameRect
    extends ImpliedInstruction {
        public static final int OPCODE = 56;

        public FrameSameRect() {
            this.opcode = 56;
        }
    }

    public static class FrameSameRgn
    extends ImpliedInstruction {
        public static final int OPCODE = 136;

        public FrameSameRgn() {
            this.opcode = 136;
        }
    }

    public static class GlyphState
    extends PICTInstruction {
        public static final int OPCODE = 46;
        public boolean outlinePreferred;
        public boolean preserveGlyph;
        public boolean fractionalWidths;
        public boolean scalingDisabled;
        public boolean[] extra;

        public GlyphState() {
            this.opcode = 46;
            this.extra = new boolean[2];
        }

        public GlyphState(boolean op, boolean pg, boolean fw, boolean sd) {
            this.opcode = 46;
            this.outlinePreferred = op;
            this.preserveGlyph = pg;
            this.fractionalWidths = fw;
            this.scalingDisabled = sd;
            this.extra = new boolean[2];
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.extra = new boolean[in.readShort() - 4];
            this.outlinePreferred = in.readBoolean();
            this.preserveGlyph = in.readBoolean();
            this.fractionalWidths = in.readBoolean();
            this.scalingDisabled = in.readBoolean();
            int i = 0;
            while (i < this.extra.length) {
                this.extra[i] = in.readBoolean();
                ++i;
            }
            if (v2 && (this.extra.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(4 + this.extra.length);
            out.writeBoolean(this.outlinePreferred);
            out.writeBoolean(this.preserveGlyph);
            out.writeBoolean(this.fractionalWidths);
            out.writeBoolean(this.scalingDisabled);
            boolean[] blArray = this.extra;
            int n = this.extra.length;
            int n2 = 0;
            while (n2 < n) {
                boolean b = blArray[n2];
                out.writeBoolean(b);
                ++n2;
            }
            if (v2 & (this.extra.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            if (this.outlinePreferred) {
                sb.append(", outlinePreferred");
            }
            if (this.preserveGlyph) {
                sb.append(", preserveGlyph");
            }
            if (this.fractionalWidths) {
                sb.append(", fractionalWidths");
            }
            if (this.scalingDisabled) {
                sb.append(", scalingDisabled");
            }
            int i = 0;
            while (i < this.extra.length) {
                if (this.extra[i]) {
                    sb.append(", " + (i + 4));
                }
                ++i;
            }
            if (sb.length() >= 2) {
                return sb.toString().substring(2);
            }
            return "";
        }
    }

    public static class HeaderOp
    extends PICTInstruction {
        public static final int OPCODE = 3072;
        public int version;
        public int reserved1;
        public float hRes;
        public float vRes;
        public Rectangle2D srcRect;
        public int reserved2;

        public HeaderOp() {
            this.opcode = 3072;
        }

        public HeaderOp(int v, float hRes, float vRes, Rectangle2D rect) {
            this.opcode = 3072;
            this.version = v;
            this.reserved1 = 0;
            this.hRes = hRes;
            this.vRes = vRes;
            this.srcRect = rect;
            this.reserved2 = 0;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.version = in.readShort();
            if (this.version <= -2) {
                this.reserved1 = in.readShort();
                this.hRes = (float)in.readInt() / 65536.0f;
                this.vRes = (float)in.readInt() / 65536.0f;
                short top = in.readShort();
                short left = in.readShort();
                short bottom = in.readShort();
                short right = in.readShort();
                this.srcRect = new Rectangle(left, top, right - left, bottom - top);
                this.reserved2 = in.readInt();
            } else {
                this.version = (this.version & 0xFFFF) << 16 | in.readShort() & 0xFFFF;
                this.reserved1 = 0;
                this.hRes = 72.0f;
                this.vRes = 72.0f;
                float left = (float)in.readInt() / 65536.0f;
                float top = (float)in.readInt() / 65536.0f;
                float right = (float)in.readInt() / 65536.0f;
                float bottom = (float)in.readInt() / 65536.0f;
                this.srcRect = new Rectangle2D.Float(left, top, right - left, bottom - top);
                this.reserved2 = in.readInt();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            if (this.version <= -2) {
                out.writeShort(this.version);
                out.writeShort(this.reserved1);
                out.writeInt((int)(this.hRes * 65536.0f));
                out.writeInt((int)(this.vRes * 65536.0f));
                out.writeShort((short)this.srcRect.getMinY());
                out.writeShort((short)this.srcRect.getMinX());
                out.writeShort((short)this.srcRect.getMaxY());
                out.writeShort((short)this.srcRect.getMaxX());
                out.writeInt(this.reserved2);
            } else {
                out.writeInt(this.version);
                out.writeInt((int)(this.srcRect.getMinY() * 65536.0));
                out.writeInt((int)(this.srcRect.getMinX() * 65536.0));
                out.writeInt((int)(this.srcRect.getMaxY() * 65536.0));
                out.writeInt((int)(this.srcRect.getMaxX() * 65536.0));
                out.writeInt(this.reserved2);
            }
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.version) + " " + this.hRes + "*" + this.vRes + " " + this.srcRect.getMinX() + "," + this.srcRect.getMinY() + "," + this.srcRect.getMaxX() + "," + this.srcRect.getMaxY();
        }
    }

    public static class HiliteColor
    extends RGBColorInstruction {
        public static final int OPCODE = 29;

        public HiliteColor() {
            this.opcode = 29;
        }

        public HiliteColor(RGBColor color) {
            this.opcode = 29;
            this.color = color;
        }
    }

    public static class HiliteMode
    extends ImpliedInstruction {
        public static final int OPCODE = 28;

        public HiliteMode() {
            this.opcode = 28;
        }
    }

    public static abstract class ImpliedInstruction
    extends PICTInstruction {
        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
        }

        @Override
        protected String toStringImpl() {
            return "";
        }
    }

    public static class InvertArc
    extends ArcInstruction {
        public static final int OPCODE = 99;

        public InvertArc() {
            this.opcode = 99;
        }

        public InvertArc(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 99;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class InvertOval
    extends RectangleInstruction {
        public static final int OPCODE = 83;

        public InvertOval() {
            this.opcode = 83;
        }

        public InvertOval(Rect rect) {
            this.opcode = 83;
            this.rect = rect;
        }
    }

    public static class InvertPoly
    extends PolygonInstruction {
        public static final int OPCODE = 115;

        public InvertPoly() {
            this.opcode = 115;
        }

        public InvertPoly(Polygon poly) {
            this.opcode = 115;
            this.poly = poly;
        }
    }

    public static class InvertRRect
    extends RectangleInstruction {
        public static final int OPCODE = 67;

        public InvertRRect() {
            this.opcode = 67;
        }

        public InvertRRect(Rect rect) {
            this.opcode = 67;
            this.rect = rect;
        }
    }

    public static class InvertRect
    extends RectangleInstruction {
        public static final int OPCODE = 51;

        public InvertRect() {
            this.opcode = 51;
        }

        public InvertRect(Rect rect) {
            this.opcode = 51;
            this.rect = rect;
        }
    }

    public static class InvertRgn
    extends RegionInstruction {
        public static final int OPCODE = 131;

        public InvertRgn() {
            this.opcode = 131;
        }

        public InvertRgn(Region rgn) {
            this.opcode = 131;
            this.rgn = rgn;
        }
    }

    public static class InvertSameArc
    extends SameArcInstruction {
        public static final int OPCODE = 107;

        public InvertSameArc() {
            this.opcode = 107;
        }

        public InvertSameArc(int startAngle, int arcAngle) {
            this.opcode = 107;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class InvertSameOval
    extends ImpliedInstruction {
        public static final int OPCODE = 91;

        public InvertSameOval() {
            this.opcode = 91;
        }
    }

    public static class InvertSamePoly
    extends ImpliedInstruction {
        public static final int OPCODE = 123;

        public InvertSamePoly() {
            this.opcode = 123;
        }
    }

    public static class InvertSameRRect
    extends ImpliedInstruction {
        public static final int OPCODE = 75;

        public InvertSameRRect() {
            this.opcode = 75;
        }
    }

    public static class InvertSameRect
    extends ImpliedInstruction {
        public static final int OPCODE = 59;

        public InvertSameRect() {
            this.opcode = 59;
        }
    }

    public static class InvertSameRgn
    extends ImpliedInstruction {
        public static final int OPCODE = 139;

        public InvertSameRgn() {
            this.opcode = 139;
        }
    }

    public static class Line
    extends PICTInstruction {
        public static final int OPCODE = 32;
        public Point pnLoc;
        public Point newPt;

        public Line() {
            this.opcode = 32;
        }

        public Line(Point p1, Point p2) {
            this.opcode = 32;
            this.pnLoc = p1;
            this.newPt = p2;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pnLoc = Point.read(in);
            this.newPt = Point.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pnLoc.write(out);
            this.newPt.write(out);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.pnLoc.toString()) + " " + this.newPt.toString();
        }
    }

    public static class LineFrom
    extends PICTInstruction {
        public static final int OPCODE = 33;
        public Point newPt;

        public LineFrom() {
            this.opcode = 33;
        }

        public LineFrom(Point p2) {
            this.opcode = 33;
            this.newPt = p2;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.newPt = Point.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.newPt.write(out);
        }

        @Override
        protected String toStringImpl() {
            return this.newPt.toString();
        }
    }

    public static class LineJustify
    extends PICTInstruction {
        public static final int OPCODE = 45;
        public float spacing;
        public float spExtra;

        public LineJustify() {
            this.opcode = 45;
        }

        public LineJustify(float spacing, float spExtra) {
            this.opcode = 45;
            this.spacing = spacing;
            this.spExtra = spExtra;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            in.readShort();
            this.spacing = (float)in.readInt() / 65536.0f;
            this.spExtra = (float)in.readInt() / 65536.0f;
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(8);
            out.writeInt((int)(this.spacing * 65536.0f));
            out.writeInt((int)(this.spExtra * 65536.0f));
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.spacing) + " " + this.spExtra;
        }
    }

    public static class LongComment
    extends PICTInstruction
    implements CommentConstants {
        public static final int OPCODE = 161;
        public int kind;
        public int appID;
        public int ppcID;
        public byte[] data;

        public LongComment() {
            this.opcode = 161;
        }

        public LongComment(int kind, byte[] data) {
            this.opcode = 161;
            this.kind = kind;
            this.appID = 0;
            this.ppcID = 0;
            this.data = data;
        }

        public LongComment(int kind, int appID, byte[] data) {
            this.opcode = 161;
            this.kind = kind;
            this.appID = appID;
            this.ppcID = 0;
            this.data = data;
        }

        public LongComment(int kind, int appID, int ppcID, byte[] data) {
            this.opcode = 161;
            this.kind = kind;
            this.appID = appID;
            this.ppcID = ppcID;
            this.data = data;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.kind = in.readShort();
            int size = in.readUnsignedShort();
            if (this.kind == 100) {
                this.appID = in.readInt();
                size -= 4;
                if (this.appID == 1263554132) {
                    this.ppcID = in.readInt();
                    size -= 4;
                } else {
                    this.ppcID = 0;
                }
            } else {
                this.appID = 0;
                this.ppcID = 0;
            }
            this.data = new byte[size];
            in.readFully(this.data);
            if (v2 & (this.data.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.kind);
            if (this.kind == 100) {
                if (this.appID == 1263554132) {
                    out.writeShort(8 + this.data.length);
                    out.writeInt(this.appID);
                    out.writeInt(this.ppcID);
                } else {
                    out.writeShort(4 + this.data.length);
                    out.writeInt(this.appID);
                }
            } else {
                out.writeShort(this.data.length);
            }
            out.write(this.data);
            if (v2 & (this.data.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            sb.append(LongComment.commentToString(this.kind));
            if (this.kind == 100) {
                sb.append(" " + LongComment.osTypeToString(this.appID));
                if (this.appID == 1263554132) {
                    sb.append(" " + LongComment.osTypeToString(this.ppcID));
                }
            }
            if (this.data.length <= 64) {
                sb.append(" ");
                byte[] byArray = this.data;
                int n = this.data.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append(" Data[" + this.data.length + "]");
            }
            return sb.toString();
        }
    }

    public static abstract class LongDataInstruction
    extends PICTInstruction {
        public byte[] data;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.data = new byte[in.readInt()];
            in.readFully(this.data);
            if (v2 && (this.data.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeInt(this.data.length);
            out.write(this.data);
            if (v2 && (this.data.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            if (this.data.length <= 64) {
                byte[] byArray = this.data;
                int n = this.data.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append("Data[" + this.data.length + "]");
            }
            return sb.toString();
        }
    }

    public static class LongText
    extends PICTInstruction {
        public static final int OPCODE = 40;
        public Point txLoc;
        public String text;

        public LongText() {
            this.opcode = 40;
        }

        public LongText(Point p, String s) {
            this.opcode = 40;
            this.txLoc = p;
            this.text = s;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.txLoc = Point.read(in);
            byte[] td = new byte[in.readUnsignedByte()];
            in.readFully(td);
            this.text = PICTUtilities.decodeString(td);
            if (v2 && (td.length & 1) == 0) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.txLoc.write(out);
            byte[] td = PICTUtilities.encodeString(this.text);
            out.writeByte(td.length);
            out.write(td);
            if (v2 && (td.length & 1) == 0) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.txLoc.toString()) + " " + this.text.trim();
        }
    }

    public static interface ModeConstants {
        public static final int SRC_COPY = 0;
        public static final int SRC_OR = 1;
        public static final int SRC_XOR = 2;
        public static final int SRC_BIC = 3;
        public static final int NOT_SRC_COPY = 4;
        public static final int NOT_SRC_OR = 5;
        public static final int NOT_SRC_XOR = 6;
        public static final int NOT_SRC_BIC = 7;
        public static final int BLEND = 32;
        public static final int ADD_PIN = 33;
        public static final int ADD_OVER = 34;
        public static final int SUB_PIN = 35;
        public static final int TRANSPARENT = 36;
        public static final int ADD_MAX = 37;
        public static final int SUB_OVER = 38;
        public static final int ADD_MIN = 39;
        public static final int GRAYISH_TEXT_OR = 49;
        public static final int HILITE = 50;
        public static final int DITHER_COPY = 64;
    }

    public static abstract class ModeInstruction
    extends PICTInstruction
    implements ModeConstants {
        public int mode;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.mode = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.mode);
        }

        @Override
        protected String toStringImpl() {
            return ModeInstruction.modeToString(this.mode);
        }
    }

    public static class NOP
    extends ImpliedInstruction {
        public static final int OPCODE = 0;

        public NOP() {
            this.opcode = 0;
        }
    }

    public static class OpColor
    extends RGBColorInstruction {
        public static final int OPCODE = 31;

        public OpColor() {
            this.opcode = 31;
        }

        public OpColor(RGBColor color) {
            this.opcode = 31;
            this.color = color;
        }
    }

    public static class OpEndPic
    extends ImpliedInstruction {
        public static final int OPCODE = 255;

        public OpEndPic() {
            this.opcode = 255;
        }
    }

    public static class Origin
    extends PICTInstruction {
        public static final int OPCODE = 12;
        public int dh;
        public int dv;

        public Origin() {
            this.opcode = 12;
        }

        public Origin(int dh, int dv) {
            this.opcode = 12;
            this.dh = dh;
            this.dv = dv;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.dh = in.readShort();
            this.dv = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.dh);
            out.writeShort(this.dv);
        }

        @Override
        protected String toStringImpl() {
            return (this.dh < 0 ? Integer.valueOf(this.dh) : "+" + this.dh) + "," + (this.dv < 0 ? Integer.valueOf(this.dv) : "+" + this.dv);
        }
    }

    public static class OvSize
    extends PICTInstruction {
        public static final int OPCODE = 11;
        public int ovalHeight;
        public int ovalWidth;

        public OvSize() {
            this.opcode = 11;
        }

        public OvSize(int w, int h) {
            this.opcode = 11;
            this.ovalWidth = w;
            this.ovalHeight = h;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.ovalHeight = in.readShort();
            this.ovalWidth = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.ovalHeight);
            out.writeShort(this.ovalWidth);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.ovalWidth) + "*" + this.ovalHeight;
        }
    }

    public static class PackBitsRect
    extends CopyBitsRectInstruction {
        public static final int OPCODE = 152;

        public PackBitsRect() {
            this.opcode = 152;
        }

        public PackBitsRect(PixMap pm, ColorTable ct, Rect src, Rect dst, int mode, byte[] data) {
            this.opcode = 152;
            this.pixMap = pm;
            this.colorTable = ct;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.pixData = data;
        }
    }

    public static class PackBitsRgn
    extends CopyBitsRegionInstruction {
        public static final int OPCODE = 153;

        public PackBitsRgn() {
            this.opcode = 153;
        }

        public PackBitsRgn(PixMap pm, ColorTable ct, Rect src, Rect dst, int mode, Region rgn, byte[] data) {
            this.opcode = 153;
            this.pixMap = pm;
            this.colorTable = ct;
            this.srcRect = src;
            this.dstRect = dst;
            this.mode = mode;
            this.maskRgn = rgn;
            this.pixData = data;
        }
    }

    public static class PaintArc
    extends ArcInstruction {
        public static final int OPCODE = 97;

        public PaintArc() {
            this.opcode = 97;
        }

        public PaintArc(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 97;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class PaintOval
    extends RectangleInstruction {
        public static final int OPCODE = 81;

        public PaintOval() {
            this.opcode = 81;
        }

        public PaintOval(Rect rect) {
            this.opcode = 81;
            this.rect = rect;
        }
    }

    public static class PaintPoly
    extends PolygonInstruction {
        public static final int OPCODE = 113;

        public PaintPoly() {
            this.opcode = 113;
        }

        public PaintPoly(Polygon poly) {
            this.opcode = 113;
            this.poly = poly;
        }
    }

    public static class PaintRRect
    extends RectangleInstruction {
        public static final int OPCODE = 65;

        public PaintRRect() {
            this.opcode = 65;
        }

        public PaintRRect(Rect rect) {
            this.opcode = 65;
            this.rect = rect;
        }
    }

    public static class PaintRect
    extends RectangleInstruction {
        public static final int OPCODE = 49;

        public PaintRect() {
            this.opcode = 49;
        }

        public PaintRect(Rect rect) {
            this.opcode = 49;
            this.rect = rect;
        }
    }

    public static class PaintRgn
    extends RegionInstruction {
        public static final int OPCODE = 129;

        public PaintRgn() {
            this.opcode = 129;
        }

        public PaintRgn(Region rgn) {
            this.opcode = 129;
            this.rgn = rgn;
        }
    }

    public static class PaintSameArc
    extends SameArcInstruction {
        public static final int OPCODE = 105;

        public PaintSameArc() {
            this.opcode = 105;
        }

        public PaintSameArc(int startAngle, int arcAngle) {
            this.opcode = 105;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class PaintSameOval
    extends ImpliedInstruction {
        public static final int OPCODE = 89;

        public PaintSameOval() {
            this.opcode = 89;
        }
    }

    public static class PaintSamePoly
    extends ImpliedInstruction {
        public static final int OPCODE = 121;

        public PaintSamePoly() {
            this.opcode = 121;
        }
    }

    public static class PaintSameRRect
    extends ImpliedInstruction {
        public static final int OPCODE = 73;

        public PaintSameRRect() {
            this.opcode = 73;
        }
    }

    public static class PaintSameRect
    extends ImpliedInstruction {
        public static final int OPCODE = 57;

        public PaintSameRect() {
            this.opcode = 57;
        }
    }

    public static class PaintSameRgn
    extends ImpliedInstruction {
        public static final int OPCODE = 137;

        public PaintSameRgn() {
            this.opcode = 137;
        }
    }

    public static interface PatternConstants {
        public static final long BLACK = -1L;
        public static final long DKGRAY = -2488276762212442761L;
        public static final long GRAY = -6172840429334713771L;
        public static final long LTGRAY = -8637191453448959966L;
        public static final long WHITE = 0L;
    }

    public static abstract class PatternInstruction
    extends PICTInstruction
    implements PatternConstants {
        public long pat;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pat = in.readLong();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeLong(this.pat);
        }

        @Override
        protected String toStringImpl() {
            return PatternInstruction.patternToString(this.pat);
        }
    }

    public static abstract class PixelPatternInstruction
    extends PICTInstruction {
        public static final int DITHER_PAT = 2;
        public static final int PIXEL_PAT = 1;
        public static final int BW_PAT = 0;
        public int patType;
        public long pat1Data;
        public RGBColor rgb;
        public PixMap pixMap;
        public ColorTable colorTable;
        public byte[] pixData;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.patType = in.readShort();
            this.pat1Data = in.readLong();
            switch (this.patType) {
                case 2: {
                    this.rgb = RGBColor.read(in);
                    this.pixMap = null;
                    this.colorTable = null;
                    this.pixData = null;
                    break;
                }
                case 1: {
                    this.rgb = null;
                    this.pixMap = PixMap.read(in, false);
                    this.colorTable = this.pixMap.hasColorTable() ? ColorTable.read(in) : null;
                    this.pixData = this.pixMap.readPixData(in, false);
                    if (!v2 || (this.pixData.length & 1) != 1) break;
                    in.readByte();
                    break;
                }
                default: {
                    this.rgb = null;
                    this.pixMap = null;
                    this.colorTable = null;
                    this.pixData = null;
                }
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.patType);
            out.writeLong(this.pat1Data);
            switch (this.patType) {
                case 2: {
                    this.rgb.write(out);
                    break;
                }
                case 1: {
                    this.pixMap.write(out, false);
                    if (this.colorTable != null) {
                        this.colorTable.write(out);
                    }
                    this.pixMap.writePixData(out, this.pixData);
                    if (!v2 || (this.pixData.length & 1) != 1) break;
                    out.writeByte(0);
                }
            }
        }

        @Override
        protected String toStringImpl() {
            String s = this.patType == 2 ? "ditherPat" : (this.patType == 1 ? "pixelPat" : "bwPat");
            s = String.valueOf(s) + " " + PixelPatternInstruction.patternToString(this.pat1Data);
            switch (this.patType) {
                case 2: {
                    s = String.valueOf(s) + " " + this.rgb.toString();
                    break;
                }
                case 1: {
                    s = String.valueOf(s) + " " + this.pixMap.toString();
                    if (this.colorTable == null) break;
                    s = String.valueOf(s) + " " + this.colorTable.toString();
                }
            }
            return s;
        }
    }

    public static class PnLocHFrac
    extends PICTInstruction {
        public static final int OPCODE = 21;
        public float hfrac;

        public PnLocHFrac() {
            this.opcode = 21;
        }

        public PnLocHFrac(float hfrac) {
            this.opcode = 21;
            this.hfrac = hfrac;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.hfrac = (float)in.readUnsignedShort() / 65536.0f;
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort((int)(this.hfrac * 65536.0f));
        }

        @Override
        protected String toStringImpl() {
            return Float.toString(this.hfrac);
        }
    }

    public static class PnMode
    extends ModeInstruction {
        public static final int OPCODE = 8;

        public PnMode() {
            this.opcode = 8;
        }

        public PnMode(int mode) {
            this.opcode = 8;
            this.mode = mode;
        }
    }

    public static class PnPat
    extends PatternInstruction {
        public static final int OPCODE = 9;

        public PnPat() {
            this.opcode = 9;
        }

        public PnPat(long pat) {
            this.opcode = 9;
            this.pat = pat;
        }
    }

    public static class PnPixPat
    extends PixelPatternInstruction {
        public static final int OPCODE = 19;

        public PnPixPat() {
            this.opcode = 19;
        }

        public PnPixPat(long pat) {
            this.opcode = 19;
            this.patType = 0;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public PnPixPat(long pat, RGBColor color) {
            this.opcode = 19;
            this.patType = 2;
            this.pat1Data = pat;
            this.rgb = color;
            this.pixMap = null;
            this.colorTable = null;
            this.pixData = null;
        }

        public PnPixPat(long pat, PixMap pm, ColorTable ct, byte[] data) {
            this.opcode = 19;
            this.patType = 1;
            this.pat1Data = pat;
            this.rgb = null;
            this.pixMap = pm;
            this.colorTable = ct;
            this.pixData = data;
        }
    }

    public static class PnSize
    extends PICTInstruction {
        public static final int OPCODE = 7;
        public int penHeight;
        public int penWidth;

        public PnSize() {
            this.opcode = 7;
        }

        public PnSize(int w, int h) {
            this.opcode = 7;
            this.penHeight = h;
            this.penWidth = w;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.penHeight = in.readShort();
            this.penWidth = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.penHeight);
            out.writeShort(this.penWidth);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.penWidth) + "*" + this.penHeight;
        }
    }

    public static abstract class PolygonInstruction
    extends PICTInstruction {
        public Polygon poly;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.poly = Polygon.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.poly.write(out);
        }

        @Override
        protected String toStringImpl() {
            return this.poly.toString();
        }
    }

    public static class RGBBkCol
    extends RGBColorInstruction {
        public static final int OPCODE = 27;

        public RGBBkCol() {
            this.opcode = 27;
        }

        public RGBBkCol(RGBColor color) {
            this.opcode = 27;
            this.color = color;
        }
    }

    public static abstract class RGBColorInstruction
    extends PICTInstruction {
        public RGBColor color;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.color = RGBColor.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.color.write(out);
        }

        @Override
        protected String toStringImpl() {
            return this.color.toString();
        }
    }

    public static class RGBFgCol
    extends RGBColorInstruction {
        public static final int OPCODE = 26;

        public RGBFgCol() {
            this.opcode = 26;
        }

        public RGBFgCol(RGBColor color) {
            this.opcode = 26;
            this.color = color;
        }
    }

    public static abstract class RectangleInstruction
    extends PICTInstruction {
        public Rect rect;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.rect = Rect.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.rect.write(out);
        }

        @Override
        protected String toStringImpl() {
            return this.rect.toString();
        }
    }

    public static abstract class RegionInstruction
    extends PICTInstruction {
        public Region rgn;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.rgn = Region.read(in);
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.rgn.write(out);
        }

        @Override
        protected String toStringImpl() {
            return this.rgn.toString();
        }
    }

    public static class Reserved0017
    extends ImpliedInstruction {
        public static final int OPCODE = 23;

        public Reserved0017() {
            this.opcode = 23;
        }
    }

    public static class Reserved0018
    extends ImpliedInstruction {
        public static final int OPCODE = 24;

        public Reserved0018() {
            this.opcode = 24;
        }
    }

    public static class Reserved0019
    extends ImpliedInstruction {
        public static final int OPCODE = 25;

        public Reserved0019() {
            this.opcode = 25;
        }
    }

    public static class Reserved0024
    extends ShortDataInstruction {
        public static final int OPCODE = 36;

        public Reserved0024() {
            this.opcode = 36;
        }

        public Reserved0024(byte[] data) {
            this.opcode = 36;
            this.data = data;
        }
    }

    public static class Reserved0025
    extends ShortDataInstruction {
        public static final int OPCODE = 37;

        public Reserved0025() {
            this.opcode = 37;
        }

        public Reserved0025(byte[] data) {
            this.opcode = 37;
            this.data = data;
        }
    }

    public static class Reserved0026
    extends ShortDataInstruction {
        public static final int OPCODE = 38;

        public Reserved0026() {
            this.opcode = 38;
        }

        public Reserved0026(byte[] data) {
            this.opcode = 38;
            this.data = data;
        }
    }

    public static class Reserved0027
    extends ShortDataInstruction {
        public static final int OPCODE = 39;

        public Reserved0027() {
            this.opcode = 39;
        }

        public Reserved0027(byte[] data) {
            this.opcode = 39;
            this.data = data;
        }
    }

    public static class Reserved002F
    extends ShortDataInstruction {
        public static final int OPCODE = 47;

        public Reserved002F() {
            this.opcode = 47;
        }

        public Reserved002F(byte[] data) {
            this.opcode = 47;
            this.data = data;
        }
    }

    public static class Reserved0035
    extends RectangleInstruction {
        public static final int OPCODE = 53;

        public Reserved0035() {
            this.opcode = 53;
        }

        public Reserved0035(Rect rect) {
            this.opcode = 53;
            this.rect = rect;
        }
    }

    public static class Reserved0036
    extends RectangleInstruction {
        public static final int OPCODE = 54;

        public Reserved0036() {
            this.opcode = 54;
        }

        public Reserved0036(Rect rect) {
            this.opcode = 54;
            this.rect = rect;
        }
    }

    public static class Reserved0037
    extends RectangleInstruction {
        public static final int OPCODE = 55;

        public Reserved0037() {
            this.opcode = 55;
        }

        public Reserved0037(Rect rect) {
            this.opcode = 55;
            this.rect = rect;
        }
    }

    public static class Reserved003D
    extends ImpliedInstruction {
        public static final int OPCODE = 61;

        public Reserved003D() {
            this.opcode = 61;
        }
    }

    public static class Reserved003E
    extends ImpliedInstruction {
        public static final int OPCODE = 62;

        public Reserved003E() {
            this.opcode = 62;
        }
    }

    public static class Reserved003F
    extends ImpliedInstruction {
        public static final int OPCODE = 63;

        public Reserved003F() {
            this.opcode = 63;
        }
    }

    public static class Reserved0045
    extends RectangleInstruction {
        public static final int OPCODE = 69;

        public Reserved0045() {
            this.opcode = 69;
        }

        public Reserved0045(Rect rect) {
            this.opcode = 69;
            this.rect = rect;
        }
    }

    public static class Reserved0046
    extends RectangleInstruction {
        public static final int OPCODE = 70;

        public Reserved0046() {
            this.opcode = 70;
        }

        public Reserved0046(Rect rect) {
            this.opcode = 70;
            this.rect = rect;
        }
    }

    public static class Reserved0047
    extends RectangleInstruction {
        public static final int OPCODE = 71;

        public Reserved0047() {
            this.opcode = 71;
        }

        public Reserved0047(Rect rect) {
            this.opcode = 71;
            this.rect = rect;
        }
    }

    public static class Reserved004D
    extends ImpliedInstruction {
        public static final int OPCODE = 77;

        public Reserved004D() {
            this.opcode = 77;
        }
    }

    public static class Reserved004E
    extends ImpliedInstruction {
        public static final int OPCODE = 78;

        public Reserved004E() {
            this.opcode = 78;
        }
    }

    public static class Reserved004F
    extends ImpliedInstruction {
        public static final int OPCODE = 79;

        public Reserved004F() {
            this.opcode = 79;
        }
    }

    public static class Reserved0055
    extends RectangleInstruction {
        public static final int OPCODE = 85;

        public Reserved0055() {
            this.opcode = 85;
        }

        public Reserved0055(Rect rect) {
            this.opcode = 85;
            this.rect = rect;
        }
    }

    public static class Reserved0056
    extends RectangleInstruction {
        public static final int OPCODE = 86;

        public Reserved0056() {
            this.opcode = 86;
        }

        public Reserved0056(Rect rect) {
            this.opcode = 86;
            this.rect = rect;
        }
    }

    public static class Reserved0057
    extends RectangleInstruction {
        public static final int OPCODE = 87;

        public Reserved0057() {
            this.opcode = 87;
        }

        public Reserved0057(Rect rect) {
            this.opcode = 87;
            this.rect = rect;
        }
    }

    public static class Reserved005D
    extends ImpliedInstruction {
        public static final int OPCODE = 93;

        public Reserved005D() {
            this.opcode = 93;
        }
    }

    public static class Reserved005E
    extends ImpliedInstruction {
        public static final int OPCODE = 94;

        public Reserved005E() {
            this.opcode = 94;
        }
    }

    public static class Reserved005F
    extends ImpliedInstruction {
        public static final int OPCODE = 95;

        public Reserved005F() {
            this.opcode = 95;
        }
    }

    public static class Reserved0065
    extends ArcInstruction {
        public static final int OPCODE = 101;

        public Reserved0065() {
            this.opcode = 101;
        }

        public Reserved0065(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 101;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved0066
    extends ArcInstruction {
        public static final int OPCODE = 102;

        public Reserved0066() {
            this.opcode = 102;
        }

        public Reserved0066(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 102;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved0067
    extends ArcInstruction {
        public static final int OPCODE = 103;

        public Reserved0067() {
            this.opcode = 103;
        }

        public Reserved0067(Rect rect, int startAngle, int arcAngle) {
            this.opcode = 103;
            this.rect = rect;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved006D
    extends SameArcInstruction {
        public static final int OPCODE = 109;

        public Reserved006D() {
            this.opcode = 109;
        }

        public Reserved006D(int startAngle, int arcAngle) {
            this.opcode = 109;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved006E
    extends SameArcInstruction {
        public static final int OPCODE = 110;

        public Reserved006E() {
            this.opcode = 110;
        }

        public Reserved006E(int startAngle, int arcAngle) {
            this.opcode = 110;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved006F
    extends SameArcInstruction {
        public static final int OPCODE = 111;

        public Reserved006F() {
            this.opcode = 111;
        }

        public Reserved006F(int startAngle, int arcAngle) {
            this.opcode = 111;
            this.startAngle = startAngle;
            this.arcAngle = arcAngle;
        }
    }

    public static class Reserved0075
    extends PolygonInstruction {
        public static final int OPCODE = 117;

        public Reserved0075() {
            this.opcode = 117;
        }

        public Reserved0075(Polygon poly) {
            this.opcode = 117;
            this.poly = poly;
        }
    }

    public static class Reserved0076
    extends PolygonInstruction {
        public static final int OPCODE = 118;

        public Reserved0076() {
            this.opcode = 118;
        }

        public Reserved0076(Polygon poly) {
            this.opcode = 118;
            this.poly = poly;
        }
    }

    public static class Reserved0077
    extends PolygonInstruction {
        public static final int OPCODE = 119;

        public Reserved0077() {
            this.opcode = 119;
        }

        public Reserved0077(Polygon poly) {
            this.opcode = 119;
            this.poly = poly;
        }
    }

    public static class Reserved007D
    extends ImpliedInstruction {
        public static final int OPCODE = 125;

        public Reserved007D() {
            this.opcode = 125;
        }
    }

    public static class Reserved007E
    extends ImpliedInstruction {
        public static final int OPCODE = 126;

        public Reserved007E() {
            this.opcode = 126;
        }
    }

    public static class Reserved007F
    extends ImpliedInstruction {
        public static final int OPCODE = 127;

        public Reserved007F() {
            this.opcode = 127;
        }
    }

    public static class Reserved0085
    extends RegionInstruction {
        public static final int OPCODE = 133;

        public Reserved0085() {
            this.opcode = 133;
        }

        public Reserved0085(Region rgn) {
            this.opcode = 133;
            this.rgn = rgn;
        }
    }

    public static class Reserved0086
    extends RegionInstruction {
        public static final int OPCODE = 134;

        public Reserved0086() {
            this.opcode = 134;
        }

        public Reserved0086(Region rgn) {
            this.opcode = 134;
            this.rgn = rgn;
        }
    }

    public static class Reserved0087
    extends RegionInstruction {
        public static final int OPCODE = 135;

        public Reserved0087() {
            this.opcode = 135;
        }

        public Reserved0087(Region rgn) {
            this.opcode = 135;
            this.rgn = rgn;
        }
    }

    public static class Reserved008D
    extends ImpliedInstruction {
        public static final int OPCODE = 141;

        public Reserved008D() {
            this.opcode = 141;
        }
    }

    public static class Reserved008E
    extends ImpliedInstruction {
        public static final int OPCODE = 142;

        public Reserved008E() {
            this.opcode = 142;
        }
    }

    public static class Reserved008F
    extends ImpliedInstruction {
        public static final int OPCODE = 143;

        public Reserved008F() {
            this.opcode = 143;
        }
    }

    public static class Reserved0092
    extends ShortDataInstruction {
        public static final int OPCODE = 146;

        public Reserved0092() {
            this.opcode = 146;
        }

        public Reserved0092(byte[] data) {
            this.opcode = 146;
            this.data = data;
        }
    }

    public static class Reserved0093
    extends ShortDataInstruction {
        public static final int OPCODE = 147;

        public Reserved0093() {
            this.opcode = 147;
        }

        public Reserved0093(byte[] data) {
            this.opcode = 147;
            this.data = data;
        }
    }

    public static class Reserved0094
    extends ShortDataInstruction {
        public static final int OPCODE = 148;

        public Reserved0094() {
            this.opcode = 148;
        }

        public Reserved0094(byte[] data) {
            this.opcode = 148;
            this.data = data;
        }
    }

    public static class Reserved0095
    extends ShortDataInstruction {
        public static final int OPCODE = 149;

        public Reserved0095() {
            this.opcode = 149;
        }

        public Reserved0095(byte[] data) {
            this.opcode = 149;
            this.data = data;
        }
    }

    public static class Reserved0096
    extends ShortDataInstruction {
        public static final int OPCODE = 150;

        public Reserved0096() {
            this.opcode = 150;
        }

        public Reserved0096(byte[] data) {
            this.opcode = 150;
            this.data = data;
        }
    }

    public static class Reserved0097
    extends ShortDataInstruction {
        public static final int OPCODE = 151;

        public Reserved0097() {
            this.opcode = 151;
        }

        public Reserved0097(byte[] data) {
            this.opcode = 151;
            this.data = data;
        }
    }

    public static class Reserved009C
    extends ShortDataInstruction {
        public static final int OPCODE = 156;

        public Reserved009C() {
            this.opcode = 156;
        }

        public Reserved009C(byte[] data) {
            this.opcode = 156;
            this.data = data;
        }
    }

    public static class Reserved009D
    extends ShortDataInstruction {
        public static final int OPCODE = 157;

        public Reserved009D() {
            this.opcode = 157;
        }

        public Reserved009D(byte[] data) {
            this.opcode = 157;
            this.data = data;
        }
    }

    public static class Reserved009E
    extends ShortDataInstruction {
        public static final int OPCODE = 158;

        public Reserved009E() {
            this.opcode = 158;
        }

        public Reserved009E(byte[] data) {
            this.opcode = 158;
            this.data = data;
        }
    }

    public static class Reserved009F
    extends ShortDataInstruction {
        public static final int OPCODE = 159;

        public Reserved009F() {
            this.opcode = 159;
        }

        public Reserved009F(byte[] data) {
            this.opcode = 159;
            this.data = data;
        }
    }

    public static class Reserved00A2to00AF
    extends ShortDataInstruction {
        public static final int OPCODE_MIN = 162;
        public static final int OPCODE_MAX = 175;

        public Reserved00A2to00AF() {
            this.opcode = 162;
        }

        public Reserved00A2to00AF(int opcode, byte[] data) {
            this.opcode = opcode;
            this.data = data;
        }
    }

    public static class Reserved00B0to00CF
    extends ImpliedInstruction {
        public static final int OPCODE_MIN = 176;
        public static final int OPCODE_MAX = 207;

        public Reserved00B0to00CF() {
            this.opcode = 176;
        }

        public Reserved00B0to00CF(int opcode) {
            this.opcode = opcode;
        }
    }

    public static class Reserved00D0to00FF
    extends LongDataInstruction {
        public static final int OPCODE_MIN = 208;
        public static final int OPCODE_MAX = 255;

        public Reserved00D0to00FF() {
            this.opcode = 208;
        }

        public Reserved00D0to00FF(int opcode, byte[] data) {
            this.opcode = opcode;
            this.data = data;
        }
    }

    public static class Reserved0100to7FFF
    extends FixedDataInstruction {
        public static final int OPCODE_MIN = 256;
        public static final int OPCODE_MAX = Short.MAX_VALUE;

        public Reserved0100to7FFF() {
            this.opcode = 256;
        }

        public Reserved0100to7FFF(int opcode, byte[] data) {
            this.opcode = opcode;
            this.data = data;
        }
    }

    public static class Reserved8000to80FF
    extends ImpliedInstruction {
        public static final int OPCODE_MIN = 32768;
        public static final int OPCODE_MAX = 33023;

        public Reserved8000to80FF() {
            this.opcode = 32768;
        }

        public Reserved8000to80FF(int opcode) {
            this.opcode = opcode;
        }
    }

    public static class Reserved8100toFFFF
    extends LongDataInstruction {
        public static final int OPCODE_MIN = 33024;
        public static final int OPCODE_MAX = 65535;

        public Reserved8100toFFFF() {
            this.opcode = 33024;
        }

        public Reserved8100toFFFF(int opcode, byte[] data) {
            this.opcode = opcode;
            this.data = data;
        }
    }

    public static abstract class SameArcInstruction
    extends PICTInstruction {
        public int startAngle;
        public int arcAngle;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.startAngle = in.readShort();
            this.arcAngle = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.startAngle);
            out.writeShort(this.arcAngle);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.startAngle) + " " + this.arcAngle;
        }
    }

    public static class ShortComment
    extends PICTInstruction
    implements CommentConstants {
        public static final int OPCODE = 160;
        public int kind;

        public ShortComment() {
            this.opcode = 160;
        }

        public ShortComment(int kind) {
            this.opcode = 160;
            this.kind = kind;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.kind = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.kind);
        }

        @Override
        protected String toStringImpl() {
            return ShortComment.commentToString(this.kind);
        }
    }

    public static abstract class ShortDataInstruction
    extends PICTInstruction {
        public byte[] data;

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.data = new byte[in.readUnsignedShort()];
            in.readFully(this.data);
            if (v2 && (this.data.length & 1) == 1) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.data.length);
            out.write(this.data);
            if (v2 && (this.data.length & 1) == 1) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            StringBuffer sb = new StringBuffer();
            if (this.data.length <= 64) {
                byte[] byArray = this.data;
                int n = this.data.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String h = "00" + Integer.toHexString(b).toUpperCase();
                    sb.append(h.substring(h.length() - 2));
                    ++n2;
                }
            } else {
                sb.append("Data[" + this.data.length + "]");
            }
            return sb.toString();
        }
    }

    public static class ShortLine
    extends PICTInstruction {
        public static final int OPCODE = 34;
        public Point pnLoc;
        public int dh;
        public int dv;

        public ShortLine() {
            this.opcode = 34;
        }

        public ShortLine(Point p1, int dh, int dv) {
            this.opcode = 34;
            this.pnLoc = p1;
            this.dh = dh;
            this.dv = dv;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.pnLoc = Point.read(in);
            this.dh = in.readByte();
            this.dv = in.readByte();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            this.pnLoc.write(out);
            out.writeByte(this.dh);
            out.writeByte(this.dv);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.pnLoc.toString()) + " " + (this.dh < 0 ? Integer.valueOf(this.dh) : "+" + this.dh) + "," + (this.dv < 0 ? Integer.valueOf(this.dv) : "+" + this.dv);
        }
    }

    public static class ShortLineFrom
    extends PICTInstruction {
        public static final int OPCODE = 35;
        public int dh;
        public int dv;

        public ShortLineFrom() {
            this.opcode = 35;
        }

        public ShortLineFrom(int dh, int dv) {
            this.opcode = 35;
            this.dh = dh;
            this.dv = dv;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.dh = in.readByte();
            this.dv = in.readByte();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.dh);
            out.writeByte(this.dv);
        }

        @Override
        protected String toStringImpl() {
            return (this.dh < 0 ? Integer.valueOf(this.dh) : "+" + this.dh) + "," + (this.dv < 0 ? Integer.valueOf(this.dv) : "+" + this.dv);
        }
    }

    public static class SpExtra
    extends PICTInstruction {
        public static final int OPCODE = 6;
        public float spExtra;

        public SpExtra() {
            this.opcode = 6;
        }

        public SpExtra(float spExtra) {
            this.opcode = 6;
            this.spExtra = spExtra;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.spExtra = (float)in.readInt() / 65536.0f;
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeInt((int)(this.spExtra * 65536.0f));
        }

        @Override
        protected String toStringImpl() {
            return Float.toString(this.spExtra);
        }
    }

    public static interface StyleConstants {
        public static final int BOLD = 1;
        public static final int ITALIC = 2;
        public static final int UNDERLINE = 4;
        public static final int OUTLINE = 8;
        public static final int SHADOW = 16;
        public static final int CONDENSE = 32;
        public static final int EXTEND = 64;
        public static final int GROUP = 128;
    }

    public static class TxFace
    extends PICTInstruction
    implements StyleConstants {
        public static final int OPCODE = 4;
        public int style;

        public TxFace() {
            this.opcode = 4;
        }

        public TxFace(int style) {
            this.opcode = 4;
            this.style = style;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.style = in.readUnsignedByte();
            if (v2) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.style);
            if (v2) {
                out.writeByte(0);
            }
        }

        @Override
        protected String toStringImpl() {
            return TxFace.styleToString(this.style);
        }
    }

    public static class TxFont
    extends PICTInstruction
    implements FontConstants {
        public static final int OPCODE = 3;
        public int fontID;

        public TxFont() {
            this.opcode = 3;
        }

        public TxFont(int fontID) {
            this.opcode = 3;
            this.fontID = fontID;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.fontID = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.fontID);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.fontID) + " (" + this.toFontName() + ")";
        }

        public String toFontName() {
            return TxFont.toFontName(this.fontID);
        }

        public static String toFontName(int fontID) {
            return TxFont.fontToString(fontID);
        }
    }

    public static class TxMode
    extends ModeInstruction {
        public static final int OPCODE = 5;

        public TxMode() {
            this.opcode = 5;
        }

        public TxMode(int mode) {
            this.opcode = 5;
            this.mode = mode;
        }
    }

    public static class TxRatio
    extends PICTInstruction {
        public static final int OPCODE = 16;
        public int vnum;
        public int hnum;
        public int vdenom;
        public int hdenom;

        public TxRatio() {
            this.opcode = 16;
        }

        public TxRatio(int xn, int xd, int yn, int yd) {
            this.opcode = 16;
            this.vnum = yn;
            this.hnum = xn;
            this.vdenom = yd;
            this.hdenom = xd;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.vnum = in.readShort();
            this.hnum = in.readShort();
            this.vdenom = in.readShort();
            this.hdenom = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.vnum);
            out.writeShort(this.hnum);
            out.writeShort(this.vdenom);
            out.writeShort(this.hdenom);
        }

        @Override
        protected String toStringImpl() {
            return String.valueOf(this.hnum) + "/" + this.hdenom + " * " + this.vnum + "/" + this.vdenom;
        }
    }

    public static class TxSize
    extends PICTInstruction {
        public static final int OPCODE = 13;
        public int size;

        public TxSize() {
            this.opcode = 13;
        }

        public TxSize(int size) {
            this.opcode = 13;
            this.size = size;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.size = in.readShort();
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeShort(this.size);
        }

        @Override
        protected String toStringImpl() {
            return Integer.toString(this.size);
        }
    }

    public static class UncompressedQuickTime
    extends LongDataInstruction {
        public static final int OPCODE = 33281;

        public UncompressedQuickTime() {
            this.opcode = 33281;
        }

        public UncompressedQuickTime(byte[] data) {
            this.opcode = 33281;
            this.data = data;
        }
    }

    public static class VersionOp
    extends PICTInstruction {
        public static final int OPCODE = 17;
        public int v;

        public VersionOp() {
            this.opcode = 17;
        }

        public VersionOp(int v) {
            this.opcode = 17;
            this.v = v;
        }

        @Override
        protected void readImpl(DataInputStream in, boolean v2) throws IOException {
            this.v = in.readUnsignedByte();
            if (this.v >= 2) {
                in.readByte();
            }
        }

        @Override
        protected void writeImpl(DataOutputStream out, boolean v2) throws IOException {
            out.writeByte(this.v);
            if (this.v >= 2) {
                out.writeByte(255);
            }
        }

        @Override
        protected String toStringImpl() {
            return Integer.toString(this.v);
        }
    }
}

