{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetProfileCurve: TAbstractNurbsControlCurveNode;
    procedure SetProfileCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetTrajectoryCurve: TAbstractNurbsControlCurveNode;
    procedure SetTrajectoryCurve(const Value: TAbstractNurbsControlCurveNode);
    function GetCcw: boolean;
    procedure SetCcw(const Value: boolean);
  public
    property ProfileCurve: TAbstractNurbsControlCurveNode read GetProfileCurve write SetProfileCurve;
    property TrajectoryCurve: TAbstractNurbsControlCurveNode read GetTrajectoryCurve write SetTrajectoryCurve;
    property Ccw: boolean read GetCcw write SetCcw;

{$endif read_interface}

{$ifdef read_implementation}

{ TNurbsSwungSurfaceNode ----------------------------------------------- }

function TNurbsSwungSurfaceNode.GetProfileCurve: TAbstractNurbsControlCurveNode;
begin
  if FdProfileCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdProfileCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSwungSurfaceNode.SetProfileCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdProfileCurve.Send(Value);
end;

function TNurbsSwungSurfaceNode.GetTrajectoryCurve: TAbstractNurbsControlCurveNode;
begin
  if FdTrajectoryCurve.Value is TAbstractNurbsControlCurveNode then
    Result := TAbstractNurbsControlCurveNode(FdTrajectoryCurve.Value)
  else
    Result := nil;
end;

procedure TNurbsSwungSurfaceNode.SetTrajectoryCurve(const Value: TAbstractNurbsControlCurveNode);
begin
  FdTrajectoryCurve.Send(Value);
end;

function TNurbsSwungSurfaceNode.GetCcw: boolean;
begin
  Result := FdCcw.Value;
end;

procedure TNurbsSwungSurfaceNode.SetCcw(const Value: boolean);
begin
  FdCcw.Send(Value);
end;

{$endif read_implementation}
