{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetCenter: TVector2;
    procedure SetCenter(const Value: TVector2);
    function GetRotation: Single;
    procedure SetRotation(const Value: Single);
    function GetScale: TVector2;
    procedure SetScale(const Value: TVector2);
    function GetTranslation: TVector2;
    procedure SetTranslation(const Value: TVector2);
  public
    property Center: TVector2 read GetCenter write SetCenter;
    property Rotation: Single read GetRotation write SetRotation;
    property Scale: TVector2 read GetScale write SetScale;
    property Translation: TVector2 read GetTranslation write SetTranslation;

{$endif read_interface}

{$ifdef read_implementation}

{ TTextureTransformNode ----------------------------------------------- }

function TTextureTransformNode.GetCenter: TVector2;
begin
  Result := FdCenter.Value;
end;

procedure TTextureTransformNode.SetCenter(const Value: TVector2);
begin
  FdCenter.Send(Value);
end;

function TTextureTransformNode.GetRotation: Single;
begin
  Result := FdRotation.Value;
end;

procedure TTextureTransformNode.SetRotation(const Value: Single);
begin
  FdRotation.Send(Value);
end;

function TTextureTransformNode.GetScale: TVector2;
begin
  Result := FdScale.Value;
end;

procedure TTextureTransformNode.SetScale(const Value: TVector2);
begin
  FdScale.Send(Value);
end;

function TTextureTransformNode.GetTranslation: TVector2;
begin
  Result := FdTranslation.Value;
end;

procedure TTextureTransformNode.SetTranslation(const Value: TVector2);
begin
  FdTranslation.Send(Value);
end;

{$endif read_implementation}
