#!/usr/bin/python3

import json
import sys
from urllib.parse import urlparse

import gi

# Libosinfo has to be imported with specifying the version first.
gi.require_version('Libosinfo', '1.0')

from gi.repository import Libosinfo  # noqa: E402

loader = Libosinfo.Loader()
loader.process_default_path()
db = loader.get_db()

url_type_media = urlparse(sys.argv[1]).path.endswith(".iso")

os = None
res = {}
if url_type_media:
    media = Libosinfo.Media().create_from_location(sys.argv[1])
    db.identify_media(media)
    os = media.get_os()
    if os:
        res = {'os': os.get_id(), 'media': media.get_id()}
else:
    tree = Libosinfo.Tree().create_from_location(sys.argv[1])
    os, _ = db.guess_os_from_tree(tree)
    if os:
        res = {'os': os.get_id()}

print(json.dumps(res))
