// Code generated by smithy-go-codegen DO NOT EDIT.

package guardduty

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/guardduty/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Configures the delegated administrator account with the provided values. You
// must provide a value for either autoEnableOrganizationMembers or autoEnable ,
// but not both. There might be regional differences because some data sources
// might not be available in all the Amazon Web Services Regions where GuardDuty is
// presently supported. For more information, see Regions and endpoints (https://docs.aws.amazon.com/guardduty/latest/ug/guardduty_regions.html)
// .
func (c *Client) UpdateOrganizationConfiguration(ctx context.Context, params *UpdateOrganizationConfigurationInput, optFns ...func(*Options)) (*UpdateOrganizationConfigurationOutput, error) {
	if params == nil {
		params = &UpdateOrganizationConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateOrganizationConfiguration", params, optFns, c.addOperationUpdateOrganizationConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateOrganizationConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateOrganizationConfigurationInput struct {

	// The ID of the detector that configures the delegated administrator.
	//
	// This member is required.
	DetectorId *string

	// Represents whether or not to automatically enable member accounts in the
	// organization. Even though this is still supported, we recommend using
	// AutoEnableOrganizationMembers to achieve the similar results. You must provide a
	// value for either autoEnableOrganizationMembers or autoEnable .
	//
	// Deprecated: This field is deprecated, use AutoEnableOrganizationMembers instead
	AutoEnable *bool

	// Indicates the auto-enablement configuration of GuardDuty for the member
	// accounts in the organization. You must provide a value for either
	// autoEnableOrganizationMembers or autoEnable . Use one of the following
	// configuration values for autoEnableOrganizationMembers :
	//   - NEW : Indicates that when a new account joins the organization, they will
	//   have GuardDuty enabled automatically.
	//   - ALL : Indicates that all accounts in the organization have GuardDuty enabled
	//   automatically. This includes NEW accounts that join the organization and
	//   accounts that may have been suspended or removed from the organization in
	//   GuardDuty. It may take up to 24 hours to update the configuration for all the
	//   member accounts.
	//   - NONE : Indicates that GuardDuty will not be automatically enabled for any
	//   account in the organization. The administrator must manage GuardDuty for each
	//   account in the organization individually.
	AutoEnableOrganizationMembers types.AutoEnableMembers

	// Describes which data sources will be updated.
	//
	// Deprecated: This parameter is deprecated, use Features instead
	DataSources *types.OrganizationDataSourceConfigurations

	// A list of features that will be configured for the organization.
	Features []types.OrganizationFeatureConfiguration

	noSmithyDocumentSerde
}

type UpdateOrganizationConfigurationOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateOrganizationConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateOrganizationConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateOrganizationConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateOrganizationConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateOrganizationConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateOrganizationConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateOrganizationConfiguration",
	}
}
