// Code generated by smithy-go-codegen DO NOT EDIT.

package restxml

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/internal/protocoltest/restxml/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
	"net/http"
	"strconv"
	"strings"
	"time"
)

type awsRestxml_serializeOpAllQueryStringTypes struct {
}

func (*awsRestxml_serializeOpAllQueryStringTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpAllQueryStringTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AllQueryStringTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/AllQueryStringTypesInput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsAllQueryStringTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsAllQueryStringTypesInput(v *AllQueryStringTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.QueryBoolean != nil {
		encoder.SetQuery("Boolean").Boolean(*v.QueryBoolean)
	}

	if v.QueryBooleanList != nil {
		for i := range v.QueryBooleanList {
			encoder.AddQuery("BooleanList").Boolean(v.QueryBooleanList[i])
		}
	}

	if v.QueryByte != nil {
		encoder.SetQuery("Byte").Byte(*v.QueryByte)
	}

	if v.QueryDouble != nil {
		encoder.SetQuery("Double").Double(*v.QueryDouble)
	}

	if v.QueryDoubleList != nil {
		for i := range v.QueryDoubleList {
			encoder.AddQuery("DoubleList").Double(v.QueryDoubleList[i])
		}
	}

	if len(v.QueryEnum) > 0 {
		encoder.SetQuery("Enum").String(string(v.QueryEnum))
	}

	if v.QueryEnumList != nil {
		for i := range v.QueryEnumList {
			encoder.AddQuery("EnumList").String(string(v.QueryEnumList[i]))
		}
	}

	if v.QueryFloat != nil {
		encoder.SetQuery("Float").Float(*v.QueryFloat)
	}

	if v.QueryInteger != nil {
		encoder.SetQuery("Integer").Integer(*v.QueryInteger)
	}

	if v.QueryIntegerEnum != 0 {
		encoder.SetQuery("IntegerEnum").Integer(v.QueryIntegerEnum)
	}

	if v.QueryIntegerEnumList != nil {
		for i := range v.QueryIntegerEnumList {
			encoder.AddQuery("IntegerEnumList").Integer(v.QueryIntegerEnumList[i])
		}
	}

	if v.QueryIntegerList != nil {
		for i := range v.QueryIntegerList {
			encoder.AddQuery("IntegerList").Integer(v.QueryIntegerList[i])
		}
	}

	if v.QueryIntegerSet != nil {
		for i := range v.QueryIntegerSet {
			encoder.AddQuery("IntegerSet").Integer(v.QueryIntegerSet[i])
		}
	}

	if v.QueryLong != nil {
		encoder.SetQuery("Long").Long(*v.QueryLong)
	}

	if v.QueryParamsMapOfStrings != nil {
		for qkey, qvalue := range v.QueryParamsMapOfStrings {
			if encoder.HasQuery(qkey) {
				continue
			}
			encoder.SetQuery(qkey).String(qvalue)
		}
	}

	if v.QueryShort != nil {
		encoder.SetQuery("Short").Short(*v.QueryShort)
	}

	if v.QueryString != nil {
		encoder.SetQuery("String").String(*v.QueryString)
	}

	if v.QueryStringList != nil {
		for i := range v.QueryStringList {
			encoder.AddQuery("StringList").String(v.QueryStringList[i])
		}
	}

	if v.QueryStringSet != nil {
		for i := range v.QueryStringSet {
			encoder.AddQuery("StringSet").String(v.QueryStringSet[i])
		}
	}

	if v.QueryTimestamp != nil {
		encoder.SetQuery("Timestamp").String(smithytime.FormatDateTime(*v.QueryTimestamp))
	}

	if v.QueryTimestampList != nil {
		for i := range v.QueryTimestampList {
			encoder.AddQuery("TimestampList").String(smithytime.FormatDateTime(v.QueryTimestampList[i]))
		}
	}

	return nil
}

type awsRestxml_serializeOpBodyWithXmlName struct {
}

func (*awsRestxml_serializeOpBodyWithXmlName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpBodyWithXmlName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BodyWithXmlNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/BodyWithXmlName")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Ahoy",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentBodyWithXmlNameInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsBodyWithXmlNameInput(v *BodyWithXmlNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentBodyWithXmlNameInput(v *BodyWithXmlNameInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Nested != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nested",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPayloadWithXmlName(v.Nested, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpConstantAndVariableQueryString struct {
}

func (*awsRestxml_serializeOpConstantAndVariableQueryString) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpConstantAndVariableQueryString) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConstantAndVariableQueryStringInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ConstantAndVariableQueryString?foo=bar")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsConstantAndVariableQueryStringInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsConstantAndVariableQueryStringInput(v *ConstantAndVariableQueryStringInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Baz != nil {
		encoder.SetQuery("baz").String(*v.Baz)
	}

	if v.MaybeSet != nil {
		encoder.SetQuery("maybeSet").String(*v.MaybeSet)
	}

	return nil
}

type awsRestxml_serializeOpConstantQueryString struct {
}

func (*awsRestxml_serializeOpConstantQueryString) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpConstantQueryString) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ConstantQueryStringInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ConstantQueryString/{hello}?foo=bar&hello")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsConstantQueryStringInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsConstantQueryStringInput(v *ConstantQueryStringInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Hello == nil || len(*v.Hello) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member hello must not be empty")}
	}
	if v.Hello != nil {
		if err := encoder.SetURI("hello").String(*v.Hello); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpContentTypeParameters struct {
}

func (*awsRestxml_serializeOpContentTypeParameters) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpContentTypeParameters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ContentTypeParametersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/ContentTypeParameters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "ContentTypeParametersInput",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentContentTypeParametersInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsContentTypeParametersInput(v *ContentTypeParametersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentContentTypeParametersInput(v *ContentTypeParametersInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Value)
	}
	return nil
}

type awsRestxml_serializeOpDatetimeOffsets struct {
}

func (*awsRestxml_serializeOpDatetimeOffsets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDatetimeOffsets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DatetimeOffsetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/DatetimeOffsets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDatetimeOffsetsInput(v *DatetimeOffsetsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpEmptyInputAndEmptyOutput struct {
}

func (*awsRestxml_serializeOpEmptyInputAndEmptyOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpEmptyInputAndEmptyOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EmptyInputAndEmptyOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/EmptyInputAndEmptyOutput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsEmptyInputAndEmptyOutputInput(v *EmptyInputAndEmptyOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpEndpointOperation struct {
}

func (*awsRestxml_serializeOpEndpointOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpEndpointOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EndpointOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/EndpointOperation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsEndpointOperationInput(v *EndpointOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpEndpointWithHostLabelHeaderOperation struct {
}

func (*awsRestxml_serializeOpEndpointWithHostLabelHeaderOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpEndpointWithHostLabelHeaderOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EndpointWithHostLabelHeaderOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/EndpointWithHostLabelHeaderOperation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsEndpointWithHostLabelHeaderOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsEndpointWithHostLabelHeaderOperationInput(v *EndpointWithHostLabelHeaderOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

type awsRestxml_serializeOpEndpointWithHostLabelOperation struct {
}

func (*awsRestxml_serializeOpEndpointWithHostLabelOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpEndpointWithHostLabelOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*EndpointWithHostLabelOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/EndpointWithHostLabelOperation")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "EndpointWithHostLabelOperationRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentEndpointWithHostLabelOperationInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsEndpointWithHostLabelOperationInput(v *EndpointWithHostLabelOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentEndpointWithHostLabelOperationInput(v *EndpointWithHostLabelOperationInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Label != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "label",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Label)
	}
	return nil
}

type awsRestxml_serializeOpFlattenedXmlMap struct {
}

func (*awsRestxml_serializeOpFlattenedXmlMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpFlattenedXmlMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*FlattenedXmlMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FlattenedXmlMap")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "FlattenedXmlMapRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentFlattenedXmlMapInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsFlattenedXmlMapInput(v *FlattenedXmlMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentFlattenedXmlMapInput(v *FlattenedXmlMapInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myMap",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentFooEnumMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpFlattenedXmlMapWithXmlName struct {
}

func (*awsRestxml_serializeOpFlattenedXmlMapWithXmlName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpFlattenedXmlMapWithXmlName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*FlattenedXmlMapWithXmlNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FlattenedXmlMapWithXmlName")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "FlattenedXmlMapWithXmlNameRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentFlattenedXmlMapWithXmlNameInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsFlattenedXmlMapWithXmlNameInput(v *FlattenedXmlMapWithXmlNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentFlattenedXmlMapWithXmlNameInput(v *FlattenedXmlMapWithXmlNameInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KVP",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentFlattenedXmlMapWithXmlNameInputOutputMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpFlattenedXmlMapWithXmlNamespace struct {
}

func (*awsRestxml_serializeOpFlattenedXmlMapWithXmlNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpFlattenedXmlMapWithXmlNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*FlattenedXmlMapWithXmlNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FlattenedXmlMapWithXmlNamespace")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsFlattenedXmlMapWithXmlNamespaceInput(v *FlattenedXmlMapWithXmlNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpFractionalSeconds struct {
}

func (*awsRestxml_serializeOpFractionalSeconds) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpFractionalSeconds) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*FractionalSecondsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FractionalSeconds")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsFractionalSecondsInput(v *FractionalSecondsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpGreetingWithErrors struct {
}

func (*awsRestxml_serializeOpGreetingWithErrors) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGreetingWithErrors) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GreetingWithErrorsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/GreetingWithErrors")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGreetingWithErrorsInput(v *GreetingWithErrorsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpEnumPayload struct {
}

func (*awsRestxml_serializeOpHttpEnumPayload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpEnumPayload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpEnumPayloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/EnumPayload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("text/plain")
	}

	if len(input.Payload) > 0 {
		payload := strings.NewReader(string(input.Payload))
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpEnumPayloadInput(v *HttpEnumPayloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadTraits struct {
}

func (*awsRestxml_serializeOpHttpPayloadTraits) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadTraits) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadTraitsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadTraits")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpPayloadTraitsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("application/octet-stream")
	}

	if input.Blob != nil {
		payload := bytes.NewReader(input.Blob)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadTraitsInput(v *HttpPayloadTraitsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil && len(*v.Foo) > 0 {
		locationName := "X-Foo"
		encoder.SetHeader(locationName).String(*v.Foo)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadTraitsWithMediaType struct {
}

func (*awsRestxml_serializeOpHttpPayloadTraitsWithMediaType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadTraitsWithMediaType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadTraitsWithMediaTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadTraitsWithMediaType")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpPayloadTraitsWithMediaTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("text/plain")
	}

	if input.Blob != nil {
		payload := bytes.NewReader(input.Blob)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadTraitsWithMediaTypeInput(v *HttpPayloadTraitsWithMediaTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil && len(*v.Foo) > 0 {
		locationName := "X-Foo"
		encoder.SetHeader(locationName).String(*v.Foo)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithMemberXmlName struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithMemberXmlName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithMemberXmlName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithMemberXmlNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithMemberXmlName")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Hola",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentPayloadWithXmlName(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithMemberXmlNameInput(v *HttpPayloadWithMemberXmlNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithStructure struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithStructure) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithStructure) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithStructureInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithStructure")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NestedPayload",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentNestedPayload(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithStructureInput(v *HttpPayloadWithStructureInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithUnion struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithUnion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithUnion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithUnionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithUnion")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nested",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentUnionPayload(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithUnionInput(v *HttpPayloadWithUnionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithXmlName struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithXmlName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithXmlName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithXmlNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithXmlName")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Hello",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentPayloadWithXmlName(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithXmlNameInput(v *HttpPayloadWithXmlNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithXmlNamespace struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithXmlNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithXmlNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithXmlNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithXmlNamespace")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRootAttr = append(payloadRootAttr, smithyxml.NewNamespaceAttribute("", "http://foo.com"))
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PayloadWithXmlNamespace",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentPayloadWithXmlNamespace(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithXmlNamespaceInput(v *HttpPayloadWithXmlNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPayloadWithXmlNamespaceAndPrefix struct {
}

func (*awsRestxml_serializeOpHttpPayloadWithXmlNamespaceAndPrefix) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPayloadWithXmlNamespaceAndPrefix) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPayloadWithXmlNamespaceAndPrefixInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPayloadWithXmlNamespaceAndPrefix")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Nested != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRootAttr = append(payloadRootAttr, smithyxml.NewNamespaceAttribute("baz", "http://foo.com"))
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PayloadWithXmlNamespaceAndPrefix",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentPayloadWithXmlNamespaceAndPrefix(input.Nested, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPayloadWithXmlNamespaceAndPrefixInput(v *HttpPayloadWithXmlNamespaceAndPrefixInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpPrefixHeaders struct {
}

func (*awsRestxml_serializeOpHttpPrefixHeaders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpPrefixHeaders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpPrefixHeadersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpPrefixHeaders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpPrefixHeadersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpPrefixHeadersInput(v *HttpPrefixHeadersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil && len(*v.Foo) > 0 {
		locationName := "X-Foo"
		encoder.SetHeader(locationName).String(*v.Foo)
	}

	if v.FooMap != nil {
		hv := encoder.Headers("X-Foo-")
		for mapKey, mapVal := range v.FooMap {
			if len(mapVal) > 0 {
				hv.SetHeader(http.CanonicalHeaderKey(mapKey)).String(mapVal)
			}
		}
	}

	return nil
}

type awsRestxml_serializeOpHttpRequestWithFloatLabels struct {
}

func (*awsRestxml_serializeOpHttpRequestWithFloatLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpRequestWithFloatLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpRequestWithFloatLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/FloatHttpLabels/{float}/{double}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpRequestWithFloatLabelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpRequestWithFloatLabelsInput(v *HttpRequestWithFloatLabelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Double == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member double must not be empty")}
	}
	if v.Double != nil {
		if err := encoder.SetURI("double").Double(*v.Double); err != nil {
			return err
		}
	}

	if v.Float == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member float must not be empty")}
	}
	if v.Float != nil {
		if err := encoder.SetURI("float").Float(*v.Float); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpHttpRequestWithGreedyLabelInPath struct {
}

func (*awsRestxml_serializeOpHttpRequestWithGreedyLabelInPath) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpRequestWithGreedyLabelInPath) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpRequestWithGreedyLabelInPathInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpRequestWithGreedyLabelInPath/foo/{foo}/baz/{baz+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpRequestWithGreedyLabelInPathInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpRequestWithGreedyLabelInPathInput(v *HttpRequestWithGreedyLabelInPathInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Baz == nil || len(*v.Baz) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member baz must not be empty")}
	}
	if v.Baz != nil {
		if err := encoder.SetURI("baz").String(*v.Baz); err != nil {
			return err
		}
	}

	if v.Foo == nil || len(*v.Foo) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member foo must not be empty")}
	}
	if v.Foo != nil {
		if err := encoder.SetURI("foo").String(*v.Foo); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpHttpRequestWithLabels struct {
}

func (*awsRestxml_serializeOpHttpRequestWithLabels) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpRequestWithLabels) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpRequestWithLabelsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpRequestWithLabels/{string}/{short}/{integer}/{long}/{float}/{double}/{boolean}/{timestamp}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpRequestWithLabelsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpRequestWithLabelsInput(v *HttpRequestWithLabelsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Boolean == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member boolean must not be empty")}
	}
	if v.Boolean != nil {
		if err := encoder.SetURI("boolean").Boolean(*v.Boolean); err != nil {
			return err
		}
	}

	if v.Double == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member double must not be empty")}
	}
	if v.Double != nil {
		if err := encoder.SetURI("double").Double(*v.Double); err != nil {
			return err
		}
	}

	if v.Float == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member float must not be empty")}
	}
	if v.Float != nil {
		if err := encoder.SetURI("float").Float(*v.Float); err != nil {
			return err
		}
	}

	if v.Integer == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member integer must not be empty")}
	}
	if v.Integer != nil {
		if err := encoder.SetURI("integer").Integer(*v.Integer); err != nil {
			return err
		}
	}

	if v.Long == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member long must not be empty")}
	}
	if v.Long != nil {
		if err := encoder.SetURI("long").Long(*v.Long); err != nil {
			return err
		}
	}

	if v.Short == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member short must not be empty")}
	}
	if v.Short != nil {
		if err := encoder.SetURI("short").Short(*v.Short); err != nil {
			return err
		}
	}

	if v.String_ == nil || len(*v.String_) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member string must not be empty")}
	}
	if v.String_ != nil {
		if err := encoder.SetURI("string").String(*v.String_); err != nil {
			return err
		}
	}

	if v.Timestamp == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member timestamp must not be empty")}
	}
	if v.Timestamp != nil {
		if err := encoder.SetURI("timestamp").String(smithytime.FormatDateTime(*v.Timestamp)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpHttpRequestWithLabelsAndTimestampFormat struct {
}

func (*awsRestxml_serializeOpHttpRequestWithLabelsAndTimestampFormat) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpRequestWithLabelsAndTimestampFormat) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpRequestWithLabelsAndTimestampFormatInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpRequestWithLabelsAndTimestampFormat/{memberEpochSeconds}/{memberHttpDate}/{memberDateTime}/{defaultFormat}/{targetEpochSeconds}/{targetHttpDate}/{targetDateTime}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsHttpRequestWithLabelsAndTimestampFormatInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpRequestWithLabelsAndTimestampFormatInput(v *HttpRequestWithLabelsAndTimestampFormatInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DefaultFormat == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member defaultFormat must not be empty")}
	}
	if v.DefaultFormat != nil {
		if err := encoder.SetURI("defaultFormat").String(smithytime.FormatDateTime(*v.DefaultFormat)); err != nil {
			return err
		}
	}

	if v.MemberDateTime == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member memberDateTime must not be empty")}
	}
	if v.MemberDateTime != nil {
		if err := encoder.SetURI("memberDateTime").String(smithytime.FormatDateTime(*v.MemberDateTime)); err != nil {
			return err
		}
	}

	if v.MemberEpochSeconds == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member memberEpochSeconds must not be empty")}
	}
	if v.MemberEpochSeconds != nil {
		if err := encoder.SetURI("memberEpochSeconds").Double(smithytime.FormatEpochSeconds(*v.MemberEpochSeconds)); err != nil {
			return err
		}
	}

	if v.MemberHttpDate == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member memberHttpDate must not be empty")}
	}
	if v.MemberHttpDate != nil {
		if err := encoder.SetURI("memberHttpDate").String(smithytime.FormatHTTPDate(*v.MemberHttpDate)); err != nil {
			return err
		}
	}

	if v.TargetDateTime == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member targetDateTime must not be empty")}
	}
	if v.TargetDateTime != nil {
		if err := encoder.SetURI("targetDateTime").String(smithytime.FormatDateTime(*v.TargetDateTime)); err != nil {
			return err
		}
	}

	if v.TargetEpochSeconds == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member targetEpochSeconds must not be empty")}
	}
	if v.TargetEpochSeconds != nil {
		if err := encoder.SetURI("targetEpochSeconds").Double(smithytime.FormatEpochSeconds(*v.TargetEpochSeconds)); err != nil {
			return err
		}
	}

	if v.TargetHttpDate == nil {
		return &smithy.SerializationError{Err: fmt.Errorf("input member targetHttpDate must not be empty")}
	}
	if v.TargetHttpDate != nil {
		if err := encoder.SetURI("targetHttpDate").String(smithytime.FormatHTTPDate(*v.TargetHttpDate)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpHttpResponseCode struct {
}

func (*awsRestxml_serializeOpHttpResponseCode) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpResponseCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpResponseCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/HttpResponseCode")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpResponseCodeInput(v *HttpResponseCodeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpHttpStringPayload struct {
}

func (*awsRestxml_serializeOpHttpStringPayload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpHttpStringPayload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*HttpStringPayloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/StringPayload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
		restEncoder.SetHeader("Content-Type").String("text/plain")
	}

	if input.Payload != nil {
		payload := strings.NewReader(*input.Payload)
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsHttpStringPayloadInput(v *HttpStringPayloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpIgnoreQueryParamsInResponse struct {
}

func (*awsRestxml_serializeOpIgnoreQueryParamsInResponse) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpIgnoreQueryParamsInResponse) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*IgnoreQueryParamsInResponseInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/IgnoreQueryParamsInResponse")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsIgnoreQueryParamsInResponseInput(v *IgnoreQueryParamsInResponseInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpInputAndOutputWithHeaders struct {
}

func (*awsRestxml_serializeOpInputAndOutputWithHeaders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpInputAndOutputWithHeaders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*InputAndOutputWithHeadersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/InputAndOutputWithHeaders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsInputAndOutputWithHeadersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsInputAndOutputWithHeadersInput(v *InputAndOutputWithHeadersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.HeaderBooleanList != nil {
		locationName := "X-Booleanlist"
		for i := range v.HeaderBooleanList {
			{
				encoder.AddHeader(locationName).Boolean(v.HeaderBooleanList[i])
			}
		}
	}

	if v.HeaderByte != nil {
		locationName := "X-Byte"
		encoder.SetHeader(locationName).Byte(*v.HeaderByte)
	}

	if v.HeaderDouble != nil {
		locationName := "X-Double"
		encoder.SetHeader(locationName).Double(*v.HeaderDouble)
	}

	if len(v.HeaderEnum) > 0 {
		locationName := "X-Enum"
		encoder.SetHeader(locationName).String(string(v.HeaderEnum))
	}

	if v.HeaderEnumList != nil {
		locationName := "X-Enumlist"
		for i := range v.HeaderEnumList {
			if len(v.HeaderEnumList[i]) > 0 {
				escaped := string(v.HeaderEnumList[i])
				if strings.Index(string(v.HeaderEnumList[i]), `,`) != -1 || strings.Index(string(v.HeaderEnumList[i]), `"`) != -1 {
					escaped = strconv.Quote(string(v.HeaderEnumList[i]))
				}

				encoder.AddHeader(locationName).String(string(escaped))
			}
		}
	}

	if v.HeaderFalseBool != nil {
		locationName := "X-Boolean2"
		encoder.SetHeader(locationName).Boolean(*v.HeaderFalseBool)
	}

	if v.HeaderFloat != nil {
		locationName := "X-Float"
		encoder.SetHeader(locationName).Float(*v.HeaderFloat)
	}

	if v.HeaderInteger != nil {
		locationName := "X-Integer"
		encoder.SetHeader(locationName).Integer(*v.HeaderInteger)
	}

	if v.HeaderIntegerList != nil {
		locationName := "X-Integerlist"
		for i := range v.HeaderIntegerList {
			{
				encoder.AddHeader(locationName).Integer(v.HeaderIntegerList[i])
			}
		}
	}

	if v.HeaderLong != nil {
		locationName := "X-Long"
		encoder.SetHeader(locationName).Long(*v.HeaderLong)
	}

	if v.HeaderShort != nil {
		locationName := "X-Short"
		encoder.SetHeader(locationName).Short(*v.HeaderShort)
	}

	if v.HeaderString != nil && len(*v.HeaderString) > 0 {
		locationName := "X-String"
		encoder.SetHeader(locationName).String(*v.HeaderString)
	}

	if v.HeaderStringList != nil {
		locationName := "X-Stringlist"
		for i := range v.HeaderStringList {
			if len(v.HeaderStringList[i]) > 0 {
				escaped := v.HeaderStringList[i]
				if strings.Index(v.HeaderStringList[i], `,`) != -1 || strings.Index(v.HeaderStringList[i], `"`) != -1 {
					escaped = strconv.Quote(v.HeaderStringList[i])
				}

				encoder.AddHeader(locationName).String(escaped)
			}
		}
	}

	if v.HeaderStringSet != nil {
		locationName := "X-Stringset"
		for i := range v.HeaderStringSet {
			if len(v.HeaderStringSet[i]) > 0 {
				escaped := v.HeaderStringSet[i]
				if strings.Index(v.HeaderStringSet[i], `,`) != -1 || strings.Index(v.HeaderStringSet[i], `"`) != -1 {
					escaped = strconv.Quote(v.HeaderStringSet[i])
				}

				encoder.AddHeader(locationName).String(escaped)
			}
		}
	}

	if v.HeaderTimestampList != nil {
		locationName := "X-Timestamplist"
		for i := range v.HeaderTimestampList {
			{
				encoder.AddHeader(locationName).String(smithytime.FormatHTTPDate(v.HeaderTimestampList[i]))
			}
		}
	}

	if v.HeaderTrueBool != nil {
		locationName := "X-Boolean1"
		encoder.SetHeader(locationName).Boolean(*v.HeaderTrueBool)
	}

	return nil
}

type awsRestxml_serializeOpNestedXmlMaps struct {
}

func (*awsRestxml_serializeOpNestedXmlMaps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpNestedXmlMaps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NestedXmlMapsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/NestedXmlMaps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "NestedXmlMapsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentNestedXmlMapsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsNestedXmlMapsInput(v *NestedXmlMapsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentNestedXmlMapsInput(v *NestedXmlMapsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.FlatNestedMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flatNestedMap",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentNestedMap(v.FlatNestedMap, el); err != nil {
			return err
		}
	}
	if v.NestedMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nestedMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNestedMap(v.NestedMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpNoInputAndNoOutput struct {
}

func (*awsRestxml_serializeOpNoInputAndNoOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpNoInputAndNoOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NoInputAndNoOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/NoInputAndNoOutput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsNoInputAndNoOutputInput(v *NoInputAndNoOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpNoInputAndOutput struct {
}

func (*awsRestxml_serializeOpNoInputAndOutput) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpNoInputAndOutput) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NoInputAndOutputInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/NoInputAndOutputOutput")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsNoInputAndOutputInput(v *NoInputAndOutputInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpNullAndEmptyHeadersClient struct {
}

func (*awsRestxml_serializeOpNullAndEmptyHeadersClient) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpNullAndEmptyHeadersClient) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NullAndEmptyHeadersClientInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/NullAndEmptyHeadersClient")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsNullAndEmptyHeadersClientInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsNullAndEmptyHeadersClientInput(v *NullAndEmptyHeadersClientInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.A != nil && len(*v.A) > 0 {
		locationName := "X-A"
		encoder.SetHeader(locationName).String(*v.A)
	}

	if v.B != nil && len(*v.B) > 0 {
		locationName := "X-B"
		encoder.SetHeader(locationName).String(*v.B)
	}

	if v.C != nil {
		locationName := "X-C"
		for i := range v.C {
			if len(v.C[i]) > 0 {
				escaped := v.C[i]
				if strings.Index(v.C[i], `,`) != -1 || strings.Index(v.C[i], `"`) != -1 {
					escaped = strconv.Quote(v.C[i])
				}

				encoder.AddHeader(locationName).String(escaped)
			}
		}
	}

	return nil
}

type awsRestxml_serializeOpNullAndEmptyHeadersServer struct {
}

func (*awsRestxml_serializeOpNullAndEmptyHeadersServer) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpNullAndEmptyHeadersServer) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*NullAndEmptyHeadersServerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/NullAndEmptyHeadersServer")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsNullAndEmptyHeadersServerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsNullAndEmptyHeadersServerInput(v *NullAndEmptyHeadersServerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.A != nil && len(*v.A) > 0 {
		locationName := "X-A"
		encoder.SetHeader(locationName).String(*v.A)
	}

	if v.B != nil && len(*v.B) > 0 {
		locationName := "X-B"
		encoder.SetHeader(locationName).String(*v.B)
	}

	if v.C != nil {
		locationName := "X-C"
		for i := range v.C {
			if len(v.C[i]) > 0 {
				escaped := v.C[i]
				if strings.Index(v.C[i], `,`) != -1 || strings.Index(v.C[i], `"`) != -1 {
					escaped = strconv.Quote(v.C[i])
				}

				encoder.AddHeader(locationName).String(escaped)
			}
		}
	}

	return nil
}

type awsRestxml_serializeOpOmitsNullSerializesEmptyString struct {
}

func (*awsRestxml_serializeOpOmitsNullSerializesEmptyString) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpOmitsNullSerializesEmptyString) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*OmitsNullSerializesEmptyStringInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/OmitsNullSerializesEmptyString")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsOmitsNullSerializesEmptyStringInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsOmitsNullSerializesEmptyStringInput(v *OmitsNullSerializesEmptyStringInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EmptyString != nil {
		encoder.SetQuery("Empty").String(*v.EmptyString)
	}

	if v.NullValue != nil {
		encoder.SetQuery("Null").String(*v.NullValue)
	}

	return nil
}

type awsRestxml_serializeOpPutWithContentEncoding struct {
}

func (*awsRestxml_serializeOpPutWithContentEncoding) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutWithContentEncoding) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutWithContentEncodingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/requestcompression/putcontentwithencoding")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutWithContentEncodingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutWithContentEncodingInput",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentPutWithContentEncodingInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutWithContentEncodingInput(v *PutWithContentEncodingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Encoding != nil && len(*v.Encoding) > 0 {
		locationName := "Content-Encoding"
		encoder.SetHeader(locationName).String(*v.Encoding)
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutWithContentEncodingInput(v *PutWithContentEncodingInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Data != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "data",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Data)
	}
	return nil
}

type awsRestxml_serializeOpQueryIdempotencyTokenAutoFill struct {
}

func (*awsRestxml_serializeOpQueryIdempotencyTokenAutoFill) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpQueryIdempotencyTokenAutoFill) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*QueryIdempotencyTokenAutoFillInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/QueryIdempotencyTokenAutoFill")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsQueryIdempotencyTokenAutoFillInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsQueryIdempotencyTokenAutoFillInput(v *QueryIdempotencyTokenAutoFillInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Token != nil {
		encoder.SetQuery("token").String(*v.Token)
	}

	return nil
}

type awsRestxml_serializeOpQueryParamsAsStringListMap struct {
}

func (*awsRestxml_serializeOpQueryParamsAsStringListMap) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpQueryParamsAsStringListMap) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*QueryParamsAsStringListMapInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/StringListMap")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsQueryParamsAsStringListMapInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsQueryParamsAsStringListMapInput(v *QueryParamsAsStringListMapInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil {
		for qkey, qvalue := range v.Foo {
			if encoder.HasQuery(qkey) {
				continue
			}
			for i := range qvalue {
				encoder.AddQuery(qkey).String(qvalue[i])
			}
		}
	}

	if v.Qux != nil {
		encoder.SetQuery("corge").String(*v.Qux)
	}

	return nil
}

type awsRestxml_serializeOpQueryPrecedence struct {
}

func (*awsRestxml_serializeOpQueryPrecedence) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpQueryPrecedence) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*QueryPrecedenceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/Precedence")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsQueryPrecedenceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsQueryPrecedenceInput(v *QueryPrecedenceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Baz != nil {
		for qkey, qvalue := range v.Baz {
			if encoder.HasQuery(qkey) {
				continue
			}
			encoder.SetQuery(qkey).String(qvalue)
		}
	}

	if v.Foo != nil {
		encoder.SetQuery("bar").String(*v.Foo)
	}

	return nil
}

type awsRestxml_serializeOpRecursiveShapes struct {
}

func (*awsRestxml_serializeOpRecursiveShapes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpRecursiveShapes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RecursiveShapesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/RecursiveShapes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "RecursiveShapesRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentRecursiveShapesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsRecursiveShapesInput(v *RecursiveShapesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentRecursiveShapesInput(v *RecursiveShapesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Nested != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nested",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRecursiveShapesInputOutputNested1(v.Nested, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpSimpleScalarProperties struct {
}

func (*awsRestxml_serializeOpSimpleScalarProperties) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpSimpleScalarProperties) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SimpleScalarPropertiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/SimpleScalarProperties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsSimpleScalarPropertiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "SimpleScalarPropertiesRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentSimpleScalarPropertiesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsSimpleScalarPropertiesInput(v *SimpleScalarPropertiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Foo != nil && len(*v.Foo) > 0 {
		locationName := "X-Foo"
		encoder.SetHeader(locationName).String(*v.Foo)
	}

	return nil
}

func awsRestxml_serializeOpDocumentSimpleScalarPropertiesInput(v *SimpleScalarPropertiesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ByteValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "byteValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Byte(*v.ByteValue)
	}
	if v.DoubleValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DoubleDribble",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(*v.DoubleValue):
			el.String("NaN")

		case math.IsInf(*v.DoubleValue, 1):
			el.String("Infinity")

		case math.IsInf(*v.DoubleValue, -1):
			el.String("-Infinity")

		default:
			el.Double(*v.DoubleValue)

		}
	}
	if v.FalseBooleanValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "falseBooleanValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.FalseBooleanValue)
	}
	if v.FloatValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "floatValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(float64(*v.FloatValue)):
			el.String("NaN")

		case math.IsInf(float64(*v.FloatValue), 1):
			el.String("Infinity")

		case math.IsInf(float64(*v.FloatValue), -1):
			el.String("-Infinity")

		default:
			el.Float(*v.FloatValue)

		}
	}
	if v.IntegerValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.IntegerValue)
	}
	if v.LongValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "longValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.LongValue)
	}
	if v.ShortValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "shortValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Short(*v.ShortValue)
	}
	if v.StringValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StringValue)
	}
	if v.TrueBooleanValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "trueBooleanValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.TrueBooleanValue)
	}
	return nil
}

type awsRestxml_serializeOpTimestampFormatHeaders struct {
}

func (*awsRestxml_serializeOpTimestampFormatHeaders) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpTimestampFormatHeaders) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TimestampFormatHeadersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/TimestampFormatHeaders")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsTimestampFormatHeadersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsTimestampFormatHeadersInput(v *TimestampFormatHeadersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DefaultFormat != nil {
		locationName := "X-Defaultformat"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.DefaultFormat))
	}

	if v.MemberDateTime != nil {
		locationName := "X-Memberdatetime"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.MemberDateTime))
	}

	if v.MemberEpochSeconds != nil {
		locationName := "X-Memberepochseconds"
		encoder.SetHeader(locationName).Double(smithytime.FormatEpochSeconds(*v.MemberEpochSeconds))
	}

	if v.MemberHttpDate != nil {
		locationName := "X-Memberhttpdate"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.MemberHttpDate))
	}

	if v.TargetDateTime != nil {
		locationName := "X-Targetdatetime"
		encoder.SetHeader(locationName).String(smithytime.FormatDateTime(*v.TargetDateTime))
	}

	if v.TargetEpochSeconds != nil {
		locationName := "X-Targetepochseconds"
		encoder.SetHeader(locationName).Double(smithytime.FormatEpochSeconds(*v.TargetEpochSeconds))
	}

	if v.TargetHttpDate != nil {
		locationName := "X-Targethttpdate"
		encoder.SetHeader(locationName).String(smithytime.FormatHTTPDate(*v.TargetHttpDate))
	}

	return nil
}

type awsRestxml_serializeOpXmlAttributes struct {
}

func (*awsRestxml_serializeOpXmlAttributes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlAttributes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlAttributesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlAttributes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	if input.Attr != nil {
		var av string
		av = *input.Attr
		rootAttr = append(rootAttr, smithyxml.NewAttribute("test", av))
	}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlAttributesRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlAttributesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlAttributesInput(v *XmlAttributesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlAttributesInput(v *XmlAttributesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Foo != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "foo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Foo)
	}
	return nil
}

type awsRestxml_serializeOpXmlAttributesOnPayload struct {
}

func (*awsRestxml_serializeOpXmlAttributesOnPayload) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlAttributesOnPayload) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlAttributesOnPayloadInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlAttributesOnPayload")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Payload != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		if input.Payload.Attr != nil {
			var av string
			av = *input.Payload.Attr
			payloadRootAttr = append(payloadRootAttr, smithyxml.NewAttribute("test", av))
		}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "XmlAttributesPayloadRequest",
			},
			Attr: payloadRootAttr,
		}
		if err := awsRestxml_serializeDocumentXmlAttributesPayloadRequest(input.Payload, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlAttributesOnPayloadInput(v *XmlAttributesOnPayloadInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

type awsRestxml_serializeOpXmlBlobs struct {
}

func (*awsRestxml_serializeOpXmlBlobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlBlobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlBlobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlBlobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlBlobsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlBlobsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlBlobsInput(v *XmlBlobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlBlobsInput(v *XmlBlobsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Data != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "data",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Base64EncodeBytes(v.Data)
	}
	return nil
}

type awsRestxml_serializeOpXmlEmptyBlobs struct {
}

func (*awsRestxml_serializeOpXmlEmptyBlobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlEmptyBlobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlEmptyBlobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlEmptyBlobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlEmptyBlobsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlEmptyBlobsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlEmptyBlobsInput(v *XmlEmptyBlobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlEmptyBlobsInput(v *XmlEmptyBlobsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Data != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "data",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Base64EncodeBytes(v.Data)
	}
	return nil
}

type awsRestxml_serializeOpXmlEmptyLists struct {
}

func (*awsRestxml_serializeOpXmlEmptyLists) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlEmptyLists) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlEmptyListsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlEmptyLists")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlEmptyListsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlEmptyListsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlEmptyListsInput(v *XmlEmptyListsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlEmptyListsInput(v *XmlEmptyListsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.BooleanList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "booleanList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentBooleanList(v.BooleanList, el); err != nil {
			return err
		}
	}
	if v.EnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "enumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFooEnumList(v.EnumList, el); err != nil {
			return err
		}
	}
	if v.FlattenedList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedList",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.FlattenedList, el); err != nil {
			return err
		}
	}
	if v.FlattenedList2 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "customName",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.FlattenedList2, el); err != nil {
			return err
		}
	}
	if v.FlattenedListWithMemberNamespace != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedListWithMemberNamespace",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListWithMemberNamespace(v.FlattenedListWithMemberNamespace, el); err != nil {
			return err
		}
	}
	if v.FlattenedListWithNamespace != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedListWithNamespace",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListWithNamespace(v.FlattenedListWithNamespace, el); err != nil {
			return err
		}
	}
	if v.FlattenedStructureList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedStructureList",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentStructureList(v.FlattenedStructureList, el); err != nil {
			return err
		}
	}
	if v.IntegerList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerList(v.IntegerList, el); err != nil {
			return err
		}
	}
	if v.IntEnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerEnumList(v.IntEnumList, el); err != nil {
			return err
		}
	}
	if v.NestedStringList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nestedStringList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNestedStringList(v.NestedStringList, el); err != nil {
			return err
		}
	}
	if v.RenamedListMembers != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "renamed",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.RenamedListMembers, el); err != nil {
			return err
		}
	}
	if v.StringList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStringList(v.StringList, el); err != nil {
			return err
		}
	}
	if v.StringSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStringSet(v.StringSet, el); err != nil {
			return err
		}
	}
	if v.StructureList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myStructureList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStructureList(v.StructureList, el); err != nil {
			return err
		}
	}
	if v.TimestampList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "timestampList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTimestampList(v.TimestampList, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlEmptyMaps struct {
}

func (*awsRestxml_serializeOpXmlEmptyMaps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlEmptyMaps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlEmptyMapsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlEmptyMaps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlEmptyMapsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlEmptyMapsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlEmptyMapsInput(v *XmlEmptyMapsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlEmptyMapsInput(v *XmlEmptyMapsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlMapsInputOutputMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlEmptyStrings struct {
}

func (*awsRestxml_serializeOpXmlEmptyStrings) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlEmptyStrings) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlEmptyStringsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlEmptyStrings")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlEmptyStringsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlEmptyStringsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlEmptyStringsInput(v *XmlEmptyStringsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlEmptyStringsInput(v *XmlEmptyStringsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.EmptyString != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "emptyString",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.EmptyString)
	}
	return nil
}

type awsRestxml_serializeOpXmlEnums struct {
}

func (*awsRestxml_serializeOpXmlEnums) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlEnums) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlEnumsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlEnums")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlEnumsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlEnumsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlEnumsInput(v *XmlEnumsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlEnumsInput(v *XmlEnumsInput, value smithyxml.Value) error {
	defer value.Close()
	if len(v.FooEnum1) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnum1",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.FooEnum1))
	}
	if len(v.FooEnum2) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnum2",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.FooEnum2))
	}
	if len(v.FooEnum3) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnum3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.FooEnum3))
	}
	if v.FooEnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFooEnumList(v.FooEnumList, el); err != nil {
			return err
		}
	}
	if v.FooEnumMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnumMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFooEnumMap(v.FooEnumMap, el); err != nil {
			return err
		}
	}
	if v.FooEnumSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "fooEnumSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFooEnumSet(v.FooEnumSet, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlIntEnums struct {
}

func (*awsRestxml_serializeOpXmlIntEnums) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlIntEnums) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlIntEnumsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlIntEnums")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlIntEnumsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlIntEnumsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlIntEnumsInput(v *XmlIntEnumsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlIntEnumsInput(v *XmlIntEnumsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.IntEnum1 != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnum1",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.IntEnum1)
	}
	if v.IntEnum2 != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnum2",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.IntEnum2)
	}
	if v.IntEnum3 != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnum3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.IntEnum3)
	}
	if v.IntEnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerEnumList(v.IntEnumList, el); err != nil {
			return err
		}
	}
	if v.IntEnumMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnumMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerEnumMap(v.IntEnumMap, el); err != nil {
			return err
		}
	}
	if v.IntEnumSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnumSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerEnumSet(v.IntEnumSet, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlLists struct {
}

func (*awsRestxml_serializeOpXmlLists) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlLists) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlListsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlLists")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlListsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlListsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlListsInput(v *XmlListsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlListsInput(v *XmlListsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.BooleanList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "booleanList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentBooleanList(v.BooleanList, el); err != nil {
			return err
		}
	}
	if v.EnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "enumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentFooEnumList(v.EnumList, el); err != nil {
			return err
		}
	}
	if v.FlattenedList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedList",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.FlattenedList, el); err != nil {
			return err
		}
	}
	if v.FlattenedList2 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "customName",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.FlattenedList2, el); err != nil {
			return err
		}
	}
	if v.FlattenedListWithMemberNamespace != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedListWithMemberNamespace",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListWithMemberNamespace(v.FlattenedListWithMemberNamespace, el); err != nil {
			return err
		}
	}
	if v.FlattenedListWithNamespace != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedListWithNamespace",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentListWithNamespace(v.FlattenedListWithNamespace, el); err != nil {
			return err
		}
	}
	if v.FlattenedStructureList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "flattenedStructureList",
			},
			Attr: rootAttr,
		}
		el := value.FlattenedElement(root)
		if err := awsRestxml_serializeDocumentStructureList(v.FlattenedStructureList, el); err != nil {
			return err
		}
	}
	if v.IntegerList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerList(v.IntegerList, el); err != nil {
			return err
		}
	}
	if v.IntEnumList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "intEnumList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentIntegerEnumList(v.IntEnumList, el); err != nil {
			return err
		}
	}
	if v.NestedStringList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nestedStringList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNestedStringList(v.NestedStringList, el); err != nil {
			return err
		}
	}
	if v.RenamedListMembers != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "renamed",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRenamedListMembers(v.RenamedListMembers, el); err != nil {
			return err
		}
	}
	if v.StringList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStringList(v.StringList, el); err != nil {
			return err
		}
	}
	if v.StringSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStringSet(v.StringSet, el); err != nil {
			return err
		}
	}
	if v.StructureList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myStructureList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStructureList(v.StructureList, el); err != nil {
			return err
		}
	}
	if v.TimestampList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "timestampList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTimestampList(v.TimestampList, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlMaps struct {
}

func (*awsRestxml_serializeOpXmlMaps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlMaps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlMapsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlMaps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlMapsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlMapsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlMapsInput(v *XmlMapsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlMapsInput(v *XmlMapsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlMapsInputOutputMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlMapsXmlName struct {
}

func (*awsRestxml_serializeOpXmlMapsXmlName) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlMapsXmlName) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlMapsXmlNameInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlMapsXmlName")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlMapsXmlNameRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlMapsXmlNameInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlMapsXmlNameInput(v *XmlMapsXmlNameInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlMapsXmlNameInput(v *XmlMapsXmlNameInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "myMap",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlMapsXmlNameInputOutputMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlMapWithXmlNamespace struct {
}

func (*awsRestxml_serializeOpXmlMapWithXmlNamespace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlMapWithXmlNamespace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlMapWithXmlNamespaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlMapWithXmlNamespace")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlMapWithXmlNamespaceRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlMapWithXmlNamespaceInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlMapWithXmlNamespaceInput(v *XmlMapWithXmlNamespaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlMapWithXmlNamespaceInput(v *XmlMapWithXmlNamespaceInput, value smithyxml.Value) error {
	defer value.Close()
	if v.MyMap != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("", "https://the-member.example.com"))
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KVP",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlMapWithXmlNamespaceInputOutputMap(v.MyMap, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlNamespaces struct {
}

func (*awsRestxml_serializeOpXmlNamespaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlNamespaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlNamespacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlNamespaces")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("", "http://foo.com"))
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlNamespacesRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlNamespacesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlNamespacesInput(v *XmlNamespacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlNamespacesInput(v *XmlNamespacesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Nested != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nested",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlNamespaceNested(v.Nested, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpXmlTimestamps struct {
}

func (*awsRestxml_serializeOpXmlTimestamps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlTimestamps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlTimestampsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlTimestamps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlTimestampsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlTimestampsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlTimestampsInput(v *XmlTimestampsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlTimestampsInput(v *XmlTimestampsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.DateTime != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "dateTime",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.DateTime))
	}
	if v.DateTimeOnTarget != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "dateTimeOnTarget",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.DateTimeOnTarget))
	}
	if v.EpochSeconds != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "epochSeconds",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Double(smithytime.FormatEpochSeconds(*v.EpochSeconds))
	}
	if v.EpochSecondsOnTarget != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "epochSecondsOnTarget",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Double(smithytime.FormatEpochSeconds(*v.EpochSecondsOnTarget))
	}
	if v.HttpDate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "httpDate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatHTTPDate(*v.HttpDate))
	}
	if v.HttpDateOnTarget != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "httpDateOnTarget",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatHTTPDate(*v.HttpDateOnTarget))
	}
	if v.Normal != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "normal",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Normal))
	}
	return nil
}

type awsRestxml_serializeOpXmlUnions struct {
}

func (*awsRestxml_serializeOpXmlUnions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpXmlUnions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*XmlUnionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/XmlUnions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	var restEncoder *httpbinding.Encoder
	if request.URL.RawPath == "" {
		restEncoder, err = httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	} else {
		request.URL.RawPath = smithyhttp.JoinPath(request.URL.RawPath, opPath)
		restEncoder, err = httpbinding.NewEncoderWithRawPath(request.URL.Path, request.URL.RawPath, request.URL.RawQuery, request.Header)
	}

	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "XmlUnionsRequest",
		},
		Attr: rootAttr,
	}
	if err := awsRestxml_serializeOpDocumentXmlUnionsInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsXmlUnionsInput(v *XmlUnionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestxml_serializeOpDocumentXmlUnionsInput(v *XmlUnionsInput, value smithyxml.Value) error {
	defer value.Close()
	if v.UnionValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "unionValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlUnionShape(v.UnionValue, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentFlattenedXmlMapWithXmlNameInputOutputMap(v map[string]string, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "K",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "V",
			},
			Attr: valueElementAttr,
		}
		entry.MemberElement(valueElement).String(v[key])
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentListWithMemberNamespace(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberNameAttr = append(customMemberNameAttr, smithyxml.NewNamespaceAttribute("", "https://xml-member.example.com"))
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "member",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentListWithNamespace(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentNestedMap(v map[string]map[string]types.FooEnum, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		if v[key] == nil {
			entry.Close()
			continue
		}
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "key",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: valueElementAttr,
		}
		if err := awsRestxml_serializeDocumentFooEnumMap(v[key], entry.MemberElement(valueElement)); err != nil {
			return err
		}
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentNestedPayload(v *types.NestedPayload, value smithyxml.Value) error {
	defer value.Close()
	if v.Greeting != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "greeting",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Greeting)
	}
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentPayloadWithXmlName(v *types.PayloadWithXmlName, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentPayloadWithXmlNamespace(v *types.PayloadWithXmlNamespace, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentPayloadWithXmlNamespaceAndPrefix(v *types.PayloadWithXmlNamespaceAndPrefix, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentRecursiveShapesInputOutputNested1(v *types.RecursiveShapesInputOutputNested1, value smithyxml.Value) error {
	defer value.Close()
	if v.Foo != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "foo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Foo)
	}
	if v.Nested != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "nested",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRecursiveShapesInputOutputNested2(v.Nested, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRecursiveShapesInputOutputNested2(v *types.RecursiveShapesInputOutputNested2, value smithyxml.Value) error {
	defer value.Close()
	if v.Bar != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "bar",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bar)
	}
	if v.RecursiveMember != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "recursiveMember",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRecursiveShapesInputOutputNested1(v.RecursiveMember, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRenamedListMembers(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "item",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentStructureList(v []types.StructureListMember, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "item",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentStructureListMember(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStructureListMember(v *types.StructureListMember, value smithyxml.Value) error {
	defer value.Close()
	if v.A != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.A)
	}
	if v.B != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "other",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.B)
	}
	return nil
}

func awsRestxml_serializeDocumentUnionPayload(v types.UnionPayload, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.UnionPayloadMemberGreeting:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "greeting",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentXmlAttributesPayloadRequest(v *types.XmlAttributesPayloadRequest, value smithyxml.Value) error {
	defer value.Close()
	if v.Foo != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "foo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Foo)
	}
	return nil
}

func awsRestxml_serializeDocumentXmlMapsInputOutputMap(v map[string]types.GreetingStruct, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "key",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: valueElementAttr,
		}
		mapVar := v[key]
		if err := awsRestxml_serializeDocumentGreetingStruct(&mapVar, entry.MemberElement(valueElement)); err != nil {
			return err
		}
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentXmlMapsXmlNameInputOutputMap(v map[string]types.GreetingStruct, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Attribute",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Setting",
			},
			Attr: valueElementAttr,
		}
		mapVar := v[key]
		if err := awsRestxml_serializeDocumentGreetingStruct(&mapVar, entry.MemberElement(valueElement)); err != nil {
			return err
		}
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentXmlMapWithXmlNamespaceInputOutputMap(v map[string]string, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElementAttr = append(keyElementAttr, smithyxml.NewNamespaceAttribute("", "https://the-key.example.com"))
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "K",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElementAttr = append(valueElementAttr, smithyxml.NewNamespaceAttribute("", "https://the-value.example.com"))
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "V",
			},
			Attr: valueElementAttr,
		}
		entry.MemberElement(valueElement).String(v[key])
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentXmlNamespacedList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberNameAttr = append(customMemberNameAttr, smithyxml.NewNamespaceAttribute("", "http://bux.com"))
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "member",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentXmlNamespaceNested(v *types.XmlNamespaceNested, value smithyxml.Value) error {
	defer value.Close()
	if v.Foo != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("baz", "http://baz.com"))
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "foo",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Foo)
	}
	if v.Values != nil {
		rootAttr := []smithyxml.Attr{}
		rootAttr = append(rootAttr, smithyxml.NewNamespaceAttribute("", "http://qux.com"))
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "values",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentXmlNamespacedList(v.Values, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentXmlNestedUnionStruct(v *types.XmlNestedUnionStruct, value smithyxml.Value) error {
	defer value.Close()
	if v.BooleanValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "booleanValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.BooleanValue)
	}
	if v.ByteValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "byteValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Byte(*v.ByteValue)
	}
	if v.DoubleValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "doubleValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(*v.DoubleValue):
			el.String("NaN")

		case math.IsInf(*v.DoubleValue, 1):
			el.String("Infinity")

		case math.IsInf(*v.DoubleValue, -1):
			el.String("-Infinity")

		default:
			el.Double(*v.DoubleValue)

		}
	}
	if v.FloatValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "floatValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(float64(*v.FloatValue)):
			el.String("NaN")

		case math.IsInf(float64(*v.FloatValue), 1):
			el.String("Infinity")

		case math.IsInf(float64(*v.FloatValue), -1):
			el.String("-Infinity")

		default:
			el.Float(*v.FloatValue)

		}
	}
	if v.IntegerValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.IntegerValue)
	}
	if v.LongValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "longValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.LongValue)
	}
	if v.ShortValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "shortValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Short(*v.ShortValue)
	}
	if v.StringValue != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringValue",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StringValue)
	}
	return nil
}

func awsRestxml_serializeDocumentXmlUnionShape(v types.XmlUnionShape, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.XmlUnionShapeMemberBooleanValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "booleanValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Boolean(uv.Value)

	case *types.XmlUnionShapeMemberByteValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "byteValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Byte(uv.Value)

	case *types.XmlUnionShapeMemberDoubleValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "doubleValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		switch {
		case math.IsNaN(uv.Value):
			av.String("NaN")

		case math.IsInf(uv.Value, 1):
			av.String("Infinity")

		case math.IsInf(uv.Value, -1):
			av.String("-Infinity")

		default:
			av.Double(uv.Value)

		}

	case *types.XmlUnionShapeMemberFloatValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "floatValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		switch {
		case math.IsNaN(float64(uv.Value)):
			av.String("NaN")

		case math.IsInf(float64(uv.Value), 1):
			av.String("Infinity")

		case math.IsInf(float64(uv.Value), -1):
			av.String("-Infinity")

		default:
			av.Float(uv.Value)

		}

	case *types.XmlUnionShapeMemberIntegerValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "integerValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Integer(uv.Value)

	case *types.XmlUnionShapeMemberLongValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "longValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Long(uv.Value)

	case *types.XmlUnionShapeMemberShortValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "shortValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.Short(uv.Value)

	case *types.XmlUnionShapeMemberStringValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "stringValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		av.String(uv.Value)

	case *types.XmlUnionShapeMemberStructValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "structValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentXmlNestedUnionStruct(&uv.Value, av); err != nil {
			return err
		}

	case *types.XmlUnionShapeMemberUnionValue:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "unionValue",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentXmlUnionShape(uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentBooleanList(v []bool, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.Boolean(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentFooEnumList(v []types.FooEnum, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentFooEnumMap(v map[string]types.FooEnum, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "key",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: valueElementAttr,
		}
		entry.MemberElement(valueElement).String(string(v[key]))
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentFooEnumSet(v []types.FooEnum, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentGreetingStruct(v *types.GreetingStruct, value smithyxml.Value) error {
	defer value.Close()
	if v.Hi != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "hi",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Hi)
	}
	return nil
}

func awsRestxml_serializeDocumentIntegerEnumList(v []types.IntegerEnum, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.Integer(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentIntegerEnumMap(v map[string]types.IntegerEnum, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "key",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: valueElementAttr,
		}
		entry.MemberElement(valueElement).Integer(v[key])
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentIntegerEnumSet(v []types.IntegerEnum, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.Integer(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentIntegerList(v []int32, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.Integer(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentNestedStringList(v [][]string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		if v[i] == nil {
			am := array.Member()
			am.Close()
			continue
		}
		am := array.Member()
		if err := awsRestxml_serializeDocumentStringList(v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStringList(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentStringSet(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentTimestampList(v []time.Time, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(smithytime.FormatDateTime(v[i]))
	}
	return nil
}
