/* Groundhog -- a simple logic game
 * Copyright (C) 1999-2002 Maurits Rijk
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _DIALOG_H
#define _DIALOG_H

#include <gtk/gtk.h>

class Dialog {
   static gint DeleteCB(GtkWidget *widget, GdkEvent *event, gpointer data);
   static void OkCB(GtkWidget *widget, gpointer data);
   static void CancelCB(GtkWidget *widget, gpointer data);
protected:
   GtkWidget*	_window;

   virtual void OnCancel();
   virtual void OnOk() {}

   void SetSize(gint width, gint height) {
      gtk_widget_set_usize(GTK_WIDGET(_window), width, height);}
   void AddCancelButton();
public:
   Dialog(const char* title);
   virtual ~Dialog() {}
   virtual void DoDialog();
};

#endif // _DIALOG_H
